/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.styles.ui;

import com.sas.graphics.styles.Style;
import com.sas.graphics.styles.StyleElement;
import com.sas.graphics.styles.StyleUtils;
import com.sas.graphics.styles.ui.StyleElementEditorPanel;
import com.sas.graphics.util.FontManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class EditorPanel
extends JPanel {
    private static final long serialVersionUID = -7344216028998902038L;
    private Style style = null;
    private JPanel jPanel = null;
    private JTabbedPane tabbedPane = null;
    private JList textElements = null;
    private JList dataElements = null;
    private JList backgroundElements = null;
    private JList otherElements = null;
    private String[][] standardContextNames = null;
    private StyleElementEditorPanel styleElementEditorPanel = null;

    public EditorPanel() {
        this.initialize();
    }

    public void setStyle(Style s) {
        this.style = s;
        if (s == null) {
            return;
        }
        StyleElement[] elements = this.style.getAllStyleElements();
        Vector<StyleElement> text = new Vector<StyleElement>();
        Vector<StyleElement> data = new Vector<StyleElement>();
        Vector<StyleElement> fill = new Vector<StyleElement>();
        Vector<StyleElement> other = new Vector<StyleElement>();
        for (int i = 0; i < elements.length; ++i) {
            String name = elements[i].getAttribute("context");
            if (StyleUtils.isTextContextName((String)name)) {
                text.addElement(elements[i]);
                continue;
            }
            if (StyleUtils.isDataContextName((String)name)) {
                data.addElement(elements[i]);
                continue;
            }
            if (StyleUtils.isFillContextName((String)name)) {
                fill.addElement(elements[i]);
                continue;
            }
            other.addElement(elements[i]);
        }
        this.getTextElements().setListData(text);
        this.getDataElements().setListData(data);
        this.getBackgroundElements().setListData(fill);
        this.getOtherElements().setListData(other);
        this.setElement("GraphDataStyleDefault");
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(592, 345);
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 10));
        this.add((Component)this.getJPanel(), "North");
        this.add((Component)this.getStyleElementEditorPanel(), "Center");
        this.standardContextNames = new String[50][2];
        this.standardContextNames[0][0] = "GraphDataStyle1";
        this.standardContextNames[1][0] = "GraphDataStyle2";
        this.standardContextNames[2][0] = "GraphDataStyle3";
        this.standardContextNames[3][0] = "GraphDataStyle4";
        this.standardContextNames[4][0] = "GraphDataStyle5";
        this.standardContextNames[5][0] = "GraphDataStyle6";
        this.standardContextNames[6][0] = "GraphDataStyle7";
        this.standardContextNames[7][0] = "GraphDataStyle8";
        this.standardContextNames[8][0] = "GraphDataStyle9";
        this.standardContextNames[9][0] = "GraphDataStyle10";
        this.standardContextNames[10][0] = "GraphDataStyle11";
        this.standardContextNames[11][0] = "GraphDataStyle12";
        this.standardContextNames[12][0] = "GraphDataStyleDefault";
        this.standardContextNames[13][0] = "Outlier";
        this.standardContextNames[14][0] = "ThreeColorRamp";
        this.standardContextNames[15][0] = "ThreeColorAltRamp";
        this.standardContextNames[16][0] = "AxisLines";
        this.standardContextNames[17][0] = "Reference";
        this.standardContextNames[18][0] = "GridLines";
        this.standardContextNames[19][0] = "Outlines";
        this.standardContextNames[20][0] = "BorderLines";
        this.standardContextNames[21][0] = "TitleText";
        this.standardContextNames[22][0] = "FootnoteText";
        this.standardContextNames[23][0] = "DataText";
        this.standardContextNames[24][0] = "LabelText";
        this.standardContextNames[25][0] = "ValueText";
        this.standardContextNames[26][0] = "Backfill";
        this.standardContextNames[27][0] = "WallFill";
        this.standardContextNames[28][0] = "FloorFill";
        this.standardContextNames[29][0] = "LegendFill";
        this.standardContextNames[30][0] = "HeaderFill";
        this.standardContextNames[31][0] = "Fit";
        this.standardContextNames[32][0] = "Fit2";
        this.standardContextNames[33][0] = "Prediction";
        this.standardContextNames[34][0] = "Confidence";
        this.standardContextNames[35][0] = "Confidence2";
        this.standardContextNames[36][0] = "PredictionLimits";
        this.standardContextNames[37][0] = "Error";
        this.standardContextNames[38][0] = "BoxMedian";
        this.standardContextNames[39][0] = "BoxMean";
        this.standardContextNames[40][0] = "BoxWhisker";
        this.standardContextNames[41][0] = "AnnoLine";
        this.standardContextNames[42][0] = "AnnoText";
        this.standardContextNames[43][0] = "AnnoShape";
        this.standardContextNames[44][0] = "Selection";
        this.standardContextNames[45][0] = "Missing";
        this.standardContextNames[46][0] = "ControlLimits";
        this.standardContextNames[47][0] = "RunTest";
        this.standardContextNames[48][0] = "Stars";
        this.standardContextNames[49][0] = "Clipping";
        ResourceBundle rb = ResourceBundle.getBundle("com.sas.graphics.styles.styles");
        if (rb != null) {
            try {
                for (int i = 0; i < this.standardContextNames.length; ++i) {
                    this.standardContextNames[i][1] = rb.getString(this.standardContextNames[i][0] + ".DisplayName.txt");
                }
            }
            catch (MissingResourceException mre) {
                this.standardContextNames = null;
            }
        }
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new BorderLayout());
            this.jPanel.add((Component)this.getTabbedPane(), "Center");
        }
        return this.jPanel;
    }

    private JTabbedPane getTabbedPane() {
        if (this.tabbedPane == null) {
            this.tabbedPane = new JTabbedPane();
            this.tabbedPane.addTab("Text", new JScrollPane(this.getTextElements()));
            this.tabbedPane.addTab("Data", new JScrollPane(this.getDataElements()));
            this.tabbedPane.addTab("Background", new JScrollPane(this.getBackgroundElements()));
            this.tabbedPane.addTab("Other", new JScrollPane(this.getOtherElements()));
        }
        return this.tabbedPane;
    }

    private JList getTextElements() {
        if (this.textElements == null) {
            this.textElements = new JList();
            this.textElements.setSelectionMode(0);
            this.textElements.setFont(FontManager.getFont((String)"Arial", (int)0, (int)12));
            this.textElements.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    EditorPanel.this.styleElementEditorPanel.setStyleElement(null);
                    if (EditorPanel.this.textElements.getModel().getSize() > 0 && EditorPanel.this.textElements.getSelectedValue() != null) {
                        EditorPanel.this.styleElementEditorPanel.setStyleElement(EditorPanel.this.style.getStyleElement(EditorPanel.this.textElements.getSelectedValue().toString()));
                    }
                }
            });
        }
        return this.textElements;
    }

    private JList getDataElements() {
        if (this.dataElements == null) {
            this.dataElements = new JList();
            this.dataElements.setSelectionMode(0);
            this.dataElements.setFont(FontManager.getFont((String)"Arial", (int)0, (int)12));
            this.dataElements.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    EditorPanel.this.styleElementEditorPanel.setStyleElement(null);
                    if (EditorPanel.this.dataElements.getModel().getSize() > 0 && EditorPanel.this.dataElements.getSelectedValue() != null) {
                        EditorPanel.this.styleElementEditorPanel.setStyleElement(EditorPanel.this.style.getStyleElement(EditorPanel.this.dataElements.getSelectedValue().toString()));
                    }
                }
            });
        }
        return this.dataElements;
    }

    private JList getBackgroundElements() {
        if (this.backgroundElements == null) {
            this.backgroundElements = new JList();
            this.backgroundElements.setSelectionMode(0);
            this.backgroundElements.setFont(FontManager.getFont((String)"Arial", (int)0, (int)12));
            this.backgroundElements.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    EditorPanel.this.styleElementEditorPanel.setStyleElement(null);
                    if (EditorPanel.this.backgroundElements.getModel().getSize() > 0 && EditorPanel.this.backgroundElements.getSelectedValue() != null) {
                        EditorPanel.this.styleElementEditorPanel.setStyleElement(EditorPanel.this.style.getStyleElement(EditorPanel.this.backgroundElements.getSelectedValue().toString()));
                    }
                }
            });
        }
        return this.backgroundElements;
    }

    private JList getOtherElements() {
        if (this.otherElements == null) {
            this.otherElements = new JList();
            this.otherElements.setSelectionMode(0);
            this.otherElements.setFont(FontManager.getFont((String)"Arial", (int)0, (int)12));
            this.otherElements.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    EditorPanel.this.styleElementEditorPanel.setStyleElement(null);
                    if (EditorPanel.this.otherElements.getModel().getSize() > 0 && EditorPanel.this.otherElements.getSelectedValue() != null) {
                        EditorPanel.this.styleElementEditorPanel.setStyleElement(EditorPanel.this.style.getStyleElement(EditorPanel.this.otherElements.getSelectedValue().toString()));
                    }
                }
            });
        }
        return this.otherElements;
    }

    public static Window getParentWindow(Component c) {
        Container parent;
        for (parent = c.getParent(); parent != null && !(parent instanceof Window); parent = parent.getParent()) {
        }
        return (Window)parent;
    }

    public void setElement(String elementName) {
        StyleElement se;
        int i;
        for (i = 0; i < this.getTextElements().getModel().getSize(); ++i) {
            se = (StyleElement)this.getTextElements().getModel().getElementAt(i);
            if (!se.getAttribute("context").equals(elementName)) continue;
            this.getTabbedPane().setSelectedIndex(0);
            this.getTextElements().setSelectedValue(se, true);
            return;
        }
        for (i = 0; i < this.getDataElements().getModel().getSize(); ++i) {
            se = (StyleElement)this.getDataElements().getModel().getElementAt(i);
            if (!se.getAttribute("context").equals(elementName)) continue;
            this.getTabbedPane().setSelectedIndex(1);
            this.getDataElements().setSelectedValue(se, true);
            return;
        }
        for (i = 0; i < this.getBackgroundElements().getModel().getSize(); ++i) {
            se = (StyleElement)this.getBackgroundElements().getModel().getElementAt(i);
            if (!se.getAttribute("context").equals(elementName)) continue;
            this.getTabbedPane().setSelectedIndex(2);
            this.getBackgroundElements().setSelectedValue(se, true);
            return;
        }
        for (i = 0; i < this.getOtherElements().getModel().getSize(); ++i) {
            se = (StyleElement)this.getOtherElements().getModel().getElementAt(i);
            if (!se.getAttribute("context").equals(elementName)) continue;
            this.getTabbedPane().setSelectedIndex(3);
            this.getOtherElements().setSelectedValue(se, true);
            return;
        }
    }

    StyleElementEditorPanel getStyleElementEditorPanel() {
        if (this.styleElementEditorPanel == null) {
            this.styleElementEditorPanel = new StyleElementEditorPanel();
        }
        return this.styleElementEditorPanel;
    }
}

