/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.styles.ui;

import com.sas.graphics.styles.Style;
import com.sas.graphics.styles.ui.StylePreview;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.EventListener;
import javax.swing.JComponent;
import javax.swing.event.EventListenerList;

public abstract class AbstractStylePreview
extends JComponent
implements StylePreview {
    private static final long serialVersionUID = 1L;
    private EventListenerList actionListeners = null;
    protected Style style = null;
    protected boolean rolloverEnabled = false;
    protected String highlightArea = null;

    public AbstractStylePreview() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                AbstractStylePreview.this.highlightArea = null;
                AbstractStylePreview.this.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                AbstractStylePreview.this.highlightArea = null;
                AbstractStylePreview.this.repaint();
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (AbstractStylePreview.this.highlightArea != null) {
                    AbstractStylePreview.this.fireActionEvent(AbstractStylePreview.this.highlightArea);
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                AbstractStylePreview.this.highlightArea = AbstractStylePreview.this.getStyleElementAt(e.getPoint());
                if (AbstractStylePreview.this.actionListeners != null && AbstractStylePreview.this.actionListeners.getListenerCount() > 0) {
                    if (AbstractStylePreview.this.highlightArea == null) {
                        AbstractStylePreview.this.setCursor(Cursor.getDefaultCursor());
                    } else {
                        AbstractStylePreview.this.setCursor(Cursor.getPredefinedCursor(12));
                    }
                }
                AbstractStylePreview.this.repaint();
            }
        });
    }

    @Override
    public void addActionListener(ActionListener listener) {
        if (listener == null) {
            return;
        }
        if (this.actionListeners == null) {
            this.actionListeners = new EventListenerList();
        }
        this.actionListeners.add(ActionListener.class, listener);
    }

    @Override
    public void removeActionListener(ActionListener listener) {
        if (listener == null || this.actionListeners == null) {
            return;
        }
        this.actionListeners.remove(ActionListener.class, listener);
    }

    protected void fireActionEvent(String actionCommand) {
        if (this.actionListeners == null || this.actionListeners.getListenerCount() == 0) {
            return;
        }
        ActionEvent ae = new ActionEvent(this, 0, actionCommand);
        EventListener[] listeners = this.actionListeners.getListeners(ActionListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            ((ActionListener)listeners[i]).actionPerformed(ae);
        }
    }

    @Override
    public void setStyle(Style style) {
        this.style = style;
    }

    public Style getStyle() {
        return this.style;
    }

    @Override
    public boolean isRolloverEnabled() {
        return this.rolloverEnabled;
    }

    @Override
    public void setRolloverEnabled(boolean enable) {
        this.rolloverEnabled = enable;
    }
}

