/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.xml.parsers;

import com.sas.graphics.silk.interfaces.ElementInfoInterface;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.util.GraphUtilities;
import com.sas.graphics.xml.GraphParserUtils;
import java.util.Properties;

public class ElementInfoReader
implements ElementInfoInterface {
    Attribute[] attributeList = null;
    String[] attributeNames = null;
    protected Properties props = null;
    private Object instance = null;

    public ElementInfoReader(String propertiesFile) {
        this.props = ResourceLoader.loadProperties(propertiesFile);
    }

    public void setInstance(Object instance) {
        this.instance = instance;
    }

    private boolean loadAttributeList() {
        if (this.attributeList != null) {
            return true;
        }
        if (this.props == null) {
            return false;
        }
        this.attributeList = this.loadAttrs(this.props);
        if (this.attributeList == null) {
            return false;
        }
        this.attributeNames = new String[this.attributeList.length];
        for (int i = 0; i < this.attributeList.length; ++i) {
            this.attributeNames[i] = this.attributeList[i].xmlName;
        }
        return true;
    }

    private Attribute[] loadAttrs(Properties p) {
        int i;
        int numAttrs;
        Properties p1;
        String parent = p.getProperty("Extends");
        Attribute[] rc = new Attribute[]{};
        if (parent != null && (p1 = ResourceLoader.loadProperties(parent)) != null) {
            rc = this.loadAttrs(p1);
        }
        if ((numAttrs = GraphParserUtils.getIntValue(p.getProperty("Number_Attributes"))) <= 0) {
            return rc;
        }
        Attribute[] currentAttrs = new Attribute[numAttrs];
        for (int i2 = 0; i2 < currentAttrs.length; ++i2) {
            currentAttrs[i2] = new Attribute();
            currentAttrs[i2].name = p.getProperty("Attribute_" + i2);
            currentAttrs[i2].xmlName = p.getProperty("Attribute_" + i2 + ".XML_Name");
            currentAttrs[i2].validValues = p.getProperty("Attribute_" + i2 + ".Valid_Values");
        }
        Attribute[] temp = rc;
        rc = new Attribute[rc.length + currentAttrs.length];
        for (i = 0; i < temp.length; ++i) {
            rc[i] = temp[i];
        }
        for (i = 0; i < currentAttrs.length; ++i) {
            rc[temp.length + i] = currentAttrs[i];
        }
        return rc;
    }

    private boolean loadInstance() {
        if (this.instance != null || this.props == null) {
            return true;
        }
        String className = this.props.getProperty("ClassName");
        if (className == null) {
            return false;
        }
        try {
            Class<?> c = Class.forName(className);
            Object o = c.newInstance();
            this.instance = o;
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public String[] getAttributeNames() {
        if (!this.loadAttributeList()) {
            return null;
        }
        return this.attributeNames;
    }

    @Override
    public int getPropertyIndex(String attribute) {
        if (!this.loadAttributeList()) {
            return -1;
        }
        String attrString = null;
        for (int i = 0; i < this.attributeList.length && attrString == null; ++i) {
            if (!attribute.equalsIgnoreCase(this.attributeList[i].xmlName)) continue;
            attrString = this.attributeList[i].name;
        }
        if (attrString == null) {
            return -1;
        }
        Object obj = GraphUtilities.getReflectedFieldValue(attrString);
        if (obj == null) {
            return -1;
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        return -1;
    }

    @Override
    public Object getValidValues(String attribute) {
        for (int i = 0; i < this.attributeList.length; ++i) {
            if (!attribute.equalsIgnoreCase(this.attributeList[i].xmlName)) continue;
            return this.attributeList[i].validValues;
        }
        return null;
    }

    @Override
    public Object getXmlTarget() {
        this.loadInstance();
        return this.instance;
    }

    class Attribute {
        String name;
        String xmlName;
        String validValues;

        Attribute() {
        }
    }
}

