/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.util;

import com.sas.graphics.util.ColorParse;
import com.sas.graphics.util.GraphUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;

public class ResourceLoader {
    public static boolean readFromFiles = true;
    protected static Object[] msgArgs = new Object[5];
    protected static String[] imageExts = new String[]{".bmp", ".gif", ".jpg", ".jpeg", ".png"};
    protected static String resOpenEngErr = "Can not open resource {0}";
    protected static String resNFEngErr = "Resource {0} not found. Using default value.";
    protected static String loadErrorEngMsg = "Error loading configuration information from {0}";
    protected static Hashtable cache = new Hashtable();
    protected static boolean cacheResources = ResourceLoader.getPropertyBoolean("Graph.config", "ResourceLoader.CacheResources", true);
    protected static String resOpenErr = ResourceLoader.getResourceString("com.sas.graphics.util.Resources_SGCommon", "ResourceLoader.ResourceOpenError.fmt.txt", "Can not open resource {0}");
    protected static String resNFErr = ResourceLoader.getResourceString("com.sas.graphics.util.Resources_SGCommon", "ResourceLoader.ResourceNotFoundError.fmt.txt", "Resource {0} not found. Using default value.");
    protected static String loadErrorMsg = ResourceLoader.getResourceString("com.sas.graphics.util.Resources_SGCommon", "ResourceLoader.ConfigLoadError.fmt.txt", "Error loading configuration information from {0}");

    protected static void printError(String pattern, String pattern2, Object val1, Object val2, Object val3, Exception e) {
        String s = pattern;
        if (s == null) {
            s = pattern2;
        }
        ResourceLoader.msgArgs[0] = val1;
        ResourceLoader.msgArgs[1] = val2;
        ResourceLoader.msgArgs[2] = val3;
        System.err.println(MessageFormat.format(s, msgArgs));
        System.err.flush();
        if (e != null) {
            e.printStackTrace();
        }
    }

    protected static int getIntegerValue(String s, int defaultValue) {
        Object o = GraphUtilities.getReflectedFieldValue(s);
        if (o != null && o instanceof Number) {
            return ((Number)o).intValue();
        }
        Integer i = null;
        if (s != null) {
            s = s.trim();
        }
        if (s == null || s.length() <= 0) {
            return defaultValue;
        }
        try {
            i = Integer.valueOf(s);
            if (i == null) {
                return defaultValue;
            }
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
        return i;
    }

    protected static double getNumericValue(String s, double defaultValue) {
        Object o = GraphUtilities.getReflectedFieldValue(s);
        if (o != null && o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        Double d = null;
        if (s != null) {
            s = s.trim();
        }
        if (s == null || s.length() <= 0) {
            return defaultValue;
        }
        try {
            d = Double.valueOf(s);
            if (d == null) {
                return defaultValue;
            }
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
        return d;
    }

    protected static String GRS(Object rb, String name, String defStrg) {
        Object o;
        String s = null;
        if (name == null) {
            return defStrg;
        }
        try {
            if (rb != null) {
                if (rb instanceof ResourceBundle) {
                    s = ((ResourceBundle)rb).getString(name);
                } else if (rb instanceof Properties) {
                    s = ((Properties)rb).getProperty(name);
                }
            }
        }
        catch (MissingResourceException e) {
            ResourceLoader.printError(resNFErr, resNFEngErr, name, null, null, null);
            s = null;
        }
        if (s == null) {
            s = defStrg;
        }
        if ((o = GraphUtilities.getReflectedFieldValue(s)) != null && o instanceof String) {
            return o.toString();
        }
        return s;
    }

    public static String getPropertyString(String configFile, String keyName, String defaultValue) {
        String out = defaultValue;
        Properties props = ResourceLoader.loadProperties(configFile, false);
        if (props == null) {
            return defaultValue;
        }
        out = ResourceLoader.getResourceString(props, keyName, defaultValue);
        return out;
    }

    public static boolean getPropertyBoolean(String configFile, String keyName, boolean defaultValue) {
        boolean out = defaultValue;
        Properties props = ResourceLoader.loadProperties(configFile, false);
        if (props == null) {
            return defaultValue;
        }
        out = ResourceLoader.getResourceBoolean(props, keyName, defaultValue);
        if (keyName != null && keyName.equalsIgnoreCase("ResourceLoader.CacheResources")) {
            cacheResources = out;
            ResourceLoader.cacheResource(configFile, props);
        }
        return out;
    }

    static void cacheResource(String name, Object resource) {
        if (!cacheResources || name == null || resource == null || cache == null) {
            return;
        }
        if (cache.get(name) != null) {
            return;
        }
        cache.put(name, resource);
    }

    protected static Object getFromCache(String name) {
        if (!cacheResources || name == null || cache == null) {
            return null;
        }
        return cache.get(name);
    }

    protected static ResourceBundle getBundleFromCache(String name) {
        Object o = ResourceLoader.getFromCache(name);
        if (o == null || !(o instanceof ResourceBundle)) {
            return null;
        }
        return (ResourceBundle)o;
    }

    protected static Properties getPropertiesFromCache(String name) {
        Object o = ResourceLoader.getFromCache(name);
        if (o == null || !(o instanceof Properties)) {
            return null;
        }
        return (Properties)o;
    }

    public static int getResourceInteger(Object resourceName, String keyName, int defaultValue) {
        String s = ResourceLoader.getResourceString(resourceName, keyName, null);
        if (s == null) {
            return defaultValue;
        }
        return ResourceLoader.getIntegerValue(s, defaultValue);
    }

    public static double getResourceDouble(Object resourceName, String keyName, double defaultValue) {
        String s = ResourceLoader.getResourceString(resourceName, keyName, null);
        if (s == null) {
            return defaultValue;
        }
        return ResourceLoader.getNumericValue(s, defaultValue);
    }

    public static boolean getResourceBoolean(Object resourceName, String keyName, boolean defaultValue) {
        boolean out = defaultValue;
        String s = ResourceLoader.getResourceString(resourceName, keyName, null);
        if (s != null) {
            if ((s = s.trim().toUpperCase()).equals("TRUE") || s.equals("T") || s.equals("ON") || s.equals("YES") || s.equals("Y")) {
                out = true;
            } else if (s.equals("FALSE") || s.equals("F") || s.equals("OFF") || s.equals("NO") || s.equals("N")) {
                out = false;
            }
        }
        return out;
    }

    public static String getResourceString(Object resourceName, String keyName, String defaultValue) {
        ResourceBundle rb = null;
        if (resourceName == null || keyName == null) {
            return defaultValue;
        }
        if (!(resourceName instanceof String)) {
            return ResourceLoader.GRS(resourceName, keyName, defaultValue);
        }
        try {
            rb = ResourceLoader.getBundleFromCache((String)resourceName);
            if (rb == null) {
                rb = ResourceBundle.getBundle((String)resourceName);
                ResourceLoader.cacheResource((String)resourceName, rb);
            }
        }
        catch (MissingResourceException e) {
            ResourceLoader.printError(resOpenErr, resOpenEngErr, resourceName, null, null, null);
            return defaultValue;
        }
        return ResourceLoader.GRS(rb, keyName, defaultValue);
    }

    public static Color getResourceColor(Object resourceName, String key, Color defVal) {
        Color c = defVal;
        String s = ResourceLoader.getResourceString(resourceName, key, null);
        if (s != null) {
            if ((s = s.trim()).equalsIgnoreCase("NONE")) {
                return null;
            }
            c = ColorParse.getColorFromString(s);
            if (c == null) {
                return defVal;
            }
        }
        return c;
    }

    public static ResourceBundle loadBundle(String resourceName) {
        ResourceBundle rb = null;
        if (resourceName == null) {
            return null;
        }
        try {
            rb = ResourceLoader.getBundleFromCache(resourceName);
            if (rb == null) {
                rb = ResourceBundle.getBundle(resourceName);
                ResourceLoader.cacheResource(resourceName, rb);
            }
        }
        catch (MissingResourceException e) {
            ResourceLoader.printError(resOpenErr, resOpenEngErr, resourceName, null, null, null);
            return null;
        }
        return rb;
    }

    public static ResourceBundle loadBundle(String resourceName, Locale locale) {
        ResourceBundle rb = null;
        if (resourceName == null) {
            return null;
        }
        try {
            rb = ResourceLoader.getBundleFromCache(resourceName);
            if (rb == null) {
                rb = ResourceBundle.getBundle(resourceName, locale);
                if (locale != null && locale.equals(Locale.getDefault())) {
                    ResourceLoader.cacheResource(resourceName, rb);
                }
            }
        }
        catch (MissingResourceException e) {
            ResourceLoader.printError(resOpenErr, resOpenEngErr, resourceName, null, null, null);
            return null;
        }
        return rb;
    }

    public static String[] getResourceList(Object rbIn, String countKey, String baseKey) {
        int n;
        String key = null;
        Object rb = rbIn;
        String[] out = null;
        if (rbIn == null || countKey == null || baseKey == null) {
            return null;
        }
        if (rbIn instanceof String) {
            try {
                rb = ResourceLoader.getBundleFromCache((String)rbIn);
                if (rb == null) {
                    rb = ResourceBundle.getBundle((String)rbIn);
                    ResourceLoader.cacheResource((String)rbIn, rb);
                }
            }
            catch (MissingResourceException e) {
                ResourceLoader.printError(resOpenErr, resOpenEngErr, rbIn, null, null, null);
                return null;
            }
        }
        if ((n = ResourceLoader.getIntegerValue(ResourceLoader.GRS(rb, countKey, null), -1)) < 0) {
            return null;
        }
        out = new String[n];
        if (out == null) {
            return null;
        }
        for (int i = 0; i < n; ++i) {
            key = baseKey + Integer.toString(i);
            out[i] = ResourceLoader.GRS(rb, key, null);
        }
        return out;
    }

    public static Image getImage(Component comp, String name) {
        String s = name;
        InputStream is = null;
        Image img = null;
        if (comp == null || name == null) {
            return null;
        }
        if (!(s.startsWith("/") || s.startsWith("http:") || s.startsWith("file:"))) {
            s = "/" + s;
        }
        s.replace('\\', '/');
        try {
            URL url = new URL(s);
            is = url.openStream();
        }
        catch (Exception url) {
            // empty catch block
        }
        if (is == null && (is = comp.getClass().getResourceAsStream(s)) == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (baos == null) {
            return null;
        }
        try {
            int c;
            while ((c = is.read()) >= 0) {
                baos.write(c);
            }
            Toolkit tk = comp.getToolkit();
            if (tk == null) {
                return null;
            }
            img = tk.createImage(baos.toByteArray());
            MediaTracker mt = new MediaTracker(comp);
            mt.addImage(img, 0);
            mt.waitForID(0);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
        return img;
    }

    public static Properties loadProperties(String configFile) {
        return ResourceLoader.loadProperties(configFile, cacheResources);
    }

    public static Properties loadProperties(String configFile, boolean cache) {
        String s = configFile;
        String source = null;
        InputStream is = null;
        File file = null;
        URL url = null;
        Properties props = null;
        Properties props2 = null;
        if (s == null) {
            return null;
        }
        props = ResourceLoader.getPropertiesFromCache(configFile);
        if (props != null) {
            return props;
        }
        is = ResourceLoader.class.getResourceAsStream("/" + configFile);
        if (is != null && (url = ResourceLoader.class.getResource("/" + configFile)) != null) {
            source = url.toExternalForm();
        }
        if (is != null) {
            try {
                props = new Properties();
                if (props == null) {
                    return null;
                }
                props.load(is);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        is = null;
        if (readFromFiles) {
            try {
                file = new File(s);
                if (file != null) {
                    is = new FileInputStream(file);
                }
            }
            catch (FileNotFoundException e) {
            }
            catch (SecurityException e2) {
                ResourceLoader.printError(loadErrorMsg, loadErrorEngMsg, s, null, null, e2);
            }
        }
        if (is != null) {
            try {
                props2 = new Properties(props);
                if (props2 == null) {
                    return null;
                }
                props2.load(is);
                props = props2;
                if (source != null) {
                    props.setProperty("_Property_Source_Secondary_", source);
                }
                if ((source = file.getAbsolutePath()) != null) {
                    props.setProperty("_Property_Source_Primary_", source);
                }
                source = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (source != null) {
            props.setProperty("_Property_Source_Primary_", source);
        }
        ResourceLoader.cacheResource(configFile, props);
        return props;
    }
}

