/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.data;

import com.sas.graphics.silk.event.DataFilterListenerInterface;
import com.sas.graphics.silk.event.DvrDataFilterEvent;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.util.Extract;
import java.util.BitSet;

public class SelectionIterator
implements DataFilterListenerInterface {
    private BitSet selections = null;
    private int current = 0;
    private DataFilterReadInterface filter = null;
    private BitSet reverseList = null;

    public SelectionIterator(BitSet selections, DataFilterReadInterface dfri) {
        this.selections = selections;
        this.filter = dfri;
        this.filter.addDataFilterListener(this);
        this.dataFilterChanged(null);
    }

    public boolean hasMoreSelections() {
        if (this.reverseList == null) {
            return this.selections.nextSetBit(this.current) >= 0;
        }
        int i = this.selections.nextSetBit(this.current);
        while (i >= 0) {
            if (this.reverseList.get(i)) {
                return true;
            }
            i = this.selections.nextSetBit(i + 1);
        }
        return false;
    }

    public int nextSelectedIndex() {
        if (this.reverseList == null) {
            int rc = this.selections.nextSetBit(this.current);
            this.current = rc + 1;
            return rc;
        }
        boolean done = false;
        int rc = this.selections.nextSetBit(this.current);
        while (!done) {
            this.current = rc + 1;
            if (rc < 0 || this.reverseList.get(rc)) {
                done = true;
                continue;
            }
            rc = this.selections.nextSetBit(this.current);
        }
        int count = 0;
        int i = this.reverseList.nextSetBit(0);
        while (i >= 0) {
            if (i == rc) {
                return count;
            }
            ++count;
            i = this.reverseList.nextSetBit(i + 1);
        }
        return rc;
    }

    public void reset() {
        this.current = 0;
    }

    public int cardinality() {
        if (this.reverseList == null) {
            return this.selections.cardinality();
        }
        int rc = 0;
        int i = this.reverseList.nextSetBit(0);
        while (i >= 0) {
            if (this.selections.get(i)) {
                ++rc;
            }
            i = this.reverseList.nextSetBit(i + 1);
        }
        return rc;
    }

    @Override
    public void dataFilterChanged(DvrDataFilterEvent evt) {
        if (evt != null && evt.type == 2) {
            return;
        }
        Object subsetList = this.filter.getSubsetList();
        if (subsetList == null) {
            this.reverseList = null;
            return;
        }
        int type = Extract.getSourceType(subsetList);
        int numInSubset = Extract.getNumberItems(subsetList, type);
        if (this.reverseList == null) {
            this.reverseList = new BitSet();
        } else {
            this.reverseList.clear();
        }
        for (int i = 0; i < numInSubset; ++i) {
            this.reverseList.set((int)Extract.getNumeric(subsetList, i, type));
        }
    }
}

