/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.data;

import com.sas.MissingValues;
import com.sas.graphics.data.AbstractDataFilter;
import com.sas.graphics.data.FormatHandler;
import com.sas.graphics.data.IOBSInterface;
import com.sas.graphics.silk.data.SelectionIterator;
import com.sas.graphics.silk.event.DvrDataFilterEvent;
import com.sas.graphics.silk.interfaces.DataFilterInfoInterface;
import com.sas.graphics.silk.interfaces.DataFilterWriteInterface;
import com.sas.graphics.util.Extract;
import com.sas.graphics.util.RangeInfoModel;
import com.sas.graphics.util.StringCompare;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.util.Locale;
import java.util.Vector;

public class JavaDataFilter
extends AbstractDataFilter
implements DataFilterWriteInterface,
DataFilterInfoInterface {
    protected boolean holdEvents = false;
    protected Vector variables = new Vector();
    protected DvrDataFilterEvent evt;
    protected int[] evtIndicies;
    protected String name;

    public JavaDataFilter(Locale localeIn) {
        this.whereClauses = new Vector();
        this.locale = localeIn;
        this.evt = new DvrDataFilterEvent();
        this.subsetted = false;
        this.subsetList = null;
        this.evtIndicies = new int[10];
        this.rangeInfoModel = new RangeInfoModel(this);
        this.name = "JavaDataFilter_" + System.currentTimeMillis();
    }

    public String getName() {
        return this.name;
    }

    public JavaDataFilter() {
        this(null);
    }

    int[] fillAll(int[] curArray, int n) {
        int[] out = null;
        out = curArray == null || curArray.length < n ? new int[n] : curArray;
        for (int i = 0; i < n; ++i) {
            out[i] = i;
        }
        return out;
    }

    protected VecEntry getVecEntry(Vector v) {
        Object o = null;
        if (v == null) {
            return null;
        }
        Object e = v.elementAt(0);
        o = e;
        if (e == null || !(o instanceof VecEntry)) {
            return null;
        }
        return o;
    }

    protected VecEntry getVecEntry(int idx) {
        return this.getVecEntry(this.getVector(idx));
    }

    protected Object getDataValue(Vector v, int idx) {
        Object o = null;
        if (v == null || idx < 0 || idx >= v.size()) {
            return null;
        }
        if (this.subsetList != null && this.subsetList.length <= idx) {
            return null;
        }
        if (this.subsetList != null) {
            idx = this.subsetList[idx];
        }
        Object e = v.elementAt(++idx);
        o = e;
        if (e == null) {
            return null;
        }
        if (!(o instanceof VecValue)) {
            return null;
        }
        return ((VecValue)o).dataValue;
    }

    protected Vector getVector(int idx) {
        Object o = null;
        if (this.variables == null || idx < 0 || idx >= this.variables.size()) {
            return null;
        }
        Object e = this.variables.elementAt(idx);
        o = e;
        if (e == null) {
            return null;
        }
        if (!(o instanceof Vector)) {
            return null;
        }
        return o;
    }

    protected int getColumn(Object colId) {
        int nCols = 0;
        int out = -1;
        Object vecId = null;
        VecEntry entry = null;
        if (colId == null || this.variables == null) {
            return -1;
        }
        nCols = this.variables.size();
        for (int i = 0; i < nCols; ++i) {
            entry = this.getVecEntry(i);
            if (entry == null || (vecId = entry.id).getClass() != colId.getClass() || !vecId.equals(colId)) continue;
            out = i;
            break;
        }
        return out;
    }

    protected void updateMinMax(VecEntry entry, Object value) {
        if (entry == null || value == null || entry.colClass == null) {
            return;
        }
        if (entry.min == null) {
            entry.min = value;
        } else if (value instanceof String) {
            if (StringCompare.compareTo((String)value, (String)entry.min) < 0) {
                entry.min = value;
            }
        } else if (value instanceof Number && !Double.isNaN(((Number)value).doubleValue()) && ((Number)value).doubleValue() < ((Number)entry.min).doubleValue()) {
            entry.min = value;
        }
        if (entry.max == null) {
            entry.max = value;
        } else if (value instanceof String) {
            if (StringCompare.compareTo((String)value, (String)entry.max) > 0) {
                entry.max = value;
            }
        } else if (value instanceof Number && !Double.isNaN(((Number)value).doubleValue()) && ((Number)value).doubleValue() > ((Number)entry.max).doubleValue()) {
            entry.max = value;
        }
    }

    protected boolean fillColumn(int col, Object data) {
        int count = 0;
        Object o = null;
        VecEntry entry = this.getVecEntry(col);
        if (col < 0 || entry == null) {
            return false;
        }
        if (data == null) {
            return true;
        }
        int type = Extract.getSourceType(data);
        count = Extract.getNumberItems(data, type);
        for (int i = 0; i < count; ++i) {
            o = Extract.getObject(data, i, type);
            if (o == null) continue;
            this.setValue(col, -1L, o);
        }
        return true;
    }

    protected int getMinimumNumberRows() {
        int numvars = this.getNumberVariables();
        if (numvars < 1) {
            return 0;
        }
        int min = this.getNumberObservations(0);
        for (int i = 1; i < numvars; ++i) {
            int cur = this.getNumberObservations(i);
            if (cur >= min) continue;
            min = cur;
        }
        return min;
    }

    protected String getFormattedValueByIndex(int idx, Object value, Object format) {
        SASFormat fmt = null;
        VecEntry entry = null;
        if (value == null) {
            return null;
        }
        if (format != null && format instanceof SASFormat) {
            fmt = (SASFormat)format;
        } else {
            entry = this.getVecEntry(idx);
            if (entry != null && entry.format != null && entry.format instanceof SASFormat) {
                fmt = (SASFormat)entry.format;
            } else if (value instanceof Number) {
                fmt = this.defFmt;
            }
        }
        if (fmt == null) {
            return value.toString();
        }
        if (fmt.isNumericFormat() && value instanceof Number || fmt.isCharacterFormat() && !(value instanceof String)) {
            return fmt.format(value);
        }
        return value.toString();
    }

    public void throwSelectEventAsRanges(int varStartIndex, int varEndIndex, int[] obsIndicies, int n) {
        int cur;
        this.evt.type = 2;
        this.evt.varStartIndex = varStartIndex;
        this.evt.varEndIndex = varEndIndex;
        this.evt.oldValue = null;
        this.evt.newValue = null;
        if (obsIndicies == null) {
            this.evt.obsStartIndex = 0;
            this.evt.obsEndIndex = this.getNumberObservations(null) - 1;
            this.evt.isAdjusting = false;
            this.throwEvent(this.evt);
            return;
        }
        if (n < 1) {
            return;
        }
        int last = cur = obsIndicies[0];
        int start = cur;
        for (int i = 1; i < n; ++i) {
            cur = obsIndicies[i];
            if (cur > last + 1) {
                this.evt.obsStartIndex = start;
                this.evt.obsEndIndex = last;
                this.evt.isAdjusting = true;
                this.throwEvent(this.evt);
                start = last = cur;
                continue;
            }
            last = cur;
        }
        this.evt.obsStartIndex = start;
        this.evt.obsEndIndex = cur;
        this.evt.isAdjusting = false;
        this.throwEvent(this.evt);
    }

    @Override
    public Object getSource() {
        return this;
    }

    @Override
    public boolean setSource(Object source) {
        Vector vecIn = null;
        Vector<Object> vec = null;
        if (source != null && source instanceof Vector) {
            for (int i = 0; i < ((Vector)source).size(); ++i) {
                Object o = ((Vector)source).elementAt(i);
                if (o == null || !(o instanceof Vector)) continue;
                vecIn = (Vector)o;
                vec = new Vector<Object>();
                if (vec == null) continue;
                for (int j = 0; j < vecIn.size(); ++j) {
                    if (j == 0) {
                        vec.addElement(new VecEntry(vecIn.elementAt(j), null, null));
                        continue;
                    }
                    vec.addElement(new VecValue(vecIn.elementAt(j)));
                }
            }
        }
        this.setSubsetList(null);
        this.throwEvent(1, -1, -1, -1, -1, null, null, false);
        return true;
    }

    @Override
    public boolean removeSource() {
        if (this.variables == null || this.variables.size() <= 0) {
            return false;
        }
        this.variables.removeAllElements();
        this.setSubsetList(null);
        this.throwEvent(1, -1, -1, -1, -1, null, null, false);
        return true;
    }

    @Override
    public int getNumberVariables() {
        if (this.variables == null) {
            return 0;
        }
        return this.variables.size();
    }

    @Override
    public boolean verifyVariable(Object id) {
        return this.getColumn(id) >= 0;
    }

    @Override
    public Object getVariableId(int idx) {
        VecEntry entry = this.getVecEntry(idx);
        if (entry == null) {
            return null;
        }
        return entry.id;
    }

    @Override
    public int getVariableIndex(Object id) {
        return this.getColumn(id);
    }

    @Override
    public Object getVariableDescription(int idx) {
        String s;
        Object desc = null;
        VecEntry entry = this.getVecEntry(idx);
        if (entry == null) {
            return null;
        }
        desc = entry.desc != null ? entry.desc : entry.id;
        if (desc == null) {
            return entry.id;
        }
        if (desc instanceof String && (s = ((String)desc).trim()) != null && s.length() <= 0) {
            desc = entry.id;
        }
        return desc;
    }

    @Override
    public Class getVariableClass(int idx) {
        VecEntry entry = this.getVecEntry(idx);
        if (entry == null) {
            return null;
        }
        return entry.colClass;
    }

    @Override
    public boolean defineVariable(Object id, Object descIn, Object data) {
        int colIdx = this.getColumn(id);
        Vector v = null;
        VecEntry entry = null;
        if (this.variables == null || id == null) {
            return false;
        }
        if (colIdx < 0) {
            v = new Vector();
            if (v == null) {
                return false;
            }
            entry = new VecEntry(id, null, null);
            if (entry == null) {
                return false;
            }
            v.addElement(entry);
        } else {
            v = this.getVector(colIdx);
            if (v == null) {
                return false;
            }
        }
        entry = this.getVecEntry(v);
        if (entry == null) {
            return false;
        }
        entry.id = id;
        entry.desc = descIn;
        entry.format = null;
        v.removeAllElements();
        v.addElement(entry);
        entry.colClass = null;
        entry.min = null;
        entry.max = null;
        if (colIdx < 0) {
            this.variables.addElement(v);
            colIdx = this.getColumn(id);
        }
        this.throwEvent(4, colIdx, colIdx, -1, -1, null, null, false);
        this.fillColumn(colIdx, data);
        return true;
    }

    @Override
    public int getNumberObservations(int idx) {
        Vector v = this.getVector(idx);
        if (this.subsetted) {
            if (this.subsetList == null) {
                return 0;
            }
            return this.subsetList.length;
        }
        if (v == null) {
            return this.getMinimumNumberRows();
        }
        return v.size() - 1;
    }

    @Override
    public boolean isNumericVariable(int idx) {
        VecEntry entry = this.getVecEntry(idx);
        Class superClass = null;
        if (entry == null) {
            return false;
        }
        if (entry.colClass == null) {
            return false;
        }
        superClass = entry.colClass.getSuperclass();
        if (superClass == null) {
            return false;
        }
        return superClass == Number.class;
    }

    @Override
    public double getNumericValue(int idx, long iobs) {
        double d = Double.NaN;
        Object value = this.getValue(idx, iobs);
        if (value == null) {
            return d;
        }
        if (!(value instanceof Number)) {
            return d;
        }
        d = ((Number)value).doubleValue();
        return d;
    }

    @Override
    public int getRowValues(long iobs, Object[] outValues) {
        int nVars = this.getNumberVariables();
        if (this.subsetList != null) {
            iobs = this.subsetList[(int)iobs];
        }
        if (outValues == null || outValues.length < nVars) {
            return -1;
        }
        for (int i = 0; i < nVars; ++i) {
            outValues[i] = this.getValue(i, iobs);
        }
        return nVars;
    }

    @Override
    public boolean removeVariable(Object id) {
        return this.removeVariable(this.getColumn(id));
    }

    @Override
    public boolean removeVariable(int idx) {
        VecEntry entry = null;
        if (this.variables == null || idx < 0 || idx >= this.variables.size()) {
            return false;
        }
        entry = this.getVecEntry(idx);
        this.variables.removeElementAt(idx);
        if (entry != null) {
            this.throwEvent(5, idx, idx, -1, -1, entry.id, null, false);
        }
        return true;
    }

    @Override
    public boolean isMissing(int idx, Object value) {
        return value == null || value instanceof MissingValues || value instanceof Double && ((Double)value).isNaN();
    }

    @Override
    public Object getValue(int idx, long iobs) {
        Vector v = null;
        if (this.variables == null || idx < 0 || idx >= this.variables.size() || iobs < 0L) {
            return null;
        }
        v = this.getVector(idx);
        if (v == null) {
            return null;
        }
        if (iobs >= (long)(v.size() - 1)) {
            return null;
        }
        return this.getDataValue(v, (int)iobs);
    }

    @Override
    protected Object getModelValue(int idx, long iobs) {
        return null;
    }

    @Override
    protected int getNumberOfObservationsOnModel() {
        return 0;
    }

    @Override
    public boolean setValue(Object variableId, long iobs, Object value) {
        return this.setValue(this.getColumn(variableId), iobs, value);
    }

    @Override
    public boolean setValue(int idx, long iobs, Object value) {
        Vector v = null;
        VecEntry entry = null;
        VecValue vv = null;
        Object oldValue = null;
        if (this.variables == null || idx < 0 || idx >= this.variables.size()) {
            return false;
        }
        v = this.getVector(idx);
        if (v == null) {
            return false;
        }
        entry = this.getVecEntry(v);
        if (entry == null) {
            return false;
        }
        if (this.subsetList != null) {
            iobs = this.subsetList[(int)iobs];
        }
        if (iobs >= (long)(v.size() - 1)) {
            return false;
        }
        if (v.size() < 2 && value != null) {
            entry.colClass = value.getClass();
        } else if (value != null && value.getClass() != entry.colClass) {
            entry.colClass = null;
            entry.format = null;
            entry.max = null;
            entry.min = null;
        }
        if (iobs < 0L) {
            v.addElement(new VecValue(value));
            iobs = v.size() - 1;
        } else {
            vv = (VecValue)v.elementAt((int)iobs + 1);
            if (vv != null) {
                oldValue = vv.dataValue;
                vv.dataValue = value;
            }
        }
        this.throwEvent(3, idx, idx, (int)iobs, (int)iobs, oldValue, value, false);
        return true;
    }

    @Override
    public boolean setValue(Object variableId, long iobs, double value) {
        return this.setValue(variableId, iobs, (Object)new Double(value));
    }

    @Override
    public boolean setValue(int idx, long iobs, double value) {
        return this.setValue(idx, iobs, (Object)new Double(value));
    }

    @Override
    public Object getFormat(Object variableId, Class returnType) {
        VecEntry entry = null;
        entry = this.getVecEntry(this.getColumn(variableId));
        if (entry == null) {
            return null;
        }
        return FormatHandler.convert(entry.format, returnType);
    }

    @Override
    public boolean setFormat(Object variableId, Object fmtId) {
        int varIdx = -1;
        VecEntry entry = null;
        Object oldFmt = null;
        SASFormat fmt = null;
        if (fmtId == null) {
            return false;
        }
        varIdx = this.getColumn(variableId);
        entry = this.getVecEntry(varIdx);
        if (entry == null) {
            return false;
        }
        oldFmt = entry.format;
        if (fmtId instanceof SASFormat) {
            fmt = (SASFormat)fmtId;
            entry.format = fmt;
        } else if (fmtId instanceof String && (fmt = this.locale != null ? SASFormat.getInstance((String)((String)fmtId), (Locale)this.locale) : SASFormat.getInstance((String)((String)fmtId))) != null) {
            entry.format = fmt;
        }
        this.throwEvent(6, varIdx, varIdx, -1, -1, oldFmt, fmt, false);
        return fmt != null;
    }

    @Override
    public boolean isModelUpdatable(int varIdx, long iobs) {
        return true;
    }

    @Override
    public String getFormattedValue(Object variableId, Object value, Object format) {
        return this.getFormattedValueByIndex(this.getColumn(variableId), value, format);
    }

    public boolean isSelected(Object variableId, long iobs) {
        return this.isSelected(this.getColumn(variableId), iobs);
    }

    public boolean isSelected(int idx, long iobs) {
        Vector v = this.getVector(idx);
        VecValue vv = null;
        if (v == null) {
            return false;
        }
        if (this.subsetList != null) {
            iobs = this.subsetList[(int)iobs];
        }
        if (iobs < 0L || iobs >= (long)(v.size() - 1)) {
            return false;
        }
        vv = (VecValue)v.elementAt((int)(iobs + 1L));
        if (vv == null) {
            return false;
        }
        return vv.selected;
    }

    @Override
    public boolean isSelected(long iobs) {
        int n = this.getNumberVariables();
        for (int i = 0; i < n; ++i) {
            if (!this.isSelected(i, iobs)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setSelected(long iobs, boolean selected) {
    }

    @Override
    public void setSelected(Object list, boolean selected, IOBSInterface operator) {
    }

    @Override
    public void setSelected(Object list, int state, IOBSInterface operator) {
    }

    @Override
    public void unselectAll() {
    }

    @Override
    public boolean isGraphed(long iobs) {
        return true;
    }

    @Override
    public void setAllGraphed(boolean graph) {
    }

    @Override
    public void setGraphed(long iobs, boolean graphed) {
    }

    @Override
    public void setGraphed(Object list, boolean graphed, IOBSInterface operator) {
    }

    @Override
    public void setGraphed(Object list, int state, IOBSInterface operator) {
    }

    @Override
    public Color getObservationColor(long iobs) {
        return null;
    }

    @Override
    public boolean setObservationColor(long iobs, Color c) {
        return false;
    }

    @Override
    public void setObservationColor(Object list, Color c, IOBSInterface operator) {
    }

    @Override
    public SelectionIterator getSelections() {
        return null;
    }

    @Override
    public Object getAdapter(Class type) {
        return null;
    }

    @Override
    public boolean isMaximumValueValid(Object variableId) {
        VecEntry entry = this.getVecEntry(this.getColumn(variableId));
        if (entry == null) {
            return false;
        }
        return entry.max != null;
    }

    @Override
    public Object getMaximumValue(Object variableId) {
        return this.getMaximumValue(variableId, true);
    }

    @Override
    public Object getMaximumValue(Object variableId, boolean useSubset) {
        if (this.rangeInfoModel == null) {
            VecEntry entry = this.getVecEntry(this.getColumn(variableId));
            if (entry == null) {
                return null;
            }
            return entry.max;
        }
        return new Double(this.rangeInfoModel.getMaximum(variableId));
    }

    @Override
    public boolean isMinimumValueValid(Object variableId) {
        VecEntry entry = this.getVecEntry(this.getColumn(variableId));
        if (entry == null) {
            return false;
        }
        return entry.min != null;
    }

    @Override
    public Object getMinimumValue(Object variableId) {
        return this.getMinimumValue(variableId, true);
    }

    @Override
    public Object getMinimumValue(Object variableId, boolean useSubset) {
        if (this.rangeInfoModel == null) {
            VecEntry entry = this.getVecEntry(this.getColumn(variableId));
            if (entry == null) {
                return null;
            }
            return entry.min;
        }
        return new Double(this.rangeInfoModel.getMinimum(variableId));
    }

    @Override
    public boolean rerunStatistics() {
        boolean status = true;
        int nVars = 0;
        long nObs = 0L;
        Object o = null;
        VecEntry entry = null;
        nVars = this.getNumberVariables();
        for (int iVar = 0; iVar < nVars; ++iVar) {
            entry = this.getVecEntry(iVar);
            if (entry == null) {
                status = false;
                continue;
            }
            if (entry.colClass == null) continue;
            nObs = this.getNumberObservations(iVar);
            entry.max = null;
            entry.min = null;
            for (long iObs = 0L; iObs < nObs; ++iObs) {
                o = this.getValue(iVar, iObs);
                if (o == null) continue;
                this.updateMinMax(entry, o);
            }
        }
        return status;
    }

    @Override
    public Object[] getUniqueValues(Object variableId, boolean useSubset, int maxSize) {
        return null;
    }

    @Override
    public Object[] getUniqueValues(Object variableId, boolean useSubset) {
        return null;
    }

    class VecEntry {
        public Class colClass;
        public Object id;
        public Object desc;
        public Object min;
        public Object max;
        public Object format;

        public VecEntry(Object id, String descIn, Object format) {
            this.id = id;
            this.desc = descIn;
            this.format = format;
            this.colClass = null;
            this.min = null;
            this.max = null;
        }
    }

    class VecValue {
        public boolean selected = false;
        public Object dataValue;

        public VecValue(Object value) {
            this.dataValue = value;
        }
    }
}

