/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.data.subset;

import com.sas.graphics.data.GTKDataFilterVariableInterface;
import com.sas.graphics.data.GTKNumericDataFilterVariable;
import com.sas.graphics.data.GTKStringDataFilterVariable;
import com.sas.graphics.data.subset.SubsetInterface;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.util.DynamicIntArray;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.VariableProcessor;
import java.util.BitSet;

public class WhereClauseSubset
implements SubsetInterface {
    private String clause = null;

    public WhereClauseSubset(String whereClause) {
        this.clause = whereClause;
    }

    @Override
    public int[] getNonPassedObs(DataFilterReadInterface filter) {
        if (filter == null) {
            return null;
        }
        int[] passed = this.getPassedObs(filter);
        if (passed == null) {
            return null;
        }
        BitSet bits = new BitSet(filter.getNumberObservations(-1));
        for (int i = 0; i < passed.length; ++i) {
            bits.set(passed[i]);
        }
        DynamicIntArray dia = new DynamicIntArray();
        int i = bits.nextSetBit(0);
        while (i >= 0) {
            dia.add(i);
            i = bits.nextClearBit(i + 1);
        }
        return dia.getElements();
    }

    @Override
    public int[] getPassedObs(DataFilterReadInterface filter) {
        if (filter == null) {
            return null;
        }
        VariableProcessor vp = new VariableProcessor();
        GTKDataFilterVariableInterface referenceVariable = null;
        for (int i = 0; i < filter.getNumberVariables(); ++i) {
            GTKDataFilterVariableInterface var = null;
            if (filter.isNumericVariable(i)) {
                var = new GTKNumericDataFilterVariable();
                ((GTKNumericDataFilterVariable)var).connectFrom(filter, i);
            } else {
                var = new GTKStringDataFilterVariable();
                ((GTKStringDataFilterVariable)var).connectFrom(filter, i);
            }
            vp.addVariable((Variable)var);
            if (referenceVariable != null) continue;
            referenceVariable = var;
        }
        vp.setWhereExpression(this.clause);
        if (!vp.isWhereExpressionValid()) {
            System.out.println(vp.getWhereExpressionParseError());
            return null;
        }
        int obsCount = referenceVariable.getValueCount();
        int[] rc = new int[obsCount];
        for (int i = 0; i < obsCount; ++i) {
            rc[i] = vp.getIndexWithoutWhereProcessing(i);
        }
        return rc;
    }
}

