/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.data.subset;

import com.sas.graphics.data.subset.SubsetInterface;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.util.DynamicIntArray;
import java.util.BitSet;
import java.util.Vector;

public class AndSubset
implements SubsetInterface {
    private Vector subsets = new Vector();

    public AndSubset(SubsetInterface[] subsetsToAnd) {
        if (subsetsToAnd != null) {
            for (int i = 0; i < subsetsToAnd.length; ++i) {
                this.subsets.addElement(subsetsToAnd[i]);
            }
        }
    }

    public SubsetInterface[] getSubsets() {
        Object[] rc = new SubsetInterface[this.subsets.size()];
        this.subsets.copyInto(rc);
        return rc;
    }

    public void addSubset(SubsetInterface subset) {
        if (subset == null || this.subsets.contains(subset)) {
            return;
        }
        this.subsets.addElement(subset);
    }

    @Override
    public int[] getNonPassedObs(DataFilterReadInterface filter) {
        if (filter == null) {
            return null;
        }
        BitSet bits = new BitSet(filter.getNumberObservations(-1));
        for (int i = 0; i < this.subsets.size(); ++i) {
            SubsetInterface si = (SubsetInterface)this.subsets.elementAt(i);
            int[] arr = si.getNonPassedObs(filter);
            for (int j = 0; j < arr.length; ++j) {
                bits.set(arr[j]);
            }
        }
        DynamicIntArray dia = new DynamicIntArray();
        int i = bits.nextSetBit(0);
        while (i >= 0) {
            dia.add(i);
            i = bits.nextSetBit(i + 1);
        }
        return dia.getElements();
    }

    private boolean arrayContainsInt(int[] arr, int num) {
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] != num) continue;
            return true;
        }
        return false;
    }

    @Override
    public int[] getPassedObs(DataFilterReadInterface filter) {
        if (filter == null || this.subsets.isEmpty()) {
            return null;
        }
        int[][] lists = new int[this.subsets.size()][];
        for (int i = 0; i < lists.length; ++i) {
            lists[i] = ((SubsetInterface)this.subsets.elementAt(i)).getPassedObs(filter);
        }
        DynamicIntArray dia = new DynamicIntArray();
        for (int i = 0; i < lists[0].length; ++i) {
            boolean good = true;
            for (int j = 1; j < lists.length; ++j) {
                boolean found = this.arrayContainsInt(lists[j], lists[0][i]);
                good &= found;
            }
            if (!good) continue;
            dia.add(lists[0][i]);
        }
        return dia.getElements();
    }
}

