/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.data;

import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.data.IOBSInterface;
import com.sas.graphics.data.sort.SortContext;
import com.sas.graphics.data.where.DvrWhereFilter;
import com.sas.graphics.silk.data.SelectionIterator;
import com.sas.graphics.silk.event.DataFilterListenerInterface;
import com.sas.graphics.silk.event.DvrDataFilterEvent;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.util.Extract;
import com.sas.graphics.util.Search;
import com.sas.graphics.util.Sort;
import java.awt.Color;
import java.util.Locale;
import java.util.Vector;

public class FilterFilter
implements DataFilterReadInterface,
DataFilterListenerInterface {
    protected boolean subsetted = false;
    protected Locale locale;
    protected Vector listeners;
    protected Vector whereClauses;
    protected DataFilterReadInterface sourceFilter;
    protected DvrDataFilterEvent evt = new DvrDataFilterEvent();
    protected int[] subsetList = null;
    protected int[] indicies;

    public FilterFilter(DataFilterReadInterface filterIn, Locale localeIn) {
        this.whereClauses = new Vector();
        this.listeners = new Vector();
        this.locale = localeIn;
        this.indicies = new int[100];
        this.setSource(filterIn);
    }

    public FilterFilter(DataFilterReadInterface filterIn) {
        this(filterIn, null);
    }

    public FilterFilter(Locale localeIn) {
        this(null, localeIn);
    }

    public FilterFilter() {
        this(null, null);
    }

    protected void throwEvent(int type, int firstVarIdx, int lastVarIdx, int firstObs, int lastObs, Object oldValue, Object newValue, boolean isAdjustingIn) {
        this.evt.source = this;
        this.evt.type = type;
        this.evt.varStartIndex = firstVarIdx;
        this.evt.varEndIndex = lastVarIdx;
        this.evt.obsStartIndex = firstObs;
        this.evt.obsEndIndex = lastObs;
        this.evt.oldValue = oldValue;
        this.evt.newValue = newValue;
        this.evt.isAdjusting = isAdjustingIn;
        this.evt.info = 0;
        this.throwEvent(this.evt);
    }

    protected void throwEvent(DvrDataFilterEvent evt) {
        int count;
        if (this.listeners == null || (count = this.listeners.size()) <= 0 || evt == null) {
            return;
        }
        Object[] array = new DataFilterListenerInterface[this.listeners.size()];
        this.listeners.copyInto(array);
        for (int i = 0; i < count; ++i) {
            Object recipient = array[i];
            if (recipient == null) continue;
            recipient.dataFilterChanged(evt);
        }
    }

    protected long getRealObsIndex(long iobs) {
        if (this.subsetted && this.subsetList != null) {
            return this.subsetList[(int)iobs];
        }
        return iobs;
    }

    @Override
    public Object getSource() {
        return this.sourceFilter;
    }

    @Override
    public boolean setSource(Object source) {
        DataFilterReadInterface oldSource = this.sourceFilter;
        if (source == null || !(source instanceof DataFilterReadInterface)) {
            return false;
        }
        this.sourceFilter = (DataFilterReadInterface)source;
        if (oldSource != null) {
            oldSource.removeDataFilterListener(this);
        }
        this.sourceFilter.addDataFilterListener(this);
        return true;
    }

    @Override
    public boolean setSource(Object source, Locale localeIn) {
        this.locale = localeIn;
        return this.setSource(source);
    }

    @Override
    public boolean removeSource() {
        if (this.sourceFilter == null) {
            return false;
        }
        this.sourceFilter.removeDataFilterListener(this);
        this.sourceFilter = null;
        return true;
    }

    @Override
    public int getNumberVariables() {
        if (this.sourceFilter == null) {
            return 0;
        }
        return this.sourceFilter.getNumberVariables();
    }

    @Override
    public boolean verifyVariable(Object id) {
        if (this.sourceFilter == null) {
            return false;
        }
        return this.sourceFilter.verifyVariable(id);
    }

    @Override
    public Object getVariableId(int idx) {
        if (this.sourceFilter == null) {
            return null;
        }
        return this.sourceFilter.getVariableId(idx);
    }

    @Override
    public int getVariableIndex(Object id) {
        if (this.sourceFilter == null) {
            return -1;
        }
        return this.sourceFilter.getVariableIndex(id);
    }

    @Override
    public Object getExactVariableId(Object id) {
        if (this.sourceFilter == null) {
            return null;
        }
        return this.sourceFilter.getExactVariableId(id);
    }

    @Override
    public Object getVariableDescription(Object id) {
        if (this.sourceFilter == null) {
            return null;
        }
        return this.sourceFilter.getVariableDescription(id);
    }

    @Override
    public Object getVariableDescription(int idx) {
        if (this.sourceFilter == null) {
            return null;
        }
        return this.sourceFilter.getVariableDescription(idx);
    }

    @Override
    public Class getVariableClass(Object id) {
        if (this.sourceFilter == null) {
            return null;
        }
        return this.sourceFilter.getVariableClass(id);
    }

    @Override
    public Class getVariableClass(int idx) {
        if (this.sourceFilter == null) {
            return null;
        }
        return this.sourceFilter.getVariableClass(idx);
    }

    @Override
    public int getNumberObservations(Object id) {
        if (this.sourceFilter == null) {
            return 0;
        }
        if (this.subsetted && this.subsetList != null) {
            return this.subsetList.length;
        }
        return this.sourceFilter.getNumberObservations(id);
    }

    @Override
    public int getNumberObservations(int idx) {
        if (this.sourceFilter == null) {
            return 0;
        }
        if (this.subsetted && this.subsetList != null) {
            return this.subsetList.length;
        }
        return this.sourceFilter.getNumberObservations(idx);
    }

    @Override
    public boolean isMissing(Object id, Object value) {
        if (this.sourceFilter == null) {
            return false;
        }
        return this.sourceFilter.isMissing(id, value);
    }

    @Override
    public boolean isMissing(int idx, Object value) {
        if (this.sourceFilter == null) {
            return false;
        }
        return this.sourceFilter.isMissing(idx, value);
    }

    @Override
    public Object getValue(Object variableId, long iobs) {
        if (this.sourceFilter == null) {
            return null;
        }
        iobs = this.getRealObsIndex(iobs);
        return this.sourceFilter.getValue(variableId, iobs);
    }

    @Override
    public Object getValue(int idx, long iobs) {
        if (this.sourceFilter == null) {
            return null;
        }
        iobs = this.getRealObsIndex(iobs);
        return this.sourceFilter.getValue(idx, iobs);
    }

    @Override
    public boolean isNumericVariable(Object id) {
        if (this.sourceFilter == null) {
            return false;
        }
        return this.sourceFilter.isNumericVariable(id);
    }

    @Override
    public boolean isNumericVariable(int idx) {
        if (this.sourceFilter == null) {
            return false;
        }
        return this.sourceFilter.isNumericVariable(idx);
    }

    @Override
    public double getNumericValue(Object variableId, long iobs) {
        if (this.sourceFilter == null) {
            return Double.NaN;
        }
        iobs = this.getRealObsIndex(iobs);
        return this.sourceFilter.getNumericValue(variableId, iobs);
    }

    @Override
    public double getNumericValue(int idx, long iobs) {
        if (this.sourceFilter == null) {
            return Double.NaN;
        }
        iobs = this.getRealObsIndex(iobs);
        return this.sourceFilter.getNumericValue(idx, iobs);
    }

    @Override
    public Object[] getRowValues(long iobs) {
        if (this.sourceFilter == null) {
            return null;
        }
        iobs = this.getRealObsIndex(iobs);
        return this.sourceFilter.getRowValues(iobs);
    }

    @Override
    public int getRowValues(long iobs, Object[] outValues) {
        if (this.sourceFilter == null) {
            return 0;
        }
        iobs = this.getRealObsIndex(iobs);
        return this.sourceFilter.getRowValues(iobs, outValues);
    }

    @Override
    public Object getFormat(Object variableId, Class returnType) {
        if (this.sourceFilter == null) {
            return null;
        }
        return this.sourceFilter.getFormat(variableId, returnType);
    }

    @Override
    public String getFormattedValue(Object variableId, Object value, Object format) {
        if (this.sourceFilter == null) {
            return null;
        }
        return this.sourceFilter.getFormattedValue(variableId, value, format);
    }

    @Override
    public String getFormattedValue(Object variableId, long iobs, Object format) {
        return this.getFormattedValue(variableId, this.getValue(variableId, iobs), format);
    }

    @Override
    public boolean isSelected(long iobs) {
        if (this.sourceFilter == null) {
            return false;
        }
        iobs = this.getRealObsIndex(iobs);
        return this.sourceFilter.isSelected(iobs);
    }

    @Override
    public void setSelected(long iobs, boolean selected) {
        if (this.sourceFilter == null) {
            return;
        }
        iobs = this.getRealObsIndex(iobs);
        this.sourceFilter.setSelected(iobs, selected);
    }

    @Override
    public void setSelected(Object list, boolean selected) {
        this.setSelected(list, selected, null);
    }

    @Override
    public void setSelected(Object list, boolean selected, IOBSInterface operator) {
        if (this.sourceFilter == null) {
            return;
        }
        if (!this.subsetted || this.subsetList == null) {
            this.sourceFilter.setSelected(list, selected, operator);
            return;
        }
        int type = Extract.getSourceType(list);
        int n = Extract.getNumberItems(list, type);
        if (n <= 0) {
            return;
        }
        int[] obsList = new int[n];
        if (obsList == null) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            obsList[i] = this.subsetList[obsList[i]];
        }
        this.sourceFilter.setSelected((Object)obsList, selected, operator);
    }

    @Override
    public void unselectAll() {
        if (this.sourceFilter == null) {
            return;
        }
        if (this.subsetted && this.subsetList != null) {
            this.sourceFilter.setSelected(this.subsetList, false);
        } else {
            this.sourceFilter.unselectAll();
        }
    }

    @Override
    public boolean isGraphed(long iobs) {
        if (this.sourceFilter == null) {
            return false;
        }
        iobs = this.getRealObsIndex(iobs);
        return this.sourceFilter.isGraphed(iobs);
    }

    @Override
    public void setAllGraphed(boolean graph) {
        if (this.sourceFilter == null) {
            return;
        }
        this.sourceFilter.setAllGraphed(graph);
    }

    @Override
    public void setGraphed(long iobs, boolean graphed) {
        if (this.sourceFilter == null) {
            return;
        }
        iobs = this.getRealObsIndex(iobs);
        this.sourceFilter.setGraphed(iobs, graphed);
    }

    @Override
    public void setGraphed(Object list, boolean graphed, IOBSInterface operator) {
        if (this.sourceFilter == null) {
            return;
        }
        if (!this.subsetted || this.subsetList == null) {
            this.sourceFilter.setGraphed(list, graphed, operator);
            return;
        }
        int type = Extract.getSourceType(list);
        int n = Extract.getNumberItems(list, type);
        if (n <= 0) {
            return;
        }
        int[] obsList = new int[n];
        if (obsList == null) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            obsList[i] = this.subsetList[obsList[i]];
        }
        this.sourceFilter.setGraphed((Object)obsList, graphed, operator);
    }

    @Override
    public void setGraphed(Object list, boolean graphed) {
        this.setGraphed(list, graphed, null);
    }

    @Override
    public Color getObservationColor(long iobs) {
        if (this.sourceFilter == null) {
            return null;
        }
        iobs = this.getRealObsIndex(iobs);
        return this.sourceFilter.getObservationColor(iobs);
    }

    @Override
    public boolean setObservationColor(long iobs, Color c) {
        if (this.sourceFilter == null) {
            return false;
        }
        iobs = this.getRealObsIndex(iobs);
        return this.sourceFilter.setObservationColor(iobs, c);
    }

    @Override
    public void setObservationColor(Object list, Color c, IOBSInterface operator) {
        if (this.sourceFilter == null) {
            return;
        }
        int[] ilist = Extract.getIntegers(list, null);
        if (ilist == null) {
            return;
        }
        for (int i = 0; i < ilist.length; ++i) {
            ilist[i] = (int)this.getRealObsIndex(ilist[i]);
        }
        this.sourceFilter.setObservationColor((Object)ilist, c, operator);
    }

    @Override
    public void setObservationColor(Object list, Color c) {
        this.setObservationColor(list, c, null);
    }

    @Override
    public boolean addDataFilterListener(Object listener) {
        if (this.listeners == null || listener == null || !(listener instanceof DataFilterListenerInterface)) {
            return false;
        }
        if (this.listeners.contains(listener)) {
            return false;
        }
        this.listeners.addElement(listener);
        return true;
    }

    @Override
    public boolean removeDataFilterListener(Object listener) {
        if (listener == null || this.listeners == null) {
            return false;
        }
        int idx = this.listeners.indexOf(listener);
        if (idx < 0) {
            return false;
        }
        this.listeners.removeElementAt(idx);
        return true;
    }

    @Override
    public void sendEvent(Object event) {
        if (event == null || !(event instanceof DvrDataFilterEvent)) {
            return;
        }
        this.throwEvent((DvrDataFilterEvent)event);
    }

    @Override
    public Object getSubsetList() {
        return this.subsetList;
    }

    @Override
    public boolean setSubsetList(Object list) {
        if (list == null) {
            this.subsetted = false;
            this.subsetList = null;
            this.throwEvent(3, 0, this.getNumberVariables(), 0, this.getNumberObservations(-1) - 1, null, null, false);
            return true;
        }
        int type = Extract.getSourceType(list);
        if (type <= 0) {
            return false;
        }
        this.subsetted = true;
        int n = Extract.getNumberItems(list, type);
        this.subsetList = n <= 0 ? new int[0] : new int[n];
        for (int i = 0; i < n; ++i) {
            this.subsetList[i] = Extract.getInteger(list, i, type);
        }
        Sort.heapsort(this.subsetList, -1);
        this.throwEvent(3, 0, this.getNumberVariables(), 0, this.getNumberObservations(-1) - 1, null, null, false);
        return true;
    }

    @Override
    public int getObservationNumber(int index) {
        if (!this.subsetted) {
            return index;
        }
        if (this.subsetList == null) {
            return -1;
        }
        if (index < 0 || index >= this.subsetList.length) {
            return -1;
        }
        return this.subsetList[index];
    }

    @Override
    public boolean applyWhereClause(String clause, boolean clearPrevious) {
        int[] prevList = this.subsetList;
        Object newList = null;
        int[] arg = null;
        if (clause == null) {
            this.setSubsetList(null);
            this.whereClauses.removeAllElements();
            return true;
        }
        DvrWhereFilter where = new DvrWhereFilter(this);
        if (where == null) {
            return false;
        }
        this.setSubsetList(null);
        if (!clearPrevious) {
            arg = prevList;
        }
        if ((newList = where.applyWhereFilter(clause, arg)) == null) {
            this.setSubsetList(prevList);
            return false;
        }
        if (clearPrevious) {
            this.whereClauses.removeAllElements();
        }
        this.whereClauses.addElement(clause);
        this.setSubsetList(newList);
        return true;
    }

    @Override
    public String getWhereClause() {
        String rc = "";
        for (int i = 0; i < this.whereClauses.size(); ++i) {
            rc = rc + "(" + this.whereClauses.elementAt(i).toString() + ")";
            if (i >= this.whereClauses.size() - 1) continue;
            rc = rc + " & ";
        }
        return rc;
    }

    @Override
    public SelectionIterator getSelections() {
        return null;
    }

    @Override
    public void dataFilterChanged(DvrDataFilterEvent e) {
        int n = 0;
        int nIn = 0;
        if (e.type != 2 || !this.subsetted || this.subsetList == null) {
            this.throwEvent(e);
            return;
        }
        switch (e.type) {
            default: {
                return;
            }
            case 1: 
            case 3: 
            case 5: {
                if (!this.subsetted || this.whereClauses == null || (n = this.whereClauses.size()) <= 0) {
                    return;
                }
                for (int i = 0; i < n; ++i) {
                    this.applyWhereClause((String)this.whereClauses.elementAt(i), i != 0);
                }
                return;
            }
            case 2: 
        }
        if (e.oldValue == null || e.newValue == null) {
            this.throwEvent(e);
            return;
        }
        if (!(e.newValue instanceof Number)) {
            return;
        }
        nIn = ((Number)e.newValue).intValue();
        int type = Extract.getSourceType(e.oldValue);
        if (this.indicies == null || this.indicies.length < nIn) {
            this.indicies = new int[nIn];
        }
        for (int i = 0; i < nIn; ++i) {
            int idx;
            int iobs = Extract.getInteger(e.oldValue, i, type);
            if (iobs < 0 || (idx = Search.binarylookup(iobs, this.subsetList, -1)) < 0) continue;
            this.indicies[n] = idx;
            ++n;
        }
        if (n == 0) {
            return;
        }
        this.evt = new DvrDataFilterEvent(e);
        this.evt.oldValue = this.indicies;
        this.evt.newValue = new Integer(n);
        this.throwEvent(this.evt);
    }

    @Override
    public Object getAdapter(Class type) {
        return null;
    }

    @Override
    public String getFormattedValue(Object variableId, long iobs, SortContext sort, Object format) {
        return null;
    }

    @Override
    public double getNumericValue(int idx, long iobs, SortContext sort) {
        return 0.0;
    }

    @Override
    public double getNumericValue(Object variableId, long iobs, SortContext sort) {
        return 0.0;
    }

    @Override
    public Color getObservationColor(long iobs, SortContext sort) {
        return null;
    }

    @Override
    public int getRowValues(long iobs, Object[] outValues, SortContext sort) {
        return 0;
    }

    @Override
    public Object[] getRowValues(long iobs, SortContext sort) {
        return null;
    }

    @Override
    public Object getValue(int idx, long iobs, SortContext sort) {
        return null;
    }

    @Override
    public Object getValue(Object variableId, long iobs, SortContext sort) {
        return null;
    }

    @Override
    public boolean isGraphed(long iobs, SortContext sort) {
        return false;
    }

    @Override
    public boolean isIndexInCurrentSubset(int index) {
        return false;
    }

    @Override
    public boolean isSelected(long iobs, SortContext sort) {
        return false;
    }

    @Override
    public void setGraphed(long iobs, SortContext sort, boolean graphed) {
    }

    @Override
    public void setGraphed(Object list, SortContext sort, boolean graphed, IOBSInterface operator) {
    }

    @Override
    public void setGraphed(Object list, SortContext sort, boolean graphed) {
    }

    @Override
    public boolean setObservationColor(long iobs, SortContext sort, Color c) {
        return false;
    }

    @Override
    public void setObservationColor(Object list, SortContext sort, Color c, IOBSInterface operator) {
    }

    @Override
    public void setObservationColor(Object list, SortContext sort, Color c) {
    }

    @Override
    public void setSelected(long iobs, SortContext sort, boolean selected) {
    }

    @Override
    public void setSelected(Object list, SortContext sort, boolean selected, IOBSInterface operator) {
    }

    @Override
    public void setSelected(Object list, SortContext sort, boolean selected) {
    }

    @Override
    public void setSelected(String[] variables, DataRange[] boundingBox, boolean selected, boolean useFormat) {
    }

    @Override
    public void setSelected(String[] variables, DataRange[] boundingBox, boolean selected) {
    }

    @Override
    public void setGraphed(String[] variables, DataRange[] boundingBox, boolean graphed, boolean useFormat) {
    }

    @Override
    public void setGraphed(String[] variables, DataRange[] ranges, boolean[] graphed, boolean[] useFormat, boolean extendCurrentGraphedState, boolean setOrClearAll) {
    }

    @Override
    public boolean areSelectionsLocal() {
        return false;
    }

    @Override
    public void setSelectionsLocal(boolean local) {
    }

    @Override
    public boolean isGraphedLocal() {
        return false;
    }

    @Override
    public void setGraphedLocal(boolean local) {
    }
}

