/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.common.waterfall;

import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorAttr;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.common.attrmap.DiscreteAttrMapper;
import com.sas.graphics.common.attrmap.RangeAttrMapper;
import com.sas.graphics.common.bubble.BubbleObject;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.Accumulator;
import com.sas.graphics.util.gtk.BooleanPipe;
import com.sas.graphics.util.gtk.BooleanVector;
import com.sas.graphics.util.gtk.Calculator;
import com.sas.graphics.util.gtk.ColorMap;
import com.sas.graphics.util.gtk.ColorMapper;
import com.sas.graphics.util.gtk.ContinuousRangeToColorMap;
import com.sas.graphics.util.gtk.ContinuousRangeToColorMapper;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMap;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMapper;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.GTKFormat;
import com.sas.graphics.util.gtk.IntegerPipe;
import com.sas.graphics.util.gtk.IntegerVector;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericMap;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.NumericVector;
import com.sas.graphics.util.gtk.Probe;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringProperty;
import com.sas.graphics.util.gtk.StringToColorMap;
import com.sas.graphics.util.gtk.StringToColorMapper;
import com.sas.graphics.util.gtk.StringToNumericMap;
import com.sas.graphics.util.gtk.StringToNumericMapper;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.StringVector;
import com.sas.graphics.util.gtk.StringVectorVariable;
import com.sas.graphics.util.gtk.TextStyle;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.gl.Bar;
import com.sas.graphics.util.gtk.gl.LineSegment;
import com.sas.graphics.util.gtk.gl.NetworkRoot;
import com.sas.graphics.util.gtk.gl.RasterLabel;
import com.sas.graphics.util.gtk.gl.SelectResult;
import com.sas.graphics.util.legend.LegendItem;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.StringTokenizer;
import java.util.Vector;

public class WaterfallChartObject {
    public static final int FILL_SOLID = 1;
    public static final int FILL_GRADIENT = 2;
    protected Channel channel;
    protected NetworkRoot root;
    protected Bar transactionBar;
    protected Bar initialBar;
    protected Bar finalBar;
    protected RasterLabel barLabel;
    protected Variable categoryVariable;
    protected Variable responseVariable;
    private Variable colorVariable;
    protected StringToNumericMapper categoryMapper;
    protected ContinuousRangeToNumericMapper startValueMapper;
    protected ContinuousRangeToNumericMapper endValueMapper;
    protected ColorMapper colorMapper;
    protected ColorMapper outlineColorMapper;
    private Accumulator cumulativeResponse;
    private Calculator computedEndValue;
    private Calculator computedStartValue;
    private BooleanVector isCategorySelected;
    protected boolean reconnectRequired = false;
    protected DataRange responseRange;
    protected DataRange colorRange;
    protected int totalNumberOfCategories = 0;
    protected double barThicknessAsPercentage = 0.85;
    protected double barThicknessRelative;
    protected Image barSkin;
    protected Image legendSkin;
    protected int skinType;
    private Image[] pixelBenderImages;
    private Image[] legendPixelBenderImages;
    private float DPIScaleFactor = 1.0f;
    protected boolean showBarLabels = false;
    protected boolean showTrendLine = true;
    protected boolean showBarEdge = true;
    protected boolean showBarFill = true;
    protected boolean showInitialBar = false;
    protected boolean showFinalBar = true;
    protected double baselineIntercept = 0.0;
    protected int trendlineType;
    public static final int TREND_TO_END = 1;
    public static final int TREND_TO_START = 0;
    protected FillAttrs transactionBarFillAttrs = null;
    protected FillAttrs initialBarFillAttrs = null;
    protected FillAttrs finalBarFillAttrs = null;
    protected FillAttrs barIncreasingFillAttrs = null;
    protected FillAttrs barDecreasingFillAttrs = null;
    protected LineAttrs barOutlineAttrs = null;
    protected LineAttrs trendlineAttrs = null;
    protected LineAttrs trendlineIncreasingAttrs = null;
    protected LineAttrs trendlineDecreasingAttrs = null;
    protected TextStyle barLabelStyle;
    protected LineAttrs baseLineAttrs = null;
    protected double initialBarValue;
    protected double finalBarValue;
    protected String initialBarTickmarkLabel;
    protected String finalBarTickmarkLabel;
    protected boolean overrideInitialTickmarkLabel = false;
    private static final int BAR_COLOR_POLICY_DEFAULT = 0;
    public static final int BAR_COLOR_POLICY_CHART = 1;
    public static final int BAR_COLOR_POLICY_DISCRETE = 2;
    public static final int BAR_COLOR_POLICY_CONTINUOUS = 3;
    public static final int BAR_COLOR_POLICY_DISCRETE_GRADIENT = 4;
    public static final int BAR_COLOR_POLICY_CONTINUOUS_GRADIENT = 5;
    private int responseStatistic = 6;
    private int colorResponseStatistic = 6;
    private double dataTransparency = 0.0;
    private int fillType = 1;
    private Color neutralColor = Color.white;
    private SASFormat barLabelFormat = null;
    private StringToColorMapper trendlineColorMapper = null;
    private boolean overrideFillColor = false;
    private boolean overrideOutlineColor = false;
    private boolean colorByResponseSign = false;
    String barIncreasingLegendLabel = null;
    String barDecreasingLegendLabel = null;
    String barZeroLegendLabel = null;
    String barMissingLabel = null;
    private boolean autoRotateLabel = true;
    private boolean labelRotated = false;
    private boolean labelDropped = false;
    private int maxBarLabelWidth = 0;
    private double minNegativeBar = Double.MAX_VALUE;
    private boolean connectSkipMiss = false;
    private double lowerLimit = 0.0;
    private double upperLimit = 0.0;

    public WaterfallChartObject() {
        this.barLabelStyle = new TextStyle();
        this.barLabelStyle.setColor(Color.BLUE);
        this.initialBarValue = this.showInitialBar ? 0.0 : 0.0;
        this.finalBarValue = 0.0;
        this.initialBarTickmarkLabel = "Initial";
        this.initialBarFillAttrs = new FillAttrs();
        this.initialBarFillAttrs.setColor(Color.GRAY);
        this.initialBarFillAttrs.setTransparency(0.0);
        this.transactionBarFillAttrs = new FillAttrs();
        this.transactionBarFillAttrs.setColor(Color.BLUE);
        this.transactionBarFillAttrs.setTransparency(0.0);
        this.finalBarTickmarkLabel = "Final";
        this.finalBarFillAttrs = new FillAttrs();
        this.finalBarFillAttrs.setColor(Color.GRAY);
        this.finalBarFillAttrs.setTransparency(0.0);
        this.barIncreasingFillAttrs = new FillAttrs();
        this.barIncreasingFillAttrs.setColor(Color.GREEN);
        this.barDecreasingFillAttrs = new FillAttrs();
        this.barDecreasingFillAttrs.setColor(Color.RED);
        this.barOutlineAttrs = new LineAttrs();
        this.barOutlineAttrs.setColor(Color.black);
        this.barOutlineAttrs.setWidth(1);
        this.trendlineAttrs = new LineAttrs();
        this.trendlineAttrs.setColor(Color.GREEN);
        this.trendlineAttrs.setPatternName("Solid");
        this.trendlineAttrs.setWidth(1);
        this.trendlineIncreasingAttrs = new LineAttrs();
        this.trendlineIncreasingAttrs.setColor(Color.GREEN);
        this.trendlineIncreasingAttrs.setPatternName("Solid");
        this.trendlineIncreasingAttrs.setWidth(1);
        this.trendlineDecreasingAttrs = new LineAttrs();
        this.trendlineDecreasingAttrs.setColor(Color.RED);
        this.trendlineDecreasingAttrs.setPatternName("Solid");
        this.trendlineDecreasingAttrs.setWidth(1);
        this.baseLineAttrs = new LineAttrs();
        this.baseLineAttrs.setColor(Color.black);
        this.baseLineAttrs.setWidth(1);
        this.trendlineType = 0;
        this.barIncreasingLegendLabel = "Increasing";
        this.barDecreasingLegendLabel = "Decreasing";
        this.barZeroLegendLabel = "Zero";
        this.barMissingLabel = "Missing";
    }

    public void setDisplayMode(String mode) {
        if (mode.length() == 0) {
            return;
        }
        if (mode.equalsIgnoreCase("standard")) {
            this.showFinalBar = true;
            this.showTrendLine = true;
            this.showBarEdge = true;
            this.showBarFill = true;
        } else if (mode.equalsIgnoreCase("all")) {
            this.showFinalBar = true;
            this.showTrendLine = true;
            this.showBarEdge = true;
            this.showBarFill = true;
        } else {
            this.showFinalBar = false;
            this.showTrendLine = false;
            this.showBarEdge = false;
            this.showBarFill = false;
            StringTokenizer st = new StringTokenizer(mode);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if ("Fill".equalsIgnoreCase(token)) {
                    this.showBarFill = true;
                    continue;
                }
                if ("Outline".equalsIgnoreCase(token)) {
                    this.showBarEdge = true;
                    continue;
                }
                if ("Connect".equalsIgnoreCase(token)) {
                    this.showTrendLine = true;
                    continue;
                }
                if (!"FinalBar".equalsIgnoreCase(token)) continue;
                this.showFinalBar = true;
            }
        }
    }

    public Font getBarLabelFont() {
        return this.barLabelStyle.getFont();
    }

    public void setBarLabelFont(Font font) {
        this.barLabelStyle.setFont(font);
    }

    public Color getBarLabelColor() {
        return this.barLabelStyle.getColor();
    }

    public void setBarLabelColor(Color color) {
        this.barLabelStyle.setColor(color);
    }

    public Image getBarSkin() {
        return this.barSkin;
    }

    public void setBarSkin(Image barSkin) {
        this.barSkin = barSkin;
    }

    public void setLegendSkin(Image legendSkin) {
        this.legendSkin = legendSkin;
    }

    public void setSkinType(int t) {
        this.skinType = t;
    }

    public void setPixelBenderImages(Image[] imgs) {
        this.pixelBenderImages = imgs;
    }

    public void setLegendPixelBenderImages(Image[] imgs) {
        this.legendPixelBenderImages = imgs;
    }

    public void setDPIScaleFactor(float fac) {
        this.DPIScaleFactor = fac;
    }

    public Color getBarEdgeColor() {
        return this.barOutlineAttrs.getColor();
    }

    public void setBarEdgeColor(Color barEdgeColor) {
        this.barOutlineAttrs.setColor(barEdgeColor);
    }

    public int getBarEdgeWidth() {
        return this.barOutlineAttrs.getWidth();
    }

    public void setBarEdgeWidth(int barEdgeWidth) {
        this.barOutlineAttrs.setWidth(barEdgeWidth);
    }

    public double getBarThicknessAsPercentage() {
        return this.barThicknessAsPercentage;
    }

    public void setBarThicknessAsPercentage(double barThicknessAsPercentage) {
        this.barThicknessAsPercentage = barThicknessAsPercentage;
    }

    public double getTransactionBarTransparency() {
        return this.transactionBarFillAttrs.getTransparency();
    }

    public void setTransactionBarTransparency(double transparency) {
        this.transactionBarFillAttrs.setTransparency(transparency);
    }

    public boolean isShowBarFill() {
        return this.showBarFill;
    }

    public boolean isShowBarEdge() {
        return this.showBarEdge;
    }

    public boolean isShowBarLabels() {
        return this.showBarLabels;
    }

    public void setShowBarLabels(boolean showBarLabels) {
        this.showBarLabels = showBarLabels;
    }

    public boolean isShowTrendLine() {
        return this.showTrendLine;
    }

    public void setShowTrendLine(boolean showTrendLine) {
        this.showTrendLine = showTrendLine;
    }

    public boolean isShowInitialBar() {
        return this.showInitialBar;
    }

    public void setShowInitialBar(boolean showInitialBar) {
        this.showInitialBar = showInitialBar;
    }

    public boolean isShowFinalBar() {
        return this.showFinalBar;
    }

    public void setShowFinalBar(boolean showFinalBar) {
        this.showFinalBar = showFinalBar;
    }

    public double getBaselineIntercept() {
        return this.baselineIntercept;
    }

    public void setBaselineIntercept(double baselineIntercept) {
        this.baselineIntercept = baselineIntercept;
    }

    public int getTrendlineType() {
        return this.trendlineType;
    }

    public void setTrendlineType(int trendlineType) {
        this.trendlineType = trendlineType;
    }

    public double getInitialBarValue() {
        return this.initialBarValue;
    }

    public double getFinalBarValue() {
        return this.finalBarValue;
    }

    public void setInitialBarValue(double initialBarValue) {
        this.initialBarValue = initialBarValue;
        if (!Double.isNaN(initialBarValue)) {
            this.showInitialBar = true;
        }
    }

    public Color getInitialBarColor() {
        return this.initialBarFillAttrs.getColor();
    }

    public void setInitialBarColor(Color initialBarColor) {
        this.initialBarFillAttrs.setColor(initialBarColor);
    }

    public double getInitialBarTransparency() {
        return this.initialBarFillAttrs.getTransparency();
    }

    public void setInitialBarTransparency(double initialBarTransparency) {
        this.initialBarFillAttrs.setTransparency(initialBarTransparency);
    }

    public String getInitialBarTickmarkLabel() {
        return this.initialBarTickmarkLabel;
    }

    public void setInitialBarTickmarkLabel(String initialBarTickmarkLabel) {
        this.setInitialBarTickmarkLabel(initialBarTickmarkLabel, false);
    }

    public void setInitialBarTickmarkLabel(String initialBarTickmarkLabel, boolean initialize) {
        this.initialBarTickmarkLabel = initialBarTickmarkLabel;
        if (!initialize) {
            this.overrideInitialTickmarkLabel = true;
        }
    }

    public boolean isInitialTickmarkLabelOverriden() {
        return this.overrideInitialTickmarkLabel;
    }

    public Color getFinalBarColor() {
        return this.finalBarFillAttrs.getColor();
    }

    public void setFinalBarColor(Color finalBarColor) {
        this.finalBarFillAttrs.setColor(finalBarColor);
    }

    public double getFinalBarTransparency() {
        return this.finalBarFillAttrs.getTransparency();
    }

    public void setFinalBarTransparency(double finalBarTransparency) {
        this.finalBarFillAttrs.setTransparency(finalBarTransparency);
    }

    public String getFinalBarTickmarkLabel() {
        return this.finalBarTickmarkLabel;
    }

    public void setFinalBarTickmarkLabel(String finalBarTickmarkLabel) {
        this.finalBarTickmarkLabel = finalBarTickmarkLabel;
    }

    public TextStyle getBarLabelStyle() {
        return this.barLabelStyle;
    }

    public void setBarLabelStyle(TextStyle barLabelStyle) {
        this.barLabelStyle = barLabelStyle;
    }

    public FillAttrs getTransactionBarFillAttrs() {
        return this.transactionBarFillAttrs;
    }

    public void setTransactionBarFillAttrs(FillAttrs transactionBarFillAttrs) {
        this.transactionBarFillAttrs = transactionBarFillAttrs;
    }

    public FillAttrs getInitialBarFillAttrs() {
        return this.initialBarFillAttrs;
    }

    public void setInitialBarFillAttrs(FillAttrs initialBarFillAttrs) {
        this.initialBarFillAttrs = initialBarFillAttrs;
    }

    public FillAttrs getFinalBarFillAttrs() {
        return this.finalBarFillAttrs;
    }

    public void setFinalBarFillAttrs(FillAttrs finalBarFillAttrs) {
        this.finalBarFillAttrs = finalBarFillAttrs;
    }

    public LineAttrs getBarOutlineAttrs() {
        return this.barOutlineAttrs;
    }

    public void setBarOutlineAttrs(LineAttrs barOutlineAttrs) {
        this.barOutlineAttrs = barOutlineAttrs;
    }

    public LineAttrs getTrendlineAttrs() {
        return this.trendlineAttrs;
    }

    public void setTrendlineAttrs(LineAttrs trendlineAttrs) {
        this.trendlineAttrs = trendlineAttrs;
    }

    protected void initInitialBar() {
        this.initialBar = new Bar();
        this.initialBar.setTwoD(true);
        this.initialBar.selectEnabled.setValue(true);
        this.initialBar.selectDetailEnabled.setValue(true);
        this.initialBar.verticalOn.setValue(true);
        this.initialBar.color1.setValue(this.adjustTransparency(this.initialBarFillAttrs.getColor(), this.initialBarFillAttrs.getTransparency()));
        this.initialBar.trendLineColor.setValue(this.adjustTransparency(this.trendlineAttrs.getColor(), this.dataTransparency));
        this.initialBar.edgeOn.setValue(this.showBarEdge);
        this.initialBar.fillOn.setValue(this.showBarFill);
        this.initialBar.edgeWidth.setValue((double)this.barOutlineAttrs.getWidth());
        this.initialBar.edgePattern.setValue(this.barOutlineAttrs.getLinePattern());
        this.initialBar.edgeColor.setValue(this.adjustTransparency(this.barOutlineAttrs.getColor(), this.dataTransparency));
        if (this.barSkin != null) {
            this.initialBar.setSkin(this.barSkin);
        }
        this.initialBar.setSkinType(this.skinType);
        this.initialBar.setDPIScaleFactor(this.DPIScaleFactor);
        this.initialBar.setPixelBenderImages(this.pixelBenderImages);
    }

    public Bar getTransactionBarElement() {
        return this.transactionBar;
    }

    protected void initTransactionBar() {
        this.transactionBar = new Bar();
        if (this.fillType == 2) {
            this.transactionBar.gradientOn.setValue(true);
        } else {
            this.transactionBar.gradientOn.setValue(false);
        }
        this.transactionBar.setTwoD(true);
        this.transactionBar.selectEnabled.setValue(true);
        this.transactionBar.selectDetailEnabled.setValue(true);
        this.transactionBar.verticalOn.setValue(true);
        this.transactionBar.trendLineOn.setValue(this.showTrendLine);
        this.transactionBar.trendLineType.setValue(this.trendlineType);
        this.transactionBar.trendLineInitialOn.setValue(this.showTrendLine && this.showInitialBar);
        this.initTrendline(this.transactionBar);
        this.transactionBar.edgeOn.setValue(this.showBarEdge);
        this.transactionBar.fillOn.setValue(this.showBarFill);
        this.transactionBar.edgeWidth.setValue((double)this.barOutlineAttrs.getWidth());
        this.transactionBar.edgePattern.setValue(this.barOutlineAttrs.getLinePattern());
        if (this.barSkin != null) {
            this.transactionBar.setSkin(this.barSkin);
        }
        this.transactionBar.setSkinType(this.skinType);
        this.transactionBar.setDPIScaleFactor(this.DPIScaleFactor);
        this.transactionBar.setPixelBenderImages(this.pixelBenderImages);
        this.transactionBar.setSkipMissingOnTrendLine(this.connectSkipMiss);
    }

    protected void initTrendline(Bar bar) {
        bar.trendLineColor.setValue(this.adjustTransparency(this.trendlineAttrs.getColor(), this.dataTransparency));
        bar.trendLineWidth.setValue((double)this.trendlineAttrs.getWidth());
        bar.trendLinePattern.setValue(this.trendlineAttrs.getLinePattern());
        if (this.responseVariable instanceof NumericVariable && this.responseVariable.getValueCount() > 0) {
            NumericVariable rv = (NumericVariable)this.responseVariable;
            StringVector cv = new StringVector();
            int n = this.responseVariable.getValueCount();
            NumericVector wv = new NumericVector();
            NumericVector pv = new NumericVector();
            for (int i = 0; i < n; ++i) {
                try {
                    if (rv.value.getValue(i) >= 0.0) {
                        cv.addValue("Positive");
                        wv.addValue((double)this.trendlineIncreasingAttrs.getWidth());
                        pv.addValue((double)this.trendlineIncreasingAttrs.getLinePattern());
                        continue;
                    }
                    cv.addValue("Negative");
                    wv.addValue((double)this.trendlineDecreasingAttrs.getWidth());
                    pv.addValue((double)this.trendlineDecreasingAttrs.getLinePattern());
                    continue;
                }
                catch (MissingValueException e) {
                    cv.addValue("Missing");
                    wv.addValue((double)this.trendlineAttrs.getWidth());
                    pv.addValue((double)this.trendlineAttrs.getLinePattern());
                }
            }
            StringVectorVariable svv = new StringVectorVariable();
            svv.connectFrom((StringPipe)cv);
            StringToColorMap map = new StringToColorMap();
            map.add("Positive", this.adjustTransparency(this.trendlineIncreasingAttrs.getColor(), this.dataTransparency));
            map.add("Negative", this.adjustTransparency(this.trendlineDecreasingAttrs.getColor(), this.dataTransparency));
            this.trendlineColorMapper = new StringToColorMapper();
            this.trendlineColorMapper.input.disconnect();
            this.trendlineColorMapper.input.connectFrom(svv.value);
            this.trendlineColorMapper.setMap(map);
            bar.trendLineColor.connectFrom(this.trendlineColorMapper.value);
            bar.trendLineWidth.connectFrom((NumericPipe)wv);
            bar.trendLinePattern.connectFrom((NumericPipe)pv);
            return;
        }
    }

    protected void initFinalBar() {
        this.finalBar = new Bar();
        this.finalBar.setTwoD(true);
        this.finalBar.selectEnabled.setValue(true);
        this.finalBar.selectDetailEnabled.setValue(true);
        this.finalBar.verticalOn.setValue(true);
        this.finalBar.color1.setValue(this.adjustTransparency(this.finalBarFillAttrs.getColor(), this.finalBarFillAttrs.getTransparency()));
        this.finalBar.trendLineOn.setValue(this.showTrendLine);
        this.finalBar.trendLineInitialOn.setValue(this.showTrendLine);
        this.finalBar.trendLineColor.setValue(this.adjustTransparency(this.trendlineAttrs.getColor(), this.dataTransparency));
        this.finalBar.trendLineWidth.setValue((double)this.trendlineAttrs.getWidth());
        this.finalBar.trendLinePattern.setValue(this.trendlineAttrs.getLinePattern());
        this.finalBar.trendLineType.setValue(1);
        this.finalBar.edgeOn.setValue(this.showBarEdge);
        this.finalBar.fillOn.setValue(this.showBarFill);
        this.finalBar.edgeWidth.setValue((double)this.barOutlineAttrs.getWidth());
        this.finalBar.edgePattern.setValue(this.barOutlineAttrs.getLinePattern());
        this.finalBar.edgeColor.setValue(this.adjustTransparency(this.barOutlineAttrs.getColor(), this.dataTransparency));
        if (this.barSkin != null) {
            this.finalBar.setSkin(this.barSkin);
        }
        this.finalBar.setSkinType(this.skinType);
        this.finalBar.setDPIScaleFactor(this.DPIScaleFactor);
        this.finalBar.setPixelBenderImages(this.pixelBenderImages);
    }

    public void draw() {
        if (!this.allRequiredVariablesAreValid()) {
            return;
        }
        this.channel.glPushAttrib(0);
        this.channel.glDisable(4);
        this.channel.glDisable(3);
        this.root.draw(this.root.getChannel(), false);
        this.channel.glPopAttrib();
    }

    public void select() {
        if (this.root == null || !this.allRequiredVariablesAreValid()) {
            return;
        }
        this.root.draw(this.root.getChannel(), true);
    }

    public Vector getSelected(Rectangle r) {
        if (!this.allRequiredVariablesAreValid()) {
            return null;
        }
        this.channel.glPushAttrib(0);
        this.channel.glDisable(4);
        this.channel.glDisable(3);
        Vector selectedObservations = this.root.select(r.x, r.y, r.width, r.height, true, true);
        if (selectedObservations.size() == 0) {
            if (this.showInitialBar) {
                this.initialBar.highlightOn.setValue(false);
            }
            if (this.showFinalBar) {
                this.finalBar.highlightOn.setValue(false);
            }
        }
        for (int i = selectedObservations.size() - 1; i >= 0; --i) {
            Element selectedElement = ((SelectResult)selectedObservations.get(i)).getElement();
            if (selectedElement.equals(this.transactionBar)) continue;
            if (selectedElement.equals(this.initialBar)) {
                this.initialBar.highlightOn.setValue(true);
            } else if (selectedElement.equals(this.finalBar)) {
                this.finalBar.highlightOn.setValue(true);
            }
            selectedObservations.remove(i);
        }
        this.channel.glPopAttrib();
        return selectedObservations;
    }

    public void setSelected(int[] selectedObservationsArray) {
        for (int i = this.isCategorySelected.capacity() - 1; i >= 0; --i) {
            this.isCategorySelected.setValueAt(false, i);
        }
        if (selectedObservationsArray != null && selectedObservationsArray.length > 0) {
            int numberOfSelectableCategories = this.isCategorySelected.capacity();
            for (int i = selectedObservationsArray.length - 1; i >= 0; --i) {
                if (selectedObservationsArray[i] >= numberOfSelectableCategories) continue;
                this.isCategorySelected.setValueAt(true, selectedObservationsArray[i]);
            }
        }
    }

    public String getTipText(int screenX, int screenY) {
        Rectangle selectArea = new Rectangle(screenX, screenY, 1, 1);
        Vector selectResults = this.getSelected(selectArea);
        if (selectResults == null || selectResults.size() == 0) {
            return null;
        }
        SelectResult result = (SelectResult)selectResults.elementAt(0);
        Element selectedBar = result.getElement();
        int observationIndex = result.getValueIndex();
        if (observationIndex < 0 || observationIndex > this.categoryVariable.getValueCount()) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        if (selectedBar == this.initialBar) {
            sb.append("\n");
            sb.append(this.categoryVariable.getColumnName());
            sb.append(" \t=\t ");
            sb.append(this.initialBarTickmarkLabel);
            sb.append("\n");
            sb.append(this.responseVariable.getColumnName());
            sb.append(" \t=\t ");
            sb.append(this.initialBarValue - this.baselineIntercept);
        } else if (selectedBar == this.finalBar) {
            sb.append("\n");
            sb.append(this.categoryVariable.getColumnName());
            sb.append(" \t=\t ");
            sb.append(this.finalBarTickmarkLabel);
            sb.append("\n");
            sb.append(this.responseVariable.getColumnName());
            sb.append(" \t=\t ");
            sb.append(this.baselineIntercept - this.finalBar.startValue.getValue());
        } else {
            sb.append("\n");
            sb.append(this.categoryVariable.getColumnName());
            sb.append(" \t=\t ");
            sb.append(Variable.getValue((Variable)this.categoryVariable, (int)observationIndex, (boolean)true));
            sb.append("\n");
            sb.append(this.responseVariable.getColumnName());
            sb.append(" \t=\t ");
            sb.append(Variable.getValue((Variable)this.responseVariable, (int)observationIndex, (boolean)true));
        }
        return sb.toString();
    }

    public DataRange getDataRange(byte dimension) {
        switch (dimension) {
            case 2: {
                return this.responseRange;
            }
        }
        return null;
    }

    protected void computeTotalNumberOfCategories() {
        int n = this.totalNumberOfCategories = this.categoryVariable == null ? 0 : this.categoryVariable.getUniqueValueCount();
        if (this.showInitialBar) {
            ++this.totalNumberOfCategories;
        }
        if (this.showFinalBar) {
            ++this.totalNumberOfCategories;
        }
    }

    protected void computeResponseRange() {
        DataRange newRange = null;
        DataRange oldRange = this.responseRange;
        FontMetrics fm = BubbleObject.getFontMetrics(this.barLabelStyle.getFont());
        if (this.responseVariable != null) {
            if (this.responseVariable.getValueCount() == 0) {
                return;
            }
            if (this.responseVariable instanceof NumericVariable) {
                NumericVariable nv = (NumericVariable)this.responseVariable;
                double relativeMin = Math.min(this.initialBarValue, this.baselineIntercept);
                double relativeMax = Math.max(this.initialBarValue, this.baselineIntercept);
                double responseTotal = this.initialBarValue;
                String label = this.barLabelFormat.format((Object)responseTotal).trim();
                this.maxBarLabelWidth = fm.stringWidth(label);
                this.minNegativeBar = Double.MAX_VALUE;
                int numberOfValues = nv.getValueCount();
                for (int i = 0; i < numberOfValues; ++i) {
                    try {
                        responseTotal += nv.value.getValue(i);
                        if (responseTotal < relativeMin) {
                            relativeMin = responseTotal;
                        } else if (responseTotal > relativeMax) {
                            relativeMax = responseTotal;
                        }
                        label = this.barLabelFormat.format((Object)responseTotal).trim();
                        this.maxBarLabelWidth = Math.max(this.maxBarLabelWidth, fm.stringWidth(label));
                        if (!(nv.value.getValue(i) < 0.0)) continue;
                        this.minNegativeBar = Math.min(responseTotal, this.minNegativeBar);
                        continue;
                    }
                    catch (MissingValueException missingValueException) {
                        // empty catch block
                    }
                }
                this.finalBarValue = responseTotal;
                newRange = new ContinuousRange(relativeMin, relativeMax);
            }
        }
        if (newRange != null && newRange.equals(oldRange)) {
            newRange = oldRange;
        }
        newRange.setLabel(this.responseVariable.getLabel());
        this.responseRange = newRange;
    }

    public Insets getPreferredInnerMargin(double wallWidth, double wallHeight) {
        return this.getPreferredInnerMargin(wallWidth, wallHeight, null);
    }

    public Insets getPreferredInnerMargin(double wallWidth, double wallHeight, ContinuousRangeToNumericMap map) {
        int l;
        int t;
        if (this.categoryVariable == null || this.responseVariable == null) {
            return null;
        }
        int b = t = 5;
        if (this.categoryVariable.getValueCount() == 0) {
            return new Insets(t, 0, b, 0);
        }
        int componentBasedWidth = (int)Math.rint(this.channel.getComponent().getWidth() / this.totalNumberOfCategories);
        int mapperBasedWidth = (int)Math.rint(wallWidth / (double)this.totalNumberOfCategories);
        int r = l = Math.max(componentBasedWidth, mapperBasedWidth) / 2;
        if (this.showBarLabels) {
            boolean reverse = map != null && map.getInputMin() > map.getInputMax();
            double requiredBarLabelHeight = Math.max(this.barLabelStyle.getFont().getSize(), this.barLabelStyle.getFont().getSize());
            ContinuousRange continuousResponseRange = (ContinuousRange)this.responseRange;
            int extraPadding = (int)Math.ceil(requiredBarLabelHeight * 0.15);
            this.labelRotated = false;
            this.labelDropped = false;
            if (this.autoRotateLabel && this.maxBarLabelWidth > Math.min(componentBasedWidth, mapperBasedWidth)) {
                this.labelRotated = true;
            }
            if (this.labelRotated) {
                boolean bl = this.labelDropped = requiredBarLabelHeight > (double)Math.min(componentBasedWidth, mapperBasedWidth);
                if (!this.labelDropped) {
                    int b0 = b;
                    int t0 = t;
                    if (continuousResponseRange.getMin() < this.baselineIntercept) {
                        b += this.maxBarLabelWidth + extraPadding;
                    } else if (this.minNegativeBar != Double.MAX_VALUE && map != null) {
                        double ratio = Math.abs((map.getOutputMax() - map.getOutputMin()) / (map.getInputMax() - map.getInputMin()));
                        double space = Math.abs((this.minNegativeBar - Math.min(map.getInputMin(), map.getInputMax())) * ratio);
                        if (space < (double)(this.maxBarLabelWidth + extraPadding)) {
                            b = (int)((double)b + ((double)(this.maxBarLabelWidth + extraPadding) - space));
                        }
                    }
                    if (continuousResponseRange.getMax() >= this.baselineIntercept) {
                        t += this.maxBarLabelWidth + extraPadding;
                    }
                    r = l = (int)Math.ceil(Math.max((double)l, requiredBarLabelHeight * 0.5));
                }
            } else {
                if (continuousResponseRange.getMin() < this.baselineIntercept) {
                    b = (int)((double)b + requiredBarLabelHeight);
                } else if (this.minNegativeBar != Double.MAX_VALUE && map != null) {
                    double ratio = Math.abs((map.getOutputMax() - map.getOutputMin()) / (map.getInputMax() - map.getInputMin()));
                    double space = Math.abs((this.minNegativeBar - Math.min(map.getInputMin(), map.getInputMax())) * ratio);
                    if (space < requiredBarLabelHeight) {
                        b = (int)((double)b + (requiredBarLabelHeight - space));
                    }
                }
                if (continuousResponseRange.getMax() >= this.baselineIntercept) {
                    t = (int)((double)t + requiredBarLabelHeight);
                }
                r = l = (int)Math.ceil(Math.max((double)l, (double)(this.maxBarLabelWidth + extraPadding) * 0.5));
            }
            if (reverse) {
                int temp = t;
                t = b;
                b = temp;
            }
        }
        return new Insets(t, l, b, r);
    }

    public void setDataRegionBounds(Rectangle bounds) {
        this.channel.getComponent().setBounds(bounds);
    }

    public void setChannel(Channel aChannel) {
        if (aChannel == null) {
            return;
        }
        this.channel = aChannel;
        this.createNetwork();
    }

    public Channel getChannel() {
        return this.channel;
    }

    protected void createNetwork() {
        this.root = new NetworkRoot(this.channel);
    }

    public NetworkRoot getNetworkRoot() {
        return this.root;
    }

    public Variable getCatetoryVariable() {
        return this.categoryVariable;
    }

    public void setCategoryVariable(Variable variable) {
        if (variable == null) {
            return;
        }
        this.categoryVariable = variable;
        this.isCategorySelected = new BooleanVector(this.categoryVariable.getValueCount());
        for (int i = this.isCategorySelected.capacity() - 1; i >= 0; --i) {
            this.isCategorySelected.addValue(false);
        }
        this.reconnectRequired = true;
        this.computeTotalNumberOfCategories();
    }

    public Variable getResponseVariable() {
        return this.responseVariable;
    }

    public void setResponseVariable(Variable variable) {
        if (variable == null) {
            return;
        }
        this.responseVariable = variable;
        this.reconnectRequired = true;
        this.computeResponseRange();
    }

    public boolean isReconnectRequired() {
        return this.reconnectRequired;
    }

    public boolean allRequiredVariablesAreValid() {
        return this.root != null && this.channel != null && this.categoryVariable != null && this.responseVariable != null && this.categoryVariable.isConnected() && this.responseVariable.isConnected();
    }

    public boolean connectNetwork(StringToNumericMap categorymap, ContinuousRangeToNumericMap responsemap, ColorMap colormap, ColorMap outlineColorMap, RangeAttrMapper rangeAttrMapper, DiscreteAttrMapper discreteAttrMapper, Probe probe, Probe initBarProbe, Probe finalBarProbe) {
        if (!this.allRequiredVariablesAreValid()) {
            return false;
        }
        this.root.removeAllElements();
        boolean rc = this.connectCategoryMappers(categorymap);
        if (!rc) {
            return false;
        }
        rc &= this.connectResponseMappers(responsemap);
        if (colormap != null) {
            rc = this.connectColorMapper(colormap, outlineColorMap, rangeAttrMapper, discreteAttrMapper);
        } else if (this.isColorByResponseSign()) {
            rc = this.connectResponseSignColorMapper();
        } else {
            this.colorMapper = null;
        }
        if (colormap == null && !this.isColorByResponseSign()) {
            this.transactionBar.color1.setValue(this.adjustTransparency(this.transactionBarFillAttrs.getColor(), this.transactionBarFillAttrs.getTransparency()));
            this.transactionBar.color2.setValue(this.adjustTransparency(this.neutralColor, this.transactionBarFillAttrs.getTransparency()));
        }
        LineSegment baseLine = new LineSegment();
        this.root.addElement((Element)baseLine);
        baseLine.beginX.setValue(this.lowerLimit);
        baseLine.beginY.setValue(this.startValueMapper.getValue(this.baselineIntercept));
        baseLine.endX.setValue(this.upperLimit);
        baseLine.endY.setValue(this.startValueMapper.getValue(this.baselineIntercept));
        baseLine.color.setValue(this.adjustTransparency(this.baseLineAttrs.getColor(), this.dataTransparency));
        baseLine.lineWidth.setValue((double)this.baseLineAttrs.getWidth());
        baseLine.linePattern.setValue(this.baseLineAttrs.getLinePattern());
        if (this.overrideOutlineColor || outlineColorMap == null) {
            this.transactionBar.edgeColor.setValue(this.adjustTransparency(this.barOutlineAttrs.getColor(), this.dataTransparency));
        }
        if (this.showInitialBar) {
            this.initialBar.setUserData((Object)initBarProbe);
        }
        this.transactionBar.setUserData((Object)probe);
        if (this.showFinalBar) {
            this.finalBar.setUserData((Object)finalBarProbe);
        }
        this.root.addElement((Element)this.initialBar);
        this.root.addElement((Element)this.transactionBar);
        this.root.addElement((Element)this.finalBar);
        if (this.showBarLabels && !this.labelDropped) {
            rc &= this.connectBarLabelMappers();
            this.root.addElement((Element)this.barLabel);
        }
        this.reconnectRequired = !rc;
        return rc;
    }

    protected boolean connectCategoryMappers(StringToNumericMap categorymap) {
        if (categorymap == null || this.categoryVariable.getValueCount() == 0) {
            return false;
        }
        if (this.categoryMapper == null) {
            this.categoryMapper = new StringToNumericMapper();
        }
        this.categoryMapper.input.disconnect();
        this.categoryMapper.input.connectFrom(this.categoryVariable.formattedValue);
        this.categoryMapper.setMap(categorymap);
        this.computeBarThickness((NumericMap)categorymap);
        this.initTransactionBar();
        this.transactionBar.position.connectFrom((NumericPipe)this.categoryMapper);
        this.transactionBar.thickness.setValue(this.barThicknessRelative);
        this.transactionBar.highlightOn.connectFrom((BooleanPipe)this.isCategorySelected);
        if (this.showInitialBar) {
            this.initInitialBar();
            this.initialBar.position.setValue(categorymap.getOutputMin());
            this.initialBar.thickness.setValue(this.barThicknessRelative);
            this.transactionBar.trendLineInitialX.setValue(this.initialBar.position.getValue() + this.barThicknessRelative / 2.0);
        }
        if (this.showFinalBar) {
            this.initFinalBar();
            this.finalBar.position.setValue(categorymap.getOutputMax());
            this.finalBar.thickness.setValue(this.barThicknessRelative);
            try {
                this.finalBar.trendLineInitialX.setValue(this.categoryMapper.getValue(Variable.getValue((Variable)this.categoryVariable, (int)(this.categoryVariable.getValueCount() - 1), (boolean)true)) + this.barThicknessRelative / 2.0);
            }
            catch (MissingValueException e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    protected boolean connectResponseMappers(ContinuousRangeToNumericMap responsemap) {
        if (responsemap == null) {
            return false;
        }
        if (this.cumulativeResponse == null) {
            this.cumulativeResponse = new Accumulator();
            this.cumulativeResponse.setPostAccumulate(true);
            this.cumulativeResponse.setStartValue(this.initialBarValue);
        }
        this.cumulativeResponse.input.disconnect();
        this.cumulativeResponse.input.connectFrom(((NumericVariable)this.responseVariable).value);
        if (this.computedEndValue == null) {
            this.computedStartValue = new Calculator("inA");
            this.computedEndValue = new Calculator("inA + inB");
        }
        this.computedStartValue.inA.connectFrom((NumericPipe)this.cumulativeResponse);
        this.computedEndValue.inA.connectFrom((NumericPipe)this.cumulativeResponse);
        this.computedEndValue.inB.connectFrom(((NumericVariable)this.responseVariable).value);
        if (this.startValueMapper == null) {
            this.startValueMapper = new ContinuousRangeToNumericMapper();
        }
        this.startValueMapper.input.disconnect();
        this.startValueMapper.input.connectFrom((NumericPipe)this.computedStartValue);
        this.startValueMapper.setMap(responsemap);
        if (this.endValueMapper == null) {
            this.endValueMapper = new ContinuousRangeToNumericMapper();
        }
        this.endValueMapper.input.disconnect();
        this.endValueMapper.input.connectFrom((NumericPipe)this.computedEndValue);
        this.endValueMapper.setMap(responsemap);
        this.transactionBar.startValue.connectFrom((NumericPipe)this.startValueMapper);
        this.transactionBar.endValue.connectFrom((NumericPipe)this.endValueMapper);
        if (this.showInitialBar) {
            this.initialBar.startValue.setValue(this.startValueMapper.getValue(this.baselineIntercept));
            this.initialBar.endValue.setValue(this.startValueMapper.getValue(this.initialBarValue));
            this.transactionBar.trendLineInitialY.setValue(this.startValueMapper.getValue(this.initialBarValue));
        }
        if (this.showFinalBar) {
            this.finalBar.trendLineInitialY.setValue(this.startValueMapper.getValue(((NumericVariable)this.responseVariable).getSum() + this.initialBarValue));
            this.finalBar.startValue.setValue(this.startValueMapper.getValue(this.baselineIntercept));
            this.finalBar.endValue.setValue(this.finalBar.trendLineInitialY.getValue());
            if (this.showTrendLine) {
                int lastTransanctionBar = 0;
                int n = this.categoryVariable.getUniqueValueCount();
                for (int i = n - 1; i >= 0; --i) {
                    try {
                        ((NumericVariable)this.responseVariable).value.getValue(i);
                        lastTransanctionBar = i;
                        break;
                    }
                    catch (MissingValueException missingValueException) {
                        continue;
                    }
                }
                if (lastTransanctionBar != n - 1) {
                    if (this.connectSkipMiss) {
                        this.finalBar.trendLineOn.setValue(false);
                        this.finalBar.trendLineInitialOn.setValue(false);
                    } else {
                        try {
                            this.finalBar.trendLineInitialX.setValue(this.categoryMapper.getValue(Variable.getValue((Variable)this.categoryVariable, (int)lastTransanctionBar, (boolean)true)) + this.barThicknessRelative / 2.0);
                        }
                        catch (MissingValueException missingValueException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        return true;
    }

    protected boolean connectBarLabelMappers() {
        if (this.responseVariable == null || this.categoryVariable == null || this.categoryMapper == null) {
            return false;
        }
        GTKFormat responseLabelFormat = this.responseVariable.getFormat();
        int responseCount = this.responseVariable.getValueCount();
        NumericVector responseValues = new NumericVector();
        StringVector labelValues = new StringVector();
        double extraPadding = 0.0;
        if (this.labelRotated) {
            extraPadding = (int)Math.ceil((double)this.barLabelStyle.getFont().getSize() * 0.15);
        }
        NumericVector offset = new NumericVector();
        NumericVector allEndValues = new NumericVector();
        NumericVector computedCategoryPositions = new NumericVector();
        TextStyle labelStyle = null;
        if (this.showInitialBar && this.showBarLabels) {
            allEndValues.addValue(this.initialBar.endValue.getValue());
            computedCategoryPositions.addValue(this.initialBar.position.getValue());
        }
        for (int i = 0; i < responseCount; ++i) {
            try {
                allEndValues.addValue(this.endValueMapper.getValue(i));
                computedCategoryPositions.addValue(this.categoryMapper.getValue(i));
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        if (this.showFinalBar && this.showBarLabels) {
            allEndValues.addValue(this.finalBar.endValue.getValue());
            computedCategoryPositions.addValue(this.finalBar.position.getValue());
        }
        Calculator responsePlusOffset = new Calculator("inA + inB");
        responsePlusOffset.inA.connectFrom((NumericPipe)allEndValues);
        responsePlusOffset.inB.connectFrom((NumericPipe)offset);
        IntegerVector justificationStyle = new IntegerVector();
        if (this.responseVariable != null && this.responseVariable.isConnected()) {
            labelStyle = this.barLabelStyle;
            if (this.showBarLabels && this.showInitialBar) {
                double v = this.initialBarValue - this.baselineIntercept;
                this.updateBarLabelMetaDataVectors(this.initialBarValue, v < 0.0, extraPadding, responseValues, labelValues, offset, justificationStyle);
            }
            for (int i = 0; i < responseCount; ++i) {
                try {
                    Object fdl = Variable.getValue((Variable)this.responseVariable, (int)i, (boolean)true);
                    double v = ((NumericVariable)this.responseVariable).value.getValue(i);
                    String label = this.barLabelFormat.format((Object)v);
                    this.updateBarLabelMetaDataVectors(label, v < 0.0, extraPadding, labelValues, offset, justificationStyle);
                    continue;
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
            }
            if (this.showBarLabels && this.showFinalBar) {
                double v;
                this.updateBarLabelMetaDataVectors(v, (v = this.initialBarValue + ((NumericVariable)this.responseVariable).getSum()) - this.baselineIntercept < 0.0, extraPadding, responseValues, labelValues, offset, justificationStyle);
            }
        } else {
            labelStyle = this.barLabelStyle;
            double lastValue = 0.0;
            if (this.showInitialBar) {
                double v = this.initialBarValue - this.baselineIntercept;
                this.updateBarLabelMetaDataVectors(this.initialBarValue, v < 0.0, extraPadding, responseValues, labelValues, offset, justificationStyle);
                lastValue = this.initialBarValue;
            }
            for (int i = 0; i < responseCount; ++i) {
                try {
                    double v = ((NumericVariable)this.responseVariable).value.getValue(i);
                    double value = lastValue + v;
                    this.updateBarLabelMetaDataVectors(value, v < 0.0, extraPadding, responseValues, labelValues, offset, justificationStyle);
                    lastValue = value;
                    continue;
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
            }
            if (this.showFinalBar) {
                double v;
                this.updateBarLabelMetaDataVectors(v, (v = this.initialBarValue + ((NumericVariable)this.responseVariable).getSum()) - this.baselineIntercept < 0.0, extraPadding, responseValues, labelValues, offset, justificationStyle);
            }
        }
        StringProperty labelProperty = new StringProperty();
        labelProperty.connectFrom((StringPipe)labelValues);
        if (this.barLabelFormat != null) {
            if (this.barLabel == null) {
                this.barLabel = new RasterLabel();
                this.barLabel.trimOn.setValue(true);
                this.barLabel.color.setValue(this.adjustTransparency(labelStyle.getColor(), this.dataTransparency));
                this.barLabel.fontName.setValue(labelStyle.getFont().getName());
                this.barLabel.fontSize.setValue(labelStyle.getFont().getSize());
                this.barLabel.fontStyle.setValue(labelStyle.getFont().getStyle());
                this.barLabel.horizontalJustification.setValue(1);
            } else {
                this.barLabel.string.disconnect();
                this.barLabel.transform.translateX.disconnect();
                this.barLabel.transform.translateY.disconnect();
                this.barLabel.verticalJustification.disconnect();
            }
        }
        this.barLabel.string.connectFrom((StringPipe)labelProperty);
        this.barLabel.transform.translateX.connectFrom((NumericPipe)computedCategoryPositions);
        this.barLabel.transform.translateY.connectFrom((NumericPipe)responsePlusOffset);
        this.barLabel.verticalJustification.connectFrom((IntegerPipe)justificationStyle);
        this.barLabel.angle.setValue(this.labelRotated ? 90.0 : 0.0);
        return true;
    }

    protected void updateBarLabelMetaDataVectors(double newValue, boolean negativeValue, double extraPadding, NumericVector responseValues, StringVector labelValues, NumericVector offset, IntegerVector justificationStyle) {
        responseValues.addValue(newValue);
        labelValues.addValue(this.barLabelFormat.format((Object)new Double(newValue)));
        if (!negativeValue) {
            offset.addValue(extraPadding);
            justificationStyle.addValue(3);
        } else if (negativeValue) {
            offset.addValue(-extraPadding);
            justificationStyle.addValue(0);
        }
    }

    protected void updateBarLabelMetaDataVectors(String newValue, boolean negativeValue, double extraPadding, StringVector labelValues, NumericVector offset, IntegerVector justificationStyle) {
        labelValues.addValue(newValue);
        if (!negativeValue) {
            offset.addValue(extraPadding);
            justificationStyle.addValue(3);
        } else if (negativeValue) {
            offset.addValue(-extraPadding);
            justificationStyle.addValue(0);
        }
    }

    protected double computeBarThickness(NumericMap map) {
        this.barThicknessRelative = this.barThicknessAsPercentage * (map.getOutputMax() - map.getOutputMin()) / (double)(this.totalNumberOfCategories - 1);
        return this.barThicknessRelative;
    }

    private boolean connectResponseSignColorMapper() {
        if (this.responseVariable instanceof NumericVariable && this.responseVariable.getValueCount() > 0) {
            NumericVariable rv = (NumericVariable)this.responseVariable;
            StringVector cv = new StringVector();
            int n = this.responseVariable.getValueCount();
            for (int i = 0; i < n; ++i) {
                try {
                    if (rv.value.getValue(i) > 0.0) {
                        cv.addValue(this.barIncreasingLegendLabel);
                        continue;
                    }
                    if (rv.value.getValue(i) < 0.0) {
                        cv.addValue(this.barDecreasingLegendLabel);
                        continue;
                    }
                    cv.addValue(this.barZeroLegendLabel);
                    continue;
                }
                catch (MissingValueException e) {
                    cv.addValue(this.barMissingLabel);
                }
            }
            StringVectorVariable svv = new StringVectorVariable();
            svv.connectFrom((StringPipe)cv);
            StringToColorMap map = new StringToColorMap();
            double trans = this.barIncreasingFillAttrs.getTransparency() == -1.0 ? this.dataTransparency : this.barIncreasingFillAttrs.getTransparency();
            Color c = this.adjustTransparency(this.barIncreasingFillAttrs.getColor(), trans);
            if (this.overrideFillColor) {
                c = this.adjustTransparency(this.transactionBarFillAttrs.getColor(), trans);
            }
            map.add(this.barIncreasingLegendLabel, c);
            trans = this.barDecreasingFillAttrs.getTransparency() == -1.0 ? this.dataTransparency : this.barDecreasingFillAttrs.getTransparency();
            c = this.adjustTransparency(this.barDecreasingFillAttrs.getColor(), trans);
            if (this.overrideFillColor) {
                c = this.adjustTransparency(this.transactionBarFillAttrs.getColor(), trans);
            }
            map.add(this.barDecreasingLegendLabel, c);
            map.add(this.barZeroLegendLabel, this.adjustTransparency(this.transactionBarFillAttrs.getColor(), this.dataTransparency));
            StringToColorMapper stcMapper = new StringToColorMapper();
            stcMapper.input.disconnect();
            stcMapper.input.connectFrom(svv.value);
            stcMapper.setMap(map);
            this.transactionBar.color1.connectFrom(stcMapper.value);
            this.transactionBar.color2.setValue(this.neutralColor);
            return true;
        }
        return false;
    }

    private boolean connectColorMapper(ColorMap colorMap, ColorMap outlineColorMap, RangeAttrMapper rangeAttrMapper, DiscreteAttrMapper discreteAttrMapper) {
        if (colorMap == null) {
            return false;
        }
        if (colorMap instanceof StringToColorMap) {
            StringToColorMap stcmap = (StringToColorMap)colorMap;
            if (this.colorMapper == null || !(this.colorMapper instanceof StringToColorMapper)) {
                this.colorMapper = new StringToColorMapper();
            }
            StringToColorMapper stcmapper = (StringToColorMapper)this.colorMapper;
            stcmapper.input.disconnect();
            stcmapper.input.connectFrom(((StringVariable)this.colorVariable).formattedValue);
            stcmapper.setMap(stcmap);
            if (discreteAttrMapper != null) {
                discreteAttrMapper.variable = this.colorVariable.formattedValue;
                discreteAttrMapper.fillColorMapper = stcmapper;
                discreteAttrMapper.lineColorMapper = stcmapper;
                this.transactionBar.color1.connectFrom(discreteAttrMapper.fillColor);
                this.transactionBar.color2.setValue(this.neutralColor);
            } else {
                this.transactionBar.color1.connectFrom(stcmapper.value);
                this.transactionBar.color2.setValue(this.neutralColor);
            }
            if (outlineColorMap != null) {
                if (this.outlineColorMapper == null || !(this.outlineColorMapper instanceof StringToColorMapper)) {
                    this.outlineColorMapper = new StringToColorMapper();
                }
                StringToColorMapper outline_stcmapper = (StringToColorMapper)this.outlineColorMapper;
                outline_stcmapper.input.disconnect();
                outline_stcmapper.input.connectFrom(((StringVariable)this.colorVariable).formattedValue);
                outline_stcmapper.setMap((StringToColorMap)outlineColorMap);
                this.transactionBar.edgeColor.connectFrom(outline_stcmapper.value);
            }
            if (this.overrideFillColor) {
                this.transactionBar.color1.setValue(this.adjustTransparency(this.transactionBarFillAttrs.getColor(), this.transactionBarFillAttrs.getTransparency()));
            }
        } else if (rangeAttrMapper != null && colorMap instanceof ContinuousRangeToColorMap) {
            rangeAttrMapper.variable = ((NumericVariable)this.colorVariable).value;
            this.transactionBar.color1.connectFrom(rangeAttrMapper.color);
            this.transactionBar.color2.setValue(this.neutralColor);
        } else if (colorMap instanceof ContinuousRangeToColorMap) {
            ContinuousRangeToColorMap crtcmap = (ContinuousRangeToColorMap)colorMap;
            if (this.colorMapper == null || !(this.colorMapper instanceof ContinuousRangeToColorMapper)) {
                this.colorMapper = new ContinuousRangeToColorMapper();
            }
            ContinuousRangeToColorMapper crtcmapper = (ContinuousRangeToColorMapper)this.colorMapper;
            crtcmapper.input.disconnect();
            crtcmapper.input.connectFrom(((NumericVariable)this.colorVariable).value);
            crtcmapper.setMap(crtcmap);
            this.transactionBar.color1.connectFrom(crtcmapper.value);
            this.transactionBar.color2.setValue(this.neutralColor);
        }
        return true;
    }

    protected Color adjustTransparency(Color color, double transparency) {
        if (transparency >= 0.0) {
            return new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(255.0 * (1.0 - transparency)));
        }
        return color;
    }

    public String[] getUniqueValues(byte dim) {
        Object[] vals;
        if (dim == 4 && this.colorRange instanceof DiscreteRange && (vals = ((DiscreteRange)this.colorRange).getValues().toArray()) != null) {
            String[] str = new String[vals.length];
            for (int i = 0; i < vals.length; ++i) {
                str[i] = vals[i].toString();
            }
            return str;
        }
        return null;
    }

    public void setXLimits(double lowerLimit, double upperLimit) {
        this.lowerLimit = lowerLimit;
        this.upperLimit = upperLimit;
    }

    public int getResponseStatistic() {
        return this.responseStatistic;
    }

    public void setResponseStatistic(int responseStatistic) {
        this.responseStatistic = responseStatistic;
    }

    public Variable getColorVariable() {
        return this.colorVariable;
    }

    public void setColorVariable(Variable colorVar) {
        this.colorVariable = colorVar;
    }

    public LegendItem getOverlayLegendItem(String legendLabel) {
        LegendItem item = null;
        if (this.showBarEdge) {
            FillAttrs fa = new FillAttrs(this.adjustTransparency(this.transactionBarFillAttrs.getColor(), this.transactionBarFillAttrs.getTransparency()), 0.0);
            LineAttrs la = new LineAttrs(this.barOutlineAttrs);
            la.setColor(this.adjustTransparency(this.barOutlineAttrs.getColor(), this.dataTransparency));
            item = new LegendItem((ColorAttr)fa, (ColorAttr)la, legendLabel, null);
        } else {
            item = new LegendItem(3, legendLabel);
            item.getSymbolAttrs().setColor(this.adjustTransparency(this.transactionBarFillAttrs.getColor(), this.transactionBarFillAttrs.getTransparency()));
        }
        if (this.legendSkin != null) {
            item.setSkinImage(this.legendSkin);
        }
        if (this.legendPixelBenderImages != null) {
            item.setPixelBenderImages(this.legendPixelBenderImages);
        }
        item.setSkinType(this.skinType);
        return item;
    }

    public LegendItem[] getLegendItems(StringVectorVariable scVar, int attrType, DiscreteAttrMapper discreteAttrMapper, StringToColorMap colorMap, StringToColorMap outlineColorMap) {
        Vector<LegendItem> legendItems = new Vector<LegendItem>();
        if (this.colorVariable instanceof StringVectorVariable) {
            if (discreteAttrMapper != null) {
                discreteAttrMapper.variable = scVar.formattedValue;
            }
            if (scVar != null) {
                for (int i = 0; i < scVar.getUniqueValueCount(); ++i) {
                    try {
                        Color c;
                        int idx = scVar.getFirstOccurringValueIndex(i);
                        String value = scVar.formattedValue.getValue(idx);
                        if (this.showBarFill) {
                            LegendItem item;
                            c = colorMap.getValue(value);
                            if (c == null) continue;
                            if (discreteAttrMapper != null && discreteAttrMapper.fillColor.getValue(idx) != null) {
                                c = discreteAttrMapper.fillColor.getValue(idx);
                            }
                            FillAttrs fa = new FillAttrs();
                            fa.setColor(c);
                            if (this.overrideFillColor && !(this.colorVariable instanceof NumericVariable)) {
                                double tr = this.transactionBarFillAttrs.getTransparency();
                                Color tbfc = this.transactionBarFillAttrs.getColor();
                                if (tr >= 0.0) {
                                    int a = (int)(255.0 * (1.0 - tr));
                                    Color nc = new Color(tbfc.getRed(), tbfc.getGreen(), tbfc.getBlue(), a);
                                    fa.setColor(nc);
                                } else {
                                    fa.setColor(tbfc);
                                }
                            }
                            c = outlineColorMap.getValue(value);
                            if (discreteAttrMapper != null && discreteAttrMapper.lineColor.getValue(idx) != null) {
                                c = discreteAttrMapper.lineColor.getValue(idx);
                            }
                            if (this.overrideOutlineColor) {
                                c = this.barOutlineAttrs.getColor();
                            }
                            LineAttrs la = new LineAttrs();
                            la.setLinePattern(this.barOutlineAttrs.getLinePattern());
                            la.setWidth(this.barOutlineAttrs.getWidth());
                            la.setColor(c);
                            LegendItem legendItem = item = this.showBarEdge ? new LegendItem((ColorAttr)fa, (ColorAttr)la, value, null) : new LegendItem((ColorAttr)fa, null, value, null);
                            if (this.legendSkin != null) {
                                item.setSkinImage(this.legendSkin);
                            }
                            if (this.legendPixelBenderImages != null) {
                                item.setPixelBenderImages(this.legendPixelBenderImages);
                            }
                            item.setSkinType(this.skinType);
                            legendItems.add(item);
                            continue;
                        }
                        c = outlineColorMap.getValue(value);
                        if (discreteAttrMapper != null && discreteAttrMapper.lineColor.getValue(idx) != null) {
                            c = discreteAttrMapper.lineColor.getValue(idx);
                        }
                        if (this.overrideOutlineColor) {
                            c = this.barOutlineAttrs.getColor();
                        }
                        LineAttrs la = new LineAttrs();
                        la.setLinePattern(this.barOutlineAttrs.getLinePattern());
                        la.setWidth(this.barOutlineAttrs.getWidth());
                        la.setColor(c);
                        LegendItem item = new LegendItem(2, value);
                        item.setSymbolAttrs((ColorAttr)la);
                        if (this.legendSkin != null) {
                            item.setSkinImage(this.legendSkin);
                        }
                        if (this.legendPixelBenderImages != null) {
                            item.setPixelBenderImages(this.legendPixelBenderImages);
                        }
                        item.setSkinType(this.skinType);
                        legendItems.add(item);
                        continue;
                    }
                    catch (MissingValueException idx) {
                        // empty catch block
                    }
                }
            }
        } else if (this.isColorByResponseSign()) {
            FillAttrs ifa = new FillAttrs(this.barIncreasingFillAttrs.getColor(), this.barIncreasingFillAttrs.getTransparency());
            if (ifa.getTransparency() == -1.0) {
                ifa.setTransparency(this.dataTransparency);
            }
            if (this.overrideFillColor) {
                ifa.setColor(this.transactionBarFillAttrs.getColor());
            }
            LegendItem barIncreasingLegendItem = new LegendItem((ColorAttr)ifa, null, this.barIncreasingLegendLabel, null);
            if (this.legendSkin != null) {
                barIncreasingLegendItem.setSkinImage(this.legendSkin);
            }
            if (this.legendPixelBenderImages != null) {
                barIncreasingLegendItem.setPixelBenderImages(this.legendPixelBenderImages);
            }
            barIncreasingLegendItem.setSkinType(this.skinType);
            legendItems.add(barIncreasingLegendItem);
            FillAttrs dfa = new FillAttrs(this.barDecreasingFillAttrs.getColor(), this.barDecreasingFillAttrs.getTransparency());
            if (dfa.getTransparency() == -1.0) {
                dfa.setTransparency(this.dataTransparency);
            }
            if (this.overrideFillColor) {
                dfa.setColor(this.transactionBarFillAttrs.getColor());
            }
            LegendItem barDecreasingLegendItem = new LegendItem((ColorAttr)dfa, null, this.barDecreasingLegendLabel, null);
            if (this.legendSkin != null) {
                barDecreasingLegendItem.setSkinImage(this.legendSkin);
            }
            if (this.legendPixelBenderImages != null) {
                barDecreasingLegendItem.setPixelBenderImages(this.legendPixelBenderImages);
            }
            barDecreasingLegendItem.setSkinType(this.skinType);
            legendItems.add(barDecreasingLegendItem);
        }
        if (legendItems.size() > 0) {
            return legendItems.toArray(new LegendItem[legendItems.size()]);
        }
        return null;
    }

    public double getDataTransparency() {
        return this.dataTransparency;
    }

    public void setDataTransparency(double dataTransparency) {
        this.dataTransparency = dataTransparency;
    }

    public int getFillType() {
        return this.fillType;
    }

    public void setFillType(int fillType) {
        this.fillType = fillType;
    }

    public boolean isConnectSkipMiss() {
        return this.connectSkipMiss;
    }

    public void setConnectSkipMiss(boolean b) {
        this.connectSkipMiss = b;
    }

    public Color getNeutralColor() {
        return this.neutralColor;
    }

    public void setNeutralColor(Color neutralColor) {
        this.neutralColor = neutralColor;
    }

    public SASFormat getBarLabelFormat() {
        return this.barLabelFormat;
    }

    public void setBarLabelFormat(SASFormat barLabelFormat) {
        this.barLabelFormat = barLabelFormat;
    }

    public LineAttrs getTrendlineIncreasingAttrs() {
        return this.trendlineIncreasingAttrs;
    }

    public void setTrendlineIncreasingAttrs(LineAttrs trendlineIncreasingAttrs) {
        this.trendlineIncreasingAttrs = trendlineIncreasingAttrs;
    }

    public LineAttrs getTrendlineDecreasingAttrs() {
        return this.trendlineDecreasingAttrs;
    }

    public void setTrendlineDecreasingAttrs(LineAttrs trendlineDecreasingAttrs) {
        this.trendlineDecreasingAttrs = trendlineDecreasingAttrs;
    }

    public boolean isFillColorOverride() {
        return this.overrideFillColor;
    }

    public void setFillColorOverride(boolean overrideFillColor) {
        this.overrideFillColor = overrideFillColor;
    }

    public boolean isOutlineColorOverride() {
        return this.overrideOutlineColor;
    }

    public void setOutlineColorOverride(boolean overrideOutlineColor) {
        this.overrideOutlineColor = overrideOutlineColor;
    }

    public LineAttrs getBaseLineAttrs() {
        return this.baseLineAttrs;
    }

    public void setBaseLineAttrs(LineAttrs baseLineAttrs) {
        this.baseLineAttrs = baseLineAttrs;
    }

    public boolean isColorByResponseSign() {
        return this.colorByResponseSign;
    }

    public void setColorByResponseSign(boolean colorByResponseSign) {
        this.colorByResponseSign = colorByResponseSign;
    }

    public FillAttrs getBarIncreasingFillAttrs() {
        return this.barIncreasingFillAttrs;
    }

    public void setBarIncreasingFillAttrs(FillAttrs barIncreasingFillAttrs) {
        this.barIncreasingFillAttrs = barIncreasingFillAttrs;
    }

    public FillAttrs getBarDecreasingFillAttrs() {
        return this.barDecreasingFillAttrs;
    }

    public void setBarDecreasingFillAttrs(FillAttrs barDecreasingFillAttrs) {
        this.barDecreasingFillAttrs = barDecreasingFillAttrs;
    }

    public String getBarIncreasingLegendLabel() {
        return this.barIncreasingLegendLabel;
    }

    public void setBarIncreasingLegendLabel(String barIncreasingLegendLabel) {
        this.barIncreasingLegendLabel = barIncreasingLegendLabel;
    }

    public String getBarDecreasingLegendLabel() {
        return this.barDecreasingLegendLabel;
    }

    public void setBarDecreasingLegendLabel(String barDecreasingLegendLabel) {
        this.barDecreasingLegendLabel = barDecreasingLegendLabel;
    }

    public boolean isAutoRotateLabel() {
        return this.autoRotateLabel;
    }

    public void setAutoRotateLabel(boolean rotate) {
        this.autoRotateLabel = rotate;
    }

    public int getColorResponseStatistic() {
        return this.colorResponseStatistic;
    }

    public void setColorResponseStatistic(int colorResponseStatistic) {
        this.colorResponseStatistic = colorResponseStatistic;
    }
}

