/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.common.pie;

import com.sas.MissingValues;
import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorAttr;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.TextAttrs;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.styles.DataStyleElement;
import com.sas.graphics.styles.Style;
import com.sas.graphics.util.attrmap.DiscreteAttributeMap;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.BooleanPipe;
import com.sas.graphics.util.gtk.GTKPieSelectDetail;
import com.sas.graphics.util.gtk.LineStyle;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.NumericVectorVariable;
import com.sas.graphics.util.gtk.OLAPLevelVariable;
import com.sas.graphics.util.gtk.StringToColorMap;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.TextStyle;
import com.sas.graphics.util.gtk.ValueMap;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.VariableProcessor;
import com.sas.graphics.util.gtk.gl.GTKLogEventListener;
import com.sas.graphics.util.gtk.gl.GTKPie;
import com.sas.graphics.util.gtk.render.RendererUtil;
import com.sas.graphics.util.gtk.render.pie.GTKPieChartRenderer;
import com.sas.graphics.util.gtk.render.pie.GTKPieChartRendererModel;
import com.sas.graphics.util.legend.DiscreteLegendInterface;
import com.sas.graphics.util.legend.LegendItem;
import com.sas.measures.Measure;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JComponent;

public class Pie
implements DiscreteLegendInterface {
    private GTKPieChartRenderer renderer;
    private GTKPieChartRendererModel rendererModel;
    private StringVariable categoryVariable;
    private StringVariable groupVariable;
    private NumericVariable[] responseVarArr;
    private NumericVariable[] defaultResponseVarArr;
    private Variable[] toolTipVarArr;
    private Variable[] otherVariableArr;
    private Variable urlVar;
    private NumericVariable colorIndex;
    private NumericVectorVariable freqVar;
    private int statistic = -1;
    private List<Color> colorList;
    private StringToColorMap strToColorMap;
    private VariableProcessor vp = new VariableProcessor();
    private FillAttrs fillAttrs;
    private FillAttrs otherFillAttrs;
    private LineAttrs outLineAttrs;
    private TextAttrs sliceLabelTAttrs;
    private TextAttrs groupLabelTAttrs;
    private TextAttrs groupValueTAttrs;
    private double dataTransparency = 0.0;
    private int otherMaxSlices;
    private double otherPercent;
    private OtherSliceType otherThresholdType;
    private boolean otherSlice;
    private LabelPlacement dataLabelPlacement;
    private RendererUtil.DataLabel dataLabelContent;
    private SortOrderType sortOrder = null;
    private DiscreteAttributeMap categoryAttrbMap;
    private String whereClause;
    private SortOrderType groupSortOrder = null;
    private boolean includeMissingCategory = false;
    private boolean includeMissingGroup = true;
    private BooleanPipe chPipe;
    private final ResourceBundle rb = ResourceLoader.loadBundle("com.sas.graphics.common.pie.pie");
    private HashMap<String, Integer> catStrMap;
    private Style styleObj;
    private DataStyleElement missingElem;
    private ArrayList<String> categoriesList = new ArrayList();
    private ArrayList<String> groupsList = new ArrayList();

    public Pie(JComponent component) {
        this.rendererModel = new GTKPieChartRendererModel();
        this.renderer = new GTKPieChartRenderer(this.rendererModel, component);
        this.init();
    }

    public Pie(JComponent component, Variable catVariable) {
        this(component);
        this.setCategoryVar(catVariable);
    }

    public Pie(JComponent component, Variable catVariable, NumericVariable responseVariable) {
        this(component, catVariable);
        this.setResponseVar(responseVariable);
    }

    private void init() {
        this.fillAttrs = new FillAttrs();
        this.otherFillAttrs = new FillAttrs();
        this.outLineAttrs = new LineAttrs();
        this.sliceLabelTAttrs = new TextAttrs();
        this.groupLabelTAttrs = new TextAttrs();
        this.groupValueTAttrs = new TextAttrs();
        this.getFillAttrs().setColor(null);
        this.applyTextAttrs();
        this.rendererModel.setOtherColor(this.otherFillAttrs.getColor());
        String otherLabel = ResourceLoader.getResourceString(this.rb, "Pie.otherlabel.txt", "Other");
        this.rendererModel.setOtherSliceLabel(otherLabel);
        this.otherMaxSlices = 10;
        this.otherPercent = 4.0;
        this.otherThresholdType = OtherSliceType.PERCENT;
        this.setShowOtherSlice(true);
        this.setDataLabelPlacement(LabelPlacement.ARROW);
        this.setDataLabelContent(RendererUtil.DataLabel.CATEGORY_RESPONSE_PERCENT);
    }

    public DiscreteAttributeMap getCategoryAttributeMap() {
        return this.categoryAttrbMap;
    }

    public void setCategoryAttributeMap(DiscreteAttributeMap map) {
        this.categoryAttrbMap = map;
    }

    private void applyTextAttrs() {
        TextStyle gtkTS = this.rendererModel.getInsideSliceLabelTextStyle();
        this.translateTextAttrs(this.sliceLabelTAttrs, gtkTS);
        this.rendererModel.setOutsideSliceLabelTextStyle(gtkTS);
        this.rendererModel.setResponseLabelTextStyle(gtkTS);
        gtkTS = this.rendererModel.getSubgroupLabelTextStyle();
        this.translateTextAttrs(this.groupLabelTAttrs, gtkTS);
        gtkTS = this.rendererModel.getSubgroupLabelValueTextStyle();
        this.translateTextAttrs(this.groupValueTAttrs, gtkTS);
    }

    private void translateTextAttrs(TextAttrs statTS, TextStyle gtkTS) {
        gtkTS.setColor(Pie.applyTransparency(statTS.getColor(), this.getTranspanrencyToApply((ColorAttr)statTS)));
        gtkTS.setFont(statTS.getFont());
    }

    public StringVariable getCategoryVar() {
        return this.categoryVariable;
    }

    public void setCategoryVar(Variable variable) {
        if (variable == null) {
            throw new NullPointerException("Category variable should be not null to create a pie chart");
        }
        this.categoryVariable = new StringVariable();
        if (variable instanceof NumericVariable) {
            this.categoryVariable.connectFrom((NumericVariable)variable);
            this.sortOrder = SortOrderType.CATEGORY_ASC;
        } else {
            this.categoryVariable.connectFrom((StringVariable)variable);
            this.sortOrder = SortOrderType.DATA;
        }
        this.categoryVariable.setLabel(variable.getLabel());
        this.categoryVariable.setFormat(variable.getFormat());
        this.rendererModel.setCategoryVariable(this.categoryVariable);
        this.createDefaultResponse();
    }

    public void setCategorySortOrder(SortOrderType sort) {
        this.sortOrder = sort;
    }

    public void setGroupSortOrder(SortOrderType sort) {
        this.groupSortOrder = sort;
    }

    public NumericVariable[] getResponseVar() {
        return this.responseVarArr;
    }

    public void setResponseVar(NumericVariable ... responseVariable) {
        if (responseVariable != null && responseVariable.length >= 1 && responseVariable[0] != null) {
            this.responseVarArr = responseVariable;
        }
    }

    public StringVariable getGroupVariable() {
        return this.groupVariable;
    }

    public void setGroupVariable(Variable gVariable) {
        if (gVariable == null) {
            return;
        }
        this.groupVariable = new StringVariable();
        if (gVariable instanceof NumericVariable) {
            this.groupVariable.connectFrom((NumericVariable)gVariable);
        } else {
            this.groupVariable.connectFrom((StringVariable)gVariable);
        }
        if (this.groupSortOrder == SortOrderType.CATEGORY_ASC) {
            this.groupVariable.getConnection().setUniqueValueSort(1);
        } else {
            this.groupVariable.getConnection().setUniqueValueSort(0);
        }
        this.groupVariable.setLabel(gVariable.getLabel());
    }

    public List<Color> getColorList() {
        return this.colorList;
    }

    public void setColorList(List<Color> colorList) {
        this.colorList = colorList;
    }

    public StringToColorMap getPieColorMap() {
        return this.strToColorMap;
    }

    public Variable getColorIndex() {
        return this.colorIndex;
    }

    public void setColorIndex(NumericVariable colorIndex) {
        this.colorIndex = colorIndex;
        if (colorIndex != null) {
            this.vp.addVariable((Variable)this.colorIndex, 0);
        }
    }

    public NumericVectorVariable getFreqVar() {
        return this.freqVar;
    }

    public void setFreqVar(NumericVectorVariable freqVar) {
        this.freqVar = freqVar;
    }

    public boolean build() {
        this.buildInternal();
        this.renderer.construct();
        return true;
    }

    private boolean buildInternal() {
        if (this.categoryVariable == null || this.responseVarArr == null && this.defaultResponseVarArr == null && this.freqVar == null) {
            return false;
        }
        this.removeSort();
        this.rendererModel.setCategoryVariable(this.categoryVariable);
        this.rendererModel.setResponseVariableArray((Variable[])this.getResponseVars());
        this.summarizeData();
        if (this.strToColorMap != null) {
            this.rendererModel.setColorMap(this.strToColorMap);
        }
        this.applyAttrs();
        this.applyOther();
        this.applySort();
        return true;
    }

    private void applyCategoryAttrbMap() {
        if (this.categoryAttrbMap == null) {
            return;
        }
        int catCount = this.categoryVariable.getUniqueValueCount();
        for (int i = 0; i < catCount; ++i) {
            Color attrColor;
            String tempCat = null;
            try {
                tempCat = this.categoryVariable.getConnection().formattedUniqueValue.getValue(i);
            }
            catch (MissingValueException e) {
                tempCat = ValueMap.getDefaultMissingValueLabel((MissingValues)e.getMissingValue());
            }
            if (tempCat == null || !this.categoryAttrbMap.contains(tempCat)) continue;
            Color origColor = this.strToColorMap.getValue(tempCat);
            FillAttrs fillAttr = this.categoryAttrbMap.get(tempCat).getFillAttrs();
            double attrTransparency = -1.0;
            if (fillAttr == null) {
                attrColor = origColor;
            } else {
                attrColor = fillAttr.getColor();
                attrTransparency = fillAttr.getTransparency();
            }
            if (attrColor == null) {
                attrColor = origColor;
            }
            if (attrTransparency == -1.0) {
                Color c = new Color(attrColor.getRed(), attrColor.getGreen(), attrColor.getBlue(), origColor.getAlpha());
                this.strToColorMap.add(tempCat, c);
                continue;
            }
            this.strToColorMap.add(tempCat, Pie.applyTransparency(attrColor, attrTransparency));
        }
    }

    private void applyLabelLocationAndContent() {
        this.applyDataLabelPlacement();
        this.applyDataLabelContent();
    }

    private void applyDataLabelContent() {
        switch (this.dataLabelPlacement.ordinal()) {
            case 2: 
            case 3: {
                this.rendererModel.setOutsideSliceLabelContent(this.dataLabelContent);
                this.rendererModel.setInsideSliceLabelContent(RendererUtil.DataLabel.NONE);
                break;
            }
            default: {
                this.rendererModel.setInsideSliceLabelContent(this.dataLabelContent);
                this.rendererModel.setOutsideSliceLabelContent(RendererUtil.DataLabel.NONE);
            }
        }
    }

    private void applyDataLabelPlacement() {
        switch (this.dataLabelPlacement.ordinal()) {
            case 3: {
                this.rendererModel.setOutsideSliceLabelPlacement(RendererUtil.Placement.ARROW);
                break;
            }
            case 2: {
                this.rendererModel.setOutsideSliceLabelPlacement(RendererUtil.Placement.BEST);
                break;
            }
            case 1: {
                this.rendererModel.setInsideSliceLabelPlacement(RendererUtil.Placement.DEFAULT);
                break;
            }
            case 4: {
                this.rendererModel.setInsideSliceLabelPlacement(RendererUtil.Placement.INSIDE_IF_FIT);
                break;
            }
            default: {
                this.rendererModel.setInsideSliceLabelPlacement(RendererUtil.Placement.BEST);
            }
        }
    }

    private void applyOther() {
        String unitName;
        double magnitude = 0.0;
        switch (this.getOtherThresholdType().ordinal()) {
            case 1: {
                magnitude = this.getOtherMaxSlices();
                unitName = "MaxSlices";
                break;
            }
            default: {
                magnitude = this.getOtherPercent();
                unitName = "percent";
            }
        }
        if (!this.isOtherSliceEnabled()) {
            magnitude = 0.0;
        }
        GTKPieChartRendererModel.GenericMeasure gm = new GTKPieChartRendererModel.GenericMeasure(magnitude, unitName);
        this.rendererModel.setOtherThreshold((Measure)gm);
    }

    private void applySort() {
        this.sortVariable(this.convertSortType(this.sortOrder), false, this.categoryVariable.getConnection());
    }

    private void sortVariable(int sortType, boolean sortByFormattedValues, Variable var) {
        var.setSortByFormattedValues(sortByFormattedValues);
        var.setUniqueValueSort(sortType);
    }

    private void removeSort() {
        this.sortVariable(this.convertSortType(SortOrderType.DATA), false, this.categoryVariable.getConnection());
    }

    private int convertSortType(SortOrderType type) {
        switch (type.ordinal()) {
            case 0: {
                return 1;
            }
        }
        return 0;
    }

    public void paintComponent(Graphics g) {
        this.renderer.paintComponent(g);
    }

    public void construct() {
        this.renderer.construct();
    }

    private void mapFillColor() {
        this.removeSort();
        if (!this.isFillOn()) {
            this.vp.addGroupVariable(this.categoryVariable.getConnection());
            return;
        }
        int idx = 0;
        int clistLen = -1;
        ArrayList<String> keysList = new ArrayList<String>();
        ArrayList<Color> colorsList = new ArrayList<Color>();
        int catCount = this.categoriesList.size();
        HashMap<String, Color> topLevelMap = new HashMap<String, Color>();
        if (this.colorList != null) {
            clistLen = this.colorList.size();
        }
        boolean useColorIdx = this.colorIndex != null;
        double transp = this.getTranspanrencyToApply((ColorAttr)this.fillAttrs);
        Color sliceColor = this.getFillAttrs().getColor();
        boolean isMissingCategory = false;
        int colorCntr = 0;
        String topLevelCat = null;
        boolean expandedCategory = false;
        boolean isOlap = this.categoryVariable.getConnection() instanceof OLAPLevelVariable;
        for (int i = 0; i < catCount; ++i) {
            topLevelCat = null;
            String tempCat = this.categoriesList.get(i);
            isMissingCategory = this.isMissing(tempCat, (Variable)this.categoryVariable);
            if (isOlap) {
                topLevelCat = Pie.getTopLevelValue(tempCat);
                expandedCategory = !tempCat.equals(topLevelCat);
            }
            keysList.add(tempCat);
            Color topLevelColor = (Color)topLevelMap.get(topLevelCat);
            if (expandedCategory && topLevelColor != null) {
                colorsList.add(topLevelColor);
                continue;
            }
            Color c = Color.white;
            if (sliceColor != null) {
                c = sliceColor;
            } else if (useColorIdx && this.colorList != null) {
                try {
                    idx = (int)this.colorIndex.value.getValue(i) - 1;
                }
                catch (MissingValueException e) {
                    e.printStackTrace();
                }
                if (idx >= clistLen) {
                    idx %= clistLen;
                }
                c = this.colorList.get(idx);
            } else if (isMissingCategory) {
                c = this.missingElem.getDefaultColor();
            } else {
                c = this.styleObj.getDataStyleElement(colorCntr).getFillColor();
                ++colorCntr;
            }
            ++idx;
            c = Pie.applyTransparency(c, transp);
            colorsList.add(c);
            if (!expandedCategory) continue;
            topLevelMap.put(topLevelCat, c);
        }
        this.vp.addGroupVariable(this.categoryVariable.getConnection());
        if (this.rendererModel.isSectorPie() && this.rendererModel.getSubgroupVariable() != null) {
            keysList.addAll(this.groupsList);
            ArrayList<Color> groupSlicesColorsList = this.getColorForGroupSlices();
            colorsList.addAll(groupSlicesColorsList);
        }
        String[] keysArr = new String[keysList.size()];
        keysArr = keysList.toArray(keysArr);
        Color[] colorsArr = new Color[colorsList.size()];
        colorsArr = colorsList.toArray(colorsArr);
        this.strToColorMap = new StringToColorMap(keysArr, colorsArr);
        this.strToColorMap.addStringPipe(this.categoryVariable.getConnection().formattedUniqueValue);
        this.strToColorMap.init(new AInitAction());
        this.applyCategoryAttrbMap();
        this.strToColorMap.init(new AInitAction());
        if (this.rendererModel.isSectorPie() && this.rendererModel.getSubgroupVariable() != null) {
            this.strToColorMap.addStringPipe(this.groupVariable.getConnection().formattedUniqueValue);
            this.strToColorMap.init(new AInitAction());
        }
    }

    private boolean isMissing(String str, Variable var) {
        if (str == null) {
            return false;
        }
        if ((var = var.getConnection()) instanceof NumericVariable) {
            return ".".equals(str.trim());
        }
        return "".equals(str.trim());
    }

    private ArrayList<Color> getColorForGroupSlices() {
        ArrayList<Color> groupSlicesColorsList = new ArrayList<Color>();
        int idx = 0;
        int clistLen = -1;
        if (this.colorList != null) {
            clistLen = this.colorList.size();
        }
        int groupCount = this.groupsList.size();
        boolean useColorIdx = this.colorIndex != null;
        boolean isMissingGroup = false;
        int colorCntr = 0;
        Color sliceColor = this.getFillAttrs().getColor();
        double transp = this.getTranspanrencyToApply((ColorAttr)this.fillAttrs);
        for (int i = 0; i < groupCount; ++i) {
            String eachGroup = this.groupsList.get(i);
            isMissingGroup = this.isMissing(eachGroup, (Variable)this.groupVariable);
            Color c = Color.white;
            if (sliceColor != null) {
                c = sliceColor;
            } else if (useColorIdx && this.colorList != null) {
                try {
                    idx = (int)this.colorIndex.value.getValue(i) - 1;
                }
                catch (MissingValueException e) {
                    e.printStackTrace();
                }
                if (idx >= clistLen) {
                    idx %= clistLen;
                }
                c = this.colorList.get(idx);
            } else if (isMissingGroup) {
                c = this.missingElem.getDefaultColor();
            } else {
                c = this.styleObj.getDataStyleElement(colorCntr).getFillColor();
                ++colorCntr;
            }
            ++idx;
            c = Pie.applyTransparency(c, transp);
            groupSlicesColorsList.add(c);
        }
        return groupSlicesColorsList;
    }

    private double getTranspanrencyToApply(ColorAttr style) {
        return style.getTransparency() == -1.0 ? this.dataTransparency : style.getTransparency();
    }

    private double getTransparencyForOtherToApply(ColorAttr style) {
        return style.getTransparency() == -1.0 ? (this.fillAttrs.getTransparency() == -1.0 ? this.dataTransparency : this.fillAttrs.getTransparency()) : style.getTransparency();
    }

    public GTKPieChartRendererModel getModel() {
        return this.rendererModel;
    }

    public int getStatistic() {
        return this.statistic;
    }

    public void setStatistic(int statistic) {
        this.statistic = statistic;
    }

    public boolean isFillOn() {
        return this.rendererModel.isFillEnabled();
    }

    public void setFillOn(boolean fillOn) {
        this.rendererModel.setFillEnable(fillOn);
    }

    public boolean isOutlineOn() {
        return this.rendererModel.getOutlineLineStyle().isVisible();
    }

    public void setOutlineOn(boolean outlineOn) {
        this.rendererModel.getOutlineLineStyle().setVisible(outlineOn);
    }

    public static Color applyTransparency(Color c, double transparency) {
        if (c == null || transparency == 0.0) {
            return c;
        }
        int alpha = (int)(255.0 * (1.0 - transparency));
        Color nc = new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
        return nc;
    }

    public double getDataTransparency() {
        return this.dataTransparency;
    }

    public void setDataTransparency(double dataTransparency) {
        this.dataTransparency = dataTransparency;
    }

    public FillAttrs getFillAttrs() {
        return this.fillAttrs;
    }

    public void setFillAttrs(FillAttrs fillAttrs) {
        this.fillAttrs = fillAttrs;
    }

    public FillAttrs getOtherFillAttrs() {
        return this.otherFillAttrs;
    }

    public void setOtherFillAttrs(FillAttrs otherFillAttrs) {
        this.otherFillAttrs = otherFillAttrs;
    }

    public LineAttrs getOutLineAttrs() {
        return this.outLineAttrs;
    }

    public void setOutLineAttrs(LineAttrs outLineAttrs) {
        this.outLineAttrs = outLineAttrs;
    }

    public TextAttrs getSliceLabelTextAttrs() {
        return this.sliceLabelTAttrs;
    }

    public void setSliceLabelTextAttrs(TextAttrs sliceLableTAttrs) {
        this.sliceLabelTAttrs = sliceLableTAttrs;
    }

    public TextAttrs getGroupLabelTextAttrs() {
        return this.groupLabelTAttrs;
    }

    public void setGroupLabelTextAttrs(TextAttrs groupLabelTAttrs) {
        this.groupLabelTAttrs = groupLabelTAttrs;
    }

    public TextAttrs getGroupValueTextAttrs() {
        return this.groupValueTAttrs;
    }

    public void setGroupValueTextAttrs(TextAttrs groupValueTAttrs) {
        this.groupValueTAttrs = groupValueTAttrs;
    }

    private void translateLineAttrs() {
        LineStyle gtkLineStyle = this.rendererModel.getOutlineLineStyle();
        gtkLineStyle.setColor(Pie.applyTransparency(this.outLineAttrs.getColor(), this.getTranspanrencyToApply((ColorAttr)this.outLineAttrs)));
        gtkLineStyle.setStippleFactor(this.outLineAttrs.stippleFactor);
        gtkLineStyle.setStipplePattern(this.outLineAttrs.stipplePattern);
        gtkLineStyle.setWidth(this.outLineAttrs.width);
    }

    private void createDefaultResponse() {
        String defaultResponseLabel = ResourceLoader.getResourceString(this.rb, "Pie.defaultresponselabel.txt", "Response");
        int n = this.categoryVariable.getValueCount();
        double[] count = new double[n];
        for (int i = 0; i < n; ++i) {
            count[i] = 1.0;
        }
        NumericVectorVariable defResponseVar = new NumericVectorVariable();
        defResponseVar.connectFrom(count);
        defResponseVar.setLabel(defaultResponseLabel);
        this.setDefaultResponseVars(new NumericVariable[]{defResponseVar});
    }

    private boolean summarizeData() {
        this.vp.removeAllVariables();
        this.vp = new VariableProcessor();
        this.rendererModel.setSubgroupVariable(null);
        if (this.groupVariable != null) {
            this.rendererModel.setSubgroupVariable(this.groupVariable);
            this.groupVariable.getConnection().setFormattedValueMissingValueExceptionsEnabled(false);
            this.vp.addGroupVariable(this.groupVariable.getConnection());
            if (this.groupSortOrder == SortOrderType.CATEGORY_ASC) {
                this.groupVariable.setUniqueValueSort(1);
            }
        }
        this.categoryVariable.getConnection().setFormattedValueMissingValueExceptionsEnabled(false);
        this.setCategoryStringsList();
        if (this.colorIndex != null) {
            this.vp.addVariable((Variable)this.colorIndex, 0);
        }
        this.mapFillColor();
        if (this.categoryVariable.getConnection() instanceof NumericVariable) {
            this.vp.addVariable(this.categoryVariable.getConnection(), 12);
        }
        if (this.responseVarArr != null && this.responseVarArr.length > 0) {
            for (NumericVariable numericVariable : this.responseVarArr) {
                if (numericVariable == null) continue;
                this.vp.addVariable((Variable)numericVariable, this.getStatistic());
            }
        }
        if (this.freqVar != null) {
            this.vp.addVariable((Variable)this.freqVar);
        }
        if (this.responseVarArr == null && this.freqVar == null) {
            for (NumericVariable numericVariable : this.defaultResponseVarArr) {
                this.vp.addVariable((Variable)numericVariable);
            }
        }
        if (this.isToolTipVarSet()) {
            for (int i = 0; i < this.toolTipVarArr.length; ++i) {
                if (this.toolTipVarArr[i] instanceof NumericVariable) {
                    this.vp.addVariable(this.toolTipVarArr[i], this.getStatistic());
                    continue;
                }
                this.vp.addVariable(this.toolTipVarArr[i], 12);
            }
        }
        if (this.urlVar != null) {
            this.vp.addVariable(this.urlVar, 12);
        }
        if (this.otherVariableArr != null) {
            for (Variable variable : this.otherVariableArr) {
                if (variable instanceof NumericVariable) {
                    this.vp.addVariable(variable, this.getStatistic());
                    continue;
                }
                this.vp.addVariable(variable, 12);
            }
        }
        if (this.rendererModel.isSectorPie() && this.rendererModel.getSubgroupVariable() != null) {
            this.includeMissingCategory = false;
        }
        String newWhereClause = this.whereClause;
        if (this.excludeMissingCategory()) {
            String missingCatExp = "(not (" + this.categoryVariable.getName() + " is missing))";
            String string = newWhereClause = newWhereClause == null ? missingCatExp : newWhereClause + " and " + missingCatExp;
        }
        if (this.excludeMissingGroup() && this.groupVariable != null) {
            String missingGrpExp = "(not (" + this.groupVariable.getName() + " is missing))";
            newWhereClause = newWhereClause == null ? missingGrpExp : newWhereClause + " and " + missingGrpExp;
        }
        this.vp.setWhereExpression(newWhereClause);
        if (this.chPipe != null) {
            NumericVectorVariable nv = new NumericVectorVariable();
            nv.connectFrom(this.chPipe);
            this.vp.addVariable((Variable)nv);
            this.rendererModel.setCHPipe(nv.value);
        }
        return true;
    }

    private void setDefaultResponseVars(NumericVariable ... responseVar) {
        this.defaultResponseVarArr = responseVar;
    }

    private void applyAttrs() {
        this.translateLineAttrs();
        this.applyTextAttrs();
        double trnsp = this.getTransparencyForOtherToApply((ColorAttr)this.otherFillAttrs);
        Color othColr = Pie.applyTransparency(this.otherFillAttrs.getColor(), trnsp);
        this.rendererModel.setOtherColor(othColr);
    }

    public NumericVariable[] getResponseVars() {
        return this.getResponseVarsInternal();
    }

    private NumericVariable[] getResponseVarsInternal() {
        if (this.responseVarArr != null) {
            return this.responseVarArr;
        }
        if (this.freqVar != null) {
            return new NumericVariable[]{this.freqVar};
        }
        return this.defaultResponseVarArr;
    }

    public int getOtherMaxSlices() {
        return this.otherMaxSlices;
    }

    public void setOtherMaxSlices(int maxSlices) {
        this.otherMaxSlices = maxSlices;
    }

    public double getOtherPercent() {
        return this.otherPercent;
    }

    public void setOtherPercent(double otherPercent) {
        this.otherPercent = otherPercent;
    }

    public OtherSliceType getOtherThresholdType() {
        return this.otherThresholdType;
    }

    public void setOtherThresholdType(OtherSliceType otherThresholdType) {
        this.otherThresholdType = otherThresholdType;
    }

    public void setOtherThreshold(double otherMaxVal, OtherSliceType otherThresholdType) {
        switch (otherThresholdType.ordinal()) {
            case 1: {
                this.setOtherMaxSlices((int)otherMaxVal);
                break;
            }
            default: {
                this.setOtherPercent(otherMaxVal);
            }
        }
        this.setOtherThresholdType(otherThresholdType);
    }

    public Variable[] getToolTipVars() {
        return this.toolTipVarArr;
    }

    public void setToolTipVars(Variable ... toolTipVarArr) {
        this.toolTipVarArr = toolTipVarArr;
    }

    public void setOtherVariableArr(Variable ... variables) {
        this.otherVariableArr = variables;
    }

    public boolean isOtherSliceEnabled() {
        return this.otherSlice;
    }

    public void setShowOtherSlice(boolean otherSlice) {
        this.otherSlice = otherSlice;
    }

    public LabelPlacement getDataLabelPlacement() {
        return this.dataLabelPlacement;
    }

    public void setDataLabelPlacement(LabelPlacement dataLabelPlacement) {
        this.dataLabelPlacement = dataLabelPlacement;
        this.applyLabelLocationAndContent();
    }

    public RendererUtil.DataLabel getDataLabelContent() {
        return this.dataLabelContent;
    }

    public void setDataLabelContent(RendererUtil.DataLabel dataLabelContent) {
        this.dataLabelContent = dataLabelContent;
        this.applyLabelLocationAndContent();
    }

    public String getOtherLabel() {
        return this.rendererModel.getOtherSliceLabel();
    }

    public void setOtherLabel(String otherLabel) {
        this.rendererModel.setOtherSliceLabel(otherLabel);
    }

    public double getStartAngle() {
        return this.rendererModel.getStartAngle();
    }

    public void setStartAngle(double startAngle) {
        this.rendererModel.setStartAngle(startAngle);
    }

    public RendererUtil.DataLabel getGroupLabelPlacement() {
        return this.rendererModel.getSubgroupLabelPlacement();
    }

    public void setGroupLabelPlacement(RendererUtil.DataLabel groupLabelPlacement) {
        this.rendererModel.setSubgroupLabelPlacement(groupLabelPlacement);
    }

    public String[] getExplodedCategories() {
        return this.rendererModel.getExplodedCategories();
    }

    public void setExplodedCategories(String ... explodedCategories) {
        this.rendererModel.setExplodedCategories(explodedCategories);
    }

    public boolean isExplodingOtherSlice() {
        return this.rendererModel.isExplodingOtherSlice();
    }

    public void setExplodeOtherSlice(boolean b) {
        this.rendererModel.setExplodeOtherSlice(b);
    }

    public DecimalFormat getPercentFormat() {
        return this.rendererModel.getPercentFormat();
    }

    public void setPercentFormat(DecimalFormat df) {
        this.rendererModel.setPercentFormat(df);
    }

    public boolean isClockwiseDirection() {
        return this.rendererModel.isReverseDirection();
    }

    public void setClockwiseDirection(boolean clockwiseDirection) {
        this.rendererModel.setReverseDirection(clockwiseDirection);
    }

    public double getRingGap() {
        return this.rendererModel.getRingGap();
    }

    public void setRingGap(double ringGap) {
        this.rendererModel.setRingGap(ringGap);
    }

    public String[] getInvisibleCategories() {
        return this.rendererModel.getInvisibleCategories();
    }

    public void setInvisibleCategories(String ... invisibleCategories) {
        this.rendererModel.setInvisibleCategories(invisibleCategories);
    }

    public RendererUtil.Skin getSkin() {
        return this.rendererModel.getSkin();
    }

    public void setSkin(RendererUtil.Skin skin) {
        this.rendererModel.setSkin(skin);
    }

    public boolean isToolTipVarSet() {
        return this.toolTipVarArr != null;
    }

    public GTKPieChartRenderer getRenderer() {
        return this.renderer;
    }

    public boolean isOtherSliceVisible() {
        return this.rendererModel.isOtherSliceVisible();
    }

    public void setVisibleOtherSlice(boolean b) {
        this.rendererModel.setVisibleOtherSlice(b);
    }

    public LegendItem[] getLegendItems(int attrType) {
        this.build();
        GTKPie[] pies = this.renderer.getPieComponents();
        ArrayList<GTKPie.LegendEntry> entries = new ArrayList<GTKPie.LegendEntry>();
        GTKPie.LegendEntry other = null;
        ArrayList<GTKPie.LegendEntry> groupSlicesEntries = new ArrayList<GTKPie.LegendEntry>();
        for (GTKPie p : pies) {
            List legendItemsList = p.getLegendItems();
            for (GTKPie.LegendEntry le : legendItemsList) {
                if (le.isOther) {
                    other = le;
                    continue;
                }
                if (this.rendererModel.isSectorPie() && this.rendererModel.getSubgroupVariable() != null && this.rendererModel.isSubgroupStacked() && le.isSubGroup()) {
                    groupSlicesEntries.add(le);
                    continue;
                }
                if (entries.contains(le)) continue;
                entries.add(le);
            }
        }
        if (this.rendererModel.isSectorPie() && this.rendererModel.getSubgroupVariable() != null && this.rendererModel.isSubgroupStacked()) {
            groupSlicesEntries.addAll(entries);
            entries = groupSlicesEntries;
        }
        boolean isOLAP = this.categoryVariable.getConnection() instanceof OLAPLevelVariable;
        ArrayList<LegendItem> legItemsList = new ArrayList<LegendItem>();
        for (GTKPie.LegendEntry entry : entries) {
            legItemsList.add(this.createLegendItem(entry, isOLAP));
        }
        Collections.sort(legItemsList, new LegendOrderComparator());
        if (other != null) {
            legItemsList.add(this.createLegendItem(other, isOLAP));
        }
        if (isOLAP) {
            for (LegendItem item : legItemsList) {
                item.setLabel(Pie.getTopLevelValue(item.getLabel()));
            }
            for (int i = 1; i < legItemsList.size(); ++i) {
                LegendItem previous = (LegendItem)legItemsList.get(i - 1);
                LegendItem current = (LegendItem)legItemsList.get(i);
                if (!previous.getLabel().equals(current.getLabel()) || !previous.getSymbolAttrs().equals(previous.getSymbolAttrs())) continue;
                legItemsList.remove(current);
                --i;
            }
        }
        LegendItem[] legendItems = new LegendItem[legItemsList.size()];
        legendItems = legItemsList.toArray(legendItems);
        return legendItems;
    }

    private LegendItem createLegendItem(GTKPie.LegendEntry entry, boolean isOLAP) {
        FillAttrs fa = new FillAttrs(entry.color);
        LegendItem legend = new LegendItem((ColorAttr)fa, (ColorAttr)this.outLineAttrs, entry.category, null);
        legend.setSkinImage(this.getLegendSkinImage());
        legend.setFillType(1);
        legend.setSkinType(RendererUtil.getSkinType((RendererUtil.Skin)this.rendererModel.getSkin()));
        return legend;
    }

    private void setCategoryStringsList() {
        this.catStrMap = new HashMap();
        Variable tempVar = this.categoryVariable.getConnection();
        if (tempVar instanceof NumericVariable) {
            tempVar.setUniqueValueSort(1);
        } else if (this.sortOrder == SortOrderType.CATEGORY_ASC) {
            tempVar.setUniqueValueSort(1);
        } else {
            tempVar.setUniqueValueSort(0);
        }
        int catCount = tempVar.getUniqueValueCount();
        for (int i = 0; i < catCount; ++i) {
            String catStr;
            try {
                catStr = tempVar.formattedUniqueValue.getValue(i);
            }
            catch (MissingValueException ex) {
                catStr = ValueMap.getDefaultMissingValueLabel((MissingValues)ex.getMissingValue());
            }
            this.catStrMap.put(catStr, i);
        }
    }

    public Image getLegendSkinImage() {
        Image skinImage = null;
        URL url = null;
        switch (this.rendererModel.getSkin()) {
            case PRESSED: {
                url = Pie.class.getResource("res/Legend.png");
                break;
            }
            default: {
                return null;
            }
        }
        Channel channel = this.renderer.getChannel();
        Component c = channel.getComponent();
        MediaTracker tracker = new MediaTracker(c);
        try {
            skinImage = Toolkit.getDefaultToolkit().getImage(url);
            tracker.addImage(skinImage, 0);
            tracker.waitForAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return skinImage;
    }

    public boolean hasLegend(int attrType) {
        return true;
    }

    public void set3D(boolean b) {
        this.rendererModel.set2D(!b);
    }

    public boolean is3D() {
        return this.rendererModel.is3D();
    }

    public String getFormattedDataTip(GTKPieSelectDetail psd) {
        Variable[] allTooltipVars;
        if (this.rendererModel.isSectorPie()) {
            return "";
        }
        if (psd == null) {
            throw new RuntimeException("Can't process the formatted data tip for null GTKPieSelectDetail");
        }
        if (psd.getType() != 0) {
            throw new RuntimeException("Can't process the formatted data tip for type other than DETAIL_TYPE_SLICE ");
        }
        if (this.toolTipVarArr == null) {
            ArrayList<Object> v = new ArrayList<Object>();
            v.add(this.renderer.getModel().getCategoryVariable());
            v.add(this.getResponseVars()[0]);
            if (this.getGroupVariable() != null) {
                v.add(this.getGroupVariable());
            }
            allTooltipVars = v.toArray(new Variable[v.size()]);
        } else {
            allTooltipVars = this.toolTipVarArr;
        }
        AInitAction ia = new AInitAction((Object)this.renderer.getChannel());
        psd.pie.processedResponse.init(ia);
        psd.pie.processedCategory.init(ia);
        psd.pie.processedSubgroup.init(ia);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < allTooltipVars.length - 1; ++i) {
            this.addToolTip(allTooltipVars[i], sb, psd);
            sb.append("\n");
        }
        this.addToolTip(allTooltipVars[allTooltipVars.length - 1], sb, psd);
        return sb.toString();
    }

    public Vector computeSelectableShapes() {
        return this.renderer.getNetworkRoot().computeSelectableShapes();
    }

    private void addToolTip(Variable v, StringBuilder sb, GTKPieSelectDetail psd) {
        String vName = v.getName();
        if (vName.equals(this.renderer.getModel().getCategoryVariable().getName())) {
            sb.append(this.getCategoryFormattedValue(psd, v));
        } else if (vName.equals(this.getResponseVars()[0].getName())) {
            sb.append(this.getResponseFormattedValue(psd, v));
        } else if (vName.equals(this.renderer.getModel().getSubgroupVariable().getName())) {
            sb.append(this.getGroupFormattedValue(psd, v));
        } else {
            String formattedVal;
            try {
                formattedVal = v.formattedValue.getValue(psd.getProcessedIndex());
            }
            catch (MissingValueException e) {
                formattedVal = v instanceof NumericVariable ? "." : "";
            }
            sb.append(v.getLabel()).append("=").append(formattedVal);
        }
    }

    private String getCategoryFormattedValue(GTKPieSelectDetail psd, Variable v) {
        String tip = v.getLabel() + "=";
        try {
            String value = psd.pie.processedCategory.getValue(psd.getProcessedIndex());
            return tip + v.getFormatter().format((Object)value);
        }
        catch (MissingValueException mve) {
            String value = v instanceof NumericVariable ? "." : "";
            return tip + value;
        }
    }

    private String getResponseFormattedValue(GTKPieSelectDetail psd, Variable v) {
        String tip = v.getLabel() + "=";
        try {
            Double value = psd.pie.processedResponse.getValue(psd.getProcessedIndex());
            return tip + v.getFormatter().format((Object)value);
        }
        catch (MissingValueException mve) {
            String value = v instanceof NumericVariable ? "." : "";
            return tip + value;
        }
    }

    private String getGroupFormattedValue(GTKPieSelectDetail psd, Variable v) {
        String tip = v.getLabel() + "=";
        try {
            Object value = psd.pie.processedSubgroup.getValue(psd.getProcessedIndex());
            if (v instanceof NumericVariable && value instanceof String) {
                value = Double.parseDouble((String)value);
            }
            return tip + v.getFormatter().format(value);
        }
        catch (MissingValueException mve) {
            String value = v instanceof NumericVariable ? "." : "";
            return tip + value;
        }
    }

    public boolean excludeMissingGroup() {
        return !this.includeMissingGroup;
    }

    public void setIncludeMissingGroup(boolean b) {
        this.includeMissingGroup = b;
    }

    public boolean excludeMissingCategory() {
        return !this.includeMissingCategory;
    }

    public void setIncludeMissingCategory(boolean b) {
        this.includeMissingCategory = b;
    }

    public Variable getURLVariable() {
        return this.urlVar;
    }

    public void setURLVariable(Variable v) {
        this.urlVar = v;
    }

    public String getURL(GTKPieSelectDetail psd) {
        String cat = null;
        boolean grpRequired = this.groupVariable != null;
        String grp = null;
        int index = -1;
        try {
            cat = psd.pie.processedCategory.getValue(psd.getProcessedIndex());
            if (grpRequired) {
                grp = psd.pie.processedSubgroup.getValue(psd.getProcessedIndex());
            }
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
        int c = this.categoryVariable.getValueCount();
        for (int i = 0; i < c; ++i) {
            try {
                String val = this.categoryVariable.formattedValue.getValue(i);
                String grpVal = null;
                if (grpRequired) {
                    grpVal = this.groupVariable.formattedValue.getValue(i);
                }
                if (!val.equals(cat) || grpRequired && !grpVal.equals(grp)) continue;
                index = i;
                break;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        if (index == -1) {
            return "";
        }
        return this.getURL(index);
    }

    private String getURL(int index) {
        String url;
        if (this.urlVar == null) {
            return "";
        }
        try {
            url = this.urlVar.formattedValue.getValue(index);
        }
        catch (MissingValueException e) {
            url = "";
        }
        return url;
    }

    public void setAntialiasedText(boolean b) {
        this.rendererModel.setAntialiasedText(b);
    }

    public void setAntialiasedGraphics(boolean b) {
        this.rendererModel.setAntialiasedGraphics(b);
    }

    public void setWhereClause(String clause) {
        this.whereClause = clause;
    }

    public void setGroupGapDimension(RendererUtil.GroupGapDimension dim) {
        this.rendererModel.setGroupGapDimension(dim);
    }

    public void addLogEventListener(GTKLogEventListener listener) {
        this.renderer.addLogEventListener(listener);
    }

    public void removeLogEventListener(GTKLogEventListener listener) {
        this.renderer.removeLogEventListener(listener);
    }

    public void removeAllLogEventListener() {
        this.renderer.removeAllLogEventListener();
    }

    private static String getTopLevelValue(String str) {
        int idx = str.indexOf(",");
        if (idx > 0) {
            str = str.substring(0, idx);
        }
        return str;
    }

    public void setCHImage(Image img) {
        this.rendererModel.setCHImage(img);
    }

    public void setCHPipe(BooleanPipe bv) {
        this.chPipe = bv;
    }

    public void setStyle(Style s) {
        this.styleObj = s;
    }

    public void setMissingStyleElement(DataStyleElement dseObj) {
        this.missingElem = dseObj;
    }

    public void setCategoriesArr(ArrayList<String> arr) {
        this.categoriesList = arr;
    }

    public void setGroupsArr(ArrayList<String> arr) {
        this.groupsList = arr;
    }

    public void setCenterFirstSlice(boolean centered) {
        this.rendererModel.setCenterFirstSlice(centered);
    }

    public boolean isCenterFirstSlice() {
        return this.rendererModel.isCenterFirstSlice();
    }

    public static enum SortOrderType {
        CATEGORY_ASC,
        DATA;

    }

    public static enum OtherSliceType {
        PERCENT,
        MAXSLICE;

    }

    public static enum LabelPlacement {
        AUTO,
        INSIDE,
        OUTSIDE,
        ARROW,
        INSIDE_IF_FIT;

    }

    private class LegendOrderComparator
    implements Comparator<LegendItem> {
        private LegendOrderComparator() {
        }

        @Override
        public int compare(LegendItem legItem1, LegendItem legItem2) {
            if (Pie.this.rendererModel.isSectorPie()) {
                return 0;
            }
            if (legItem1 == null && legItem2 == null) {
                return 0;
            }
            if (legItem1 == null) {
                return -1;
            }
            if (legItem2 == null) {
                return 1;
            }
            String legItem1Label = legItem1.getLabel();
            String legItem2Label = legItem2.getLabel();
            int legItem1Loc = (Integer)Pie.this.catStrMap.get(legItem1Label);
            int legItem2Loc = (Integer)Pie.this.catStrMap.get(legItem2Label);
            return legItem1Loc - legItem2Loc;
        }
    }
}

