/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.common.heatmap;

import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.util.Bin;
import com.sas.graphics.util.BinUtilities;
import com.sas.graphics.util.BinValues;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.NumericVectorVariable;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.StringVectorVariable;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.gl.SelectResult;
import java.awt.Point;
import java.util.LinkedHashMap;
import java.util.Vector;

public class HeatmapBinningUtility {
    protected Variable xVariable;
    protected Variable yVariable;
    protected Variable colorVariable;
    protected NumericVariable frequencyVariable;
    protected int xNumberOfBins = 10;
    protected int yNumberOfBins = 10;
    protected double[] xBinBoundaries = null;
    protected double[] yBinBoundaries = null;
    protected Vector<Bin> xbins;
    protected Vector<Bin> ybins;
    protected Integer[] binIndex;
    protected BinValues binValues;
    protected boolean xBinToDataRange = false;
    protected int xBoundary = 0;
    protected boolean yBinToDataRange = false;
    protected int yBoundary = 0;
    protected Vector[] binPositionAndLengthArrays = null;
    private Variable xBinVariable = null;
    private Variable yBinVariable = null;
    private Variable binCountVariable = null;
    private Variable binColorVariable = null;
    private int[][] xyBinToVariableIndexMap = null;
    private LinkedHashMap<Integer, Point> binVarIndexToBinMap = null;
    private DataRange xRange = null;
    private DataRange yRange = null;
    private double xBinSize = Double.NaN;
    private double yBinSize = Double.NaN;

    public Variable getXVariable() {
        return this.xVariable;
    }

    public void setXVariable(Variable variable) {
        this.xVariable = variable;
    }

    public Variable getYVariable() {
        return this.yVariable;
    }

    public void setYVariable(Variable variable) {
        this.yVariable = variable;
    }

    public Variable getColorVariable() {
        return this.colorVariable;
    }

    public void setColorVariable(Variable variable) {
        this.colorVariable = variable;
    }

    public NumericVariable getFrequencyVariable() {
        return this.frequencyVariable;
    }

    public void setFrequencyVariable(NumericVariable variable) {
        this.frequencyVariable = variable;
    }

    public void computeBins(DataRange xRange, DataRange yRange, boolean xAxisIsDiscrete, boolean yAxisIsDiscrete) {
        if (this.xVariable == null || this.yVariable == null) {
            return;
        }
        this.xRange = xRange;
        this.yRange = yRange;
        this.binValues = new BinValues();
        if (this.xbins == null) {
            this.xbins = new Vector();
        } else {
            this.xbins.clear();
        }
        if (this.ybins == null) {
            this.ybins = new Vector();
        } else {
            this.ybins.clear();
        }
        boolean buildSuccess = BinUtilities.doBivariateBinning(this.xVariable, xRange, xAxisIsDiscrete, this.xNumberOfBins, this.xBinBoundaries, this.xBoundary, this.xBinToDataRange, this.yVariable, yRange, yAxisIsDiscrete, this.yNumberOfBins, this.yBinBoundaries, this.yBoundary, this.yBinToDataRange, this.frequencyVariable, this.colorVariable, this.xbins, this.ybins, this.binValues);
        this.buildVariablesFromBins(this.xVariable, this.yVariable, this.xbins, this.ybins, this.binValues);
        this.xBinSize = xRange instanceof ContinuousRange ? this.computeBinSize((ContinuousRange)xRange, this.xNumberOfBins) : 1.0;
        this.yBinSize = yRange instanceof ContinuousRange ? this.computeBinSize((ContinuousRange)yRange, this.yNumberOfBins) : 1.0;
    }

    private double computeBinSize(ContinuousRange cr, int numBins) {
        if (cr == null || numBins <= 0) {
            return Double.NaN;
        }
        return (cr.getMax() - cr.getMin()) / (double)numBins;
    }

    private void buildVariablesFromBins(Variable xVar, Variable yVar, Vector<Bin> xBins, Vector<Bin> yBins, BinValues binValues) {
        double[] vals;
        NumericVectorVariable nv;
        StringVectorVariable sv;
        if (xVar == null || xBins == null || yVar == null || yBins == null) {
            return;
        }
        boolean xDiscrete = xVar instanceof StringVariable;
        boolean yDiscrete = yVar instanceof StringVariable;
        Vector<String> xValues = null;
        Vector<Double> xMidPoints = null;
        if (xDiscrete) {
            xValues = new Vector<String>(xBins.size() * yBins.size());
        } else {
            xMidPoints = new Vector<Double>(xBins.size() * yBins.size());
        }
        Vector<String> yValues = null;
        Vector<Double> yMidPoints = null;
        if (yDiscrete) {
            yValues = new Vector<String>(xBins.size() * yBins.size());
        } else {
            yMidPoints = new Vector<Double>(xBins.size() * yBins.size());
        }
        Vector<Double> binCount = new Vector<Double>(xBins.size() * yBins.size());
        Vector<Double> binColor = new Vector<Double>(xBins.size() * yBins.size());
        this.xyBinToVariableIndexMap = new int[xBins.size()][yBins.size()];
        this.binVarIndexToBinMap = new LinkedHashMap();
        for (int i = 0; i < xBins.size(); ++i) {
            String xValue = null;
            double xMidPoint = Double.NaN;
            if (xDiscrete) {
                xValue = xBins.elementAt(i).getDiscreteValue();
            } else {
                xMidPoint = xBins.elementAt(i).getMidpoint();
            }
            for (int j = 0; j < yBins.size(); ++j) {
                int binVarIndex;
                double count = binValues.getCount(i, j);
                if (count <= 0.0) continue;
                if (xDiscrete) {
                    xValues.add(xValue);
                } else {
                    xMidPoints.add(xMidPoint);
                }
                if (yDiscrete) {
                    yValues.add(yBins.elementAt(j).getDiscreteValue());
                } else {
                    yMidPoints.add(yBins.elementAt(j).getMidpoint());
                }
                this.xyBinToVariableIndexMap[i][j] = binVarIndex = binCount.size();
                this.binVarIndexToBinMap.put(binVarIndex, new Point(i, j));
                binCount.add(count);
                binColor.add(binValues.getColorNumeric(i, j));
            }
        }
        if (xDiscrete) {
            sv = new StringVectorVariable();
            sv.connectFrom(xValues.toArray(new String[xValues.size()]));
            this.xBinVariable = sv;
        } else {
            nv = new NumericVectorVariable();
            vals = new double[xMidPoints.size()];
            for (int i = 0; i < vals.length; ++i) {
                vals[i] = (Double)xMidPoints.elementAt(i);
            }
            nv.connectFrom(vals);
            this.xBinVariable = nv;
        }
        if (yDiscrete) {
            sv = new StringVectorVariable();
            sv.connectFrom(yValues.toArray(new String[yValues.size()]));
            this.yBinVariable = sv;
        } else {
            nv = new NumericVectorVariable();
            vals = new double[yMidPoints.size()];
            for (int i = 0; i < vals.length; ++i) {
                vals[i] = (Double)yMidPoints.elementAt(i);
            }
            nv.connectFrom(vals);
            this.yBinVariable = nv;
        }
        NumericVectorVariable countVar = new NumericVectorVariable();
        vals = new double[binCount.size()];
        for (int i = 0; i < vals.length; ++i) {
            vals[i] = (Double)binCount.elementAt(i);
        }
        countVar.connectFrom(vals);
        countVar.value.init(new AInitAction());
        this.binCountVariable = countVar;
        if (this.colorVariable != null) {
            NumericVectorVariable colorVar = new NumericVectorVariable();
            vals = new double[binColor.size()];
            for (int i = 0; i < vals.length; ++i) {
                vals[i] = (Double)binColor.elementAt(i);
            }
            colorVar.connectFrom(vals);
            colorVar.value.init(new AInitAction());
            this.binColorVariable = colorVar;
        }
    }

    public Variable getXBinVariable() {
        return this.xBinVariable;
    }

    public Variable getYBinVariable() {
        return this.yBinVariable;
    }

    public Variable getBinCountVariable() {
        return this.binCountVariable;
    }

    public Variable getBinColorVariable() {
        return this.binColorVariable;
    }

    public int getXBoundary() {
        return this.xBoundary;
    }

    public void setXBoundary(int boundary) {
        this.xBoundary = boundary;
    }

    public int getYBoundary() {
        return this.yBoundary;
    }

    public void setYBoundary(int boundary) {
        this.yBoundary = boundary;
    }

    public boolean isXBinToDataRange() {
        return this.xBinToDataRange;
    }

    public void setXBinToDataRange(boolean binToDataRange) {
        this.xBinToDataRange = binToDataRange;
    }

    public boolean isYBinToDataRange() {
        return this.yBinToDataRange;
    }

    public void setYBinToDataRange(boolean binToDataRange) {
        this.yBinToDataRange = binToDataRange;
    }

    public Object[] getBinCorrespondingToSelectResult(SelectResult selection) {
        if (selection == null) {
            return null;
        }
        int index = selection.getValueIndex();
        if (this.binVarIndexToBinMap == null || !this.binVarIndexToBinMap.containsKey(index)) {
            return null;
        }
        Point p = this.binVarIndexToBinMap.get(index);
        Object colorValue = null;
        switch (this.binValues.getColorType()) {
            case 1: {
                colorValue = new Double(this.binValues.getColorNumeric(p.x, p.y));
                break;
            }
            case 0: {
                colorValue = this.binValues.getColorDiscrete(p.x, p.y);
            }
        }
        return new Object[]{this.xbins.elementAt(p.x), this.ybins.elementAt(p.y), new Integer((int)this.binValues.getCount(p.x, p.y)), colorValue};
    }

    public int getXBinIndex(int obs) {
        if (this.binValues == null) {
            return -1;
        }
        return this.binValues.getXBinIndex(obs);
    }

    public int getYBinIndex(int obs) {
        if (this.binValues == null) {
            return -1;
        }
        return this.binValues.getYBinIndex(obs);
    }

    public int getBinVariableIndex(int xBinIndex, int yBinIndex) {
        return this.xyBinToVariableIndexMap[xBinIndex][yBinIndex];
    }

    public int getXNumberOfBins() {
        return this.xNumberOfBins;
    }

    public void setXNumberOfBins(int numberOfBins) {
        this.xNumberOfBins = numberOfBins;
    }

    public int getYNumberOfBins() {
        return this.yNumberOfBins;
    }

    public void setYNumberOfBins(int numberOfBins) {
        this.yNumberOfBins = numberOfBins;
    }

    public Object[] getTickmarkValuesForDimension(byte dimension, boolean endLabels) {
        Variable var = null;
        Vector<Bin> bins = null;
        switch (dimension) {
            case 1: {
                var = this.xVariable;
                bins = this.xbins;
                break;
            }
            case 2: {
                var = this.yVariable;
                bins = this.ybins;
            }
        }
        if (var == null || !(var instanceof NumericVariable) || bins == null || bins.size() == 0) {
            return null;
        }
        int extraTick = endLabels ? 1 : 0;
        Object[] ticks = new Object[bins.size() + extraTick];
        for (int i = 0; i < ticks.length - extraTick; ++i) {
            Bin b = bins.get(i);
            if (endLabels) {
                ticks[i] = b.getMin();
                if (i != ticks.length - 2) continue;
                ticks[i + 1] = b.getMax();
                continue;
            }
            ticks[i] = b.getMidpoint();
        }
        return ticks;
    }

    public double getBinColorValue(int xBinIndex, int yBinIndex) {
        return this.binValues.getColorNumeric(xBinIndex, yBinIndex);
    }

    public double getBinCount(int xBinIndex, int yBinIndex) {
        return this.binValues.getCount(xBinIndex, yBinIndex);
    }

    public DataRange getXRange() {
        return this.xRange;
    }

    public DataRange getYRange() {
        return this.yRange;
    }

    public int[] getObservationIndices(int xBinIndex, int yBinIndex) {
        return this.binValues.getObservationIndices(xBinIndex, yBinIndex);
    }

    public double[] getXBinBoundaries() {
        return this.xBinBoundaries;
    }

    public void setXBinBoundaries(double[] binBoundaries) {
        this.xBinBoundaries = binBoundaries;
    }

    public double[] getYBinBoundaries() {
        return this.yBinBoundaries;
    }

    public void setYBinBoundaries(double[] binBoundaries) {
        this.yBinBoundaries = binBoundaries;
    }

    public double getXBinSize() {
        return this.xBinSize;
    }

    public double getYBinSize() {
        return this.yBinSize;
    }

    public void dispose() {
        if (this.xVariable != null) {
            this.xVariable.disconnect();
            this.xVariable = null;
        }
        if (this.yVariable != null) {
            this.yVariable.disconnect();
            this.yVariable = null;
        }
        if (this.colorVariable != null) {
            this.colorVariable.disconnect();
            this.colorVariable = null;
        }
        if (this.frequencyVariable != null) {
            this.frequencyVariable.disconnect();
            this.frequencyVariable = null;
        }
        this.xBinBoundaries = null;
        this.yBinBoundaries = null;
        if (this.xbins != null) {
            this.xbins.clear();
        }
        this.xbins = null;
        if (this.ybins != null) {
            this.ybins.clear();
        }
        this.ybins = null;
        this.binIndex = null;
        if (this.binValues != null) {
            this.binValues.dispose();
        }
        if (this.binPositionAndLengthArrays != null) {
            for (int i = 0; i < this.binPositionAndLengthArrays.length; ++i) {
                if (this.binPositionAndLengthArrays[i] == null) continue;
                this.binPositionAndLengthArrays[i].clear();
                this.binPositionAndLengthArrays[i] = null;
            }
        }
        this.binPositionAndLengthArrays = null;
        if (this.xBinVariable != null) {
            this.xBinVariable.disconnect();
            this.xBinVariable = null;
        }
        if (this.yBinVariable != null) {
            this.yBinVariable.disconnect();
            this.yBinVariable = null;
        }
        if (this.binCountVariable != null) {
            this.binCountVariable.disconnect();
            this.binCountVariable = null;
        }
        if (this.binColorVariable != null) {
            this.binColorVariable.disconnect();
            this.binColorVariable = null;
        }
        this.xyBinToVariableIndexMap = null;
        if (this.binVarIndexToBinMap != null) {
            this.binVarIndexToBinMap.clear();
        }
        this.binVarIndexToBinMap = null;
        this.xRange = null;
        this.yRange = null;
    }
}

