/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.common.attrmap;

import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.MarkerAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.TextAttrs;
import com.sas.graphics.common.attrmap.AttrMapper;
import com.sas.graphics.util.SASLinePatterns;
import com.sas.graphics.util.attrmap.DiscreteAttributeMap;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.AResetAction;
import com.sas.graphics.util.gtk.ColorMapper;
import com.sas.graphics.util.gtk.ColorPipe;
import com.sas.graphics.util.gtk.Formatter;
import com.sas.graphics.util.gtk.IntegerPipe;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericMapper;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.Pipe;
import com.sas.graphics.util.gtk.StringPipe;
import java.awt.Color;
import java.util.HashMap;

public class DiscreteAttrMapper
extends AttrMapper {
    public StringPipe variable;
    public ColorMapper fillColorMapper = null;
    public ColorMapper lineColorMapper = null;
    public NumericMapper linePatternMapper = null;
    public NumericMapper lineThicknessMapper = null;
    public ColorMapper markerColorMapper = null;
    public NumericMapper markerSymbolMapper = null;
    public NumericPipe markerSizeMapper = null;
    public ColorMapper markerFillColorMapper = null;
    public ColorMapper textColorMapper = null;
    public NumericMapper textStyleMapper = null;
    public ColorPipe fillColorPipe = null;
    public ColorPipe lineColorPipe = null;
    public IntegerPipe linePatternPipe = null;
    public ColorPipe markerColorPipe = null;
    public IntegerPipe markerSymbolPipe = null;
    public ColorPipe markerFillColorPipe = null;
    public ColorPipe textColorPipe = null;
    public IntegerPipe textStylePipe = null;
    public final ColorPipe fillColor = new FillColorPipe();
    public final ColorPipe markerFillColor = new MarkerFillColorPipe();
    public final MarkerColorPipe markerColor = new MarkerColorPipe();
    public final MarkerSymbolPipe markerSymbol = new MarkerSymbolPipe();
    public final HashMap<String, MarkerSizePipe> markerSize = new HashMap();
    public final HashMap<String, MarkerEdgeThicknessPipe> markerEdgeThickness = new HashMap();
    public final LineColorPipe lineColor = new LineColorPipe();
    public final LinePatternPipe linePattern = new LinePatternPipe();
    public final LineStipplePatternPipe lineStipplePattern = new LineStipplePatternPipe();
    public final LineStippleFactorPipe lineStippleFactor = new LineStippleFactorPipe();
    public final HashMap<String, LineThicknessPipe> lineThickness = new HashMap();
    public final TextColorPipe textColor = new TextColorPipe();
    public final TextStylePipe textStyle = new TextStylePipe();
    private DiscreteAttributeMap attrMap;
    private double fillTransparency = 0.0;
    private double markerTransparency = 0.0;
    private double lineTransparency = 0.0;
    private double textTransparency = 0.0;
    private boolean useFillTransparency = false;
    private boolean useMarkerTransparency = false;
    private boolean trimOn = false;
    private boolean scaleMarkers = false;
    private int minMarkerSize = 5;
    private double ratioH = 1.0;
    private double ratioW = 1.0;
    private double dataDPIScaleFactor = 1.0;

    public DiscreteAttrMapper(DiscreteAttributeMap map) {
        this.attrMap = map;
    }

    public DiscreteAttrMapper() {
        this(null);
    }

    public DiscreteAttributeMap getAttrMap() {
        return this.attrMap;
    }

    public void setAttrMap(DiscreteAttributeMap map) {
        this.attrMap = map;
    }

    public void addLineThicknessPipe(String name, int defaultThickness) {
        this.lineThickness.put(name, new LineThicknessPipe(defaultThickness));
    }

    public void addMarkerSizePipe(String name, int defaultSize) {
        this.markerSize.put(name, new MarkerSizePipe(defaultSize));
    }

    public void addMarkerEdgeThicknessPipe(String name, int defaultSize, int defaultWeight) {
        this.markerEdgeThickness.put(name, new MarkerEdgeThicknessPipe(defaultSize, defaultWeight));
    }

    public void addMarkerEdgeThicknessPipe(String name, int defaultSize, int defaultWeight, boolean fixedSize) {
        this.markerEdgeThickness.put(name, new MarkerEdgeThicknessPipe(defaultSize, defaultWeight, fixedSize));
    }

    public boolean isTrimOn() {
        return this.trimOn;
    }

    public void setTrimOn(boolean trimOn) {
        this.trimOn = trimOn;
    }

    public double getFillTransparency() {
        return this.fillTransparency;
    }

    public void setFillTransparency(double fillTransparency) {
        this.fillTransparency = fillTransparency;
    }

    public double getMarkerTransparency() {
        return this.markerTransparency;
    }

    public void setMarkerTransparency(double markerTransparency) {
        this.markerTransparency = markerTransparency;
    }

    public double getLineTransparency() {
        return this.lineTransparency;
    }

    public void setLineTransparency(double lineTransparency) {
        this.lineTransparency = lineTransparency;
    }

    public boolean isUseMarkerTransparency() {
        return this.useMarkerTransparency;
    }

    public void setUseMarkerTransparency(boolean useMarkerTransparency) {
        this.useMarkerTransparency = useMarkerTransparency;
    }

    public boolean isUseFillTransparency() {
        return this.useFillTransparency;
    }

    public void setUseFillTransparency(boolean useFillTransparency) {
        this.useFillTransparency = useFillTransparency;
    }

    public double getTextTransparency() {
        return this.textTransparency;
    }

    public void setTextTransparency(double textTransparency) {
        this.textTransparency = textTransparency;
    }

    public boolean isScaleMarkers() {
        return this.scaleMarkers;
    }

    public void setScaleMarkers(boolean scaleMarkers) {
        this.scaleMarkers = scaleMarkers;
    }

    public double getRatioH() {
        return this.ratioH;
    }

    public void setRatioH(double ratioH) {
        this.ratioH = ratioH;
    }

    public double getRatioW() {
        return this.ratioW;
    }

    public void setRatioW(double ratioW) {
        this.ratioW = ratioW;
    }

    public int getMinMarkerSize() {
        return this.minMarkerSize;
    }

    public void setMinMarkerSize(int minMarkerSize) {
        this.minMarkerSize = minMarkerSize;
    }

    public double getDataDPIScaleFactor() {
        return this.dataDPIScaleFactor;
    }

    public void setDataDPIScaleFactor(double dataDPIScaleFactor) {
        this.dataDPIScaleFactor = dataDPIScaleFactor;
    }

    public int getMaxMarkerSize() {
        String[] val = this.attrMap.getValues();
        if (val == null || val.length == 0) {
            return 0;
        }
        int ms = 0;
        for (int i = 0; i < val.length; ++i) {
            ms = Math.max(ms, this.getMarkerSize(val[i]));
        }
        return ms;
    }

    public int getMaxLineThickness() {
        String[] val = this.attrMap.getValues();
        if (val == null || val.length == 0) {
            return 0;
        }
        int lt = 0;
        for (int i = 0; i < val.length; ++i) {
            lt = Math.max(lt, this.getLineThickness(val[i]));
        }
        return lt;
    }

    private int scaleMarker(int ms) {
        if (!this.scaleMarkers) {
            return ms;
        }
        double newSize = (double)ms * Math.pow(Math.min(this.ratioW, this.ratioH), 0.25) + 0.5;
        return (int)Math.min((double)ms, Math.max((double)this.minMarkerSize, newSize));
    }

    public Color getFillColor(String value) {
        if (this.attrMap == null || value == null) {
            return null;
        }
        value = this.fixValue(value);
        FillAttrs fa = null;
        if (this.attrMap.get(value) != null) {
            fa = this.attrMap.get(value).getFillAttrs();
        }
        if (fa != null && fa.getColor() != null) {
            return fa.getColor();
        }
        return null;
    }

    public double getFillTransparency(String value) {
        if (this.attrMap == null || value == null) {
            return 0.0;
        }
        value = this.fixValue(value);
        FillAttrs fa = null;
        if (this.attrMap.get(value) != null) {
            fa = this.attrMap.get(value).getFillAttrs();
        }
        if (fa != null && fa.getTransparency() >= 0.0) {
            return fa.getTransparency();
        }
        return 0.0;
    }

    public Color getMarkerColor(String value) {
        if (this.attrMap == null || value == null) {
            return null;
        }
        value = this.fixValue(value);
        MarkerAttrs ma = null;
        if (this.attrMap.get(value) != null) {
            ma = this.attrMap.get(value).getMarkerAttrs();
        }
        if (ma != null && ma.getColor() != null) {
            return ma.getColor();
        }
        return null;
    }

    public double getMarkerTransparency(String value) {
        if (this.attrMap == null || value == null) {
            return 0.0;
        }
        value = this.fixValue(value);
        MarkerAttrs ma = null;
        if (this.attrMap.get(value) != null) {
            ma = this.attrMap.get(value).getMarkerAttrs();
        }
        if (ma != null && ma.getTransparency() >= 0.0) {
            return ma.getTransparency();
        }
        return 0.0;
    }

    public int getMarkerSymbol(String value) {
        if (this.attrMap == null || value == null) {
            return -1;
        }
        value = this.fixValue(value);
        MarkerAttrs ma = null;
        if (this.attrMap.get(value) != null) {
            ma = this.attrMap.get(value).getMarkerAttrs();
        }
        if (ma != null && ma.getShape() >= 0) {
            return ma.getShape();
        }
        return -1;
    }

    public int getMarkerSize(String value) {
        if (this.attrMap == null || value == null) {
            return -1;
        }
        value = this.fixValue(value);
        MarkerAttrs ma = null;
        if (this.attrMap.get(value) != null) {
            ma = this.attrMap.get(value).getMarkerAttrs();
        }
        if (ma != null && ma.getSize() >= 0) {
            return ma.getSize();
        }
        return -1;
    }

    public int getMarkerWeight(String value) {
        if (this.attrMap == null || value == null) {
            return -1;
        }
        value = this.fixValue(value);
        MarkerAttrs ma = null;
        if (this.attrMap.get(value) != null) {
            ma = this.attrMap.get(value).getMarkerAttrs();
        }
        if (ma != null && ma.getWeight() >= 0) {
            return ma.getWeight();
        }
        return -1;
    }

    public Color getLineColor(String value) {
        if (this.attrMap == null || value == null) {
            return null;
        }
        value = this.fixValue(value);
        LineAttrs la = null;
        if (this.attrMap.get(value) != null) {
            la = this.attrMap.get(value).getLineAttrs();
        }
        if (la != null && la.getColor() != null) {
            return la.getColor();
        }
        return null;
    }

    public int getLinePattern(String value) {
        if (this.attrMap == null || value == null) {
            return -1;
        }
        value = this.fixValue(value);
        LineAttrs la = null;
        if (this.attrMap.get(value) != null) {
            la = this.attrMap.get(value).getLineAttrs();
        }
        if (la != null && la.getLinePattern() >= 0) {
            return la.getLinePattern();
        }
        return -1;
    }

    public int getLineThickness(String value) {
        if (this.attrMap == null || value == null) {
            return -1;
        }
        value = this.fixValue(value);
        LineAttrs la = null;
        if (this.attrMap.get(value) != null) {
            la = this.attrMap.get(value).getLineAttrs();
        }
        if (la != null && la.getWidth() >= 0) {
            return la.getWidth();
        }
        return -1;
    }

    public Color getTextColor(String value) {
        if (this.attrMap == null || value == null) {
            return null;
        }
        value = this.fixValue(value);
        TextAttrs ta = null;
        if (this.attrMap.get(value) != null) {
            ta = this.attrMap.get(value).getTextAttrs();
        }
        if (ta != null && ta.getColor() != null) {
            return ta.getColor();
        }
        return null;
    }

    private String fixValue(String value) {
        if (value == null) {
            return null;
        }
        if (this.trimOn) {
            value = value.trim();
        }
        if (value.equals("")) {
            value = " ";
        }
        return value;
    }

    private class FillColorPipe
    extends FillAttrsPipe
    implements ColorPipe {
        private FillColorPipe() {
        }

        public Color getValue(int index) throws MissingValueException {
            FillAttrs fa = this.getFillAttrs(index);
            if (fa != null && fa.getColor() != null) {
                if (DiscreteAttrMapper.this.useFillTransparency) {
                    return AttrMapper.applyTransparency(fa.getColor(), DiscreteAttrMapper.this.fillTransparency);
                }
                double ft = fa.getTransparency() < 0.0 ? 0.0 : fa.getTransparency();
                return AttrMapper.applyTransparency(fa.getColor(), ft);
            }
            if (DiscreteAttrMapper.this.fillColorMapper != null) {
                DiscreteAttrMapper.this.fillColorMapper.init(new AInitAction());
                return DiscreteAttrMapper.this.fillColorMapper.getValue(index);
            }
            if (DiscreteAttrMapper.this.fillColorPipe != null) {
                return DiscreteAttrMapper.this.fillColorPipe.getValue(index);
            }
            return null;
        }
    }

    private class MarkerFillColorPipe
    extends FillAttrsPipe
    implements ColorPipe {
        private MarkerFillColorPipe() {
        }

        public Color getValue(int index) throws MissingValueException {
            FillAttrs fa = this.getFillAttrs(index);
            if (fa != null && fa.getColor() != null) {
                if (DiscreteAttrMapper.this.useMarkerTransparency) {
                    return AttrMapper.applyTransparency(fa.getColor(), DiscreteAttrMapper.this.markerTransparency);
                }
                MarkerAttrs ma = this.getMarkerAttrs(index);
                double mt = ma.getTransparency() >= 0.0 ? ma.getTransparency() : 0.0;
                return AttrMapper.applyTransparency(fa.getColor(), mt);
            }
            if (DiscreteAttrMapper.this.markerFillColorMapper != null) {
                DiscreteAttrMapper.this.markerFillColorMapper.init(new AInitAction());
                return DiscreteAttrMapper.this.markerFillColorMapper.getValue(index);
            }
            if (DiscreteAttrMapper.this.markerFillColorPipe != null) {
                return DiscreteAttrMapper.this.markerFillColorPipe.getValue(index);
            }
            return null;
        }
    }

    private class MarkerColorPipe
    extends MarkerAttrsPipe
    implements ColorPipe {
        private MarkerColorPipe() {
        }

        public Color getValue(int index) throws MissingValueException {
            MarkerAttrs ma = this.getMarkerAttrs(index);
            if (ma != null && ma.getColor() != null) {
                if (DiscreteAttrMapper.this.useMarkerTransparency) {
                    return AttrMapper.applyTransparency(ma.getColor(), DiscreteAttrMapper.this.markerTransparency);
                }
                double mt = ma.getTransparency() >= 0.0 ? ma.getTransparency() : 0.0;
                return AttrMapper.applyTransparency(ma.getColor(), mt);
            }
            if (DiscreteAttrMapper.this.markerColorMapper != null) {
                DiscreteAttrMapper.this.markerColorMapper.init(new AInitAction());
                return DiscreteAttrMapper.this.markerColorMapper.getValue(index);
            }
            if (DiscreteAttrMapper.this.markerColorPipe != null) {
                return DiscreteAttrMapper.this.markerColorPipe.getValue(index);
            }
            return null;
        }
    }

    private class MarkerSymbolPipe
    extends MarkerAttrsPipe
    implements IntegerPipe {
        private MarkerSymbolPipe() {
        }

        public int getValue(int index) throws MissingValueException {
            MarkerAttrs ma = this.getMarkerAttrs(index);
            if (ma != null && ma.getShape() >= 0) {
                return ma.getShape();
            }
            if (DiscreteAttrMapper.this.markerSymbolMapper != null) {
                DiscreteAttrMapper.this.markerSymbolMapper.init(new AInitAction());
                return (int)DiscreteAttrMapper.this.markerSymbolMapper.getValue(index);
            }
            if (DiscreteAttrMapper.this.markerSymbolPipe != null) {
                return DiscreteAttrMapper.this.markerSymbolPipe.getValue(index);
            }
            return -1;
        }
    }

    public class LineColorPipe
    extends LineAttrsPipe
    implements ColorPipe {
        public Color getValue(int index) throws MissingValueException {
            LineAttrs la = this.getLineAttrs(index);
            if (la != null && la.getColor() != null) {
                return AttrMapper.applyTransparency(la.getColor(), DiscreteAttrMapper.this.lineTransparency);
            }
            if (DiscreteAttrMapper.this.lineColorMapper != null) {
                DiscreteAttrMapper.this.lineColorMapper.init(new AInitAction());
                return DiscreteAttrMapper.this.lineColorMapper.getValue(index);
            }
            if (DiscreteAttrMapper.this.lineColorPipe != null) {
                return DiscreteAttrMapper.this.lineColorPipe.getValue(index);
            }
            return null;
        }
    }

    private class LinePatternPipe
    extends LineAttrsPipe
    implements IntegerPipe {
        private LinePatternPipe() {
        }

        public int getValue(int index) throws MissingValueException {
            LineAttrs la = this.getLineAttrs(index);
            if (la != null && la.getLinePattern() >= 0) {
                return la.getLinePattern();
            }
            if (DiscreteAttrMapper.this.linePatternMapper != null) {
                DiscreteAttrMapper.this.linePatternMapper.init(new AInitAction());
                return (int)DiscreteAttrMapper.this.linePatternMapper.getValue(index);
            }
            if (DiscreteAttrMapper.this.linePatternPipe != null) {
                return DiscreteAttrMapper.this.linePatternPipe.getValue(index);
            }
            return -1;
        }
    }

    private class LineStipplePatternPipe
    extends LineAttrsPipe
    implements IntegerPipe {
        private LineStipplePatternPipe() {
        }

        public int getValue(int index) throws MissingValueException {
            LineAttrs la = this.getLineAttrs(index);
            if (la != null && la.getLinePattern() >= 0) {
                return SASLinePatterns.getStipplePattern((int)la.getLinePattern());
            }
            if (DiscreteAttrMapper.this.linePatternMapper != null) {
                DiscreteAttrMapper.this.linePatternMapper.init(new AInitAction());
                return SASLinePatterns.getStipplePattern((int)((int)DiscreteAttrMapper.this.linePatternMapper.getValue(index)));
            }
            if (DiscreteAttrMapper.this.linePatternPipe != null) {
                return SASLinePatterns.getStipplePattern((int)DiscreteAttrMapper.this.linePatternPipe.getValue(index));
            }
            return -1;
        }
    }

    private class LineStippleFactorPipe
    extends LineAttrsPipe
    implements IntegerPipe {
        private LineStippleFactorPipe() {
        }

        public int getValue(int index) throws MissingValueException {
            LineAttrs la = this.getLineAttrs(index);
            if (la != null && la.getLinePattern() >= 0) {
                return SASLinePatterns.getStippleFactor((int)la.getLinePattern());
            }
            if (DiscreteAttrMapper.this.linePatternMapper != null) {
                DiscreteAttrMapper.this.linePatternMapper.init(new AInitAction());
                return SASLinePatterns.getStippleFactor((int)((int)DiscreteAttrMapper.this.linePatternMapper.getValue(index)));
            }
            if (DiscreteAttrMapper.this.linePatternPipe != null) {
                return SASLinePatterns.getStippleFactor((int)DiscreteAttrMapper.this.linePatternPipe.getValue(index));
            }
            return -1;
        }
    }

    public class TextColorPipe
    extends TextAttrsPipe
    implements ColorPipe {
        public Color getValue(int index) throws MissingValueException {
            TextAttrs ta = this.getTextAttrs(index);
            if (ta != null && ta.getColor() != null) {
                return AttrMapper.applyTransparency(ta.getColor(), DiscreteAttrMapper.this.textTransparency);
            }
            if (DiscreteAttrMapper.this.textColorMapper != null) {
                DiscreteAttrMapper.this.textColorMapper.init(new AInitAction());
                return DiscreteAttrMapper.this.textColorMapper.getValue(index);
            }
            if (DiscreteAttrMapper.this.textColorPipe != null) {
                return DiscreteAttrMapper.this.textColorPipe.getValue(index);
            }
            return null;
        }
    }

    private class TextStylePipe
    extends TextAttrsPipe
    implements IntegerPipe {
        private TextStylePipe() {
        }

        public int getValue(int index) throws MissingValueException {
            TextAttrs ta = this.getTextAttrs(index);
            if (ta != null && ta.getFont() != null) {
                return ta.getFont().getStyle();
            }
            if (DiscreteAttrMapper.this.textStyleMapper != null) {
                DiscreteAttrMapper.this.textStyleMapper.init(new AInitAction());
                return (int)DiscreteAttrMapper.this.textStyleMapper.getValue(index);
            }
            if (DiscreteAttrMapper.this.textStylePipe != null) {
                return DiscreteAttrMapper.this.textStylePipe.getValue(index);
            }
            return -1;
        }
    }

    public class LineThicknessPipe
    extends LineAttrsPipe
    implements IntegerPipe {
        private int defaultValue;

        public LineThicknessPipe(int defaultValue) {
            this.defaultValue = -1;
            this.defaultValue = defaultValue;
        }

        public int getValue(int index) throws MissingValueException {
            LineAttrs la = this.getLineAttrs(index);
            if (la != null && la.getWidth() >= 0) {
                return la.getWidth();
            }
            if (DiscreteAttrMapper.this.lineThicknessMapper != null) {
                DiscreteAttrMapper.this.lineThicknessMapper.init(new AInitAction());
                return (int)DiscreteAttrMapper.this.lineThicknessMapper.getValue(index);
            }
            if (this.defaultValue >= 0) {
                return this.defaultValue;
            }
            return -1;
        }
    }

    public class MarkerSizePipe
    extends MarkerAttrsPipe
    implements IntegerPipe {
        private int defaultValue;

        public MarkerSizePipe(int defaultValue) {
            this.defaultValue = -1;
            this.defaultValue = defaultValue;
        }

        public int getValue(int index) throws MissingValueException {
            MarkerAttrs ma = this.getMarkerAttrs(index);
            if (ma != null && ma.getSize() >= 0) {
                return DiscreteAttrMapper.this.scaleMarker(ma.getSize());
            }
            if (DiscreteAttrMapper.this.markerSizeMapper != null) {
                DiscreteAttrMapper.this.markerSizeMapper.init(new AInitAction());
                return (int)DiscreteAttrMapper.this.markerSizeMapper.getValue(index);
            }
            if (this.defaultValue >= 0) {
                return this.defaultValue;
            }
            return -1;
        }
    }

    public class MarkerEdgeThicknessPipe
    extends MarkerAttrsPipe
    implements IntegerPipe {
        private int defaultSize;
        private int defaultWeight;
        private boolean fixedSize;

        public MarkerEdgeThicknessPipe(int defaultSize, int defaultWeight) {
            this(defaultSize, defaultWeight, false);
        }

        public MarkerEdgeThicknessPipe(int defaultSize, int defaultWeight, boolean fixedSize) {
            this.defaultSize = -1;
            this.defaultWeight = -1;
            this.fixedSize = false;
            this.defaultSize = defaultSize;
            this.defaultWeight = defaultWeight;
            this.fixedSize = fixedSize;
        }

        public int getValue(int index) throws MissingValueException {
            double size = this.defaultSize;
            MarkerAttrs ma = this.getMarkerAttrs(index);
            if (!this.fixedSize) {
                if (ma != null && ma.getSize() >= 0) {
                    size = DiscreteAttrMapper.this.scaleMarker(ma.getSize());
                } else if (DiscreteAttrMapper.this.markerSizeMapper != null) {
                    DiscreteAttrMapper.this.markerSizeMapper.init(new AInitAction());
                    size = DiscreteAttrMapper.this.markerSizeMapper.getValue(index);
                }
            }
            int weight = ma != null && ma.getWeight() >= 0 ? ma.getWeight() : this.defaultWeight;
            return this.getMarkerEdgeWidth(size, weight);
        }

        private int getMarkerEdgeWidth(double size, int weight) {
            double width;
            double ratio = (size /= DiscreteAttrMapper.this.dataDPIScaleFactor) / 7.0;
            if (weight == 2) {
                double power = 0.7;
                double minWidth = 2.0;
                width = ratio <= 2.0 ? minWidth : minWidth + Math.pow(ratio - 2.0, power);
            } else if (weight == 1) {
                double power = 0.65;
                double minWidth = 1.0;
                width = ratio <= 2.0 ? minWidth : minWidth + Math.pow(ratio - 2.0, power);
            } else {
                double power = 0.5;
                double minWidth = 1.0;
                width = ratio <= 3.0 ? minWidth : minWidth + Math.pow(ratio - 3.0, power);
            }
            width = Math.max(1.0, width * DiscreteAttrMapper.this.dataDPIScaleFactor);
            return (int)width;
        }
    }

    private class TextAttrsPipe
    implements Pipe {
        private TextAttrsPipe() {
        }

        public Formatter getFormatter() {
            return DiscreteAttrMapper.this.variable.getFormatter();
        }

        public void init(AInitAction initAction) {
            DiscreteAttrMapper.this.variable.init(initAction);
        }

        public void reset(AResetAction resetAction) {
        }

        protected TextAttrs getTextAttrs(int i) {
            TextAttrs result = null;
            String str = null;
            try {
                str = DiscreteAttrMapper.this.variable.getValue(i);
                str = DiscreteAttrMapper.this.fixValue(str);
                if (DiscreteAttrMapper.this.attrMap.get(str) != null) {
                    result = DiscreteAttrMapper.this.attrMap.get(str).getTextAttrs();
                }
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
            return result;
        }
    }

    private class LineAttrsPipe
    implements Pipe {
        private LineAttrsPipe() {
        }

        public Formatter getFormatter() {
            return DiscreteAttrMapper.this.variable.getFormatter();
        }

        public void init(AInitAction initAction) {
            DiscreteAttrMapper.this.variable.init(initAction);
        }

        public void reset(AResetAction resetAction) {
        }

        protected LineAttrs getLineAttrs(int i) {
            LineAttrs result = null;
            String str = null;
            try {
                str = DiscreteAttrMapper.this.variable.getValue(i);
                str = DiscreteAttrMapper.this.fixValue(str);
                if (DiscreteAttrMapper.this.attrMap.get(str) != null) {
                    result = DiscreteAttrMapper.this.attrMap.get(str).getLineAttrs();
                }
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
            return result;
        }
    }

    private class MarkerAttrsPipe
    implements Pipe {
        private MarkerAttrsPipe() {
        }

        public Formatter getFormatter() {
            return DiscreteAttrMapper.this.variable.getFormatter();
        }

        public void init(AInitAction initAction) {
            DiscreteAttrMapper.this.variable.init(initAction);
        }

        public void reset(AResetAction resetAction) {
        }

        protected MarkerAttrs getMarkerAttrs(int i) {
            MarkerAttrs result = null;
            String str = null;
            try {
                str = DiscreteAttrMapper.this.variable.getValue(i);
                str = DiscreteAttrMapper.this.fixValue(str);
                if (DiscreteAttrMapper.this.attrMap.get(str) != null) {
                    result = DiscreteAttrMapper.this.attrMap.get(str).getMarkerAttrs();
                }
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
            return result;
        }
    }

    private class FillAttrsPipe
    implements Pipe {
        private FillAttrsPipe() {
        }

        public Formatter getFormatter() {
            return DiscreteAttrMapper.this.variable.getFormatter();
        }

        public void init(AInitAction initAction) {
            DiscreteAttrMapper.this.variable.init(initAction);
        }

        public void reset(AResetAction resetAction) {
        }

        protected FillAttrs getFillAttrs(int i) {
            FillAttrs result = null;
            String str = null;
            try {
                str = DiscreteAttrMapper.this.variable.getValue(i);
                str = DiscreteAttrMapper.this.fixValue(str);
                if (DiscreteAttrMapper.this.attrMap.get(str) != null) {
                    result = DiscreteAttrMapper.this.attrMap.get(str).getFillAttrs();
                }
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
            return result;
        }

        protected MarkerAttrs getMarkerAttrs(int i) {
            MarkerAttrs result = null;
            String str = null;
            try {
                str = DiscreteAttrMapper.this.variable.getValue(i);
                str = DiscreteAttrMapper.this.fixValue(str);
                if (DiscreteAttrMapper.this.attrMap.get(str) != null) {
                    result = DiscreteAttrMapper.this.attrMap.get(str).getMarkerAttrs();
                }
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
            return result;
        }
    }
}

