/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.common.attrmap;

import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorModel;
import com.sas.graphics.common.attrmap.RangeAttrMapper;
import com.sas.graphics.util.attrmap.AttributeMapRange;
import com.sas.graphics.util.attrmap.RangeAttrBundle;
import com.sas.graphics.util.attrmap.RangeColorMapper;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.ContinuousRangeToColorMapper;
import com.sas.graphics.util.gtk.MissingValueException;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Vector;

public class ContinuousRangeColorMapper
extends ContinuousRangeToColorMapper {
    public final RangeAttrMapper rangeMapper;
    private final RangeColorMapper colorMapper;

    public ContinuousRangeColorMapper(RangeAttrMapper rangeMapper, double min, double max) {
        String error = rangeMapper.createColorMapper(min, max);
        this.rangeMapper = rangeMapper;
        this.colorMapper = rangeMapper.getRangeColorMapper();
        if (this.colorMapper == null) {
            throw new RuntimeException(error);
        }
    }

    public final Color getValue(double d) {
        return this.colorMapper.getMappedColor(d);
    }

    public final Color[] getColorSpectrumColors() throws MissingValueException {
        Vector ranges = this.rangeMapper.getAttrMap().getRanges();
        ArrayList<Color> allColors = new ArrayList<Color>();
        for (AttributeMapRange r : ranges) {
            Color[] clrs;
            RangeAttrBundle b = r.getRangeAttrBundle();
            ColorModel cm = b.getRangeColorModel();
            for (Color c : clrs = cm.getColors()) {
                allColors.add(c);
            }
        }
        return allColors.toArray(new Color[allColors.size()]);
    }

    public final void init(AInitAction ia) {
        this.rangeMapper.init(ia);
    }
}

