/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.range;

import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataPoint;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscretePoint;
import com.sas.graphics.applets.statgraph.sgchart.range.OrdinalRange;
import java.util.Enumeration;
import java.util.Vector;

public class DiscreteRange
extends DataRange {
    public static final int SORT_CUSTOM = -3;
    public static final int SORT_NONE = -2;
    public static final int SORT_DESCENDING = -1;
    public static final int SORT_DATA = 0;
    public static final int SORT_ASCENDING = 1;
    public static final int VALUE_POSITION_START = 1;
    public static final int VALUE_POSITION_END = 2;
    private Vector values;
    private int MPCBlankCount = 0;
    private int leadingBlankCount = 0;
    private int endingBlankCount = 0;
    private int sort = 0;
    protected Vector valuesAtStart = null;
    protected Vector valuesAtEnd = null;

    public DiscreteRange() {
        this.values = new Vector();
        this.valuesAtStart = new Vector();
        this.valuesAtEnd = new Vector();
    }

    public DiscreteRange(DataRange src) {
        this.values = new Vector();
        this.valuesAtStart = new Vector();
        this.valuesAtEnd = new Vector();
        this.copyDR(src);
        if (src instanceof DiscreteRange) {
            DiscreteRange dr = (DiscreteRange)src;
            this.values = (Vector)dr.values.clone();
            this.MPCBlankCount = ((DiscreteRange)src).getMPCBlankCount();
            Vector vs = dr.getValuesAtStart();
            Enumeration vse = vs.elements();
            while (vse.hasMoreElements()) {
                this.valuesAtStart.add(vse.nextElement());
            }
            Vector ve = dr.getValuesAtEnd();
            Enumeration vee = ve.elements();
            while (vee.hasMoreElements()) {
                this.valuesAtEnd.add(vee.nextElement());
            }
        } else if (src instanceof ContinuousRange) {
            this.valid = false;
        }
    }

    public DiscreteRange(Object[] v) {
        int n = v.length;
        this.values = new Vector(n);
        this.valuesAtStart = new Vector();
        this.valuesAtEnd = new Vector();
        for (int i = 0; i < n; ++i) {
            if (v[i] == null) continue;
            this.values.addElement(v[i]);
        }
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof DiscreteRange)) {
            return false;
        }
        DiscreteRange dr = (DiscreteRange)o;
        if (!this.equalDR(dr)) {
            return false;
        }
        return this.values.equals(dr.values);
    }

    @Override
    public Object cloneRange() {
        return new DiscreteRange(this);
    }

    @Override
    public boolean union(DataRange range) {
        if (range instanceof DiscreteRange) {
            Object o;
            int i;
            DiscreteRange dr = (DiscreteRange)range;
            if (dr instanceof OrdinalRange && !((OrdinalRange)dr).isDataOrder()) {
                ((OrdinalRange)dr).sortValues();
            }
            Vector vc = (Vector)dr.values.clone();
            int n = vc.size();
            for (i = 0; i < n; ++i) {
                o = vc.elementAt(i);
                if (this.values.contains(o) || this.valuesAtStart.contains(o) || this.valuesAtEnd.contains(o)) continue;
                this.values.addElement(o);
            }
            for (i = this.valuesAtStart.size() - 1; i >= 0; --i) {
                o = this.valuesAtStart.get(i);
                if (this.values.contains(o)) {
                    this.values.remove(o);
                }
                this.values.insertElementAt(o, 0);
            }
            for (i = 0; i < this.valuesAtEnd.size(); ++i) {
                o = this.valuesAtEnd.get(i);
                if (this.values.contains(o)) {
                    this.values.remove(o);
                }
                this.values.add(o);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(DataPoint point) {
        if (point instanceof DiscretePoint) {
            DiscretePoint dp = (DiscretePoint)point;
            return this.values.contains(dp.getValue());
        }
        return false;
    }

    @Override
    public String toString() {
        int n = this.values.size();
        String s = "{";
        if (n < 10) {
            for (int i = 0; i < n; ++i) {
                s = s + this.values.elementAt(i) + (i == n - 1 ? "" : ",");
            }
        } else {
            int i;
            for (i = 0; i < 3; ++i) {
                s = s + this.values.elementAt(i) + (i == 2 ? "" : ",");
            }
            s = s + "...,";
            for (i = n - 4; i < n; ++i) {
                s = s + this.values.elementAt(i) + (i == n - 1 ? "" : ",");
            }
        }
        s = s + "}";
        return s;
    }

    public int getValuesSize() {
        return this.values.size();
    }

    public Enumeration getEnumeration() {
        return this.values.elements();
    }

    public Vector getValues() {
        return this.values;
    }

    public void setValues(Vector newValues) {
        this.values = newValues;
    }

    public void setMPCBlankCount(int count) {
        this.MPCBlankCount = count;
    }

    public int getMPCBlankCount() {
        return this.MPCBlankCount;
    }

    public void setLeadingBlankCount(int count) {
        this.leadingBlankCount = count;
    }

    public int getLeadingBlankCount() {
        return this.leadingBlankCount;
    }

    public void setEndingBlankCount(int count) {
        this.endingBlankCount = count;
    }

    public int getEndingBlankCount() {
        return this.endingBlankCount;
    }

    public int getSort() {
        return this.sort;
    }

    public void setSort(int sort) {
        this.sort = sort;
    }

    public Vector getValuesAtStart() {
        return this.valuesAtStart;
    }

    public void setValuePosition(String value, int position) {
        if (value == null) {
            return;
        }
        if (1 == position) {
            if (!this.valuesAtStart.contains(value)) {
                this.valuesAtStart.add(value);
            }
            if (this.values.contains(value)) {
                this.values.remove(value);
                this.values.insertElementAt(value, 0 + this.valuesAtStart.size() - 1);
            }
        } else if (2 == position) {
            if (!this.valuesAtEnd.contains(value)) {
                this.valuesAtEnd.add(value);
            }
            if (this.values.contains(value)) {
                this.values.remove(value);
                this.values.add(value);
            }
        }
    }

    public Vector getValuesAtEnd() {
        return this.valuesAtEnd;
    }
}

