/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.range;

import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousPoint;
import com.sas.graphics.applets.statgraph.sgchart.range.CustomBinnedRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataPoint;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.applets.statgraph.sgchart.range.SimpleBinnedRange;

public final class ContinuousRange
extends DataRange {
    private double min;
    private double max;
    private boolean minExclude = false;
    private boolean maxExclude = false;

    public ContinuousRange() {
        this.valid = false;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ContinuousRange)) {
            return false;
        }
        ContinuousRange cr = (ContinuousRange)o;
        if (!this.equalDR(cr)) {
            return false;
        }
        if (this.min != cr.min) {
            return false;
        }
        return this.max == cr.max;
    }

    public ContinuousRange(double min, double max) {
        this.min = min;
        this.max = max;
    }

    public ContinuousRange(DataRange src) {
        this.copyDR(src);
        if (src instanceof ContinuousRange) {
            ContinuousRange cr = (ContinuousRange)src;
            this.min = cr.min;
            this.max = cr.max;
            this.minExclude = cr.minExclude;
            this.maxExclude = cr.maxExclude;
        } else if (src instanceof DiscreteRange) {
            this.valid = false;
        } else if (src instanceof SimpleBinnedRange) {
            SimpleBinnedRange sbr = (SimpleBinnedRange)src;
            double first = sbr.getFirstMidpoint();
            double last = sbr.getLastMidpoint();
            double size = sbr.getBinSize();
            if (size <= 0.0) {
                this.valid = false;
            } else {
                this.min = first - size / 2.0;
                this.max = last + size / 2.0;
            }
        } else if (src instanceof CustomBinnedRange) {
            CustomBinnedRange cbr = (CustomBinnedRange)src;
            this.min = cbr.getMin();
            this.max = cbr.getMax();
        }
    }

    @Override
    public Object cloneRange() {
        return new ContinuousRange(this);
    }

    @Override
    public boolean union(DataRange range) {
        if (range instanceof ContinuousRange) {
            ContinuousRange cr = (ContinuousRange)range;
            this.min = Math.min(this.min, cr.getMin());
            this.max = Math.max(this.max, cr.getMax());
            return true;
        }
        if (range instanceof SimpleBinnedRange) {
            SimpleBinnedRange sbr = (SimpleBinnedRange)range;
            ContinuousRange cr = (ContinuousRange)sbr.getDual();
            if (sbr.isUpdateDual() && cr != null) {
                this.min = Math.min(this.min, cr.getMin());
                this.max = Math.max(this.max, cr.getMax());
            } else {
                this.min = Math.min(this.min, sbr.getFirstMidpoint() - sbr.getBinSize() / 2.0);
                this.max = Math.max(this.max, sbr.getLastMidpoint() + sbr.getBinSize() / 2.0);
            }
            return true;
        }
        if (range instanceof CustomBinnedRange) {
            CustomBinnedRange cbr = (CustomBinnedRange)range;
            ContinuousRange cr = (ContinuousRange)cbr.getDual();
            if (cbr.isUpdateDual() && cr != null) {
                this.min = Math.min(this.min, cr.getMin());
                this.max = Math.max(this.max, cr.getMax());
            } else {
                this.min = Math.min(this.min, cbr.getMin());
                this.max = Math.max(this.max, cbr.getMax());
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(DataPoint point) {
        if (point instanceof ContinuousPoint) {
            ContinuousPoint cp = (ContinuousPoint)point;
            return cp.getValue() >= this.min && cp.getValue() <= this.max;
        }
        return false;
    }

    @Override
    public String toString() {
        return "{" + this.min + "-" + this.max + "}";
    }

    public double getMin() {
        return this.min;
    }

    public void setMin(double aMin) {
        this.min = aMin;
    }

    public double getMax() {
        return this.max;
    }

    public void setMax(double aMax) {
        this.max = aMax;
    }

    public void setMinExclude(boolean exclude) {
        this.minExclude = exclude;
    }

    public boolean isMinExclude() {
        return this.minExclude;
    }

    public void setMaxExclude(boolean exclude) {
        this.maxExclude = exclude;
    }

    public boolean isMaxExclude() {
        return this.maxExclude;
    }
}

