/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.applets.statgraph.sgchart.grid;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;

public class StripLabel
extends JLabel
implements PropertyChangeListener {
    protected double low;
    protected double high;
    protected Color hilite;
    protected Color hiliteOutline;
    public static final int NONE = 0;
    public static final int NUMERIC_TRUNCATE = 1;
    protected int fitPolicy = 0;
    private boolean notFit = false;

    public StripLabel(String text) {
        this(text, 0.0, 0.0);
    }

    public StripLabel(String text, double low, double high) {
        super(text);
        if (low < 0.0 || low > 1.0 || high < 0.0 || high > 1.0 || low > high) {
            throw new IllegalArgumentException("invalid range (" + low + "," + high + ")");
        }
        this.low = low;
        this.high = high;
        this.addPropertyChangeListener("font", this);
    }

    public double getLow() {
        return this.low;
    }

    public void setLow(double value) {
        if (this.low < 0.0 || this.low > 1.0) {
            throw new IllegalArgumentException("invalid low " + this.low);
        }
        this.low = value;
    }

    public double getHigh() {
        return this.high;
    }

    public void setHigh(double value) {
        if (this.high < 0.0 || this.high > 1.0) {
            throw new IllegalArgumentException("invalid high " + this.high);
        }
        this.high = value;
    }

    public Color getHilte() {
        return this.hilite;
    }

    public void setHilite(Color color) {
        this.hilite = color;
    }

    public Color getHilteOutline() {
        return this.hiliteOutline;
    }

    public void setHiliteOutline(Color color) {
        this.hiliteOutline = color;
    }

    public int getFitPolicy() {
        return this.fitPolicy;
    }

    public void setFitPolicy(int policy) {
        this.fitPolicy = policy;
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        Font oldFont = (Font)pce.getOldValue();
        Font newFont = (Font)pce.getNewValue();
        if (oldFont != null && newFont != null && oldFont.getSize() != newFont.getSize() && this.getParent() != null) {
            this.getParent().validate();
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        Dimension d = this.getSize();
        int start = (int)(this.low * (double)d.width);
        int hiliteWidth = (int)((this.high - this.low) * (double)d.width);
        boolean opaque = this.isOpaque();
        if (opaque) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, d.width, d.height);
        }
        if (hiliteWidth > 0) {
            g.setColor(this.hilite);
            g.fillRect(start, 0, hiliteWidth, d.height);
            if (this.hiliteOutline != null) {
                g.setColor(this.hiliteOutline);
                g.drawLine(start, 0, start, d.height);
                g.drawLine(start + hiliteWidth, 0, start + hiliteWidth, d.height);
            }
        }
        this.setOpaque(false);
        if (this.fitPolicy == 1) {
            String text = this.getText();
            if (this.notFit) {
                this.setText("*");
            }
            super.paintComponent(g);
            if (this.notFit) {
                this.setText(text);
            }
        } else {
            super.paintComponent(g);
        }
        this.setOpaque(opaque);
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        if (this.fitPolicy == 1) {
            int pw = this.getPreferredSize().width;
            this.notFit = pw > w;
        }
        super.setBounds(x, y, w, h);
    }
}

