/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.anno;

import com.sas.graphics.anno.AreaAnno;
import com.sas.graphics.anno.Constants;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;

public class TextAnno
extends AreaAnno {
    private AttributedString text;
    private Insets margins = new Insets(0, 0, 0, 0);
    private Rectangle2D.Double rawTextBoundsD;
    private Rectangle2D.Double borderBoundsD;
    float wrappingWidthD;
    boolean validText = false;
    private boolean svgRender = false;

    public AttributedString getText() {
        return this.text;
    }

    public void setText(AttributedString text) {
        this.text = text;
    }

    @Override
    public double getHeight() {
        return Double.NaN;
    }

    @Override
    public void setHeight(double height) {
    }

    @Override
    public int getHeightSpace() {
        return -1;
    }

    @Override
    public void setHeightSpace(int heightSpace) {
    }

    @Override
    public void paint(Graphics2D g) {
        if (this.subpixelRendering) {
            this.subpixelPaint(g);
            return;
        }
        if (this.text == null) {
            return;
        }
        Graphics2D gc = (Graphics2D)g.create();
        if (this.antialias) {
            gc.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            gc.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        if (this.antialiasText) {
            gc.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else {
            gc.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
        if (!this.setTextLayout(gc)) {
            gc.dispose();
            return;
        }
        if (this.rotationAngle != 0.0) {
            gc.rotate(-this.rotationAngle, this.anchorScreen.x, this.anchorScreen.y);
        }
        if (this.transparency != 0.0) {
            gc.setComposite(AlphaComposite.getInstance(3, (float)(1.0 - this.transparency)));
        }
        if (this.clip) {
            boolean flag;
            boolean bl = flag = Constants.getSpace(this.anchorPoint.xSpace) == 2 && Constants.getSpace(this.anchorPoint.ySpace) == 2;
            if (flag) {
                Rectangle c = this.container.getDataBoundingBox();
                if (this.rotationAngle != 0.0) {
                    AffineTransform at = AffineTransform.getRotateInstance(this.rotationAngle, this.anchorScreen.x, this.anchorScreen.y);
                    gc.clip(at.createTransformedShape(c));
                } else {
                    gc.clip(c);
                }
            }
        }
        Rectangle borderBounds = this.borderBoundsD.getBounds();
        if (this.background) {
            gc.setColor(this.backgroundColor);
            gc.fillRect(borderBounds.x, borderBounds.y, borderBounds.width, borderBounds.height);
        }
        if (this.border) {
            gc.setColor(this.borderColor);
            gc.setStroke(this.borderStroke);
            gc.drawRect(borderBounds.x, borderBounds.y, borderBounds.width, borderBounds.height);
        }
        if (this.validText) {
            this.drawText(gc, true, -1);
        }
        this.region.reset();
        this.region.append(this.boundsD.getBounds(), false);
        if (this.rotationAngle != 0.0) {
            AffineTransform at = AffineTransform.getRotateInstance(-this.rotationAngle, this.anchorScreen.x, this.anchorScreen.y);
            this.region.transform(at);
            this.textBounds = at.createTransformedShape(this.rawTextBoundsD);
        } else {
            this.textBounds = this.rawTextBoundsD;
        }
        gc.dispose();
    }

    public void subpixelPaint(Graphics2D g) {
        if (this.text == null) {
            return;
        }
        Graphics2D gc = (Graphics2D)g.create();
        if (this.antialias) {
            gc.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            gc.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        if (this.antialiasText) {
            gc.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else {
            gc.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
        gc.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        if (!this.setTextLayout(gc)) {
            gc.dispose();
            return;
        }
        if (this.rotationAngle != 0.0) {
            gc.rotate(-this.rotationAngle, this.anchorScreen.getX(), this.anchorScreen.getY());
        }
        if (this.transparency != 0.0) {
            gc.setComposite(AlphaComposite.getInstance(3, (float)(1.0 - this.transparency)));
        }
        if (this.clip) {
            boolean flag;
            boolean bl = flag = Constants.getSpace(this.anchorPoint.xSpace) == 2 && Constants.getSpace(this.anchorPoint.ySpace) == 2;
            if (flag) {
                Rectangle c = this.container.getDataBoundingBox();
                if (this.rotationAngle != 0.0) {
                    AffineTransform at = AffineTransform.getRotateInstance(this.rotationAngle, this.anchorScreen.getX(), this.anchorScreen.getY());
                    gc.clip(at.createTransformedShape(c));
                } else {
                    gc.clip(c);
                }
            }
        }
        if (this.background) {
            gc.setColor(this.backgroundColor);
            gc.fill(this.borderBoundsD);
        }
        if (this.border) {
            gc.setColor(this.borderColor);
            gc.setStroke(this.borderStroke);
            gc.draw(this.borderBoundsD);
        }
        if (this.validText) {
            this.drawText(gc, true, -1);
        }
        this.region.reset();
        this.region.append(this.boundsD, false);
        if (this.rotationAngle != 0.0) {
            AffineTransform at = AffineTransform.getRotateInstance(-this.rotationAngle, this.anchorScreen.getX(), this.anchorScreen.getY());
            this.region.transform(at);
            this.textBounds = at.createTransformedShape(this.rawTextBoundsD);
        } else {
            this.textBounds = this.rawTextBoundsD;
        }
        gc.dispose();
    }

    private void drawText(Graphics2D gc, boolean drawText, int caret) {
        int pad = this.border ? (int)this.borderStroke.getLineWidth() : 0;
        float ty = this.subpixelRendering ? (float)(Math.floor(this.boundsD.y) + (double)this.margins.top + (double)pad) : (float)(this.boundsD.getBounds().getY() + (double)this.margins.top + (double)pad);
        this.lbm.setPosition(0);
        float _wrappingWidth = this.subpixelRendering ? this.wrappingWidthD : (float)Math.round(this.wrappingWidthD);
        TextLayout tl = this.lbm.nextLayout(_wrappingWidth);
        ty += tl.getAscent();
        int prev = 0;
        int next = 0;
        while (true) {
            float start = this.getTextAnchor(tl);
            prev = next;
            next = this.lbm.getPosition();
            if (drawText) {
                if (this.svgRender) {
                    AttributedCharacterIterator iter = this.text.getIterator(attributes, prev, next);
                    float xx = start;
                    int s1 = prev;
                    int end = iter.getRunLimit();
                    while (true) {
                        char c;
                        int style;
                        Number num;
                        String family;
                        Font ff;
                        if ((ff = (Font)iter.getAttribute(TextAttribute.FONT)) == null) {
                            ff = gc.getFont();
                        }
                        if ((family = (String)iter.getAttribute(TextAttribute.FAMILY)) == null) {
                            family = ff.getFamily();
                        }
                        float size = (num = (Number)iter.getAttribute(TextAttribute.SIZE)) != null ? num.floatValue() : (float)ff.getSize();
                        boolean italic = ff.isItalic();
                        boolean bold = ff.isBold();
                        Object obj = iter.getAttribute(TextAttribute.POSTURE);
                        if (obj instanceof Number) {
                            boolean bl = italic = (Number)obj == TextAttribute.POSTURE_OBLIQUE;
                        }
                        if ((obj = iter.getAttribute(TextAttribute.WEIGHT)) instanceof Number) {
                            bold = (Number)obj == TextAttribute.WEIGHT_BOLD;
                        }
                        int n = style = bold ? 1 : 0;
                        if (italic) {
                            style |= 2;
                        }
                        Number sup = (Number)iter.getAttribute(TextAttribute.SUPERSCRIPT);
                        float offset = 0.0f;
                        int sign = 1;
                        if (sup != null && sup.doubleValue() != 0.0) {
                            double value = sup.doubleValue();
                            if (value < 0.0) {
                                sign *= -1;
                            }
                            offset = (float)((double)size * 0.5 * Math.pow(0.6666666666666666, (double)sign * value - 1.0)) * (float)(-1 * sign);
                            size = (float)((double)size * (0.6666666666666666 * ((double)sign * value)));
                        }
                        Font font = new Font(family, style, Math.round(size));
                        gc.setFont(font);
                        gc.setColor((Color)iter.getAttribute(TextAttribute.FOREGROUND));
                        StringBuffer sb = new StringBuffer();
                        sb.append(iter.setIndex(s1));
                        while (iter.getIndex() + 1 < end && (c = iter.next()) != '\uffff') {
                            sb.append(c);
                        }
                        gc.drawString(sb.toString(), xx, ty + offset);
                        if (end != next) {
                            xx = (float)((double)xx + gc.getFontMetrics().getStringBounds(iter, s1, end, (Graphics)gc).getWidth());
                            s1 = end;
                            iter.setIndex(s1);
                            end = iter.getRunLimit();
                            continue;
                        }
                        break;
                    }
                } else {
                    tl.draw(gc, start, ty);
                }
            }
            if (caret != -1 && caret >= prev && caret < next) {
                this.drawCaret(gc, caret - prev, start, ty, tl);
            }
            ty += tl.getDescent();
            tl = this.lbm.nextLayout(_wrappingWidth);
            if (tl == null) break;
            ty += tl.getLeading() + tl.getAscent();
        }
    }

    protected float getTextAnchor(TextLayout tl) {
        int pad;
        int n = pad = this.border ? (int)this.borderStroke.getLineWidth() : 0;
        if (this.subpixelRendering) {
            double xo = this.borderBoundsD.x + (double)this.margins.left + (double)pad;
            return this.getTextAnchor(tl, (float)xo, (float)this.rawTextBoundsD.width);
        }
        int xo = (int)Math.floor(this.borderBoundsD.x) + this.margins.left + pad;
        return this.getTextAnchor(tl, xo, (int)Math.round(this.rawTextBoundsD.width));
    }

    private boolean setTextLayout(Graphics2D g) {
        double width;
        double height;
        Point2D.Double sz = this.container.getScreenSize(this.size, this.linearScaleFactor);
        if (sz == null) {
            return false;
        }
        Point p = TextAnno.getPoint(sz);
        boolean bl = this.badData = p.x == Integer.MIN_VALUE || p.y == Integer.MIN_VALUE;
        if (this.badData) {
            return false;
        }
        double pad = this.border ? (double)this.borderStroke.getLineWidth() : 0.0;
        this.wrappingWidthD = (float)Math.max(6.0, sz.getX() - 2.0 * pad - (double)this.margins.left - (double)this.margins.right);
        this.anchorScreen = this.container.getScreenPoint(this.anchorPoint, this.dataDPIScaleFactor);
        if (this.anchorScreen == null) {
            return false;
        }
        Point pt = TextAnno.getPoint(this.anchorScreen);
        boolean bl2 = this.badData = pt.x == Integer.MIN_VALUE || pt.y == Integer.MIN_VALUE;
        if (this.badData) {
            return false;
        }
        float _wrappingWidth = this.subpixelRendering ? this.wrappingWidthD : (float)Math.round(this.wrappingWidthD);
        FontRenderContext frc = g.getFontRenderContext();
        TextLayout tl = null;
        if (this.text == null || this.text.getIterator().getEndIndex() == 0) {
            AttributedString ar = new AttributedString("Tg");
            ar.addAttribute(TextAttribute.FONT, this.getFont());
            this.lbm = new LineBreakMeasurer(ar.getIterator(), frc);
            this.lbm.setPosition(0);
            tl = this.lbm.nextLayout(_wrappingWidth);
            height = tl.getAscent() + tl.getDescent();
            width = _wrappingWidth;
            this.validText = false;
        } else {
            this.lbm = new LineBreakMeasurer(this.text.getIterator(), frc);
            this.lbm.setPosition(0);
            tl = this.lbm.nextLayout(_wrappingWidth);
            this.validText = true;
            height = tl.getAscent() + tl.getDescent();
            width = tl.getVisibleAdvance();
        }
        while ((tl = this.lbm.nextLayout(_wrappingWidth)) != null) {
            width = Math.max(width, (double)tl.getVisibleAdvance());
            height += (double)(tl.getAscent() + tl.getDescent() + tl.getLeading());
        }
        double xo = 0.0;
        double yo = 0.0;
        double x1 = 0.0;
        switch (this.anchor) {
            case 3: {
                xo += this.anchorScreen.x - width / 2.0 - pad - (double)((this.margins.left + this.margins.right) / 2);
                x1 += this.anchorScreen.x - (double)(_wrappingWidth / 2.0f) - pad - (double)((this.margins.left + this.margins.right) / 2);
                yo += this.anchorScreen.y;
                break;
            }
            case 4: {
                xo += this.anchorScreen.x - width / 2.0 - pad - (double)((this.margins.left + this.margins.right) / 2);
                x1 += this.anchorScreen.x - (double)(_wrappingWidth / 2.0f) - pad - (double)((this.margins.left + this.margins.right) / 2);
                yo += this.anchorScreen.y - (double)this.margins.top - (double)this.margins.bottom - height - 2.0 * pad;
                break;
            }
            case 1: {
                xo += this.anchorScreen.x;
                x1 += this.anchorScreen.x;
                yo += this.anchorScreen.y - (double)((this.margins.top + this.margins.bottom) / 2) - height / 2.0 - pad;
                break;
            }
            case 2: {
                xo += this.anchorScreen.x - width - 2.0 * pad - (double)this.margins.left - (double)this.margins.right;
                x1 += this.anchorScreen.x - (double)_wrappingWidth - 2.0 * pad - (double)this.margins.left - (double)this.margins.right;
                yo += this.anchorScreen.y - (double)((this.margins.top + this.margins.bottom) / 2) - height / 2.0 - pad;
                break;
            }
            default: {
                xo = this.anchorScreen.x - width / 2.0 - pad - (double)((this.margins.left + this.margins.right) / 2);
                x1 = this.anchorScreen.x - (double)(_wrappingWidth / 2.0f) - pad - (double)((this.margins.left + this.margins.right) / 2);
                yo += this.anchorScreen.y - (double)((this.margins.top + this.margins.bottom) / 2) - pad - height / 2.0;
                break;
            }
            case 5: {
                xo += this.anchorScreen.x;
                x1 += this.anchorScreen.x;
                yo += this.anchorScreen.y;
                break;
            }
            case 8: {
                xo += this.anchorScreen.x - width - 2.0 * pad - (double)this.margins.left - (double)this.margins.right;
                x1 += this.anchorScreen.x - (double)_wrappingWidth - 2.0 * pad - (double)this.margins.left - (double)this.margins.right;
                yo += this.anchorScreen.y;
                break;
            }
            case 6: {
                xo += this.anchorScreen.x;
                x1 += this.anchorScreen.x;
                yo += this.anchorScreen.y - (double)this.margins.top - (double)this.margins.bottom - height - 2.0 * pad;
                break;
            }
            case 7: {
                xo += this.anchorScreen.x - width - 2.0 * pad - (double)this.margins.left - (double)this.margins.right;
                x1 += this.anchorScreen.x - (double)_wrappingWidth - 2.0 * pad - (double)this.margins.left - (double)this.margins.right;
                yo += this.anchorScreen.y - (double)this.margins.top - (double)this.margins.bottom - height - 2.0 * pad;
            }
        }
        this.rawTextBoundsD = new Rectangle2D.Double(xo + (double)this.margins.left + pad, yo + (double)this.margins.top + pad, width, height);
        this.borderBoundsD = new Rectangle2D.Double(xo, yo, (double)(this.margins.left + this.margins.right) + width + 2.0 * pad, (double)(this.margins.top + this.margins.bottom) + height + 2.0 * pad);
        this.boundsD = new Rectangle2D.Double(x1, yo, (double)((float)(this.margins.left + this.margins.right) + _wrappingWidth) + 2.0 * pad, (double)(this.margins.top + this.margins.bottom) + height + 2.0 * pad);
        return true;
    }

    public Insets getMargins() {
        return this.margins;
    }

    public void setMargins(Insets margins) {
        this.margins = margins;
    }

    private Shape getTextBounds(int begin, int end) {
        if (begin == -1 || end == -1) {
            return this.rawTextBoundsD;
        }
        float ty = (float)this.rawTextBoundsD.y;
        this.lbm.setPosition(0);
        float _wrappingWidth = this.subpixelRendering ? this.wrappingWidthD : (float)Math.round(this.wrappingWidthD);
        TextLayout tl = this.lbm.nextLayout(_wrappingWidth);
        ty += tl.getAscent();
        int soffset = 0;
        while (this.lbm.getPosition() <= begin) {
            ty += tl.getDescent();
            soffset = this.lbm.getPosition();
            tl = this.lbm.nextLayout(_wrappingWidth);
            if (tl == null) {
                return this.rawTextBoundsD;
            }
            ty += tl.getLeading() + tl.getAscent();
        }
        float xo = this.getTextAnchor(tl);
        if (this.lbm.getPosition() >= end) {
            Shape s = tl.getLogicalHighlightShape(begin - soffset, end - soffset);
            return AffineTransform.getTranslateInstance(xo, ty).createTransformedShape(s);
        }
        Polygon poly = new Polygon();
        int index = begin - soffset;
        Rectangle r = tl.getLogicalHighlightShape(index, index + 1).getBounds();
        poly.addPoint((int)Math.floor(this.rawTextBoundsD.x), (int)ty + r.y + r.height + (int)tl.getLeading());
        poly.addPoint((int)xo + r.x, (int)ty + r.y + r.height + (int)tl.getLeading());
        poly.addPoint((int)xo + r.x, (int)ty + r.y);
        poly.addPoint((int)Math.floor(this.rawTextBoundsD.x) + (int)Math.round(this.rawTextBoundsD.width), (int)ty + r.y);
        if (end == this.lbm.nextOffset(2.1474836E9f)) {
            poly.addPoint((int)Math.floor(this.rawTextBoundsD.x) + (int)Math.round(this.rawTextBoundsD.width), (int)Math.floor(this.rawTextBoundsD.y) + (int)Math.round(this.rawTextBoundsD.height));
            poly.addPoint((int)Math.floor(this.rawTextBoundsD.x), (int)Math.floor(this.rawTextBoundsD.y) + (int)Math.round(this.rawTextBoundsD.height));
            return poly;
        }
        int eoffset = soffset;
        while (this.lbm.getPosition() < end) {
            ty += tl.getDescent();
            eoffset = this.lbm.getPosition();
            tl = this.lbm.nextLayout(_wrappingWidth);
            if (tl == null) {
                return this.rawTextBoundsD;
            }
            ty += tl.getLeading() + tl.getAscent();
        }
        xo = this.getTextAnchor(tl);
        r = tl.getLogicalHighlightShape(end - eoffset, this.lbm.getPosition() - eoffset).getBounds();
        poly.addPoint((int)Math.floor(this.rawTextBoundsD.x) + (int)Math.round(this.rawTextBoundsD.width), (int)ty + r.y);
        poly.addPoint(r.x + (int)xo, (int)ty + r.y);
        poly.addPoint(r.x + (int)xo, (int)ty + r.y + r.height);
        poly.addPoint((int)Math.floor(this.rawTextBoundsD.x), (int)ty + r.y + r.height);
        return poly;
    }

    @Override
    public void drawText(Graphics2D gc, int caret, boolean highlight, Color hc) {
        if (highlight) {
            this.drawText(gc, caret, 0, this.text.getIterator().getEndIndex(), hc);
        } else {
            this.drawText(gc, caret, caret, caret, hc);
        }
    }

    public void drawText(Graphics2D gc, int caret, int begin, int end, Color hc) {
        float _wrappingWidth;
        boolean highlight;
        if (this.lbm == null) {
            return;
        }
        AffineTransform saveAT = gc.getTransform();
        if (this.rotationAngle != 0.0) {
            gc.rotate(-this.rotationAngle, this.anchorScreen.x, this.anchorScreen.y);
        }
        Color c = this.getTextColor();
        boolean bl = highlight = begin != -1 && end != -1 && begin != end;
        if (begin > end) {
            int swap = end;
            end = begin;
            begin = swap;
        }
        float f = _wrappingWidth = this.subpixelRendering ? this.wrappingWidthD : (float)Math.round(this.wrappingWidthD);
        if (highlight) {
            gc.setColor(hc);
            Shape bb = this.getTextBounds(begin, end);
            gc.fill(bb);
            c = new Color(255 - hc.getRed(), 255 - hc.getGreen(), 255 - hc.getBlue());
            LineBreakMeasurer save = this.lbm;
            AttributedString tt = new AttributedString(this.text.getIterator());
            tt.addAttribute(TextAttribute.FOREGROUND, c);
            this.lbm = new LineBreakMeasurer(tt.getIterator(), gc.getFontRenderContext());
            Shape clip = gc.getClip();
            gc.setClip(bb);
            this.drawText(gc, true, caret);
            gc.setClip(clip);
            this.lbm = save;
        }
        if (caret != -1) {
            this.lbm.setPosition(0);
            int offset = 0;
            TextLayout tl = this.lbm.nextLayout(_wrappingWidth);
            float yo = (float)this.rawTextBoundsD.y;
            if (!this.subpixelRendering) {
                yo = Math.round(yo);
            }
            this.lbm.setPosition(0);
            tl = this.lbm.nextLayout(_wrappingWidth);
            double dy = tl.getAscent() + tl.getDescent() + tl.getLeading();
            while (this.lbm.getPosition() < caret) {
                offset = this.lbm.getPosition();
                tl = this.lbm.nextLayout(_wrappingWidth);
                if (tl == null) break;
                yo = (float)((double)yo + dy);
            }
            if (tl != null) {
                this.drawCaret(gc, caret - offset, this.getTextAnchor(tl), yo + tl.getAscent(), tl);
            }
        }
        gc.setTransform(saveAT);
        Stroke save = gc.getStroke();
        gc.setColor(Color.LIGHT_GRAY);
        gc.setStroke(textBorder);
        gc.draw(this.textBounds);
        gc.setStroke(save);
    }

    @Override
    public int getCaretPosition(int x, int y) {
        if (!this.textBounds.contains(x, y)) {
            return -1;
        }
        Point2D p = new Point2D.Double(x, y);
        if (this.rotationAngle != 0.0) {
            AffineTransform at = AffineTransform.getRotateInstance(this.rotationAngle, this.anchorScreen.x, this.anchorScreen.y);
            p = at.transform(p, p);
        }
        return this.getCaret(p);
    }

    @Override
    protected int getCaret(Point2D p) {
        if (this.lbm == null || this.text == null) {
            return -1;
        }
        this.lbm.setPosition(0);
        int offset = 0;
        float _wrappingWidth = this.subpixelRendering ? this.wrappingWidthD : (float)Math.round(this.wrappingWidthD);
        TextLayout tl = this.lbm.nextLayout(_wrappingWidth);
        float yo = (float)this.rawTextBoundsD.y;
        this.lbm.setPosition(0);
        tl = this.lbm.nextLayout(_wrappingWidth);
        double dy = tl.getAscent() + tl.getDescent() + tl.getLeading();
        double py = p.getY();
        while ((double)yo + dy <= py) {
            offset = this.lbm.getPosition();
            tl = this.lbm.nextLayout(_wrappingWidth);
            if (tl == null) break;
            yo = (float)((double)yo + dy);
        }
        if (tl == null) {
            return -1;
        }
        TextHitInfo thi = tl.hitTestChar((float)p.getX() - this.getTextAnchor(tl), (float)p.getY() - yo);
        int caret = 0;
        if (thi != null) {
            caret = offset + thi.getInsertionIndex();
        }
        return caret;
    }

    public int getWrappingWidth() {
        return Math.round(this.wrappingWidthD);
    }

    @Override
    public Shape[] getHandles() {
        if (this.anchorScreen == null) {
            return new GeneralPath[0];
        }
        Shape[] handles = super.getHandles();
        ((GeneralPath)handles[5]).reset();
        ((GeneralPath)handles[8]).reset();
        ((GeneralPath)handles[3]).reset();
        ((GeneralPath)handles[6]).reset();
        ((GeneralPath)handles[4]).reset();
        ((GeneralPath)handles[7]).reset();
        return handles;
    }

    public void setSVGRender(boolean svg) {
        this.svgRender = svg;
    }

    @Override
    public Shape[] getImageMapRegions() {
        Rectangle2D.Double rect;
        if (this.subpixelRendering) {
            return this.getSubpixelImageMapRegions();
        }
        Shape imageMapRegion = rect = new Rectangle2D.Double(this.borderBoundsD.x, this.borderBoundsD.y, this.borderBoundsD.width, this.borderBoundsD.height);
        if (this.rotationAngle != 0.0) {
            AffineTransform at = AffineTransform.getRotateInstance(-this.rotationAngle, this.anchorScreen.x, this.anchorScreen.y);
            imageMapRegion = at.createTransformedShape(rect);
        }
        return new Shape[]{imageMapRegion};
    }

    public Shape[] getSubpixelImageMapRegions() {
        Rectangle2D.Double rect;
        Shape imageMapRegion = rect = new Rectangle2D.Double(this.borderBoundsD.x, this.borderBoundsD.y, this.borderBoundsD.width, this.borderBoundsD.height);
        if (this.rotationAngle != 0.0) {
            AffineTransform at = AffineTransform.getRotateInstance(-this.rotationAngle, this.anchorScreen.getX(), this.anchorScreen.getY());
            imageMapRegion = at.createTransformedShape(rect);
        }
        return new Shape[]{imageMapRegion};
    }
}

