/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.anno;

import com.sas.graphics.anno.AreaAnno;
import com.sas.graphics.anno.Constants;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.RoundRectangle2D;

public class RectangleAnno
extends AreaAnno {
    private double cornerRadius = 0.0;

    public double getCornerRadius() {
        return this.cornerRadius;
    }

    public void setCornerRadius(double cornerRadius) {
        this.cornerRadius = cornerRadius;
    }

    @Override
    public void paint(Graphics2D g) {
        AffineTransform at;
        if (this.subpixelRendering) {
            this.subpixelPaint(g);
            return;
        }
        if (this.anchorPoint.x == null || this.anchorPoint.y == null || !this.container.isValidContainer()) {
            return;
        }
        if (this.computeBounds() == null) {
            return;
        }
        Graphics2D gc = (Graphics2D)g.create();
        if (this.antialias) {
            gc.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            gc.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        if (this.antialiasText) {
            gc.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else {
            gc.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
        if (this.rotationAngle != 0.0) {
            gc.rotate(-this.rotationAngle, this.anchorScreen.x, this.anchorScreen.y);
        }
        if (this.transparency != 0.0) {
            gc.setComposite(AlphaComposite.getInstance(3, (float)(1.0 - this.transparency)));
        }
        if (this.clip) {
            boolean flag;
            boolean bl = flag = Constants.getSpace(this.anchorPoint.xSpace) == 2 && Constants.getSpace(this.anchorPoint.ySpace) == 2;
            if (flag) {
                Rectangle c = this.container.getDataBoundingBox();
                if (this.rotationAngle != 0.0) {
                    at = AffineTransform.getRotateInstance(this.rotationAngle, this.anchorScreen.x, this.anchorScreen.y);
                    gc.clip(at.createTransformedShape(c));
                } else {
                    gc.clip(c);
                }
            }
        }
        int arc = 0;
        Rectangle bounds = this.boundsD.getBounds();
        if (this.cornerRadius != 0.0) {
            arc = (int)(this.cornerRadius * (double)Math.min(bounds.width, bounds.height));
        }
        if (this.background) {
            gc.setColor(this.backgroundColor);
            if (arc != 0) {
                gc.fillRoundRect(bounds.x, bounds.y, bounds.width, bounds.height, arc, arc);
            } else {
                gc.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
            }
        }
        if (this.border) {
            gc.setColor(this.borderColor);
            gc.setStroke(this.borderStroke);
            if (arc != 0) {
                gc.drawRoundRect(bounds.x, bounds.y, bounds.width, bounds.height, arc, arc);
            } else {
                gc.drawRect(bounds.x, bounds.y, bounds.width, bounds.height);
            }
        }
        this.region.reset();
        this.region.append(bounds, false);
        this.drawText(gc, bounds);
        if (this.textBounds != null && this.textAnchor != 0) {
            this.region.append(this.textBounds, false);
        }
        if (this.rotationAngle != 0.0) {
            at = AffineTransform.getRotateInstance(-this.rotationAngle, this.anchorScreen.x, this.anchorScreen.y);
            this.region.transform(at);
            this.textBounds = at.createTransformedShape(this.textBounds);
        }
        gc.dispose();
    }

    public void subpixelPaint(Graphics2D g) {
        AffineTransform at;
        if (this.anchorPoint.x == null || this.anchorPoint.y == null || !this.container.isValidContainer()) {
            return;
        }
        if (this.computeBounds() == null) {
            return;
        }
        Graphics2D gc = (Graphics2D)g.create();
        if (this.antialias) {
            gc.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            gc.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        if (this.antialiasText) {
            gc.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else {
            gc.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
        gc.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        if (this.rotationAngle != 0.0) {
            gc.rotate(-this.rotationAngle, this.anchorScreen.getX(), this.anchorScreen.getY());
        }
        if (this.transparency != 0.0) {
            gc.setComposite(AlphaComposite.getInstance(3, (float)(1.0 - this.transparency)));
        }
        if (this.clip) {
            boolean flag;
            boolean bl = flag = Constants.getSpace(this.anchorPoint.xSpace) == 2 && Constants.getSpace(this.anchorPoint.ySpace) == 2;
            if (flag) {
                Rectangle c = this.container.getDataBoundingBox();
                if (this.rotationAngle != 0.0) {
                    at = AffineTransform.getRotateInstance(this.rotationAngle, this.anchorScreen.getX(), this.anchorScreen.getY());
                    gc.clip(at.createTransformedShape(c));
                } else {
                    gc.clip(c);
                }
            }
        }
        double arc = 0.0;
        if (this.cornerRadius != 0.0) {
            arc = this.cornerRadius * Math.min(this.boundsD.width, this.boundsD.height);
        }
        if (this.background) {
            gc.setColor(this.backgroundColor);
            if (arc != 0.0) {
                gc.fill(new RoundRectangle2D.Double(this.boundsD.x, this.boundsD.y, this.boundsD.width, this.boundsD.height, arc, arc));
            } else {
                gc.fill(this.boundsD);
            }
        }
        if (this.border) {
            gc.setColor(this.borderColor);
            gc.setStroke(this.borderStroke);
            if (arc != 0.0) {
                gc.draw(new RoundRectangle2D.Double(this.boundsD.x, this.boundsD.y, this.boundsD.width, this.boundsD.height, arc, arc));
            } else {
                gc.draw(this.boundsD);
            }
        }
        this.region.reset();
        this.region.append(this.boundsD, false);
        this.drawText(gc, this.boundsD);
        if (this.textBounds != null && this.textAnchor != 0) {
            this.region.append(this.textBounds, false);
        }
        if (this.rotationAngle != 0.0) {
            at = AffineTransform.getRotateInstance(-this.rotationAngle, this.anchorScreen.getX(), this.anchorScreen.getY());
            this.region.transform(at);
            this.textBounds = at.createTransformedShape(this.textBounds);
        }
        gc.dispose();
    }
}

