/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.anno;

import com.sas.graphics.anno.AreaAnno;
import com.sas.graphics.anno.Constants;
import com.sas.graphics.anno.PointAndSpace;
import com.sas.graphics.anno.SizeAndSpace;
import com.sas.graphics.util.Markers;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;

public class MarkerAnno
extends AreaAnno {
    protected Color markerColor;
    protected int symbol = 1;

    public Color getColor() {
        return this.markerColor;
    }

    public void setColor(Color markerColor) {
        this.markerColor = markerColor;
    }

    public int getSymbol() {
        return this.symbol;
    }

    public void setSymbol(int symbol) {
        this.symbol = symbol;
    }

    @Override
    public void setWidth(double width) {
        this.size.width = width;
        this.size.height = width;
    }

    @Override
    public void setWidthSpace(int widthSpace) {
    }

    @Override
    public double getHeight() {
        return this.size.height;
    }

    @Override
    public void setHeight(double height) {
        this.size.height = height;
        this.size.width = height;
    }

    public void setSize(int ss) {
        this.size.height = ss;
        this.size.width = ss;
    }

    @Override
    public int getHeightSpace() {
        return this.size.heightSpace;
    }

    public MarkerAnno() {
        this.size = new SizeAndSpace(7.0, 7.0, 0, 0, true, true);
        this.anchorPoint = new PointAndSpace(null, null, 1, 1, true, true);
        this.textAnchor = 4;
    }

    @Override
    public void paint(Graphics2D g) {
        if (this.subpixelRendering) {
            this.subpixelPaint(g);
            return;
        }
        if (this.anchorPoint.x == null || this.anchorPoint.y == null) {
            return;
        }
        Point2D.Double sz = this.container.getScreenSize(this.size, this.linearScaleFactor);
        if (sz == null) {
            return;
        }
        this.anchorScreen = this.container.getScreenPoint(this.anchorPoint, this.dataDPIScaleFactor);
        if (this.anchorScreen == null) {
            return;
        }
        Point pt = MarkerAnno.getPoint(this.anchorScreen);
        Point szPt = MarkerAnno.getPoint(sz);
        boolean bl = this.badData = pt.x == Integer.MIN_VALUE || pt.y == Integer.MIN_VALUE || szPt.x == Integer.MIN_VALUE || szPt.y == Integer.MIN_VALUE;
        if (this.badData) {
            return;
        }
        Graphics2D gc = (Graphics2D)g.create();
        if (this.antialias) {
            gc.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            gc.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        if (this.antialiasText) {
            gc.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else {
            gc.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
        double xo = this.anchorScreen.x - sz.getX() / 2.0;
        double yo = this.anchorScreen.y - sz.getY() / 2.0;
        if (sz.getX() < 0.0) {
            sz.x *= -1.0;
            xo -= sz.getX();
        }
        if (sz.getY() < 0.0) {
            sz.y *= -1.0;
            yo -= sz.getY();
        }
        this.boundsD = new Rectangle2D.Double(xo, yo, sz.getX(), sz.getY());
        if (this.rotationAngle != 0.0) {
            gc.rotate(-this.rotationAngle, this.anchorScreen.x, this.anchorScreen.y);
        }
        if (this.transparency != 0.0) {
            gc.setComposite(AlphaComposite.getInstance(3, (float)(1.0 - this.transparency)));
        }
        if (this.clip) {
            boolean flag;
            boolean bl2 = flag = Constants.getSpace(this.anchorPoint.xSpace) == 2 && Constants.getSpace(this.anchorPoint.ySpace) == 2;
            if (flag) {
                Rectangle c = this.container.getDataBoundingBox();
                if (this.rotationAngle != 0.0) {
                    AffineTransform at = AffineTransform.getRotateInstance(this.rotationAngle, this.anchorScreen.x, this.anchorScreen.y);
                    gc.clip(at.createTransformedShape(c));
                } else {
                    gc.clip(c);
                }
            }
        }
        Rectangle bounds = this.boundsD.getBounds();
        int msize = (int)Math.round(Math.min(Math.abs(sz.getX()), Math.abs(sz.getY())));
        int edgeWeight = Markers.isBold((int)this.symbol) ? 2 : 0;
        int edgeSize = MarkerAnno.getMarkerEdgeWidth(msize, edgeWeight);
        Markers.draw((Graphics)gc, (Color)this.markerColor, (Color)this.markerColor, (int)this.symbol, (int)msize, (int)((int)Math.round(this.anchorScreen.x)), (int)((int)Math.round(this.anchorScreen.y)), (boolean)false, (int)edgeWeight, (int)edgeSize);
        this.region.reset();
        this.region.append(bounds, false);
        this.drawText(gc, bounds);
        if (this.textBounds != null && this.textAnchor != 0) {
            this.region.append(this.textBounds, false);
        }
        if (this.rotationAngle != 0.0) {
            AffineTransform at = AffineTransform.getRotateInstance(-this.rotationAngle, this.anchorScreen.x, this.anchorScreen.y);
            this.region.transform(at);
            this.textBounds = at.createTransformedShape(this.textBounds);
        }
        gc.dispose();
    }

    public void subpixelPaint(Graphics2D g) {
        if (this.anchorPoint.x == null || this.anchorPoint.y == null) {
            return;
        }
        Point2D.Double sz = this.container.getScreenSize(this.size, this.linearScaleFactor);
        if (sz == null) {
            return;
        }
        this.anchorScreen = this.container.getScreenPoint(this.anchorPoint, this.dataDPIScaleFactor);
        if (this.anchorScreen == null) {
            return;
        }
        Point pt = MarkerAnno.getPoint(this.anchorScreen);
        Point szPt = MarkerAnno.getPoint(sz);
        boolean bl = this.badData = pt.x == Integer.MIN_VALUE || pt.y == Integer.MIN_VALUE || szPt.x == Integer.MIN_VALUE || szPt.y == Integer.MIN_VALUE;
        if (this.badData) {
            return;
        }
        Graphics2D gc = (Graphics2D)g.create();
        if (this.antialias) {
            gc.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            gc.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        if (this.antialiasText) {
            gc.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else {
            gc.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
        gc.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        double width = sz.getX();
        double height = sz.getY();
        double xo = this.anchorScreen.getX() - width / 2.0;
        double yo = this.anchorScreen.getY() - height / 2.0;
        if (width < 0.0) {
            xo -= (width *= -1.0);
        }
        if (height < 0.0) {
            yo -= (height *= -1.0);
        }
        this.boundsD = new Rectangle2D.Double(xo, yo, width, height);
        if (this.rotationAngle != 0.0) {
            gc.rotate(-this.rotationAngle, this.anchorScreen.getX(), this.anchorScreen.getY());
        }
        if (this.transparency != 0.0) {
            gc.setComposite(AlphaComposite.getInstance(3, (float)(1.0 - this.transparency)));
        }
        if (this.clip) {
            boolean flag;
            boolean bl2 = flag = Constants.getSpace(this.anchorPoint.xSpace) == 2 && Constants.getSpace(this.anchorPoint.ySpace) == 2;
            if (flag) {
                Rectangle c = this.container.getDataBoundingBox();
                if (this.rotationAngle != 0.0) {
                    AffineTransform at = AffineTransform.getRotateInstance(this.rotationAngle, this.anchorScreen.getX(), this.anchorScreen.getY());
                    gc.clip(at.createTransformedShape(c));
                } else {
                    gc.clip(c);
                }
            }
        }
        double msize = Math.min(Math.abs(width), Math.abs(height));
        int edgeWeight = Markers.isBold((int)this.symbol) ? 2 : 0;
        int edgeSize = MarkerAnno.getMarkerEdgeWidth(msize, edgeWeight);
        Markers.draw((Graphics)gc, (Color)this.markerColor, (Color)this.markerColor, (int)this.symbol, (double)msize, (double)this.anchorScreen.getX(), (double)this.anchorScreen.getY(), (boolean)false, (int)edgeWeight, (int)edgeSize, (boolean)true, null);
        this.region.reset();
        this.region.append(this.boundsD, false);
        this.drawText(gc, this.boundsD);
        if (this.textBounds != null && this.textAnchor != 0) {
            this.region.append(this.textBounds, false);
        }
        if (this.rotationAngle != 0.0) {
            AffineTransform at = AffineTransform.getRotateInstance(-this.rotationAngle, this.anchorScreen.getX(), this.anchorScreen.getY());
            this.region.transform(at);
            this.textBounds = at.createTransformedShape(this.textBounds);
        }
        gc.dispose();
    }

    @Override
    public boolean isInDataSpace() {
        return Constants.getSpace(this.anchorPoint.xSpace) == 2 && Constants.getSpace(this.anchorPoint.ySpace) == 2;
    }

    @Override
    public Shape[] getHandles() {
        if (this.anchorScreen == null || this.boundsD == null) {
            return new GeneralPath[0];
        }
        AffineTransform at = AffineTransform.getRotateInstance(-this.rotationAngle, this.anchorScreen.x, this.anchorScreen.y);
        Shape[] handles = new GeneralPath[9];
        Ellipse2D.Double ee = new Ellipse2D.Double(this.boundsD.x + this.boundsD.width / 2.0 - 4.0, this.boundsD.y - 24.0, 8.0, 8.0);
        Line2D.Double ll = new Line2D.Double(this.boundsD.x + this.boundsD.width / 2.0, this.boundsD.y - 16.0, this.boundsD.x + this.boundsD.width / 2.0, this.boundsD.y + this.boundsD.height / 2.0);
        handles[0] = new GeneralPath();
        handles[0].append(ee.getPathIterator(at), false);
        handles[0].append(ll.getPathIterator(at), false);
        ee = new Ellipse2D.Double(this.boundsD.x - 4.0, this.boundsD.y - 4.0, 8.0, 8.0);
        handles[5] = new GeneralPath(ee);
        ee = new Ellipse2D.Double(this.boundsD.x + this.boundsD.width - 4.0, this.boundsD.y - 4.0, 8.0, 8.0);
        handles[8] = new GeneralPath(ee);
        ee = new Ellipse2D.Double(this.boundsD.x - 4.0, this.boundsD.y + this.boundsD.height - 4.0, 8.0, 8.0);
        handles[6] = new GeneralPath(ee);
        ee = new Ellipse2D.Double(this.boundsD.x + this.boundsD.width - 4.0, this.boundsD.y + this.boundsD.height - 4.0, 8.0, 8.0);
        handles[7] = new GeneralPath(ee);
        handles[3] = new GeneralPath();
        handles[2] = new GeneralPath();
        handles[1] = new GeneralPath();
        handles[4] = new GeneralPath();
        return handles;
    }

    public static int getMarkerEdgeWidth(double size, int weight) {
        double width;
        double ratio = size / 7.0;
        if (weight == 2) {
            double power = 0.7;
            double minWidth = 2.0;
            width = ratio <= 2.0 ? minWidth : minWidth + Math.pow(ratio - 2.0, power);
        } else if (weight == 1) {
            double power = 0.65;
            double minWidth = 1.0;
            width = ratio <= 2.0 ? minWidth : minWidth + Math.pow(ratio - 2.0, power);
        } else {
            double power = 0.5;
            double minWidth = 1.0;
            width = ratio <= 3.0 ? minWidth : minWidth + Math.pow(ratio - 3.0, power);
        }
        return (int)width;
    }

    @Override
    protected Shape drawText(Graphics2D gc, Rectangle bounds) {
        this.textBounds = null;
        this.lbm = null;
        if (this.label != null && this.label.length() > 0) {
            this.as = new AttributedString(this.label);
            if (this.font != null) {
                this.as.addAttribute(TextAttribute.FONT, this.font);
            }
            if (this.textColor != null) {
                this.as.addAttribute(TextAttribute.FOREGROUND, this.textColor);
            }
            this.lbm = new LineBreakMeasurer(this.as.getIterator(), gc.getFontRenderContext());
            this.lbm.setPosition(0);
            float width = bounds.width;
            float height = bounds.height;
            switch (this.textAnchor) {
                default: {
                    TextLayout tl = this.lbm.nextLayout(2.1474836E9f);
                    height = tl.getAscent() + tl.getDescent();
                    float vspace = 0.2f * height;
                    width = tl.getVisibleAdvance();
                    float xo = (float)(bounds.x + bounds.width / 2) - width / 2.0f;
                    float yo = this.textAnchor == 0 ? (float)(bounds.y + bounds.height / 2) - height / 2.0f + tl.getAscent() : (this.textAnchor == 3 ? (float)bounds.y - height - vspace + tl.getAscent() : (float)(bounds.y + bounds.height) + vspace + tl.getAscent());
                    this.textBounds = new Rectangle((int)(xo - vspace), (int)(yo - tl.getAscent() - vspace), (int)(width + 2.0f * vspace), (int)(height + 2.0f * vspace));
                    AttributedCharacterIterator iter = this.as.getIterator(attributes);
                    gc.setFont((Font)iter.getAttribute(TextAttribute.FONT));
                    gc.setColor((Color)iter.getAttribute(TextAttribute.FOREGROUND));
                    gc.drawString(iter, xo, yo);
                    this.textAngle = 0.0;
                    break;
                }
                case 1: {
                    TextLayout tl = this.lbm.nextLayout(2.1474836E9f);
                    height = tl.getAscent() + tl.getDescent();
                    float vspace = 0.2f * height;
                    width = tl.getVisibleAdvance();
                    float xo = (float)bounds.x - tl.getDescent() - vspace;
                    float yo = (float)(bounds.y + bounds.height / 2) + width / 2.0f;
                    this.textBounds = new Rectangle((int)((float)bounds.x - height), (int)(yo - width - vspace), (int)(height + 2.0f * vspace), (int)(width + 2.0f * vspace));
                    gc.rotate(-1.5707963267948966, xo, yo);
                    AttributedCharacterIterator iter = this.as.getIterator(attributes);
                    gc.setFont((Font)iter.getAttribute(TextAttribute.FONT));
                    gc.setColor((Color)iter.getAttribute(TextAttribute.FOREGROUND));
                    gc.drawString(iter, xo, yo);
                    gc.rotate(1.5707963267948966, xo, yo);
                    this.textAngle = -1.5707963267948966;
                    break;
                }
                case 2: {
                    TextLayout tl = this.lbm.nextLayout(2.1474836E9f);
                    height = tl.getAscent() + tl.getDescent();
                    float vspace = 0.2f * height;
                    width = tl.getVisibleAdvance();
                    float xo = (float)(bounds.x + bounds.width) + tl.getAscent() + vspace;
                    float yo = (float)(bounds.y + bounds.height / 2) + width / 2.0f;
                    this.textBounds = new Rectangle(bounds.x + bounds.width, (int)(yo - width - vspace), (int)(height + 2.0f * vspace), (int)(width + 2.0f * vspace));
                    gc.rotate(-1.5707963267948966, xo, yo);
                    AttributedCharacterIterator iter = this.as.getIterator(attributes);
                    gc.setFont((Font)iter.getAttribute(TextAttribute.FONT));
                    gc.setColor((Color)iter.getAttribute(TextAttribute.FOREGROUND));
                    gc.drawString(iter, xo, yo);
                    gc.rotate(1.5707963267948966, xo, yo);
                    this.textAngle = -1.5707963267948966;
                    break;
                }
            }
        } else {
            this.textBounds = null;
            this.textAngle = 0.0;
        }
        return this.textBounds;
    }

    @Override
    protected Shape drawText(Graphics2D gc, Rectangle2D bounds) {
        this.textBounds = null;
        this.lbm = null;
        if (this.label != null && this.label.length() > 0) {
            this.as = new AttributedString(this.label);
            if (this.font != null) {
                this.as.addAttribute(TextAttribute.FONT, this.font);
            }
            if (this.textColor != null) {
                this.as.addAttribute(TextAttribute.FOREGROUND, this.textColor);
            }
            this.lbm = new LineBreakMeasurer(this.as.getIterator(), gc.getFontRenderContext());
            this.lbm.setPosition(0);
            float width = (float)bounds.getWidth();
            float height = (float)bounds.getHeight();
            switch (this.textAnchor) {
                default: {
                    TextLayout tl = this.lbm.nextLayout(2.1474836E9f);
                    height = tl.getAscent() + tl.getDescent();
                    float vspace = 0.2f * height;
                    width = tl.getVisibleAdvance();
                    float xo = (float)(bounds.getX() + bounds.getWidth() * 0.5 - (double)width * 0.5);
                    float yo = this.textAnchor == 0 ? (float)(bounds.getY() + bounds.getHeight() * 0.5 - (double)(height / 2.0f)) + tl.getAscent() : (this.textAnchor == 3 ? (float)bounds.getY() - height - vspace + tl.getAscent() : (float)(bounds.getY() + bounds.getHeight()) + vspace + tl.getAscent());
                    this.textBounds = new Rectangle((int)(xo - vspace), (int)(yo - tl.getAscent() - vspace), (int)(width + 2.0f * vspace), (int)(height + 2.0f * vspace));
                    AttributedCharacterIterator iter = this.as.getIterator(attributes);
                    gc.setFont((Font)iter.getAttribute(TextAttribute.FONT));
                    gc.setColor((Color)iter.getAttribute(TextAttribute.FOREGROUND));
                    gc.drawString(iter, xo, yo);
                    this.textAngle = 0.0;
                    break;
                }
                case 1: {
                    TextLayout tl = this.lbm.nextLayout(2.1474836E9f);
                    height = tl.getAscent() + tl.getDescent();
                    float vspace = 0.2f * height;
                    width = tl.getVisibleAdvance();
                    float xo = (float)bounds.getX() - tl.getDescent() - vspace;
                    float yo = (float)(bounds.getY() + bounds.getHeight() / 2.0) + width / 2.0f;
                    this.textBounds = new Rectangle2D.Double(bounds.getX() - (double)height, yo - width - vspace, height + 2.0f * vspace, width + 2.0f * vspace);
                    gc.rotate(-1.5707963267948966, xo, yo);
                    AttributedCharacterIterator iter = this.as.getIterator(attributes);
                    gc.setFont((Font)iter.getAttribute(TextAttribute.FONT));
                    gc.setColor((Color)iter.getAttribute(TextAttribute.FOREGROUND));
                    gc.drawString(iter, xo, yo);
                    gc.rotate(1.5707963267948966, xo, yo);
                    this.textAngle = -1.5707963267948966;
                    break;
                }
                case 2: {
                    TextLayout tl = this.lbm.nextLayout(2.1474836E9f);
                    height = tl.getAscent() + tl.getDescent();
                    float vspace = 0.2f * height;
                    width = tl.getVisibleAdvance();
                    float xo = (float)(bounds.getX() + bounds.getWidth()) + tl.getAscent() + vspace;
                    float yo = (float)(bounds.getY() + bounds.getHeight() / 2.0) + width / 2.0f;
                    this.textBounds = new Rectangle2D.Double(bounds.getX() + bounds.getWidth(), yo - width - vspace, height + 2.0f * vspace, width + 2.0f * vspace);
                    gc.rotate(-1.5707963267948966, xo, yo);
                    AttributedCharacterIterator iter = this.as.getIterator(attributes);
                    gc.setFont((Font)iter.getAttribute(TextAttribute.FONT));
                    gc.setColor((Color)iter.getAttribute(TextAttribute.FOREGROUND));
                    gc.drawString(iter, xo, yo);
                    gc.rotate(1.5707963267948966, xo, yo);
                    this.textAngle = -1.5707963267948966;
                    break;
                }
            }
        } else {
            this.textBounds = null;
            this.textAngle = 0.0;
        }
        return this.textBounds;
    }

    @Override
    public void drawText(Graphics2D gc, boolean redraw, Color c, int caret) {
        if (this.lbm == null) {
            return;
        }
        Rectangle2D.Double bounds = this.flipIfNeeded(this.boundsD);
        if (redraw && c != null) {
            this.as.addAttribute(TextAttribute.FOREGROUND, c);
            this.lbm = new LineBreakMeasurer(this.as.getIterator(), gc.getFontRenderContext());
        }
        this.lbm.setPosition(0);
        float width = (float)bounds.width;
        float height = (float)bounds.height;
        switch (this.textAnchor) {
            default: {
                TextLayout tl = this.lbm.nextLayout(2.1474836E9f);
                height = tl.getAscent() + tl.getDescent();
                float vspace = 0.2f * height;
                width = tl.getVisibleAdvance();
                float xo = (float)(bounds.x + bounds.width / 2.0 - (double)(width / 2.0f));
                float yo = this.textAnchor == 0 ? (float)(bounds.y + bounds.height / 2.0 - (double)(height / 2.0f) + (double)tl.getAscent()) : (this.textAnchor == 3 ? (float)(bounds.y - (double)height - (double)vspace + (double)tl.getAscent()) : (float)(bounds.y + bounds.height + (double)vspace + (double)tl.getAscent()));
                if (redraw) {
                    AttributedCharacterIterator iter = this.as.getIterator(attributes);
                    gc.setFont((Font)iter.getAttribute(TextAttribute.FONT));
                    gc.setColor((Color)iter.getAttribute(TextAttribute.FOREGROUND));
                    gc.drawString(iter, xo, yo);
                }
                if (redraw) {
                    tl.draw(gc, xo, yo);
                }
                if (caret == -1) break;
                this.drawCaret(gc, caret, xo, yo, tl);
                break;
            }
            case 1: {
                TextLayout tl = this.lbm.nextLayout(2.1474836E9f);
                height = tl.getAscent() + tl.getDescent();
                float vspace = 0.2f * height;
                width = tl.getVisibleAdvance();
                float xo = (float)(bounds.x - (double)tl.getDescent() - (double)vspace);
                float yo = (float)(bounds.y + bounds.height / 2.0 + (double)(width / 2.0f));
                gc.rotate(-1.5707963267948966, xo, yo);
                if (redraw) {
                    AttributedCharacterIterator iter = this.as.getIterator(attributes);
                    gc.setFont((Font)iter.getAttribute(TextAttribute.FONT));
                    gc.setColor((Color)iter.getAttribute(TextAttribute.FOREGROUND));
                    gc.drawString(iter, xo, yo);
                }
                if (caret != -1) {
                    this.drawCaret(gc, caret, xo, yo, tl);
                }
                gc.rotate(1.5707963267948966, xo, yo);
                break;
            }
            case 2: {
                TextLayout tl = this.lbm.nextLayout(2.1474836E9f);
                height = tl.getAscent() + tl.getDescent();
                float vspace = 0.2f * height;
                width = tl.getVisibleAdvance();
                float xo = (float)(bounds.x + bounds.width + (double)tl.getAscent() + (double)vspace);
                float yo = (float)(bounds.y + bounds.height / 2.0 + (double)(width / 2.0f));
                gc.rotate(-1.5707963267948966, xo, yo);
                if (redraw) {
                    AttributedCharacterIterator iter = this.as.getIterator(attributes);
                    gc.setFont((Font)iter.getAttribute(TextAttribute.FONT));
                    gc.setColor((Color)iter.getAttribute(TextAttribute.FOREGROUND));
                    gc.drawString(iter, xo, yo);
                }
                if (caret != -1) {
                    this.drawCaret(gc, caret, xo, yo, tl);
                }
                gc.rotate(1.5707963267948966, xo, yo);
            }
        }
        if (c != null) {
            this.as.addAttribute(TextAttribute.FOREGROUND, this.textColor);
            this.lbm = new LineBreakMeasurer(this.as.getIterator(), gc.getFontRenderContext());
        }
    }

    @Override
    public void resetAdjusters() {
        super.resetAdjusters();
        if (this.size.height < 0.0) {
            this.size.height *= -1.0;
        }
    }
}

