/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.util;

import com.sas.codepolicy.SASScope;
import java.rmi.dgc.VMID;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimerTask;

@SASScope
public class UniTimer {
    private static final int TASKLIST_INIT = 20;
    private static final int MINIMUM_WAIT = 100;
    private static UniTimer instance = new UniTimer();
    private TimerThread thread;
    private List taskList = new ArrayList(20);
    private Object monitor = new Object();

    public static UniTimer getInstance() {
        return instance;
    }

    private UniTimer() {
        this.thread = new TimerThread();
    }

    public String schedule(TimerTask task, Date time) {
        if (task == null) {
            throw new IllegalArgumentException();
        }
        if (time == null) {
            throw new IllegalArgumentException();
        }
        TimerElement te = new TimerElement(task, time);
        this.addScheduledTask(te);
        return te.getId();
    }

    public String schedule(TimerTask task, Date time, long interval) {
        if (task == null) {
            throw new IllegalArgumentException();
        }
        if (time == null) {
            throw new IllegalArgumentException();
        }
        TimerElement te = new TimerElement(task, time, interval);
        this.addScheduledTask(te);
        return te.getId();
    }

    public String schedule(TimerTask task, long delay) {
        if (task == null) {
            throw new IllegalArgumentException();
        }
        TimerElement te = new TimerElement(task, delay);
        this.addScheduledTask(te);
        return te.getId();
    }

    public String schedule(TimerTask task, long delay, long interval) {
        if (task == null) {
            throw new IllegalArgumentException();
        }
        TimerElement te = new TimerElement(task, delay, interval);
        this.addScheduledTask(te);
        return te.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelTask(String id) {
        if (id == null) {
            return;
        }
        Object object = this.monitor;
        synchronized (object) {
            for (int i = 0; i < this.taskList.size(); ++i) {
                TimerElement te = (TimerElement)this.taskList.get(i);
                if (!te.getId().equals(id)) continue;
                this.taskList.remove(i);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAll() {
        this.thread.cancel();
        Object object = this.monitor;
        synchronized (object) {
            this.thread.interrupt();
            this.taskList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addScheduledTask(TimerElement te) {
        if (this.thread.isCancelled()) {
            this.thread.uncancel();
        }
        Object object = this.monitor;
        synchronized (object) {
            long nextTime = te.getNextTime();
            if (this.taskList.size() == 0) {
                this.taskList.add(te);
                this.monitor.notifyAll();
            } else {
                for (int i = 0; i < this.taskList.size(); ++i) {
                    TimerElement nextElement = (TimerElement)this.taskList.get(i);
                    long nextNextTime = nextElement.getNextTime();
                    if (nextTime >= nextNextTime) continue;
                    this.taskList.add(i, te);
                    if (i == 0) {
                        this.monitor.notifyAll();
                    }
                    return;
                }
                this.taskList.add(te);
            }
        }
        if (!this.thread.isAlive()) {
            this.thread.start();
        }
    }

    @SASScope
    private class TimerElement {
        private TimerTask task;
        private String id = new VMID().toString();
        private long interval;
        private long nextTime;

        TimerElement(TimerTask task, Date start) {
            this.task = task;
            this.interval = -1L;
            this.nextTime = start.getTime();
        }

        TimerElement(TimerTask task, Date start, long interval) {
            this.task = task;
            this.interval = interval;
            this.nextTime = start.getTime();
        }

        TimerElement(TimerTask task, long delay) {
            this.task = task;
            this.interval = -1L;
            this.nextTime = System.currentTimeMillis() + delay;
        }

        TimerElement(TimerTask task, long delay, long interval) {
            this.task = task;
            this.interval = interval;
            this.nextTime = System.currentTimeMillis() + delay;
        }

        public final long getNextTime() {
            return this.nextTime;
        }

        public final long reschedule() {
            if (this.interval < 0L) {
                throw new RuntimeException();
            }
            this.nextTime = System.currentTimeMillis() + this.interval;
            return this.nextTime;
        }

        public final long getInterval() {
            return this.interval;
        }

        public final TimerTask getTask() {
            return this.task;
        }

        public final String getId() {
            return this.id;
        }
    }

    @SASScope
    private class TimerThread
    extends Thread {
        private boolean cancelled = false;

        TimerThread() {
            this.setName("UniTimer runner");
            this.setDaemon(true);
        }

        public final boolean isCancelled() {
            return this.cancelled;
        }

        public void cancel() {
            this.cancelled = true;
        }

        public void uncancel() {
            this.cancelled = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.isCancelled()) {
                Object object;
                if (UniTimer.this.taskList.size() > 0) {
                    object = UniTimer.this.monitor;
                    synchronized (object) {
                        TimerElement te = (TimerElement)UniTimer.this.taskList.get(0);
                        long time = te.getNextTime();
                        while (time <= System.currentTimeMillis()) {
                            if (this.isCancelled()) {
                                return;
                            }
                            UniTimer.this.taskList.remove(0);
                            TimerTask task = te.getTask();
                            task.run();
                            long interval = te.getInterval();
                            if (interval > 0L) {
                                interval = te.reschedule();
                                UniTimer.this.addScheduledTask(te);
                            }
                            if (UniTimer.this.taskList.size() > 0) {
                                te = (TimerElement)UniTimer.this.taskList.get(0);
                                time = te.getNextTime();
                                continue;
                            }
                            time = System.currentTimeMillis() + 100L;
                        }
                    }
                }
                try {
                    if (this.isCancelled()) {
                        return;
                    }
                    object = UniTimer.this.monitor;
                    synchronized (object) {
                        long waitTime = 0L;
                        if (UniTimer.this.taskList.size() <= 0) {
                            return;
                        }
                        TimerElement te = (TimerElement)UniTimer.this.taskList.get(0);
                        long time = te.getNextTime();
                        waitTime = time - System.currentTimeMillis();
                        if (waitTime < 0L) {
                            waitTime = 100L;
                        }
                        UniTimer.this.monitor.wait(waitTime);
                    }
                }
                catch (InterruptedException iex) {
                    return;
                }
            }
            return;
        }
    }
}

