/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.util;

import com.sas.codepolicy.SASScope;
import com.sas.services.util.RemoteMBeanProxyException;
import java.io.IOException;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.security.auth.Subject;

@SASScope
public class RemoteMBeanProxy
implements DynamicMBean,
NotificationEmitter,
MBeanRegistration {
    private final ObjectName objectName;
    private final JMXConnector connector;
    private final MBeanServerConnection connection;

    public RemoteMBeanProxy(ObjectName objectName, JMXServiceURL url, Map map, Subject subject) throws IOException {
        this(objectName, JMXConnectorFactory.newJMXConnector(url, map), map, subject);
    }

    public RemoteMBeanProxy(ObjectName objectName, JMXConnector connector, Map map, Subject subject) throws IOException {
        this.objectName = objectName;
        this.connector = connector;
        this.connector.connect(map);
        this.connection = connector.getMBeanServerConnection(subject);
    }

    public RemoteMBeanProxy(ObjectName objectName, MBeanServerConnection connection) {
        this.objectName = objectName;
        this.connector = null;
        this.connection = connection;
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
        JMXConnector cntor = this.getJMXConnector();
        if (cntor != null) {
            cntor.close();
        }
    }

    @Override
    public void postDeregister() {
    }

    protected ObjectName getObjectName() {
        return this.objectName;
    }

    protected MBeanServerConnection getMBeanServerConnection() {
        return this.connection;
    }

    protected JMXConnector getJMXConnector() {
        return this.connector;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        try {
            return this.getMBeanServerConnection().getMBeanInfo(this.getObjectName());
        }
        catch (Exception e) {
            throw new RemoteMBeanProxyException(e);
        }
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        try {
            return this.getMBeanServerConnection().getAttribute(this.getObjectName(), attribute);
        }
        catch (InstanceNotFoundException e) {
            throw new RemoteMBeanProxyException(e);
        }
        catch (IOException e) {
            throw new RemoteMBeanProxyException(e);
        }
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        try {
            this.getMBeanServerConnection().setAttribute(this.getObjectName(), attribute);
        }
        catch (InstanceNotFoundException e) {
            throw new RemoteMBeanProxyException(e);
        }
        catch (IOException e) {
            throw new RemoteMBeanProxyException(e);
        }
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        try {
            return this.getMBeanServerConnection().getAttributes(this.getObjectName(), attributes);
        }
        catch (InstanceNotFoundException e) {
            throw new RemoteMBeanProxyException(e);
        }
        catch (ReflectionException e) {
            throw new RemoteMBeanProxyException(e);
        }
        catch (IOException e) {
            throw new RemoteMBeanProxyException(e);
        }
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        try {
            return this.getMBeanServerConnection().setAttributes(this.getObjectName(), attributes);
        }
        catch (InstanceNotFoundException e) {
            throw new RemoteMBeanProxyException(e);
        }
        catch (ReflectionException e) {
            throw new RemoteMBeanProxyException(e);
        }
        catch (IOException e) {
            throw new RemoteMBeanProxyException(e);
        }
    }

    @Override
    public Object invoke(String method, Object[] arguments, String[] params) throws MBeanException, ReflectionException {
        try {
            return this.getMBeanServerConnection().invoke(this.getObjectName(), method, arguments, params);
        }
        catch (InstanceNotFoundException e) {
            throw new RemoteMBeanProxyException(e);
        }
        catch (IOException e) {
            throw new RemoteMBeanProxyException(e);
        }
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return this.getMBeanInfo().getNotifications();
    }

    @Override
    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        try {
            this.getMBeanServerConnection().addNotificationListener(this.getObjectName(), listener, filter, handback);
        }
        catch (InstanceNotFoundException e) {
            throw new RemoteMBeanProxyException(e);
        }
        catch (IOException e) {
            throw new RemoteMBeanProxyException(e);
        }
    }

    @Override
    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        try {
            this.getMBeanServerConnection().removeNotificationListener(this.getObjectName(), listener);
        }
        catch (InstanceNotFoundException e) {
            throw new RemoteMBeanProxyException(e);
        }
        catch (IOException e) {
            throw new RemoteMBeanProxyException(e);
        }
    }

    @Override
    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        try {
            this.getMBeanServerConnection().removeNotificationListener(this.getObjectName(), listener, filter, handback);
        }
        catch (InstanceNotFoundException e) {
            throw new RemoteMBeanProxyException(e);
        }
        catch (IOException e) {
            throw new RemoteMBeanProxyException(e);
        }
    }
}

