/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.util;

import com.sas.codepolicy.SASScope;
import com.sas.services.ServiceException;
import com.sas.services.user.UserContext;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserInitializationException;
import com.sas.services.user.UserServiceInterface;
import com.sas.services.util.RB;
import java.io.InterruptedIOException;
import java.lang.ref.WeakReference;
import java.nio.channels.ClosedByInterruptException;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Timer;
import java.util.TimerTask;

@SASScope
public final class NewUserWrapper {
    private static WeakReference _timerRef;
    private UserContext _privUser;
    private String _uid;
    private String _password;
    private String _domain;
    private String _clientSource;
    private String _appSource;
    private int _methodID;
    private Thread _thread;
    private int[] _threadLock = new int[0];
    private boolean _interrupted;

    private NewUserWrapper() {
    }

    public static NewUserWrapper createWrapper(String clientSource, String appSource) {
        NewUserWrapper wrapper = new NewUserWrapper();
        wrapper._methodID = 0;
        wrapper._clientSource = clientSource;
        wrapper._appSource = appSource;
        return wrapper;
    }

    public static NewUserWrapper createWrapper(String uid, String password, String domain) {
        NewUserWrapper wrapper = new NewUserWrapper();
        wrapper._methodID = 1;
        wrapper._uid = uid;
        wrapper._password = password;
        wrapper._domain = domain;
        return wrapper;
    }

    public static NewUserWrapper createWrapper(String uid, String password, String domain, String clientSource, String appSource) {
        NewUserWrapper wrapper = new NewUserWrapper();
        wrapper._methodID = 2;
        wrapper._uid = uid;
        wrapper._password = password;
        wrapper._domain = domain;
        wrapper._clientSource = clientSource;
        wrapper._appSource = appSource;
        return wrapper;
    }

    public static NewUserWrapper createWrapper(UserContext privUser, String uid, String password, String domain) {
        NewUserWrapper wrapper = new NewUserWrapper();
        wrapper._methodID = 3;
        wrapper._uid = uid;
        wrapper._password = password;
        wrapper._domain = domain;
        return wrapper;
    }

    public static NewUserWrapper createWrapper(UserContext privUser, String uid, String password, String domain, String clientSource, String appSource) {
        NewUserWrapper wrapper = new NewUserWrapper();
        wrapper._methodID = 4;
        wrapper._uid = uid;
        wrapper._password = password;
        wrapper._domain = domain;
        wrapper._clientSource = clientSource;
        wrapper._appSource = appSource;
        return wrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized UserContextInterface invoke(UserServiceInterface userService, long timeout) throws InterruptedException, RemoteException, ServiceException, UserInitializationException {
        int[] nArray;
        if (timeout < 0L) {
            throw new IllegalArgumentException();
        }
        UserContextInterface userContext = null;
        try {
            nArray = this._threadLock;
            synchronized (this._threadLock) {
                this._thread = Thread.currentThread();
                this._interrupted = false;
                // ** MonitorExit[var5_4] (shouldn't be in output)
                TimeoutHandler timeoutHandler = this.registerTimeout(timeout);
                try {
                    userContext = this.invoke(userService);
                }
                catch (ServiceException se) {
                    int[] nArray2 = this._threadLock;
                    synchronized (this._threadLock) {
                        if (this._interrupted && NewUserWrapper.isInterruptedException((Throwable)((Object)se))) {
                            String msg = timeout > 0L ? RB.getStringResource("NewUserWrapper.timedOut.ex.txt") : RB.getStringResource("NewUserWrapper.interrupted.ex.txt");
                            InterruptedException ie = new InterruptedException(msg);
                            ie.initCause((Throwable)((Object)se));
                            throw ie;
                        }
                        // ** MonitorExit[var7_7] (shouldn't be in output)
                        throw se;
                    }
                }
                finally {
                    this.unregisterTimeout(timeoutHandler);
                }
            }
        }
        finally {
            nArray = this._threadLock;
            synchronized (this._threadLock) {
                this._thread = null;
                if (this._interrupted) {
                    Thread.interrupted();
                }
                // ** MonitorExit[var5_4] (shouldn't be in output)
            }
        }
        {
            return userContext;
        }
    }

    public void interrupt() {
        PrivilegedAction action = new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                int[] nArray = NewUserWrapper.this._threadLock;
                synchronized (nArray) {
                    if (NewUserWrapper.this._thread != null) {
                        NewUserWrapper.this._thread.interrupt();
                        NewUserWrapper.this._thread = null;
                        NewUserWrapper.this._interrupted = true;
                    }
                }
                return null;
            }
        };
        AccessController.doPrivileged(action);
    }

    private UserContextInterface invoke(UserServiceInterface userService) throws RemoteException, ServiceException, UserInitializationException {
        switch (this._methodID) {
            case 0: {
                UserContextInterface userContext = userService.newUser(this._clientSource, this._appSource);
                return userContext;
            }
            case 1: {
                UserContextInterface userContext = userService.newUser(this._uid, this._password, this._domain);
                return userContext;
            }
            case 2: {
                UserContextInterface userContext = userService.newUser(this._uid, this._password, this._domain, this._clientSource, this._appSource);
                return userContext;
            }
            case 3: {
                UserContextInterface userContext = userService.newUser(this._privUser, this._uid, this._password, this._domain);
                return userContext;
            }
        }
        UserContextInterface userContext = userService.newUser(this._privUser, this._uid, this._password, this._domain, this._clientSource, this._appSource);
        return userContext;
    }

    private final TimeoutHandler registerTimeout(long timeout) {
        if (timeout == 0L) {
            return null;
        }
        TimeoutHandler timeoutHandler = new TimeoutHandler();
        Timer timer = NewUserWrapper.getTimer();
        timer.schedule((TimerTask)timeoutHandler, timeout);
        return timeoutHandler;
    }

    private void unregisterTimeout(TimeoutHandler timeoutHandler) {
        if (timeoutHandler != null) {
            timeoutHandler.cancel();
        }
    }

    private static synchronized Timer getTimer() {
        Timer timer;
        Timer timer2 = timer = _timerRef != null ? (Timer)_timerRef.get() : null;
        if (timer == null) {
            String timerName = NewUserWrapper.class.getName();
            timer = new Timer(timerName, true);
            _timerRef = new WeakReference<Timer>(timer);
        }
        return timer;
    }

    private static boolean isInterruptedException(Throwable t) {
        HashSet<Throwable> visitedSet = new HashSet<Throwable>(8);
        visitedSet.add(t);
        for (Throwable cause = t.getCause(); cause != null && visitedSet.add(cause); cause = cause.getCause()) {
            if (!(cause instanceof InterruptedException) && !(cause instanceof ClosedByInterruptException) && !(cause instanceof InterruptedIOException)) continue;
            return true;
        }
        String msg = t.getMessage();
        return msg.indexOf(InterruptedException.class.getName()) >= 0 || msg.indexOf(ClosedByInterruptException.class.getName()) >= 0 || msg.indexOf(InterruptedIOException.class.getName()) >= 0;
    }

    @SASScope
    private class TimeoutHandler
    extends TimerTask {
        private TimeoutHandler() {
        }

        @Override
        public void run() {
            NewUserWrapper.this.interrupt();
        }
    }
}

