/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.util;

import com.sas.codepolicy.SASScope;
import com.sas.services.util.GetPropertyAction;
import com.sas.services.util.RB;
import com.sas.text.Message;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.regex.PatternSyntaxException;

@SASScope
public final class JMXAgentConfiguration {
    public static final String MODE_NONE = "None";
    public static final String MODE_ALL = "All";
    public static final String MODE_SOME = "Some";
    public static final String JMX_CONFIG_FILE = "com.sas.jmx.config";
    public static final String PROPERTY_JMX_ENABLE_MODE = "com.sas.jmx.enable.mode";
    public static final String PROPERTY_ENABLED_FILE = "com.sas.jmx.enable.file";
    public static final String PROPERTY_ALIAS_FILE = "com.sas.jmx.alias.file";
    public static final String PROPERTY_CREATE_MBEAN_SERVER = "com.sas.jmx.create.mbean.server";
    public static final String PROPERTY_AGENT_ID = "com.sas.jmx.agent.id";
    public static final String PROPERTY_JMX_CONNECTOR_URL = "com.sas.jmx.connector.server";
    public static final String PROPERTY_JMX_CONNECTOR_CREDENTIALS = "com.sas.jmx.connector.credentials";
    public static final String PROPERTY_JMX_CONNECTOR_REBIND = "com.sas.jmx.connector.rebind";
    public static final String PROPERTY_JMX_CONNECTOR_AUTHENTICATOR = "com.sas.jmx.connector.authenticator";
    public static final String PROPERTY_JMX_CONNECTOR_PASSWORD_FILE = "com.sas.jmx.connector.password.file";
    public static final String PROPERTY_JMX_EXTERNAL_SERVER_URL = "com.sas.jmx.external.server";
    public static final String PROPERTY_JMX_EXTERNAL_SERVER_CREDENTIALS = "com.sas.jmx.external.server.credentials";
    public static final String PROPERTY_JMX_EXTERNAL_SERVER_CLASSPATH_FILE = "com.sas.jmx.external.server.classpath.file";
    public static final String PROPERTY_JMX_CONNECTOR_RMI_PORT = "com.sas.jmx.connector.rmi.port";
    private String _jmxEnableMode = "All";
    private Properties _jmxMBeanAliasProperties = null;
    private boolean _createMBeanServer = false;
    private String _agentID = null;
    private String _jmxConnectorURL = null;
    private String[] _jmxConnectorCredentials = null;
    private boolean _jmxConnectorRebind = false;
    private String _jmxConnectorAuthenticator = null;
    private String _jmxConnectorPasswordFile = null;
    private String _jmxExternalServerURL = null;
    private String _jmxExternalServerClasspathFile = null;
    private String[] _jmxExternalServerCredentials = null;
    private int _rmiPort = -1;

    JMXAgentConfiguration(Properties configProps, Properties enableProps, Properties aliasProps) throws IllegalArgumentException {
        this.initialize(configProps, enableProps, aliasProps);
    }

    private void initialize(Properties configProps, Properties enableProps, Properties aliasProps) throws IllegalArgumentException {
        Properties jmxConfigProperties = null;
        if (configProps != null) {
            jmxConfigProperties = configProps;
        } else {
            String configFile = AccessController.doPrivileged(new GetPropertyAction(JMX_CONFIG_FILE));
            if (configFile != null) {
                try {
                    jmxConfigProperties = new Properties();
                    jmxConfigProperties.load(new FileInputStream(configFile));
                }
                catch (FileNotFoundException e) {
                    String msg = Message.format((ResourceBundle)RB.getResources(), (String)"JMXAgentConfiguration.ConfigFileNotFound.fmt.txt", (Object)configFile);
                    throw (IllegalArgumentException)new IllegalArgumentException(msg).initCause(e);
                }
                catch (IOException e) {
                    String msg = Message.format((ResourceBundle)RB.getResources(), (String)"JMXAgentConfiguration.ConfigFileIOException.fmt.txt", (Object)configFile);
                    throw (IllegalArgumentException)new IllegalArgumentException(msg).initCause(e);
                }
            }
        }
        if (jmxConfigProperties != null && jmxConfigProperties.size() > 0) {
            String jmxEnableMode = jmxConfigProperties.getProperty(PROPERTY_JMX_ENABLE_MODE);
            if (jmxEnableMode != null) {
                this.setEnableMode(jmxEnableMode);
                if (this._jmxEnableMode.equals(MODE_SOME)) {
                    this.readEnableProperties(jmxConfigProperties, enableProps);
                }
            }
            this.readAliasProperties(jmxConfigProperties, aliasProps);
            String createMBeanServerString = jmxConfigProperties.getProperty(PROPERTY_CREATE_MBEAN_SERVER);
            if (createMBeanServerString != null) {
                this._createMBeanServer = Boolean.valueOf(createMBeanServerString);
            }
            if (!this._createMBeanServer) {
                this._agentID = jmxConfigProperties.getProperty(PROPERTY_AGENT_ID);
            } else {
                String credentialsString;
                this._jmxConnectorURL = jmxConfigProperties.getProperty(PROPERTY_JMX_CONNECTOR_URL);
                if (null != this._jmxConnectorURL) {
                    String rebindString = jmxConfigProperties.getProperty(PROPERTY_JMX_CONNECTOR_REBIND);
                    this._jmxConnectorRebind = Boolean.valueOf(rebindString);
                    this._jmxConnectorAuthenticator = jmxConfigProperties.getProperty(PROPERTY_JMX_CONNECTOR_AUTHENTICATOR);
                    this._jmxConnectorPasswordFile = jmxConfigProperties.getProperty(PROPERTY_JMX_CONNECTOR_PASSWORD_FILE);
                    String credentialsString2 = jmxConfigProperties.getProperty(PROPERTY_JMX_CONNECTOR_CREDENTIALS);
                    if (null != credentialsString2) {
                        this._jmxConnectorCredentials = this.parseCredentials(credentialsString2);
                    }
                }
                this._jmxExternalServerURL = jmxConfigProperties.getProperty(PROPERTY_JMX_EXTERNAL_SERVER_URL);
                if (null != this._jmxExternalServerURL && null != (credentialsString = jmxConfigProperties.getProperty(PROPERTY_JMX_EXTERNAL_SERVER_CREDENTIALS))) {
                    this._jmxExternalServerCredentials = this.parseCredentials(credentialsString);
                }
                this._jmxExternalServerClasspathFile = jmxConfigProperties.getProperty(PROPERTY_JMX_EXTERNAL_SERVER_CLASSPATH_FILE);
                String rmiPort = jmxConfigProperties.getProperty(PROPERTY_JMX_CONNECTOR_RMI_PORT);
                if (rmiPort != null) {
                    try {
                        this._rmiPort = Integer.parseInt(rmiPort);
                    }
                    catch (NumberFormatException nfe) {
                        String msg = Message.format((ResourceBundle)RB.getResources(), (String)"JMXAgentConfiguration.InvalidRMIPortNumber.fmt.txt", (Object)rmiPort);
                        throw (IllegalArgumentException)new IllegalArgumentException(msg).initCause(nfe);
                    }
                }
            }
        }
    }

    private String[] parseCredentials(String credentialsString) {
        String[] credentials = null;
        try {
            credentials = credentialsString.split(",");
            try {
                for (int i = 0; i < credentials.length; ++i) {
                    credentials[i] = SasPasswordString.decode((String)credentials[i]);
                }
            }
            catch (SasPasswordEncodingException e) {
                String msg = RB.getStringResource("JMXAgentConfiguration.CredentialsEncodingException.ex.txt");
                throw (IllegalArgumentException)new IllegalArgumentException(msg).initCause(e);
            }
        }
        catch (PatternSyntaxException e) {
            String msg = RB.getStringResource("JMXAgentConfiguration.CredentialsSyntaxException.ex.txt");
            throw (IllegalArgumentException)new IllegalArgumentException(msg).initCause(e);
        }
        return credentials;
    }

    private void setEnableMode(String enableMode) throws IllegalArgumentException {
        if (enableMode.equalsIgnoreCase(MODE_NONE)) {
            this._jmxEnableMode = MODE_NONE;
        } else if (enableMode.equalsIgnoreCase(MODE_ALL)) {
            this._jmxEnableMode = MODE_ALL;
        } else if (enableMode.equalsIgnoreCase(MODE_SOME)) {
            this._jmxEnableMode = MODE_SOME;
        } else {
            throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"JMXAgentConfiguration.InvalidEnableMode.fmt.txt", (Object)enableMode, (Object)MODE_ALL));
        }
    }

    private void readEnableProperties(Properties jmxConfiguration, Properties enableProps) throws IllegalArgumentException {
        String jmxEnableFile = null;
        if (enableProps != null) {
            this._jmxMBeanAliasProperties = enableProps;
        } else {
            jmxEnableFile = jmxConfiguration.getProperty(PROPERTY_ENABLED_FILE);
            if (jmxEnableFile != null) {
                if (this._jmxMBeanAliasProperties == null) {
                    this._jmxMBeanAliasProperties = new Properties();
                }
                try {
                    this._jmxMBeanAliasProperties.load(new FileInputStream(jmxEnableFile));
                }
                catch (FileNotFoundException e) {
                    String msg = Message.format((ResourceBundle)RB.getResources(), (String)"JMXAgentConfiguration.EnableFileNotFound.fmt.txt", (Object)jmxEnableFile);
                    throw (IllegalArgumentException)new IllegalArgumentException(msg).initCause(e);
                }
                catch (IOException e) {
                    String msg = Message.format((ResourceBundle)RB.getResources(), (String)"JMXAgentConfiguration.EnableFileIOException.fmt.txt", (Object)jmxEnableFile);
                    throw (IllegalArgumentException)new IllegalArgumentException(msg).initCause(e);
                }
            }
        }
        if (this._jmxMBeanAliasProperties == null && this._jmxEnableMode.equals(MODE_SOME)) {
            if (jmxEnableFile != null) {
                throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"JMXAgentConfiguration.MustSpecifyEnableFile.fmt.txt", (Object)PROPERTY_ENABLED_FILE));
            }
            throw new IllegalArgumentException(RB.getStringResource("JMXAgentConfiguration.MustSpecifyEnableProperties.txt"));
        }
    }

    private void readAliasProperties(Properties jmxConfiguration, Properties aliasProps) throws IllegalArgumentException {
        Properties tempProperties = null;
        if (aliasProps != null) {
            tempProperties = aliasProps;
        } else {
            String jmxAliasFile = jmxConfiguration.getProperty(PROPERTY_ALIAS_FILE);
            if (jmxAliasFile != null) {
                try {
                    tempProperties = new Properties();
                    tempProperties.load(new FileInputStream(jmxAliasFile));
                }
                catch (FileNotFoundException e) {
                    String msg = Message.format((ResourceBundle)RB.getResources(), (String)"JMXAgentConfiguration.AliasFileNotFound.fmt.txt", (Object)jmxAliasFile);
                    throw (IllegalArgumentException)new IllegalArgumentException(msg).initCause(e);
                }
                catch (IOException e) {
                    String msg = Message.format((ResourceBundle)RB.getResources(), (String)"JMXAgentConfiguration.AliasFileIOException.fmt.txt", (Object)jmxAliasFile);
                    throw (IllegalArgumentException)new IllegalArgumentException(msg).initCause(e);
                }
            }
        }
        if (tempProperties != null) {
            if (this._jmxEnableMode != MODE_SOME) {
                this._jmxMBeanAliasProperties = tempProperties;
            } else {
                if (this._jmxMBeanAliasProperties == null) {
                    this._jmxMBeanAliasProperties = new Properties();
                }
                Enumeration<?> aliasNames = tempProperties.propertyNames();
                while (aliasNames.hasMoreElements()) {
                    String key = (String)aliasNames.nextElement();
                    if (this._jmxMBeanAliasProperties.getProperty(key) == null) continue;
                    String value = tempProperties.getProperty(key);
                    this._jmxMBeanAliasProperties.setProperty(key, value);
                }
            }
        }
    }

    boolean isCreateMBeanServer() {
        return this._createMBeanServer;
    }

    String getAgentID() {
        return this._agentID;
    }

    String getConnectorURL() {
        return this._jmxConnectorURL;
    }

    int getRMIPort() {
        return this._rmiPort;
    }

    String getExternalServerURL() {
        return this._jmxExternalServerURL;
    }

    String getEnableMode() {
        return this._jmxEnableMode;
    }

    boolean isEnabled() {
        return this.getEnableMode() != MODE_NONE;
    }

    boolean isMBeanEnabled(String mBeanName) {
        if (this._jmxEnableMode.equals(MODE_NONE)) {
            return false;
        }
        if (this._jmxEnableMode.equals(MODE_ALL)) {
            return true;
        }
        if (this._jmxMBeanAliasProperties != null) {
            if (this._jmxMBeanAliasProperties.getProperty(mBeanName) == null) {
                String stripped = mBeanName.replaceFirst("\\d+$", "");
                return this._jmxMBeanAliasProperties.getProperty(stripped) != null;
            }
            return true;
        }
        return false;
    }

    String getAliasName(String mBeanName) {
        if (this._jmxMBeanAliasProperties == null) {
            return mBeanName;
        }
        String alias = this._jmxMBeanAliasProperties.getProperty(mBeanName);
        if (alias != null && !alias.equals("")) {
            return alias;
        }
        return mBeanName;
    }

    boolean isConnectorRebind() {
        return this._jmxConnectorRebind;
    }

    String getConnectorAuthenticator() {
        return this._jmxConnectorAuthenticator;
    }

    String getConnectorPasswordFile() {
        return this._jmxConnectorPasswordFile;
    }

    String getExternalServerClasspathFile() {
        return this._jmxExternalServerClasspathFile;
    }

    String[] getExternalServerCredentials() {
        return this._jmxExternalServerCredentials;
    }

    String[] getConnectorCredentials() {
        return this._jmxConnectorCredentials;
    }
}

