/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.util;

import com.sas.codepolicy.SASScope;
import com.sas.net.ssl.SSLRMISocketFactories;
import com.sas.services.InitializationException;
import com.sas.services.ServiceException;
import com.sas.services.deployment.RMIConfiguration;
import com.sas.services.util.JMXAgentConfiguration;
import com.sas.services.util.JMXRegistration;
import com.sas.services.util.RB;
import com.sas.text.Message;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;
import javax.management.remote.JMXAuthenticator;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import javax.security.auth.Subject;

@SASScope
public class JMXAgent {
    private static JMXAgent _agent = null;
    private static JMXAgentConfiguration _config = null;
    private static boolean _isEnabled = true;
    private JMXConnectorServer _connector;
    JMXServiceURL _connectorURL;
    private String[] _connectorCredentials;
    private MBeanServer _server;
    private MBeanServerConnection _externalServer;
    private ObjectName _mLetObjectName;
    private String MLET_OBJECT_NAME = "MyLoadInjector:type=classloader";
    private boolean _createMBeanServer = true;
    private final Map<String, JMXRegistration> _registrationMap = new HashMap<String, JMXRegistration>(5);

    public static JMXAgent getInstance() {
        return JMXAgent.getInstance(null, null, null);
    }

    public static JMXAgent getInstance(Properties configProps, Properties enableProps, Properties aliasProps) {
        if (_isEnabled) {
            if (_config == null) {
                try {
                    _config = new JMXAgentConfiguration(configProps, enableProps, aliasProps);
                    _isEnabled = _config.isEnabled();
                    if (_isEnabled) {
                        _agent = new JMXAgent();
                    }
                }
                catch (IllegalArgumentException e) {
                    System.err.println(RB.getStringResource("JMXAgent.exceptionConfiguration.txt"));
                    e.printStackTrace();
                    _isEnabled = false;
                    return null;
                }
            }
            return _agent;
        }
        return null;
    }

    public static void destroy() {
        if (_agent != null) {
            _agent.stop();
            _agent = null;
        }
        _config = null;
        _isEnabled = true;
    }

    private JMXAgent() {
        if (this.isEnabled()) {
            this.initialize();
        }
    }

    private void initialize() {
        this._createMBeanServer = _config.isCreateMBeanServer();
        if (!this._createMBeanServer) {
            String agentID = _config.getAgentID();
            this._server = this.findMBeanServer(agentID);
            if (this._server == null && agentID != null) {
                throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"JMXAgent.exceptionMBeanServerNotFound.fmt.txt", (Object)_config.getAgentID()));
            }
        } else {
            this._server = MBeanServerFactory.createMBeanServer();
            if (this._server == null) {
                throw new IllegalArgumentException(RB.getStringResource("JMXAgent.exceptionCreateMBeanServer.txt"));
            }
            String externalServerURL = null;
            if (_config != null) {
                externalServerURL = _config.getExternalServerURL();
            }
            if (externalServerURL != null) {
                try {
                    String[] credentials = _config.getExternalServerCredentials();
                    this._externalServer = this.connectToExternalServer(externalServerURL, credentials);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                if (this._externalServer != null) {
                    try {
                        this.createMLet();
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                }
            }
            String connectorURL = null;
            if (_config != null) {
                connectorURL = _config.getConnectorURL();
            }
            if (connectorURL != null) {
                boolean rebind = _config.isConnectorRebind();
                String passwordFile = _config.getConnectorPasswordFile();
                String authenticator = _config.getConnectorAuthenticator();
                this._connectorCredentials = _config.getConnectorCredentials();
                this._connector = this.createConnector(connectorURL, rebind, passwordFile, authenticator, _config.getRMIPort());
            }
        }
    }

    public boolean isEnabled() {
        if (_config == null) {
            throw new IllegalStateException(RB.getStringResource("JMXAgent.exceptionConfigNull.txt"));
        }
        return _config.isEnabled();
    }

    public boolean isMBeanEnabled(String mBeanName) {
        if (_config == null) {
            throw new IllegalStateException(RB.getStringResource("JMXAgent.exceptionConfigNull.txt"));
        }
        return _config.isMBeanEnabled(mBeanName);
    }

    public JMXRegistration registerMBean(Object mBean, String mBeanName) throws IllegalArgumentException {
        return this.registerMBean(mBean, mBeanName, false);
    }

    public JMXRegistration registerMBean(Object mBean, String mBeanName, boolean rebind) throws IllegalArgumentException {
        ObjectInstance objectInstance;
        if (!this.isMBeanEnabled(mBeanName)) {
            throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"JMXAgent.mBeanNotEnabled.fmt.txt", (Object)mBeanName));
        }
        JMXRegistration jmxRegistration = new JMXRegistration();
        jmxRegistration.setRequestedMBeanName(mBeanName);
        if (null != mBeanName) {
            this.addJMXRegistration(mBeanName, jmxRegistration);
        }
        ObjectName mBeanObjectName = null;
        ObjectName returnedObjectName = null;
        if (mBeanName != null) {
            mBeanName = this.getAliasName(mBeanName);
            mBeanObjectName = this.createObjectName(mBeanName);
        }
        if (this._server != null) {
            objectInstance = this.registerWithInternalServer(mBean, mBeanName, mBeanObjectName, rebind);
            returnedObjectName = objectInstance.getObjectName();
            jmxRegistration.setInternalObjectInstance(objectInstance);
        }
        if (this._externalServer != null) {
            objectInstance = this.registerWithExternalServer(returnedObjectName.getCanonicalName(), returnedObjectName, rebind);
            jmxRegistration.setExternalObjectInstance(objectInstance);
        }
        return jmxRegistration;
    }

    private ObjectName createObjectName(String mBeanName) {
        ObjectName mBeanObjectName;
        try {
            mBeanObjectName = new ObjectName(mBeanName);
        }
        catch (MalformedObjectNameException e) {
            IllegalArgumentException iae = new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"JMXAgent.exceptionMalformedJMXObjectName.fmt.txt", (Object)mBeanName));
            iae.initCause(e);
            throw iae;
        }
        catch (NullPointerException e) {
            IllegalArgumentException iae = new IllegalArgumentException(RB.getStringResource("JMXAgent.exceptionNullJMXObjectName.txt"));
            iae.initCause(e);
            throw iae;
        }
        return mBeanObjectName;
    }

    private ObjectInstance registerWithInternalServer(Object mBean, String mBeanName, ObjectName mBeanObjectName, boolean rebind) {
        ObjectInstance objectInstance = null;
        if (this._server == null) {
            throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"JMXAgent.exceptionRegisterWithoutInternalServer.fmt.txt", (Object)mBeanName));
        }
        if (rebind && mBeanObjectName != null) {
            try {
                if (this._server.isRegistered(mBeanObjectName)) {
                    this._server.unregisterMBean(mBeanObjectName);
                }
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
            }
            catch (MBeanRegistrationException mBeanRegistrationException) {
                // empty catch block
            }
        }
        try {
            objectInstance = this._server.registerMBean(mBean, mBeanObjectName);
        }
        catch (InstanceAlreadyExistsException e) {
            if (mBeanName != null) {
                IllegalArgumentException iae = new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"JMXAgent.exceptionInstanceAlreadyExists.fmt.txt", (Object)mBeanName));
                iae.initCause(e);
                throw iae;
            }
            IllegalArgumentException iae = new IllegalArgumentException(RB.getStringResource("JMXAgent.exceptionInstanceAlreadyExistsNoName.txt"));
            iae.initCause(e);
            throw iae;
        }
        catch (MBeanRegistrationException e) {
            IllegalArgumentException iae = new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"JMXAgent.exceptionMBeanRegistration.fmt.txt", (Object)mBeanName));
            iae.initCause(e);
            throw iae;
        }
        catch (NotCompliantMBeanException e) {
            IllegalArgumentException iae = new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"JMXAgent.exceptionNotCompliantMBean.fmt.txt", (Object)mBeanName));
            iae.initCause(e);
            throw iae;
        }
        return objectInstance;
    }

    private ObjectInstance registerWithExternalServer(String mBeanName, ObjectName mBeanObjectName, boolean rebind) {
        ObjectInstance objectInstance = null;
        if (this._connectorURL == null || this._externalServer == null) {
            throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"JMXAgent.exceptionProxyWithoutInternalServer.fmt.txt", (Object)mBeanName));
        }
        if (rebind) {
            try {
                if (this._externalServer.isRegistered(mBeanObjectName)) {
                    this._externalServer.unregisterMBean(mBeanObjectName);
                }
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
            }
            catch (MBeanRegistrationException mBeanRegistrationException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            HashMap<String, String[]> env = new HashMap<String, String[]>();
            if (null != this._connectorCredentials && this._connectorCredentials.length > 0) {
                env.put("jmx.remote.credentials", this._connectorCredentials);
            }
            objectInstance = this._externalServer.createMBean("com.sas.services.util.RemoteMBeanProxy", mBeanObjectName, this._mLetObjectName, new Object[]{mBeanObjectName, this._connectorURL, env, null}, new String[]{ObjectName.class.getName(), JMXServiceURL.class.getName(), Map.class.getName(), Subject.class.getName()});
        }
        catch (MBeanException e) {
            IllegalArgumentException iae = new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"JMXAgent.exceptionRemoteRegistrationMBean.fmt.txt", (Object)mBeanName));
            iae.initCause(e);
            throw iae;
        }
        catch (ReflectionException e) {
            IllegalArgumentException iae = new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"JMXAgent.exceptionRemoteRegistrationReflection.fmt.txt", (Object)mBeanName));
            iae.initCause(e);
            throw iae;
        }
        catch (IOException e) {
            IllegalArgumentException iae = new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"JMXAgent.exceptionRemoteRegistrationIO.fmt.txt", (Object)mBeanName));
            iae.initCause(e);
            throw iae;
        }
        catch (NotCompliantMBeanException e) {
            IllegalArgumentException iae = new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"JMXAgent.exceptionRemoteRegistrationNotCompliantMBean.fmt.txt", (Object)mBeanName));
            iae.initCause(e);
            throw iae;
        }
        catch (InstanceAlreadyExistsException e) {
            IllegalArgumentException iae = new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"JMXAgent.exceptionRemoteRegistrationInstanceAlreadyExists.fmt.txt", (Object)mBeanName));
            iae.initCause(e);
            throw iae;
        }
        catch (InstanceNotFoundException e) {
            IllegalArgumentException iae = new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"JMXAgent.exceptionMLetInstanceNotFound.fmt.txt", (Object)this.MLET_OBJECT_NAME));
            iae.initCause(e);
            throw iae;
        }
        catch (RuntimeMBeanException e) {
            IllegalArgumentException iae = new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"JMXAgent.exceptionRuntimeMBean.fmt.txt", (Object)mBeanName));
            iae.initCause(e);
            throw iae;
        }
        return objectInstance;
    }

    public void unregisterMBean(String mBeanName) throws IllegalArgumentException {
        JMXRegistration jmxRegistration = this.getJMXRegistration(mBeanName);
        if (null != jmxRegistration) {
            this.unregisterMBeanUsingRegistration(jmxRegistration);
        }
    }

    public void unregisterMBeanUsingRegistration(JMXRegistration jmxRegistration) {
        if (null != jmxRegistration) {
            String mBeanName;
            ObjectName mBeanObjectName;
            ObjectInstance objectInstance;
            if (null != this._server) {
                objectInstance = jmxRegistration.getInternalObjectInstance();
                ObjectName objectName = mBeanObjectName = null == objectInstance ? null : objectInstance.getObjectName();
                if (null != mBeanObjectName) {
                    try {
                        this._server.unregisterMBean(mBeanObjectName);
                    }
                    catch (InstanceNotFoundException e) {
                        IllegalArgumentException iae = new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"JMXAgent.exceptionInstanceNotFound.fmt.txt", (Object)mBeanObjectName.getCanonicalName()));
                        iae.initCause(e);
                        throw iae;
                    }
                    catch (MBeanRegistrationException e) {
                        IllegalArgumentException iae = new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"JMXAgent.exceptionMBeanRegistration.fmt.txt", (Object)mBeanObjectName.getCanonicalName()));
                        iae.initCause(e);
                        throw iae;
                    }
                }
            }
            if (this._externalServer != null) {
                objectInstance = jmxRegistration.getExternalObjectInstance();
                ObjectName objectName = mBeanObjectName = null == objectInstance ? null : objectInstance.getObjectName();
                if (null != mBeanObjectName) {
                    try {
                        this._externalServer.unregisterMBean(mBeanObjectName);
                    }
                    catch (InstanceNotFoundException e) {
                        throw this.newIllegalArgumentExceptionUnregister(e, mBeanObjectName);
                    }
                    catch (MBeanRegistrationException e) {
                        throw this.newIllegalArgumentExceptionUnregister(e, mBeanObjectName);
                    }
                    catch (IOException e) {
                        throw this.newIllegalArgumentExceptionUnregister(e, mBeanObjectName);
                    }
                }
            }
            if (null != (mBeanName = jmxRegistration.getRequestedMBeanName())) {
                this.removeJMXRegistration(mBeanName);
            }
        }
    }

    private String getAliasName(String mBeanName) {
        if (_config == null) {
            throw new IllegalStateException(RB.getStringResource("JMXAgent.exceptionConfigNull.txt"));
        }
        return _config.getAliasName(mBeanName);
    }

    private MBeanServer findMBeanServer(String AgentID) {
        MBeanServer mbeanServer = null;
        ArrayList<MBeanServer> mbservers = MBeanServerFactory.findMBeanServer(AgentID);
        if (!mbservers.isEmpty()) {
            mbeanServer = mbservers.get(0);
        }
        return mbeanServer;
    }

    private JMXConnectorServer createConnector(String connectorURLString, boolean rebind, String passwordFile, String authenticator, int rmiPort) {
        JMXConnectorServer connectorServer = null;
        try {
            HashMap<String, Object> envMap = new HashMap<String, Object>();
            if (rebind) {
                envMap.put("jmx.remote.jndi.rebind", "true");
            }
            if (passwordFile != null) {
                envMap.put("jmx.remote.x.password.file", passwordFile);
            }
            if (authenticator != null) {
                try {
                    JMXAuthenticator jmxAuthenticator = (JMXAuthenticator)Class.forName(authenticator).newInstance();
                    envMap.put("jmx.remote.authenticator", jmxAuthenticator);
                }
                catch (InstantiationException ie) {
                    IllegalArgumentException e = new IllegalArgumentException(Message.format((String)RB.getStringResource("JMXAgent.authenticator.InstantiationException.ex.fmt.txt"), (Object)authenticator));
                    e.initCause(ie);
                    throw e;
                }
                catch (ClassNotFoundException cnfe) {
                    IllegalArgumentException e = new IllegalArgumentException(Message.format((String)RB.getStringResource("JMXAgent.authenticator.ClassNotFoundException.ex.fmt.txt"), (Object)authenticator));
                    e.initCause(cnfe);
                    throw e;
                }
                catch (IllegalAccessException iae) {
                    IllegalArgumentException e = new IllegalArgumentException(Message.format((String)RB.getStringResource("JMXAgent.authenticator.IllegalAccessException.ex.fmt.txt"), (Object)authenticator));
                    e.initCause(iae);
                    throw e;
                }
            }
            if (SSLRMISocketFactories.isJSSEAvailable()) {
                SSLRMISocketFactories f = SSLRMISocketFactories.getInstance();
                Class<?> clazz = this.getClass();
                RMIClientSocketFactory csf = f.getRMIClientSocketFactoryForClass(clazz);
                RMIServerSocketFactory ssf = f.getRMIServerSocketFactoryForClass(clazz);
                if (csf != null && ssf != null) {
                    envMap.put("jmx.remote.rmi.client.socket.factory", csf);
                    envMap.put("jmx.remote.rmi.server.socket.factory", ssf);
                }
            }
            if (rmiPort != -1) {
                RMIConfiguration rmiConfiguration = new RMIConfiguration("localhost", rmiPort);
                try {
                    rmiConfiguration.getRMIRegistry(true);
                }
                catch (ServiceException e) {
                    throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"JMXAgent.exceptionRegistryInit.fmt.txt", (Object)rmiPort));
                }
            }
            this._connectorURL = new JMXServiceURL(connectorURLString);
            connectorServer = JMXConnectorServerFactory.newJMXConnectorServer(this._connectorURL, envMap, this._server);
            if (connectorServer != null) {
                connectorServer.start();
            }
        }
        catch (MalformedURLException e) {
            IllegalArgumentException iae = new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"JMXAgent.ExceptionMalformedURLConnectorServer.fmt.txt", (Object)connectorURLString));
            iae.initCause(e);
            throw iae;
        }
        catch (IOException e) {
            IllegalArgumentException iae = new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"JMXAgent.IOExceptionURLConnectorServerStart.fmt.txt", (Object)connectorURLString));
            iae.initCause(e);
            throw iae;
        }
        catch (InitializationException e) {
            IllegalArgumentException iae = new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"JMXAgent.ExceptionInitializationConnectorServer.fmt.txt", (Object)connectorURLString));
            iae.initCause((Throwable)((Object)e));
            throw iae;
        }
        return connectorServer;
    }

    private MBeanServerConnection connectToExternalServer(String externalServerURL, String[] credentials) {
        MBeanServerConnection externalServer = null;
        HashMap<String, String[]> env = new HashMap<String, String[]>();
        try {
            JMXServiceURL url = new JMXServiceURL(externalServerURL);
            if (null != credentials && credentials.length > 0) {
                env.put("jmx.remote.credentials", credentials);
            }
            JMXConnector jmxc = JMXConnectorFactory.connect(url, env);
            externalServer = jmxc.getMBeanServerConnection();
        }
        catch (MalformedURLException e) {
            IllegalArgumentException iae = new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"JMXAgent.ExceptionMalformedURLExternalServer.fmt.txt", (Object)externalServerURL));
            iae.initCause(e);
            throw iae;
        }
        catch (IOException e) {
            IllegalArgumentException iae = new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"JMXAgent.IOExceptionURLExternalServer.fmt.txt", (Object)externalServerURL));
            iae.initCause(e);
            throw iae;
        }
        return externalServer;
    }

    private void createMLet() {
        if (this._externalServer != null) {
            this._mLetObjectName = this.createObjectName(this.MLET_OBJECT_NAME);
            try {
                if (this._externalServer.isRegistered(this._mLetObjectName)) {
                    try {
                        this._externalServer.unregisterMBean(this._mLetObjectName);
                    }
                    catch (InstanceNotFoundException instanceNotFoundException) {}
                }
            }
            catch (MBeanRegistrationException mBeanRegistrationException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            String classpathFile = _config.getExternalServerClasspathFile();
            URL[] urlArray = null;
            if (null != classpathFile) {
                urlArray = this.loadURLArrayFromFile(classpathFile);
            }
            try {
                if (null != urlArray) {
                    this._externalServer.createMBean("javax.management.loading.MLet", this._mLetObjectName, new Object[]{urlArray}, new String[]{URL[].class.getName()});
                } else {
                    this._externalServer.createMBean("javax.management.loading.MLet", this._mLetObjectName);
                }
            }
            catch (MBeanException e) {
                IllegalArgumentException iae = new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"JMXAgent.exceptionRemoteRegistrationMBean.fmt.txt", (Object)this.MLET_OBJECT_NAME));
                iae.initCause(e);
                throw iae;
            }
            catch (ReflectionException e) {
                IllegalArgumentException iae = new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"JMXAgent.exceptionRemoteRegistrationReflection.fmt.txt", (Object)this.MLET_OBJECT_NAME));
                iae.initCause(e);
                throw iae;
            }
            catch (IOException e) {
                IllegalArgumentException iae = new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"JMXAgent.exceptionRemoteRegistrationIO.fmt.txt", (Object)this.MLET_OBJECT_NAME));
                iae.initCause(e);
                throw iae;
            }
            catch (NotCompliantMBeanException e) {
                IllegalArgumentException iae = new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"JMXAgent.exceptionRemoteRegistrationNotCompliantMBean.fmt.txt", (Object)this.MLET_OBJECT_NAME));
                iae.initCause(e);
                throw iae;
            }
            catch (InstanceAlreadyExistsException e) {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"JMXAgent.exceptionRemoteRegistrationInstanceAlreadyExists.fmt.txt", (Object)this.MLET_OBJECT_NAME);
                IllegalArgumentException iae = new IllegalArgumentException(msg);
                iae.initCause(e);
                throw iae;
            }
        }
    }

    private URL[] loadURLArrayFromFile(String classpathFile) {
        ArrayList<URL> urlList = new ArrayList<URL>();
        if (null != classpathFile) {
            File file = new File(classpathFile);
            if (file.canRead()) {
                LineNumberReader lnr = null;
                String line = null;
                try {
                    lnr = new LineNumberReader(new FileReader(file));
                    while ((line = lnr.readLine()) != null) {
                        if (line.equals("")) continue;
                        urlList.add(new URL(line));
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (MalformedURLException e) {
                    IllegalArgumentException iae = new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"JMXAgent.exceptionMalformedClasspathURL.fmt.txt", (Object)"com.sas.jmx.external.server.classpath.file", (Object)classpathFile, line));
                    iae.initCause(e);
                    throw iae;
                }
                catch (IOException e) {
                    IllegalArgumentException iae = new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"JMXAgent.exceptionClasspathFileIO.fmt.txt", (Object)"com.sas.jmx.external.server.classpath.file", (Object)classpathFile));
                    iae.initCause(e);
                    throw iae;
                }
                finally {
                    if (null != lnr) {
                        try {
                            lnr.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            } else {
                throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"JMXAgent.exceptionClasspathFileNotFound.fmt.txt", (Object)"com.sas.jmx.external.server.classpath.file", (Object)classpathFile));
            }
        }
        if (urlList.size() > 0) {
            return urlList.toArray(new URL[urlList.size()]);
        }
        return null;
    }

    private void stop() {
        if (this._connector != null) {
            try {
                this._connector.stop();
            }
            catch (IOException e) {
                IllegalArgumentException iae = new IllegalArgumentException(RB.getStringResource("JMXAgent.IOExceptionURLConnectorServerStop.txt"));
                iae.initCause(e);
                throw iae;
            }
            this._connector = null;
        }
        if (this._server != null && this._createMBeanServer) {
            MBeanServerFactory.releaseMBeanServer(this._server);
            this._server = null;
        }
        this._externalServer = null;
    }

    private IllegalArgumentException newIllegalArgumentExceptionUnregister(Throwable cause, ObjectName mBeanObjectName) {
        IllegalArgumentException iae = new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"JMXAgent.exceptionRemoteUnregisterInstanceNotFound.fmt.txt", (Object)mBeanObjectName.getCanonicalName()));
        iae.initCause(cause);
        return iae;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JMXRegistration getJMXRegistration(String mBeanName) {
        JMXRegistration jmxRegistration = null;
        Map<String, JMXRegistration> map = this._registrationMap;
        synchronized (map) {
            jmxRegistration = this._registrationMap.get(mBeanName);
        }
        return jmxRegistration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addJMXRegistration(String mBeanName, JMXRegistration jmxRegistration) {
        boolean wasAdded = false;
        if (null != mBeanName) {
            Map<String, JMXRegistration> map = this._registrationMap;
            synchronized (map) {
                this._registrationMap.put(mBeanName, jmxRegistration);
            }
            wasAdded = true;
        }
        return wasAdded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeJMXRegistration(String mBeanName) {
        boolean wasRemoved = false;
        if (null != mBeanName) {
            Map<String, JMXRegistration> map = this._registrationMap;
            synchronized (map) {
                wasRemoved = null != this._registrationMap.remove(mBeanName);
            }
        }
        return wasRemoved;
    }
}

