/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.util;

import com.sas.codepolicy.SASScope;
import com.sas.services.ServiceException;
import com.sas.services.util.RB;
import com.sas.text.Message;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;

@SASScope
public class IOUtil {
    private static final int BUFFER_CAPACITY = 200;
    private static final int BUFFER_LENGTH = 1000;

    private IOUtil() {
    }

    public static final String getStringFromResource(Class sourceClass, String resourceName) throws IllegalArgumentException {
        if (sourceClass == null || resourceName == null) {
            throw new IllegalArgumentException();
        }
        return IOUtil.getString(sourceClass.getResourceAsStream(resourceName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String getStringFromResourceUsingEncoding(Class sourceClass, String resourceName, String charsetEncoding) throws ServiceException {
        if (sourceClass == null || resourceName == null) {
            throw new IllegalArgumentException();
        }
        String value = null;
        InputStream inputStream = null;
        try {
            inputStream = sourceClass.getResourceAsStream(resourceName);
            if (inputStream == null) {
                throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"IOUtil.invalidInputSource.ex.fmt.txt", (Object)resourceName));
            }
            value = IOUtil.getStringUsingEncoding(inputStream, charsetEncoding);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LogManager.getLogger(IOUtil.class).error(RB.getStringResource("IOUtil.closeIO.ex.txt"), (Throwable)e);
                }
            }
        }
        return value;
    }

    public static final String getString(InputStream inputStream) throws IllegalArgumentException {
        String value = null;
        try {
            value = IOUtil.getStringUsingEncoding(inputStream, null);
        }
        catch (ServiceException e) {
            throw new IllegalArgumentException(e.getLocalizedMessage());
        }
        return value;
    }

    public static final String getStringUsingEncoding(InputStream inputStream, String charsetEncoding) throws ServiceException {
        if (inputStream == null) {
            throw new ServiceException(RB.getStringResource("IOUtil.nullInputStream.ex.txt"));
        }
        String string = null;
        BufferedReader bufferedReader = null;
        try {
            StringBuilder stringBuffer = new StringBuilder(200);
            BufferedReader bufferedReader2 = bufferedReader = charsetEncoding == null ? new BufferedReader(new InputStreamReader(inputStream)) : new BufferedReader(new InputStreamReader(inputStream, charsetEncoding));
            if (bufferedReader != null) {
                char[] charBuf = new char[1000];
                int numChars = bufferedReader.read(charBuf, 0, 1000);
                while (numChars > 0) {
                    stringBuffer.append(charBuf, 0, numChars);
                    numChars = bufferedReader.read(charBuf, 0, 1000);
                }
                bufferedReader.close();
            }
            string = stringBuffer.toString();
        }
        catch (IOException e) {
            throw new ServiceException(e, e.getLocalizedMessage());
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException e) {
                    LogManager.getLogger(IOUtil.class).error(RB.getStringResource("IOUtil.closeIO.ex.txt"), (Throwable)e);
                }
            }
        }
        return string;
    }
}

