/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.util;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.net.ssl.SSLRMISocketFactories;
import com.sas.services.ParseException;
import com.sas.services.util.AttributeMapInterface;
import com.sas.services.util.NameValueNode;
import com.sas.services.util.QueryNode;
import com.sas.services.util.RB;
import com.sas.services.util.Token;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class AttributeMap
extends UnicastRemoteObject
implements AttributeMapInterface {
    private static final String TOKEN_QUOTE = "\"";
    private static final int TOKEN_QUOTE_LENGTH = "\"" != null ? "\"".length() : 0;
    private Map _pairs = new HashMap();
    private List _orderedNames = new ArrayList();
    private static final String NODE_KEY = "Node";

    public AttributeMap() throws RemoteException {
        super(SSLRMISocketFactories.getInstance().getPortForClass(0, AttributeMap.class), SSLRMISocketFactories.getInstance().getRMIClientSocketFactoryForClass(AttributeMap.class), SSLRMISocketFactories.getInstance().getRMIServerSocketFactoryForClass(AttributeMap.class));
    }

    @Override
    public String getAttribute(String name) throws RemoteException {
        List l = (List)this._pairs.get(name);
        if (l == null) {
            return null;
        }
        if (l.size() == 0) {
            return null;
        }
        return (String)l.get(0);
    }

    @Override
    public String[] getAttributes(String name) throws RemoteException {
        List l = (List)this._pairs.get(name);
        if (l == null) {
            return new String[0];
        }
        String[] valueArray = new String[l.size()];
        int i = 0;
        Iterator itor = l.iterator();
        while (itor.hasNext()) {
            valueArray[i++] = (String)itor.next();
        }
        return valueArray;
    }

    @Override
    public void setAttribute(String name, String value) throws RemoteException, IllegalArgumentException {
        ArrayList o;
        if (name == null) {
            throw new IllegalArgumentException(RB.getStringResource("AttributeMap.nameIllegalArgumentException.ex.txt"));
        }
        String tmpName = name.trim();
        if (tmpName.equals("")) {
            throw new IllegalArgumentException(RB.getStringResource("AttributeMap.nameIllegalArgumentException.ex.txt"));
        }
        ArrayList<String> l = new ArrayList<String>();
        if (value != null && !value.equals("")) {
            l.add(value);
        }
        if ((o = this._pairs.put(name, l)) == null) {
            this._orderedNames.add(name);
        }
    }

    @Override
    public void addAttribute(String name, String value) throws RemoteException, IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException(RB.getStringResource("AttributeMap.nameIllegalArgumentException.ex.txt"));
        }
        String tmpName = name.trim();
        if (tmpName.equals("")) {
            throw new IllegalArgumentException(RB.getStringResource("AttributeMap.nameIllegalArgumentException.ex.txt"));
        }
        ArrayList<String> l = (ArrayList<String>)this._pairs.get(name);
        if (l == null) {
            ArrayList o;
            l = new ArrayList<String>();
            if (value != null && !value.equals("")) {
                l.add(value);
            }
            if ((o = this._pairs.put(name, l)) == null) {
                this._orderedNames.add(name);
            }
        } else if (value != null && !value.equals("")) {
            l.add(value);
        }
    }

    @Override
    public String[] listAttributeNames() throws RemoteException {
        String[] nameArray = new String[this._orderedNames.size()];
        int i = 0;
        Iterator itor = this._orderedNames.iterator();
        while (itor.hasNext()) {
            nameArray[i++] = (String)itor.next();
        }
        return nameArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AttributeMapInterface parseNameValuePairs(AttributeMapInterface attrMap, String nameValuePairs) throws ParseException {
        AttributeMapInterface nv = attrMap;
        try {
            int len;
            int moreLength;
            if (nv == null) {
                nv = new AttributeMap();
            }
            if ((moreLength = (nameValuePairs = nameValuePairs.trim()).length()) == 0) {
                return nv;
            }
            if (nameValuePairs.startsWith(TOKEN_QUOTE)) {
                if (!nameValuePairs.endsWith(TOKEN_QUOTE)) {
                    throw new ParseException(RB.getStringResource("AttributeMap.noMatchingQuoteParsingException.ex.txt"));
                }
                len = nameValuePairs.length();
                if (len <= TOKEN_QUOTE_LENGTH) throw new ParseException(RB.getStringResource("AttributeMap.noMatchingQuoteParsingException.ex.txt"));
                nameValuePairs = nameValuePairs.substring(1, len - 1);
            } else if (nameValuePairs.charAt(0) == '\'') {
                if (!nameValuePairs.endsWith("'")) {
                    throw new ParseException(RB.getStringResource("AttributeMap.noMatchingQuoteParsingException.ex.txt"));
                }
                len = nameValuePairs.length();
                if (len <= "'".length()) throw new ParseException(RB.getStringResource("AttributeMap.noMatchingQuoteParsingException.ex.txt"));
                nameValuePairs = nameValuePairs.substring(1, len - 1);
            }
            moreLength = nameValuePairs.length();
            while (moreLength > 0 && (nameValuePairs = nameValuePairs.trim()).length() != 0) {
                int tokLen;
                int blank = nameValuePairs.indexOf(" ", 0);
                int equal = nameValuePairs.indexOf("=", 0);
                if (blank >= 0 && equal >= 0) {
                    tokLen = blank;
                    if (equal < tokLen) {
                        tokLen = equal;
                    }
                } else {
                    tokLen = blank >= 0 ? blank : (equal >= 0 ? equal : nameValuePairs.length());
                }
                String name = nameValuePairs.substring(0, tokLen);
                if (tokLen >= nameValuePairs.length()) {
                    nv.setAttribute(name, null);
                    return nv;
                }
                len = nameValuePairs.length();
                moreLength = (nameValuePairs = nameValuePairs.substring(tokLen, len).trim()).length();
                if (moreLength <= 0) continue;
                if (nameValuePairs.charAt(0) == '=') {
                    nameValuePairs = AttributeMap.setAttributes(nv, name, nameValuePairs.substring(1, moreLength), 0);
                    nameValuePairs.trim();
                    moreLength = nameValuePairs.length();
                    continue;
                }
                nv.setAttribute(name, null);
            }
            return nv;
        }
        catch (RemoteException e) {
            throw new ParseException(e, RB.getStringResource("AttributeMap.remoteException.ex.txt"));
        }
    }

    public static AttributeMapInterface parseValues(AttributeMapInterface attrMap, String name, String values) throws ParseException {
        AttributeMapInterface nv = attrMap;
        try {
            int moreLength;
            if (nv == null) {
                nv = new AttributeMap();
            }
            if ((moreLength = (values = values.trim()).length()) == 0) {
                nv.setAttribute(name, null);
                return nv;
            }
            while (moreLength > 0 && (values = values.trim()).length() != 0) {
                values = AttributeMap.setAttributes(nv, name, values, 0);
                values = values.trim();
                moreLength = values.length();
            }
        }
        catch (RemoteException e) {
            throw new ParseException(e, RB.getStringResource("AttributeMap.remoteException.ex.txt"));
        }
        return nv;
    }

    private static String setAttributes(AttributeMapInterface nv, String name, String nameValuePairs, int listEnd) throws ParseException, RemoteException {
        int length = 0;
        int tokLen = 0;
        int endChar = 0;
        length = (nameValuePairs = nameValuePairs.trim()).length();
        if (length == 0) {
            throw new ParseException(RB.getStringResource("AttributeMap.endOfOptionsParsingException.ex.txt"));
        }
        if (nameValuePairs.charAt(0) == '(' || nameValuePairs.charAt(0) == '{' || nameValuePairs.charAt(0) == '[') {
            if (listEnd != 0) {
                throw new ParseException(RB.getStringResource("AttributeMap.nestedListParseExeption.ex.txt"));
            }
            if (nameValuePairs.charAt(0) == '(') {
                endChar = 41;
            } else if (nameValuePairs.charAt(0) == '{') {
                endChar = 125;
            } else if (nameValuePairs.charAt(0) == '[') {
                endChar = 93;
            }
            nameValuePairs = nameValuePairs.substring(1, length).trim();
            length = nameValuePairs.length();
            if (length == 0) {
                throw new ParseException(RB.getStringResource("AttributeMap.endOfOptionsParsingException.ex.txt"));
            }
            tokLen = nameValuePairs.indexOf(endChar);
            if (tokLen < 0) {
                throw new ParseException(RB.getStringResource("AttributeMap.noListCloseParsingException.ex.txt"));
            }
            nameValuePairs = AttributeMap.setAttributes(nv, name, nameValuePairs, endChar);
            if ((nameValuePairs = nameValuePairs.trim()).length() == 1) {
                nameValuePairs = "";
            }
            return nameValuePairs;
        }
        if (nameValuePairs.startsWith(TOKEN_QUOTE)) {
            tokLen = nameValuePairs.indexOf(TOKEN_QUOTE, 1);
            if (tokLen < 0) {
                throw new ParseException(RB.getStringResource("AttributeMap.noMatchingQuoteParsingException.ex.txt"));
            }
            nv.addAttribute(name, nameValuePairs.substring(1, tokLen));
            if (tokLen + 1 >= length) {
                nameValuePairs = "";
            } else {
                nameValuePairs = nameValuePairs.substring(tokLen + 1, length);
                if (listEnd != 0) {
                    return AttributeMap.setAttributes(nv, name, nameValuePairs, listEnd);
                }
            }
        } else if (nameValuePairs.charAt(0) == '\'') {
            tokLen = nameValuePairs.indexOf("'", 1);
            if (tokLen < 0) {
                throw new ParseException(RB.getStringResource("AttributeMap.noMatchingQuoteParsingException.ex.txt"));
            }
            nv.addAttribute(name, nameValuePairs.substring(1, tokLen));
            if (tokLen + 1 >= length) {
                nameValuePairs = "";
            } else {
                nameValuePairs = nameValuePairs.substring(tokLen + 1, length);
                if (listEnd != 0) {
                    return AttributeMap.setAttributes(nv, name, nameValuePairs, listEnd);
                }
            }
        } else if (nameValuePairs.charAt(0) == ')' || nameValuePairs.charAt(0) == '}' || nameValuePairs.charAt(0) == ']') {
            if (listEnd == 0) {
                throw new ParseException(Message.format((ResourceBundle)RB.getResources(), (String)"AttributeMap.expectingValueParsingException.ex.fmt.txt", (Object)Character.toString(nameValuePairs.charAt(0))));
            }
            int idx = nameValuePairs.indexOf(listEnd);
            if (idx != 0) {
                throw new ParseException(RB.getStringResource("AttributeMap.noListCloseParsingException.ex.txt"));
            }
            nameValuePairs = length == 1 ? "" : nameValuePairs.substring(1, length);
        } else {
            if (nameValuePairs.charAt(0) == ',') {
                if (listEnd == 0) {
                    throw new ParseException(Message.format((ResourceBundle)RB.getResources(), (String)"AttributeMap.expectingValueParsingException.ex.fmt.txt", (Object)Character.toString(nameValuePairs.charAt(0))));
                }
                return AttributeMap.setAttributes(nv, name, nameValuePairs.substring(1, length).trim(), listEnd);
            }
            if (listEnd != 0) {
                int blank = nameValuePairs.indexOf(32);
                int comma = nameValuePairs.indexOf(44);
                endChar = nameValuePairs.indexOf(listEnd);
                if (blank < 0 && comma < 0 && endChar < 0) {
                    tokLen = -1;
                } else {
                    tokLen = -1;
                    if (blank >= 0) {
                        tokLen = blank;
                    }
                    if (comma >= 0) {
                        if (tokLen >= 0 && comma < tokLen) {
                            tokLen = comma;
                        } else if (tokLen < 0) {
                            tokLen = comma;
                        }
                    }
                    if (endChar >= 0) {
                        if (tokLen >= 0 && endChar < tokLen) {
                            tokLen = endChar;
                        } else if (tokLen < 0) {
                            tokLen = endChar;
                        }
                    }
                }
            } else {
                tokLen = nameValuePairs.indexOf(32);
            }
            if (tokLen < 0) {
                tokLen = nameValuePairs.length();
            }
            if (tokLen <= 0) {
                throw new ParseException(RB.getStringResource("AttributeMap.endOfOptionsParsingException.ex.txt"));
            }
            length = nameValuePairs.length();
            nv.addAttribute(name, nameValuePairs.substring(0, tokLen));
            nameValuePairs = tokLen == length ? "" : nameValuePairs.substring(tokLen, length);
            if (listEnd != 0) {
                return AttributeMap.setAttributes(nv, name, nameValuePairs, listEnd);
            }
        }
        return nameValuePairs;
    }

    public static String buildValue(String[] values) throws ParseException {
        String mvaString = null;
        StringBuffer buf = null;
        if (values.length == 1) {
            if (values[0] != null) {
                int pos = values[0].indexOf(" ");
                if (pos < 0) {
                    pos = values[0].indexOf("'");
                }
                if (pos < 0) {
                    mvaString = values[0];
                } else if (values[0].charAt(0) == '\'' || values[0].startsWith(TOKEN_QUOTE)) {
                    mvaString = values[0];
                } else {
                    buf = new StringBuffer();
                    int doubleQ = values[0].indexOf(TOKEN_QUOTE);
                    int singleQ = values[0].indexOf("'");
                    if (doubleQ < 0) {
                        buf.append('\"');
                        buf.append(values[0]);
                        buf.append('\"');
                    } else if (singleQ < 0) {
                        buf.append("'");
                        buf.append(values[0]);
                        buf.append("'");
                    } else {
                        throw new ParseException(RB.getStringResource("AttributeMap.bothQuotes.ex.txt"));
                    }
                    mvaString = buf.toString();
                }
            }
        } else if (values.length > 1) {
            buf = new StringBuffer();
            buf.append("(");
            for (int v = 0; v < values.length; ++v) {
                int pos;
                if (values[v] == null || values[v].equals("")) continue;
                if (v != 0) {
                    buf.append(",");
                }
                if ((pos = values[v].indexOf(" ")) < 0) {
                    pos = values[v].indexOf(",");
                }
                if (pos < 0) {
                    pos = values[v].indexOf("'");
                }
                if (pos < 0) {
                    pos = values[v].indexOf(TOKEN_QUOTE);
                }
                if (pos >= 0) {
                    if (values[v].charAt(0) == '\'' || values[v].startsWith(TOKEN_QUOTE)) {
                        buf.append(values[v]);
                        continue;
                    }
                    int doubleQ = values[v].indexOf(TOKEN_QUOTE);
                    int singleQ = values[v].indexOf("'");
                    if (doubleQ < 0) {
                        buf.append('\"');
                        buf.append(values[v]);
                        buf.append('\"');
                        continue;
                    }
                    if (singleQ < 0) {
                        buf.append("'");
                        buf.append(values[v]);
                        buf.append("'");
                        continue;
                    }
                    throw new ParseException(RB.getStringResource("AttributeMap.bothQuotes.ex.txt"));
                }
                buf.append(values[v]);
            }
            buf.append(")");
            mvaString = buf.toString();
        }
        return mvaString;
    }

    public static boolean applyFilter(String filter, AttributeMapInterface attr) throws ParseException {
        int openNum = 0;
        Token token = null;
        ArrayList<Token> list = new ArrayList<Token>();
        StringTokenizer st = new StringTokenizer(filter, ", \t()=!?&|", true);
        while (st.hasMoreTokens()) {
            boolean done;
            StringBuffer b;
            String s = st.nextToken();
            if (s.equals(" ") || s.equals("\t")) continue;
            if (s.equals("(")) {
                token = new Token(s, 5);
                ++openNum;
            } else if (s.equals(")")) {
                token = new Token(s, 1);
                --openNum;
            } else if (s.equals("&")) {
                token = new Token(s, 4);
            } else if (s.equals("|")) {
                token = new Token(s, 4);
            } else if (s.equals("?")) {
                token = new Token(s, 3);
            } else if (s.equals(",")) {
                token = new Token(s, 2);
            } else if (s.equals("=")) {
                token = new Token(s, 3);
            } else if (s.equals("!")) {
                if (!st.hasMoreTokens()) {
                    throw new ParseException(Message.format((ResourceBundle)RB.getResources(), (String)"AttributeMap.endStr.ex.fmt.txt", (Object)"="));
                }
                String nextT = st.nextToken();
                if (!nextT.equals("=")) {
                    throw new ParseException(Message.format((ResourceBundle)RB.getResources(), (String)"AttributeMap.invalidChar.ex.fmt.txt", (Object)"=", (Object)nextT));
                }
                token = new Token("!=", 3);
            } else if (s.startsWith(TOKEN_QUOTE)) {
                if (s.endsWith(TOKEN_QUOTE)) {
                    token = new Token(s.substring(1, s.length() - 1), 6);
                } else {
                    b = new StringBuffer();
                    b.append(s);
                    done = false;
                    while (st.hasMoreTokens()) {
                        s = st.nextToken();
                        b.append(s);
                        if (!s.endsWith(TOKEN_QUOTE)) continue;
                        done = true;
                        break;
                    }
                    if (!done) {
                        throw new ParseException(Message.format((ResourceBundle)RB.getResources(), (String)"AttributeMap.unMatched.ex.fmt.txt", (Object)TOKEN_QUOTE));
                    }
                    s = b.toString();
                    token = new Token(s.substring(1, s.length() - 1), 6);
                }
            } else if (s.charAt(0) == '\'') {
                if (s.endsWith("'")) {
                    token = new Token(s.substring(1, s.length() - 1), 6);
                } else {
                    b = new StringBuffer();
                    b.append(s);
                    done = false;
                    while (st.hasMoreTokens()) {
                        s = st.nextToken();
                        b.append(s);
                        if (!s.endsWith("'")) continue;
                        done = true;
                        break;
                    }
                    if (!done) {
                        throw new ParseException(Message.format((ResourceBundle)RB.getResources(), (String)"AttributeMap.unMatched.ex.fmt.txt", (Object)"'"));
                    }
                    s = b.toString();
                    token = new Token(s.substring(1, s.length() - 1), 6);
                }
            } else {
                Token token2 = token = (s = s.trim()).length() == 0 ? null : new Token(s, 6);
            }
            if (token == null) continue;
            list.add(token);
        }
        if (openNum != 0) {
            if (openNum > 0) {
                throw new ParseException(Message.format((ResourceBundle)RB.getResources(), (String)"AttributeMap.unMatched.ex.fmt.txt", (Object)"("));
            }
            throw new ParseException(Message.format((ResourceBundle)RB.getResources(), (String)"AttributeMap.unMatched.ex.fmt.txt", (Object)")"));
        }
        ArrayList l = new ArrayList();
        AttributeMap.buildTree(null, list.iterator(), l);
        boolean match = AttributeMap.processQuery(l.iterator(), null, attr);
        return match;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Token buildTree(Token curTok, Iterator itor, List queryList) throws ParseException {
        Token t = null;
        if (curTok == null) {
            if (!itor.hasNext()) throw new ParseException(RB.getStringResource("AttributeMap.endStr.ex.txt"));
            t = (Token)itor.next();
        } else {
            t = curTok;
        }
        if (t.getType() == 5) {
            if (!itor.hasNext()) {
                throw new ParseException(RB.getStringResource("AttributeMap.parseErr.ex.txt"));
            }
            curTok = (Token)itor.next();
            if (curTok.getType() != 6 && curTok.getType() != 5) {
                throw new ParseException(Message.format((ResourceBundle)RB.getResources(), (String)"AttributeMap.parenNameValue.ex.fmt.txt", (Object)"(", (Object)curTok.getToken()));
            }
            if ((curTok = AttributeMap.buildTree(curTok, itor, queryList)).getType() != 1) {
                throw new ParseException(RB.getStringResource("AttributeMap.parseErr.ex.txt"));
            }
            if (!itor.hasNext()) return null;
            curTok = (Token)itor.next();
        } else {
            if (t.getType() != 6) throw new ParseException(RB.getStringResource("AttributeMap.parseErr.ex.txt"));
            curTok = AttributeMap.parseNameValue(itor, queryList, t);
        }
        if (curTok == null) return curTok;
        if (curTok.getType() == 1) {
            return curTok;
        }
        if (curTok.getType() != 4) {
            throw new ParseException(Message.format((ResourceBundle)RB.getResources(), (String)"AttributeMap.logicalOper.ex.fmt.txt", (Object)"&", (Object)"|", (Object)curTok.getToken()));
        }
        String s = curTok.getToken();
        int type = s.equals("&") ? 0 : 1;
        QueryNode q = new QueryNode(type, null);
        curTok = AttributeMap.buildTree(null, itor, queryList);
        queryList.add(0, q);
        return curTok;
    }

    private static Token parseNameValue(Iterator itor, List queryList, Token t) throws ParseException {
        ArrayList<Token> valueList = new ArrayList<Token>();
        String name = t.getToken();
        int compType = 0;
        Token returnTok = null;
        Token curTok = null;
        if (itor.hasNext() && (curTok = (Token)itor.next()).getType() == 3) {
            String s = curTok.getToken();
            if (s.equals("?")) {
                compType = 3;
            } else {
                int n = compType = s.equals("!=") ? 2 : 1;
            }
            if (!itor.hasNext()) {
                throw new ParseException(RB.getStringResource("AttributeMap.valueEndStr.ex.txt"));
            }
            curTok = (Token)itor.next();
            if (curTok.getType() == 5) {
                if (!itor.hasNext()) {
                    throw new ParseException(RB.getStringResource("AttributeMap.valueEndStr.ex.txt"));
                }
                curTok = (Token)itor.next();
                while (curTok != null && curTok.getType() != 1) {
                    if (curTok.getType() != 6) {
                        throw new ParseException(Message.format((ResourceBundle)RB.getResources(), (String)"AttributeMap.expValue.ex.fmt.txt", (Object)curTok.getToken()));
                    }
                    Token saveTok = curTok;
                    if (itor.hasNext()) {
                        curTok = (Token)itor.next();
                        if (curTok.getType() == 2) {
                            if (!itor.hasNext()) {
                                throw new ParseException(RB.getStringResource("AttributeMap.valueEndStr.ex.txt"));
                            }
                            curTok = (Token)itor.next();
                            if (curTok.getType() != 6) {
                                throw new ParseException(Message.format((ResourceBundle)RB.getResources(), (String)"AttributeMap.expValue.ex.fmt.txt", (Object)curTok.getToken()));
                            }
                            valueList.add(saveTok);
                            continue;
                        }
                        valueList.add(saveTok);
                        continue;
                    }
                    throw new ParseException(RB.getStringResource("AttributeMap.parseErr.ex.txt"));
                }
                if (valueList.size() == 0) {
                    throw new ParseException(Message.format((ResourceBundle)RB.getResources(), (String)"AttributeMap.expValue.ex.fmt.txt", (Object)"')'"));
                }
                if (curTok == null) {
                    throw new ParseException(RB.getStringResource("AttributeMap.valueEndStr.ex.txt"));
                }
                if (curTok.getType() != 1) {
                    throw new ParseException(Message.format((ResourceBundle)RB.getResources(), (String)"AttributeMap.expValue.ex.fmt.txt", (Object)curTok.getToken()));
                }
            } else if (curTok.getType() == 6) {
                valueList.add(curTok);
            } else {
                throw new ParseException(Message.format((ResourceBundle)RB.getResources(), (String)"AttributeMap.expValue.ex.fmt.txt", (Object)curTok.getToken()));
            }
        }
        returnTok = curTok;
        String[] values = null;
        if (valueList.size() > 0) {
            values = new String[valueList.size()];
            Iterator it = valueList.iterator();
            int idx = 0;
            while (it.hasNext()) {
                curTok = (Token)it.next();
                values[idx++] = curTok.getToken();
            }
        }
        QueryNode q = new QueryNode(2, new NameValueNode(name, compType, values));
        queryList.add(0, q);
        if (valueList.size() > 0) {
            returnTok = !itor.hasNext() ? null : (Token)itor.next();
        }
        return returnTok;
    }

    private static boolean processQuery(Iterator itor, Map state, AttributeMapInterface attr) throws ParseException {
        QueryNode currentNode;
        boolean okSoFar = false;
        if (state == null) {
            state = new HashMap();
            if (!itor.hasNext()) {
                throw new ParseException(RB.getStringResource("AttributeMap.parseErr.ex.txt"));
            }
            state.put(NODE_KEY, itor.next());
        }
        if ((currentNode = (QueryNode)state.get(NODE_KEY)).getType() == 0) {
            state.put(NODE_KEY, itor.next());
            okSoFar = AttributeMap.processQuery(itor, state, attr);
            if (!okSoFar) {
                AttributeMap.flush(itor, state);
            } else {
                okSoFar = AttributeMap.processQuery(itor, state, attr);
            }
            return okSoFar;
        }
        if (currentNode.getType() == 1) {
            state.put(NODE_KEY, itor.next());
            okSoFar = AttributeMap.processQuery(itor, state, attr);
            if (okSoFar) {
                AttributeMap.flush(itor, state);
            } else {
                okSoFar = AttributeMap.processQuery(itor, state, attr);
            }
        } else {
            String[] names = null;
            String[] pkgValues = null;
            try {
                names = attr.listAttributeNames();
            }
            catch (RemoteException e) {
                throw new ParseException(e, RB.getStringResource("AttributeMap.parseErr.ex.txt"));
            }
            for (int i = 0; i < names.length; ++i) {
                if (!names[i].equalsIgnoreCase(currentNode.getNameValueNode().getName())) continue;
                try {
                    pkgValues = attr.getAttributes(names[i]);
                }
                catch (RemoteException e) {
                    throw new ParseException(e, RB.getStringResource("AttributeMap.parseErr.ex.txt"));
                }
                String[] values = currentNode.getNameValueNode().getValues();
                if (currentNode.getNameValueNode().getType() == 1) {
                    if (values.length != pkgValues.length) {
                        return okSoFar;
                    }
                    boolean found = false;
                    for (int j = 0; j < values.length; ++j) {
                        for (int k = 0; k < pkgValues.length; ++k) {
                            if (pkgValues[k].equals(values[j])) {
                                found = true;
                                break;
                            }
                            if (found) break;
                        }
                        if (found) break;
                    }
                    if (!found) break;
                    okSoFar = true;
                    break;
                }
                if (currentNode.getNameValueNode().getType() == 2) {
                    if (values.length != pkgValues.length) {
                        okSoFar = true;
                        state.put(NODE_KEY, itor.next());
                        return okSoFar;
                    }
                    boolean found = false;
                    for (int j = 0; j < values.length; ++j) {
                        for (int k = 0; k < pkgValues.length; ++k) {
                            if (!values[j].equals(pkgValues[k])) continue;
                            found = true;
                            break;
                        }
                        if (found) break;
                    }
                    if (found) break;
                    okSoFar = true;
                    break;
                }
                if (currentNode.getNameValueNode().getType() == 3) {
                    if (values.length > pkgValues.length) {
                        state.put(NODE_KEY, itor.next());
                        return okSoFar;
                    }
                    boolean found = false;
                    for (int j = 0; j < values.length; ++j) {
                        found = false;
                        for (int k = 0; k < pkgValues.length; ++k) {
                            if (!values[j].equals(pkgValues[k])) continue;
                            found = true;
                            break;
                        }
                        if (!found) break;
                    }
                    if (!found) break;
                    okSoFar = true;
                    break;
                }
                if (pkgValues.length != 0) break;
                okSoFar = true;
                break;
            }
            if (itor.hasNext()) {
                state.put(NODE_KEY, itor.next());
            } else {
                state.put(NODE_KEY, null);
            }
        }
        return okSoFar;
    }

    private static void flush(Iterator itor, Map state) {
        QueryNode next = null;
        if (itor.hasNext()) {
            next = (QueryNode)itor.next();
        }
        state.put(NODE_KEY, next);
    }
}

