/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.user;

import com.sas.codepolicy.SASScope;
import com.sas.services.InitializationException;
import com.sas.services.ServiceException;
import com.sas.services.ServiceProxy;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.metadata.PersonInterface;
import com.sas.services.security.RemoteCallbackHandler;
import com.sas.services.user.ProfileDomain;
import com.sas.services.user.ProfileInterface;
import com.sas.services.user.SubjectMatter;
import com.sas.services.user.SummaryData;
import com.sas.services.user.UserContext;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserIdentityInterface;
import com.sas.services.user.UserInitializationException;
import com.sas.services.user.UserServiceInterface;
import java.rmi.ConnectException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;

@SASScope
public class UserServiceProxy
extends ServiceProxy
implements UserServiceInterface {
    private static final long serialVersionUID = 7254668703794705688L;

    public UserServiceProxy(UserServiceInterface userService) throws InitializationException {
        super(userService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUser(UserContextInterface user) throws RemoteException {
        UserServiceInterface service = this.getUserService();
        RemoteException remoteException = null;
        try {
            service.setUser(user);
        }
        catch (ConnectException e) {
            remoteException = e;
        }
        catch (NoSuchObjectException e) {
            remoteException = e;
        }
        finally {
            if (remoteException != null) {
                try {
                    this.findUserService().setUser(user);
                }
                catch (ServiceException ex) {
                    throw new RemoteException(ex.getLocalizedMessage(), (Throwable)((Object)ex));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeUser(UserContextInterface user) throws RemoteException {
        boolean wasRemoved = false;
        UserServiceInterface service = this.getUserService();
        RemoteException remoteException = null;
        try {
            wasRemoved = service.removeUser(user);
        }
        catch (ConnectException e) {
            remoteException = e;
        }
        catch (NoSuchObjectException e) {
            remoteException = e;
        }
        finally {
            if (remoteException != null) {
                try {
                    wasRemoved = this.findUserService().removeUser(user);
                }
                catch (ServiceException ex) {
                    throw remoteException;
                }
            }
        }
        return wasRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserContextInterface getUser(String user) throws RemoteException {
        UserContextInterface userContext = null;
        UserServiceInterface service = this.getUserService();
        RemoteException remoteException = null;
        try {
            userContext = service.getUser(user);
        }
        catch (ConnectException e) {
            remoteException = e;
        }
        catch (NoSuchObjectException e) {
            remoteException = e;
        }
        finally {
            if (remoteException != null) {
                try {
                    userContext = this.findUserService().getUser(user);
                }
                catch (ServiceException ex) {
                    throw remoteException;
                }
            }
        }
        return userContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserContextInterface getUser(UserContextInterface privUser, String user) throws RemoteException {
        UserContextInterface userContext = null;
        UserServiceInterface service = this.getUserService();
        RemoteException remoteException = null;
        try {
            userContext = service.getUser(privUser, user);
        }
        catch (ConnectException e) {
            remoteException = e;
        }
        catch (NoSuchObjectException e) {
            remoteException = e;
        }
        finally {
            if (remoteException != null) {
                try {
                    userContext = this.findUserService().getUser(privUser, user);
                }
                catch (ServiceException ex) {
                    throw remoteException;
                }
            }
        }
        return userContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserIdentityInterface newUserIdentity(Object principal, Object credential, String domain, String mechanism) throws ServiceException, RemoteException {
        UserIdentityInterface userIdentity = null;
        UserServiceInterface service = this.getUserService();
        RemoteException remoteException = null;
        try {
            userIdentity = service.newUserIdentity(principal, credential, domain, mechanism);
        }
        catch (ConnectException e) {
            remoteException = e;
        }
        catch (NoSuchObjectException e) {
            remoteException = e;
        }
        finally {
            if (remoteException != null) {
                userIdentity = this.findUserService().newUserIdentity(principal, credential, domain, mechanism);
            }
        }
        return userIdentity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getGroups(UserContextInterface user) throws ServiceException, RemoteException {
        List groupList = null;
        UserServiceInterface service = this.getUserService();
        RemoteException remoteException = null;
        try {
            groupList = service.getGroups(user);
        }
        catch (ConnectException e) {
            remoteException = e;
        }
        catch (NoSuchObjectException e) {
            remoteException = e;
        }
        finally {
            if (remoteException != null) {
                groupList = this.findUserService().getGroups(user);
            }
        }
        return groupList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProfileDomain getProfileDefinition(String application) throws ServiceException, RemoteException {
        ProfileDomain profileDomain = null;
        UserServiceInterface service = this.getUserService();
        RemoteException remoteException = null;
        try {
            profileDomain = service.getProfileDefinition(application);
        }
        catch (ConnectException e) {
            remoteException = e;
        }
        catch (NoSuchObjectException e) {
            remoteException = e;
        }
        finally {
            if (remoteException != null) {
                profileDomain = this.findUserService().getProfileDefinition(application);
            }
        }
        return profileDomain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProfileInterface loadProfile(UserContextInterface user, String application) throws ServiceException, RemoteException {
        ProfileInterface profile = null;
        UserServiceInterface service = this.getUserService();
        RemoteException remoteException = null;
        try {
            profile = service.loadProfile(user, application);
        }
        catch (ConnectException e) {
            remoteException = e;
        }
        catch (NoSuchObjectException e) {
            remoteException = e;
        }
        finally {
            if (remoteException != null) {
                profile = this.findUserService().loadProfile(user, application);
            }
        }
        return profile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProfileInterface loadProfile(UserContextInterface searchContext, UserContextInterface user, String application) throws ServiceException, RemoteException {
        ProfileInterface profile = null;
        UserServiceInterface service = this.getUserService();
        RemoteException remoteException = null;
        try {
            profile = service.loadProfile(searchContext, user, application);
        }
        catch (ConnectException e) {
            remoteException = e;
        }
        catch (NoSuchObjectException e) {
            remoteException = e;
        }
        finally {
            if (remoteException != null) {
                profile = this.findUserService().loadProfile(searchContext, user, application);
            }
        }
        return profile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProfileInterface createProfile(UserContextInterface user, String application) throws ServiceException, RemoteException {
        ProfileInterface profile = null;
        UserServiceInterface service = this.getUserService();
        RemoteException remoteException = null;
        try {
            profile = service.createProfile(user, application);
        }
        catch (ConnectException e) {
            remoteException = e;
        }
        catch (NoSuchObjectException e) {
            remoteException = e;
        }
        finally {
            if (remoteException != null) {
                profile = this.findUserService().createProfile(user, application);
            }
        }
        return profile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProfileInterface createProfile(UserContextInterface privUser, UserContextInterface user, String application) throws ServiceException, RemoteException {
        ProfileInterface profile = null;
        UserServiceInterface service = this.getUserService();
        RemoteException remoteException = null;
        try {
            profile = service.createProfile(privUser, user, application);
        }
        catch (ConnectException e) {
            remoteException = e;
        }
        catch (NoSuchObjectException e) {
            remoteException = e;
        }
        finally {
            if (remoteException != null) {
                profile = this.findUserService().createProfile(privUser, user, application);
            }
        }
        return profile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadUserCredentials(UserContextInterface user) throws ServiceException, RemoteException {
        UserServiceInterface service = this.getUserService();
        RemoteException remoteException = null;
        try {
            service.loadUserCredentials(user);
        }
        catch (ConnectException e) {
            remoteException = e;
        }
        catch (NoSuchObjectException e) {
            remoteException = e;
        }
        finally {
            if (remoteException != null) {
                this.findUserService().loadUserCredentials(user);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProfileInterface getProfile(PersonInterface person, String application) throws ServiceException, RemoteException {
        ProfileInterface profile = null;
        UserServiceInterface service = this.getUserService();
        RemoteException remoteException = null;
        try {
            profile = service.getProfile(person, application);
        }
        catch (ConnectException e) {
            remoteException = e;
        }
        catch (NoSuchObjectException e) {
            remoteException = e;
        }
        finally {
            if (remoteException != null) {
                profile = this.findUserService().getProfile(person, application);
            }
        }
        return profile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getUserCount() throws ServiceException, RemoteException {
        int count = 0;
        UserServiceInterface service = this.getUserService();
        RemoteException remoteException = null;
        try {
            count = service.getUserCount();
        }
        catch (ConnectException e) {
            remoteException = e;
        }
        catch (NoSuchObjectException e) {
            remoteException = e;
        }
        finally {
            if (remoteException != null) {
                count = this.findUserService().getUserCount();
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SummaryData getSummaryData(boolean includeDetails) throws ServiceException, RemoteException {
        SummaryData result = null;
        UserServiceInterface service = this.getUserService();
        RemoteException remoteException = null;
        try {
            result = service.getSummaryData(includeDetails);
        }
        catch (ConnectException e) {
            remoteException = e;
        }
        catch (NoSuchObjectException e) {
            remoteException = e;
        }
        finally {
            if (remoteException != null) {
                result = this.findUserService().getSummaryData(includeDetails);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadUserCredentials(UserContextInterface searchContext, UserContextInterface user) throws ServiceException, RemoteException {
        UserServiceInterface service = this.getUserService();
        RemoteException remoteException = null;
        try {
            service.loadUserCredentials(searchContext, user);
        }
        catch (ConnectException e) {
            remoteException = e;
        }
        catch (NoSuchObjectException e) {
            remoteException = e;
        }
        finally {
            if (remoteException != null) {
                this.findUserService().loadUserCredentials(searchContext, user);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserContextInterface newUser(String clientSource, String appSource) throws ServiceException, RemoteException, UserInitializationException {
        UserContextInterface user = null;
        UserServiceInterface service = this.getUserService();
        RemoteException remoteException = null;
        try {
            user = service.newUser(clientSource, appSource);
        }
        catch (ConnectException e) {
            remoteException = e;
        }
        catch (NoSuchObjectException e) {
            remoteException = e;
        }
        finally {
            if (remoteException != null) {
                user = this.findUserService().newUser(clientSource, appSource);
            }
        }
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserContextInterface newUser(String clientSource, String appSource, Map advancedOptions) throws ServiceException, RemoteException, UserInitializationException {
        UserContextInterface user = null;
        UserServiceInterface service = this.getUserService();
        RemoteException remoteException = null;
        try {
            user = service.newUser(clientSource, appSource, advancedOptions);
        }
        catch (ConnectException e) {
            remoteException = e;
        }
        catch (NoSuchObjectException e) {
            remoteException = e;
        }
        finally {
            if (remoteException != null) {
                user = this.findUserService().newUser(clientSource, appSource, advancedOptions);
            }
        }
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserContextInterface newUser(String uid, String password, String domain) throws RemoteException, ServiceException, UserInitializationException {
        UserContextInterface user = null;
        UserServiceInterface service = this.getUserService();
        RemoteException remoteException = null;
        try {
            user = service.newUser(uid, password, domain);
        }
        catch (ConnectException e) {
            remoteException = e;
        }
        catch (NoSuchObjectException e) {
            remoteException = e;
        }
        finally {
            if (remoteException != null) {
                user = this.findUserService().newUser(uid, password, domain);
            }
        }
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserContextInterface newUser(String uid, String password, String domain, String clientSource, String appSource) throws RemoteException, ServiceException, UserInitializationException {
        UserContextInterface user = null;
        UserServiceInterface service = this.getUserService();
        RemoteException remoteException = null;
        try {
            user = service.newUser(uid, password, domain, clientSource, appSource);
        }
        catch (ConnectException e) {
            remoteException = e;
        }
        catch (NoSuchObjectException e) {
            remoteException = e;
        }
        finally {
            if (remoteException != null) {
                user = this.findUserService().newUser(uid, password, domain, clientSource, appSource);
            }
        }
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserContextInterface newUser(UserContext privUser, String uid, String password, String domain) throws RemoteException, ServiceException, UserInitializationException {
        UserContextInterface user = null;
        UserServiceInterface service = this.getUserService();
        RemoteException remoteException = null;
        try {
            user = service.newUser(privUser, uid, password, domain);
        }
        catch (ConnectException e) {
            remoteException = e;
        }
        catch (NoSuchObjectException e) {
            remoteException = e;
        }
        finally {
            if (remoteException != null) {
                user = this.findUserService().newUser(privUser, uid, password, domain);
            }
        }
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserContextInterface newUser(UserContextInterface privUser, String uid, String password, String domain) throws RemoteException, ServiceException, UserInitializationException {
        UserContextInterface user = null;
        UserServiceInterface service = this.getUserService();
        RemoteException remoteException = null;
        try {
            user = service.newUser(privUser, uid, password, domain);
        }
        catch (ConnectException e) {
            remoteException = e;
        }
        catch (NoSuchObjectException e) {
            remoteException = e;
        }
        finally {
            if (remoteException != null) {
                user = this.findUserService().newUser(privUser, uid, password, domain);
            }
        }
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserContextInterface newUser(UserContext privUser, String uid, String password, String domain, String clientSource, String appSource) throws RemoteException, ServiceException, UserInitializationException {
        UserContextInterface user = null;
        UserServiceInterface service = this.getUserService();
        RemoteException remoteException = null;
        try {
            user = service.newUser(privUser, uid, password, domain, clientSource, appSource);
        }
        catch (ConnectException e) {
            remoteException = e;
        }
        catch (NoSuchObjectException e) {
            remoteException = e;
        }
        finally {
            if (remoteException != null) {
                user = this.findUserService().newUser(privUser, uid, password, domain, clientSource, appSource);
            }
        }
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserContextInterface newUser(UserContextInterface privUser, String uid, String password, String domain, String clientSource, String appSource) throws RemoteException, ServiceException, UserInitializationException {
        UserContextInterface user = null;
        UserServiceInterface service = this.getUserService();
        RemoteException remoteException = null;
        try {
            user = service.newUser(privUser, uid, password, domain, clientSource, appSource);
        }
        catch (ConnectException e) {
            remoteException = e;
        }
        catch (NoSuchObjectException e) {
            remoteException = e;
        }
        finally {
            if (remoteException != null) {
                user = this.findUserService().newUser(privUser, uid, password, domain, clientSource, appSource);
            }
        }
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserContextInterface newUser(UserContext privUser, String uid, String password, String domain, String clientSource, String appSource, Map advancedOptions) throws RemoteException, ServiceException, UserInitializationException {
        UserContextInterface user = null;
        UserServiceInterface service = this.getUserService();
        RemoteException remoteException = null;
        try {
            user = service.newUser(privUser, uid, password, domain, clientSource, appSource, advancedOptions);
        }
        catch (ConnectException e) {
            remoteException = e;
        }
        catch (NoSuchObjectException e) {
            remoteException = e;
        }
        finally {
            if (remoteException != null) {
                user = this.findUserService().newUser(privUser, uid, password, domain, clientSource, appSource, advancedOptions);
            }
        }
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserContextInterface newUser(UserContextInterface privUser, String uid, String password, String domain, String clientSource, String appSource, Map advancedOptions) throws RemoteException, ServiceException, UserInitializationException {
        UserContextInterface user = null;
        UserServiceInterface service = this.getUserService();
        RemoteException remoteException = null;
        try {
            user = service.newUser(privUser, uid, password, domain, clientSource, appSource, advancedOptions);
        }
        catch (ConnectException e) {
            remoteException = e;
        }
        catch (NoSuchObjectException e) {
            remoteException = e;
        }
        finally {
            if (remoteException != null) {
                user = this.findUserService().newUser(privUser, uid, password, domain, clientSource, appSource, advancedOptions);
            }
        }
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserContextInterface newUserWithInfoService(UserContext privUser, String uid, String password, String domain, InformationServiceInterface infoService) throws RemoteException, ServiceException, UserInitializationException {
        UserContextInterface user = null;
        UserServiceInterface service = this.getUserService();
        RemoteException remoteException = null;
        try {
            user = service.newUserWithInfoService(privUser, uid, password, domain, infoService);
        }
        catch (ConnectException e) {
            remoteException = e;
        }
        catch (NoSuchObjectException e) {
            remoteException = e;
        }
        finally {
            if (remoteException != null) {
                user = this.findUserService().newUserWithInfoService(privUser, uid, password, domain, infoService);
            }
        }
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserContextInterface newRemoteUser(SubjectMatter subject) throws RemoteException, ServiceException, UserInitializationException {
        UserContextInterface user = null;
        UserServiceInterface service = this.getUserService();
        RemoteException remoteException = null;
        try {
            user = service.newRemoteUser(subject);
        }
        catch (ConnectException e) {
            remoteException = e;
        }
        catch (NoSuchObjectException e) {
            remoteException = e;
        }
        finally {
            if (remoteException != null) {
                user = this.findUserService().newRemoteUser(subject);
            }
        }
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserContextInterface newRemoteUser(SubjectMatter subject, Map advancedOptions) throws RemoteException, ServiceException, UserInitializationException {
        UserContextInterface user = null;
        UserServiceInterface service = this.getUserService();
        RemoteException remoteException = null;
        try {
            user = service.newRemoteUser(subject, advancedOptions);
        }
        catch (ConnectException e) {
            remoteException = e;
        }
        catch (NoSuchObjectException e) {
            remoteException = e;
        }
        finally {
            if (remoteException != null) {
                user = this.findUserService().newRemoteUser(subject, advancedOptions);
            }
        }
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserContextInterface newAuthenticatedUser(Subject subject) throws RemoteException, ServiceException, UserInitializationException {
        UserContextInterface user = null;
        UserServiceInterface service = this.getUserService();
        RemoteException remoteException = null;
        try {
            user = service.newAuthenticatedUser(subject);
        }
        catch (ConnectException e) {
            remoteException = e;
        }
        catch (NoSuchObjectException e) {
            remoteException = e;
        }
        finally {
            if (remoteException != null) {
                user = this.findUserService().newAuthenticatedUser(subject);
            }
        }
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserContextInterface fromByteArray(byte[] data) throws ServiceException, RemoteException {
        UserContextInterface user = null;
        UserServiceInterface service = this.getUserService();
        RemoteException remoteException = null;
        try {
            user = service.fromByteArray(data);
        }
        catch (ConnectException e) {
            remoteException = e;
        }
        catch (NoSuchObjectException e) {
            remoteException = e;
        }
        finally {
            if (remoteException != null) {
                user = this.findUserService().fromByteArray(data);
            }
        }
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setChallengeCallbackHandler(RemoteCallbackHandler handler) throws RemoteException {
        UserServiceInterface service = this.getUserService();
        RemoteException remoteException = null;
        try {
            service.setChallengeCallbackHandler(handler);
        }
        catch (ConnectException e) {
            remoteException = e;
        }
        catch (NoSuchObjectException e) {
            remoteException = e;
        }
        finally {
            if (remoteException != null) {
                try {
                    this.findUserService().setChallengeCallbackHandler(handler);
                }
                catch (ServiceException ex) {
                    throw remoteException;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteCallbackHandler getChallengeCallbackHandler() throws RemoteException {
        RemoteCallbackHandler handler = null;
        UserServiceInterface service = this.getUserService();
        RemoteException remoteException = null;
        try {
            handler = service.getChallengeCallbackHandler();
        }
        catch (ConnectException e) {
            remoteException = e;
        }
        catch (NoSuchObjectException e) {
            remoteException = e;
        }
        finally {
            if (remoteException != null) {
                try {
                    service = this.findUserService();
                    handler = service.getChallengeCallbackHandler();
                }
                catch (ServiceException ex) {
                    throw remoteException;
                }
            }
        }
        return handler;
    }

    private final UserServiceInterface getUserService() {
        return (UserServiceInterface)this.getService();
    }

    private final UserServiceInterface findUserService() throws ServiceException, RemoteException {
        return (UserServiceInterface)this.findRemoteService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getGroupLoginEnabled() throws ServiceException, RemoteException {
        boolean result = false;
        UserServiceInterface service = this.getUserService();
        RemoteException remoteException = null;
        try {
            result = service.getGroupLoginEnabled();
        }
        catch (ConnectException e) {
            remoteException = e;
        }
        catch (NoSuchObjectException e) {
            remoteException = e;
        }
        finally {
            if (remoteException != null) {
                try {
                    result = this.findUserService().getGroupLoginEnabled();
                }
                catch (ServiceException ex) {
                    throw remoteException;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setGroupLoginEnabled(boolean groupLoginFlag) throws ServiceException, RemoteException {
        UserServiceInterface service = this.getUserService();
        RemoteException remoteException = null;
        try {
            service.setGroupLoginEnabled(groupLoginFlag);
        }
        catch (ConnectException e) {
            remoteException = e;
        }
        catch (NoSuchObjectException e) {
            remoteException = e;
        }
        finally {
            if (remoteException != null) {
                try {
                    this.findUserService().setGroupLoginEnabled(groupLoginFlag);
                }
                catch (ServiceException ex) {
                    throw remoteException;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetInternalPassword(String host, String port, String username, String oldPassword, String newPassword) throws ServiceException, RemoteException {
        UserServiceInterface service = this.getUserService();
        RemoteException remoteException = null;
        try {
            service.resetInternalPassword(host, port, username, oldPassword, newPassword);
        }
        catch (ConnectException e) {
            remoteException = e;
        }
        catch (NoSuchObjectException e) {
            remoteException = e;
        }
        finally {
            if (remoteException != null) {
                try {
                    this.findUserService().resetInternalPassword(host, port, username, oldPassword, newPassword);
                }
                catch (ServiceException ex) {
                    throw remoteException;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void userDestroyed(UserContextInterface user) throws ServiceException, RemoteException {
        UserServiceInterface service = this.getUserService();
        RemoteException remoteException = null;
        try {
            service.userDestroyed(user);
        }
        catch (ConnectException e) {
            remoteException = e;
        }
        catch (NoSuchObjectException e) {
            remoteException = e;
        }
        finally {
            if (remoteException != null) {
                try {
                    this.findUserService().userDestroyed(user);
                }
                catch (ServiceException ex) {
                    throw remoteException;
                }
            }
        }
    }
}

