/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.user;

import com.sas.codepolicy.SASScope;
import com.sas.services.AbstractServiceComponentConfig;
import com.sas.services.MergePolicy;
import com.sas.services.ServiceConfigurationException;
import com.sas.services.ServiceException;
import com.sas.services.deployment.ConsumedResourceAdapter;
import com.sas.services.deployment.ConsumedResourceInterface;
import com.sas.services.deployment.Consumer;
import com.sas.services.deployment.ConsumerResourceAssoc;
import com.sas.services.deployment.ConsumerUsage;
import com.sas.services.user.ProfileDomain;
import com.sas.services.user.ProfileDomainResourceAdapter;
import com.sas.services.user.RB;
import com.sas.services.user.SimpleUserIdentity;
import com.sas.services.user.UserServiceFactory;
import com.sas.services.user.UserServiceInitializer;
import com.sas.text.Message;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import com.sas.util.Strings;
import com.sas.util.UsageVersion;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;

@SASScope
public final class UserServiceInitObject
extends AbstractServiceComponentConfig {
    private static final int USER_LIST_INIT = 8;
    private static final int PROFILE_DEF_MAP_INIT = 12;
    private static final boolean IS_CONFIGURATION_UPDATEABLE = true;
    private static final UsageVersion USAGEVERSION_OLDEST = new UsageVersion(0, 0);
    private static final UsageVersion USAGEVERSION_CURRENT = new UsageVersion(0, 0);
    private String _personBase;
    private String _groupBase;
    private String _credBase;
    private String _domain;
    private List<SimpleUserIdentity> _users = new ArrayList<SimpleUserIdentity>(5);
    private Map<String, ProfileDomain> _profileDefs = new HashMap<String, ProfileDomain>(5);

    public UserServiceInitObject() {
        super(UserServiceInitializer.getXMLDocument(), true);
        this.setVersionCompatibility();
        this.setDomain("");
        this.setCredentialBase("");
        this.setGroupBase("");
        this.setPersonBase("");
    }

    public UserServiceInitObject(InputStream configInputStream) throws IllegalArgumentException {
        super(configInputStream, true);
        this.setVersionCompatibility();
        this.setDomain("");
        this.setCredentialBase("");
        this.setGroupBase("");
        this.setPersonBase("");
    }

    private void setVersionCompatibility() {
        this.setUsageVersionCompatibility(USAGEVERSION_OLDEST, USAGEVERSION_CURRENT);
    }

    public UserServiceInitObject(List<SimpleUserIdentity> users, Map<String, ProfileDomain> profileDomainMap) throws IllegalArgumentException {
        this();
        try {
            if (users != null && users.size() > 0) {
                for (SimpleUserIdentity simpleUserIdentity : users) {
                    this.addUser((SimpleUserIdentity)simpleUserIdentity.clone());
                }
            }
            if (profileDomainMap != null && profileDomainMap.size() > 0) {
                for (Map.Entry entry : profileDomainMap.entrySet()) {
                    this.addProfile((String)entry.getKey(), (ProfileDomain)((ProfileDomain)entry.getValue()).clone());
                }
            }
        }
        catch (ServiceConfigurationException e) {
            throw new IllegalArgumentException((Throwable)((Object)e));
        }
    }

    @Override
    protected AbstractServiceComponentConfig createConfiguration(Document document) throws ServiceException {
        return UserServiceInitializer.parse(document);
    }

    public void changeHost(String oldHost, String newHost) {
        Set<String> keySet = this._profileDefs.keySet();
        for (String nextKey : keySet) {
            ProfileDomain nextProfile = this._profileDefs.get(nextKey);
            String profileUrl = nextProfile.getUrl();
            int index = 0;
            index = profileUrl.lastIndexOf(58);
            String urlHost = profileUrl.substring(6, index);
            String urlPort = profileUrl.substring(index + 1);
            if (!urlHost.equalsIgnoreCase(oldHost)) continue;
            nextProfile.setUrl("omi://" + newHost + ":" + urlPort);
        }
    }

    @Override
    protected void mergeConfiguration(AbstractServiceComponentConfig currentConfig, AbstractServiceComponentConfig newConfig) throws ServiceConfigurationException, IllegalArgumentException {
        this.mergeConfiguration(currentConfig, newConfig, this.getDefaultMergePolicy());
    }

    @Override
    protected void mergeConfiguration(AbstractServiceComponentConfig currentConfig, AbstractServiceComponentConfig newConfig, MergePolicy mergePolicy) throws ServiceConfigurationException, IllegalArgumentException {
        UserServiceInitObject serviceConfig1 = null;
        UserServiceInitObject serviceConfig2 = null;
        try {
            serviceConfig1 = (UserServiceInitObject)currentConfig;
            serviceConfig2 = (UserServiceInitObject)newConfig;
        }
        catch (ClassCastException e) {
            throw new ServiceConfigurationException(e, Message.format((ResourceBundle)RB.getResources(), (String)"UserServiceInitObject.invalidConfig.ex.fmt.txt", (Object)UserServiceInitObject.class.getName()));
        }
        UserServiceInitObject.mergeConfiguration(serviceConfig1, serviceConfig2, mergePolicy == null ? this.getDefaultMergePolicy() : mergePolicy);
    }

    public SimpleUserIdentity getUserUsingID(String userID) {
        SimpleUserIdentity simpleUserIdentity = null;
        if (userID != null) {
            for (SimpleUserIdentity aSimpleUserIdentity : this._users) {
                if (!userID.equals(aSimpleUserIdentity.getResourceID())) continue;
                simpleUserIdentity = aSimpleUserIdentity;
                break;
            }
        }
        return simpleUserIdentity;
    }

    private SimpleUserIdentity getUserForPrincipal(Object principal, String domain) {
        SimpleUserIdentity simpleUserIdentity = null;
        if (principal != null) {
            for (SimpleUserIdentity nextSimpleUserIdentity : this._users) {
                if (!Strings.equal((String)domain, (String)nextSimpleUserIdentity.getDomain(), (boolean)false, (boolean)false) || !principal.equals(nextSimpleUserIdentity.getPrincipal())) continue;
                simpleUserIdentity = nextSimpleUserIdentity;
                break;
            }
        }
        return simpleUserIdentity;
    }

    private void replaceProfileDomainApplication(String oldApplicationName, String newApplicationName) {
        ProfileDomain profileDomain;
        if (oldApplicationName != null && newApplicationName != null && (profileDomain = this._profileDefs.remove(oldApplicationName)) != null) {
            this._profileDefs.put(newApplicationName, profileDomain);
        }
    }

    @Override
    public Consumer addConsumer(Consumer consumer, boolean isConsumer) {
        Consumer addedConsumer = super.addConsumer(consumer, isConsumer);
        if (isConsumer) {
            this.clearUndefinedResources(consumer);
        }
        return addedConsumer;
    }

    @Override
    public void setIsConsumer(Consumer consumer, boolean isConsumer) {
        super.setIsConsumer(consumer, isConsumer);
        if (isConsumer) {
            this.clearUndefinedResources(consumer);
        }
    }

    private void clearUndefinedResources(Consumer consumer) {
        if (consumer != null) {
            String consumerID = consumer.getID();
            ConsumerUsage consumerUsage = this.getConsumerUsage();
            ConsumerResourceAssoc consumerResourceAssoc = null;
            if (UserServiceInitObject.isResourceUndefined(this.getCredentialBase())) {
                consumerResourceAssoc = consumerUsage.getConsumerResourceAssocsForConsumerAndResource(consumerID, "LDAPBaseCredential");
                consumerResourceAssoc.setIsConsumer(false);
            }
            if (UserServiceInitObject.isResourceUndefined(this.getGroupBase())) {
                consumerResourceAssoc = consumerUsage.getConsumerResourceAssocsForConsumerAndResource(consumerID, "LDAPBaseGroup");
                consumerResourceAssoc.setIsConsumer(false);
            }
            if (UserServiceInitObject.isResourceUndefined(this.getPersonBase())) {
                consumerResourceAssoc = consumerUsage.getConsumerResourceAssocsForConsumerAndResource(consumerID, "LDAPBasePerson");
                consumerResourceAssoc.setIsConsumer(false);
            }
            if (UserServiceInitObject.isResourceUndefined(this.getDomain())) {
                consumerResourceAssoc = consumerUsage.getConsumerResourceAssocsForConsumerAndResource(consumerID, "AuthDomain");
                consumerResourceAssoc.setIsConsumer(false);
            }
        }
    }

    private static boolean isResourceUndefined(String value) {
        return value == null || value.trim().length() == 0;
    }

    private static void mergeConfiguration(UserServiceInitObject thisConfig, UserServiceInitObject newConfig, MergePolicy mergePolicy) throws ServiceConfigurationException, IllegalArgumentException {
        if (mergePolicy == null) {
            throw new IllegalArgumentException();
        }
        if (thisConfig == null || newConfig == null) {
            throw new IllegalArgumentException(RB.getStringResource("UserServiceInitObject.mustSpecifyConfiguration.ex.txt"));
        }
        HashMap<String, String> resourceIdMap = new HashMap<String, String>(newConfig.getProfiles().size() + newConfig.getUserList().size() + 5);
        UserServiceInitObject.mergeDomain(thisConfig, newConfig, mergePolicy, resourceIdMap);
        UserServiceInitObject.mergeLDAP(thisConfig, newConfig, mergePolicy, resourceIdMap);
        UserServiceInitObject.mergeUsers(thisConfig, newConfig, mergePolicy, resourceIdMap);
        UserServiceInitObject.mergeProfiles(thisConfig, newConfig, mergePolicy, resourceIdMap);
        thisConfig.getConsumerUsage().merge(newConfig.getConsumerUsage(), resourceIdMap);
    }

    private static void mergeDomain(UserServiceInitObject thisConfig, UserServiceInitObject newConfig, MergePolicy mergePolicy, Map<String, String> resourceIdMap) throws ServiceConfigurationException, IllegalArgumentException {
        String thisDomain = thisConfig.getDomain();
        String newDomain = newConfig.getDomain();
        String key = "AuthDomain";
        String thisResourceID = thisConfig.getConsumedResourceAdapter("AuthDomain").getResourceID();
        String newResourceID = newConfig.getConsumedResourceAdapter("AuthDomain").getResourceID();
        boolean isSame = Strings.equal((String)thisResourceID, (String)newResourceID, (boolean)false, (boolean)false);
        if (UserServiceInitObject.isResourceUndefined(thisDomain)) {
            thisConfig.setDomain(newDomain);
        } else if (!UserServiceInitObject.isResourceUndefined(newDomain) && !Strings.equal((String)thisDomain, (String)newDomain, (boolean)false, (boolean)false)) {
            if (isSame) {
                thisConfig.setDomain(newDomain);
            } else if (mergePolicy.isOKToReplace()) {
                thisConfig.setDomain(newDomain);
            } else {
                throw new ServiceConfigurationException(Message.format((ResourceBundle)RB.getResources(), (String)"UserServiceInitObject.conflictDomain.ex.fmt.txt", (Object)thisDomain, (Object)newDomain));
            }
        }
        resourceIdMap.put(newResourceID, thisResourceID);
    }

    private static void mergeLDAP(UserServiceInitObject thisConfig, UserServiceInitObject newConfig, MergePolicy mergePolicy, Map<String, String> resourceIdMap) throws ServiceConfigurationException, IllegalArgumentException {
        String thisDirectory = thisConfig.getPersonBase();
        String otherDirectory = newConfig.getPersonBase();
        if (UserServiceInitObject.isResourceUndefined(thisDirectory)) {
            thisConfig.setPersonBase(otherDirectory);
        } else if (!UserServiceInitObject.isResourceUndefined(otherDirectory) && !Strings.equal((String)thisDirectory, (String)otherDirectory, (boolean)false, (boolean)false)) {
            if (mergePolicy.isOKToReplace()) {
                thisConfig.setPersonBase(otherDirectory);
            } else {
                throw new ServiceConfigurationException(Message.format((ResourceBundle)RB.getResources(), (String)"UserServiceInitObject.conflictLDAPBasePerson.ex.fmt.txt", (Object)thisDirectory, (Object)otherDirectory));
            }
        }
        thisDirectory = thisConfig.getGroupBase();
        otherDirectory = newConfig.getGroupBase();
        if (UserServiceInitObject.isResourceUndefined(thisDirectory)) {
            thisConfig.setGroupBase(otherDirectory);
        } else if (!UserServiceInitObject.isResourceUndefined(otherDirectory) && !Strings.equal((String)thisDirectory, (String)otherDirectory, (boolean)false, (boolean)false)) {
            if (mergePolicy.isOKToReplace()) {
                thisConfig.setGroupBase(otherDirectory);
            } else {
                throw new ServiceConfigurationException(Message.format((ResourceBundle)RB.getResources(), (String)"UserServiceInitObject.conflictLDAPBaseGroup.ex.fmt.txt", (Object)thisDirectory, (Object)otherDirectory));
            }
        }
        thisDirectory = thisConfig.getCredentialBase();
        otherDirectory = newConfig.getCredentialBase();
        if (UserServiceInitObject.isResourceUndefined(thisDirectory)) {
            thisConfig.setCredentialBase(otherDirectory);
        } else if (!UserServiceInitObject.isResourceUndefined(otherDirectory) && !Strings.equal((String)thisDirectory, (String)otherDirectory, (boolean)false, (boolean)false)) {
            if (mergePolicy.isOKToReplace()) {
                thisConfig.setCredentialBase(otherDirectory);
            } else {
                throw new ServiceConfigurationException(Message.format((ResourceBundle)RB.getResources(), (String)"UserServiceInitObject.conflictLDAPBaseCredential.ex.fmt.txt", (Object)thisDirectory, (Object)otherDirectory));
            }
        }
        String key = "LDAPBaseCredential";
        resourceIdMap.put(newConfig.getConsumedResourceAdapter(key).getResourceID(), thisConfig.getConsumedResourceAdapter(key).getResourceID());
        key = "LDAPBaseGroup";
        resourceIdMap.put(newConfig.getConsumedResourceAdapter(key).getResourceID(), thisConfig.getConsumedResourceAdapter(key).getResourceID());
        key = "LDAPBasePerson";
        resourceIdMap.put(newConfig.getConsumedResourceAdapter(key).getResourceID(), thisConfig.getConsumedResourceAdapter(key).getResourceID());
    }

    private static void mergeProfiles(UserServiceInitObject thisConfig, UserServiceInitObject newConfig, MergePolicy mergePolicy, Map<String, String> resourceIdMap) throws ServiceConfigurationException, IllegalArgumentException {
        String newResourceID = null;
        String thisResourceID = null;
        ProfileDomain newProfile = null;
        ProfileDomain thisProfile = null;
        String newApplicationName = null;
        String oldApplicationName = null;
        for (Map.Entry<String, ProfileDomain> mapEntry : newConfig.getProfiles().entrySet()) {
            boolean isSame;
            newApplicationName = mapEntry.getKey();
            newProfile = mapEntry.getValue();
            newResourceID = newProfile.getResourceID();
            thisProfile = thisConfig.getProfileUsingID(newResourceID);
            boolean bl = isSame = thisProfile != null;
            if (thisProfile == null) {
                thisProfile = thisConfig.getProfileForApplication(newApplicationName);
            }
            if (thisProfile == null) {
                thisConfig.addProfile(newApplicationName, newProfile);
                thisResourceID = newProfile.getResourceID();
            } else if (isSame) {
                oldApplicationName = thisConfig.getApplicationForProfile(thisProfile.getResourceID());
                if (!Strings.equal((String)newApplicationName, (String)oldApplicationName, (boolean)false, (boolean)false)) {
                    thisConfig.replaceProfileDomainApplication(oldApplicationName, newApplicationName);
                }
                thisProfile.merge(newProfile);
                thisResourceID = thisProfile.getResourceID();
            } else if (!newProfile.hasConflict(thisProfile)) {
                thisProfile.merge(newProfile);
                thisResourceID = thisProfile.getResourceID();
            } else if (mergePolicy.isOKToReplace()) {
                thisProfile.replace(newProfile);
                thisResourceID = thisProfile.getResourceID();
            } else {
                throw new ServiceConfigurationException(Message.format((ResourceBundle)RB.getResources(), (String)"UserServiceInitObject.conflictProfile.ex.fmt.txt", (Object)thisProfile.toString(), (Object)newProfile.toString()));
            }
            resourceIdMap.put(newResourceID, thisResourceID);
        }
    }

    private static void mergeUsers(UserServiceInitObject thisConfig, UserServiceInitObject newConfig, MergePolicy mergePolicy, Map<String, String> resourceIdMap) throws ServiceConfigurationException, IllegalArgumentException {
        String newResourceID = null;
        String thisResourceID = null;
        SimpleUserIdentity thisUser = null;
        for (SimpleUserIdentity newUser : newConfig.getUserList()) {
            boolean isSame;
            newResourceID = newUser.getResourceID();
            thisUser = thisConfig.getUserUsingID(newResourceID);
            boolean bl = isSame = thisUser != null;
            if (thisUser == null) {
                thisUser = thisConfig.getUserForPrincipal(newUser.getPrincipal(), newUser.getDomain());
            }
            if (thisUser == null) {
                thisConfig.addUser(newUser);
                thisResourceID = newUser.getResourceID();
            } else if (isSame || !newUser.hasConflict(thisUser)) {
                thisUser.merge(newUser);
                thisResourceID = thisUser.getResourceID();
            } else if (mergePolicy.isOKToReplace()) {
                thisUser.replace(newUser);
                thisResourceID = thisUser.getResourceID();
            } else {
                throw new ServiceConfigurationException(Message.format((ResourceBundle)RB.getResources(), (String)"UserServiceInitObject.conflictIdentity.ex.fmt.txt", (Object)thisUser.toString(), (Object)newUser.toString()));
            }
            resourceIdMap.put(newResourceID, thisResourceID);
        }
    }

    @Override
    protected void validateServiceConfigurationCustom(Document document) throws ServiceException {
        UserServiceInitializer.parse(document);
    }

    static void validate(Document document) throws ServiceConfigurationException {
        if (document == null) {
            throw new ServiceConfigurationException(RB.getStringResource("IllegalArgument.specifyDocument.ex.txt"));
        }
        Element docElement = document.getDocumentElement();
        String docElementName = docElement.getNodeName();
        if (!"UserService".equals(docElementName)) {
            throw new ServiceConfigurationException(Message.format((ResourceBundle)RB.getResources(), (String)"UserServiceInitObject.invalidConfigDocElement.ex.fmt.txt", (Object)"UserService", (Object)docElementName));
        }
    }

    @Override
    protected String getServiceFactoryClassName() {
        return UserServiceFactory.class.getName();
    }

    public Iterator<SimpleUserIdentity> getUsers() {
        return this.getUserList().iterator();
    }

    public void addUser(String id, String credential, String domain) throws ServiceConfigurationException {
        SimpleUserIdentity identity = new SimpleUserIdentity(id, credential, domain);
        this.addUser(identity);
    }

    public void addUser(SimpleUserIdentity identity) throws ServiceConfigurationException, IllegalArgumentException {
        this.addUser(identity, null);
    }

    private void addUser(SimpleUserIdentity identity, UserServiceInitObject mergeConfig) throws ServiceConfigurationException, IllegalArgumentException {
        if (identity == null) {
            throw new IllegalArgumentException(RB.getStringResource("UserServiceInitObject.mustSpecifyIdentity.ex.txt"));
        }
        List<SimpleUserIdentity> userList = this.getUserList();
        boolean isAlreadyDefined = false;
        Object identityPrincipal = identity.getPrincipal();
        if (userList.size() > 0) {
            Iterator<SimpleUserIdentity> iter = userList.iterator();
            SimpleUserIdentity userIdentity = null;
            while (iter.hasNext()) {
                userIdentity = iter.next();
                if (identity.equals(userIdentity)) {
                    isAlreadyDefined = true;
                    break;
                }
                if (identity.getResourceID().equals(userIdentity.getResourceID())) {
                    if (identity == userIdentity) continue;
                    iter.remove();
                    continue;
                }
                if (!identityPrincipal.equals(userIdentity.getPrincipal())) continue;
                throw new ServiceConfigurationException(mergeConfig == null ? Message.format((ResourceBundle)RB.getResources(), (String)"UserServiceInitObject.unableToAddIdentityPrincialAlreadyDefined.ex.fmt.txt", (Object)identityPrincipal) : Message.format((ResourceBundle)RB.getResources(), (String)"UserServiceInitObject.conflictIdentity.ex.fmt.txt", (Object)identityPrincipal, (Object)this.getConfigName(), (Object)mergeConfig.getConfigName(), (Object)userIdentity.toString(), (Object)identity.toString()));
            }
        }
        if (!isAlreadyDefined) {
            if (!userList.add(identity)) {
                throw new ServiceConfigurationException(Message.format((ResourceBundle)RB.getResources(), (String)"UserServiceInitObject.unableToAddIdentity.ex.fmt.txt", (Object)identity.getPrincipal()));
            }
            this.addResource(identity);
        }
    }

    public void addProfile(String application, String domain, String className, String type, String filter) throws IllegalArgumentException {
        ProfileDomain profile = new ProfileDomain(domain, type, filter, className);
        this.addProfile(application, profile);
    }

    public boolean addProfile(String application, ProfileDomain profile) throws IllegalArgumentException {
        if (application == null || application.trim().length() == 0) {
            throw new IllegalArgumentException(RB.getStringResource("UserServiceInitObject.mustSpecifyProfileApplication.ex.txt"));
        }
        if (profile == null) {
            throw new IllegalArgumentException(RB.getStringResource("UserServiceInitObject.mustSpecifyProfile.ex.txt"));
        }
        Map<String, ProfileDomain> profiles = this.getProfiles();
        boolean wasAdded = false;
        ProfileDomain profileDomain = profiles.get(application);
        if (profileDomain == null) {
            profiles.put(application, profile);
            this.addResource(new ProfileDomainResourceAdapter(application, profile));
            wasAdded = true;
        } else if (profileDomain.getResourceID().equals(profile.getResourceID())) {
            try {
                if (profileDomain != profile) {
                    HashSet<ConsumedResourceInterface> removedConsumedResources = new HashSet<ConsumedResourceInterface>(5);
                    ProfileDomain oldProfileDomain = profiles.get(application);
                    if (oldProfileDomain instanceof ConsumedResourceInterface) {
                        this.removeResource(oldProfileDomain.getResourceID(), removedConsumedResources);
                    }
                    profiles.remove(application);
                    profiles.put(application, profile);
                    this.addResource(new ProfileDomainResourceAdapter(application, profile));
                }
                wasAdded = true;
            }
            catch (ServiceException e) {
                wasAdded = false;
            }
        } else {
            wasAdded = profileDomain.equals(profile);
        }
        return wasAdded;
    }

    public void removeApplicationProfile(String applicationName) throws ServiceException {
        ProfileDomain profileDomain = this._profileDefs.get(applicationName);
        if (profileDomain != null) {
            HashSet<ConsumedResourceInterface> removedConsumedResources = new HashSet<ConsumedResourceInterface>(1);
            this.removeResource(profileDomain.getResourceID(), removedConsumedResources);
        }
    }

    public void changeApplicationForProfileDomain(ProfileDomain profileDomain, String oldApplicationName, String newApplicationName) throws ServiceException {
        if (profileDomain != null) {
            if (!this.addProfile(newApplicationName, profileDomain)) {
                throw new ServiceConfigurationException(Message.format((ResourceBundle)RB.getResources(), (String)"UserServiceInitObject.addProfile.ex.fmt.txt", (Object)newApplicationName, (Object)profileDomain.toString()));
            }
            this.removeApplicationProfile(oldApplicationName);
            ProfileDomainResourceAdapter profileDomainAdapter = (ProfileDomainResourceAdapter)this.getConsumerUsage().getResourceUsingUID(profileDomain.getResourceID());
            if (profileDomainAdapter != null) {
                profileDomainAdapter.setApplicationName(newApplicationName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeApplicationProfiles(Collection<String> applicationNames) throws ServiceException {
        block11: {
            RuntimeException ex = null;
            try {
                if (applicationNames != null) {
                    for (String applicationName : applicationNames) {
                        this.removeApplicationProfile(applicationName);
                    }
                }
            }
            catch (UnsupportedOperationException e) {
                ex = e;
            }
            catch (ClassCastException e) {
                ex = e;
            }
            catch (NullPointerException e) {
                ex = e;
            }
            finally {
                if (ex == null) break block11;
                throw new ServiceException(ex, ex.getLocalizedMessage());
            }
        }
    }

    public void removeProfiles(Collection<String> applicationNames) throws Exception {
        this.removeApplicationProfiles(applicationNames);
    }

    public boolean removeUsers(SimpleUserIdentity[] users) {
        boolean isOk = true;
        if (users != null) {
            try {
                int numUsers = users.length;
                HashSet<ConsumedResourceInterface> removedConsumedResoruces = new HashSet<ConsumedResourceInterface>(numUsers);
                SimpleUserIdentity user = null;
                for (int i = 0; i < numUsers; ++i) {
                    user = users[i];
                    if (user == null) continue;
                    isOk = isOk && this.removeResource(user.getResourceID(), removedConsumedResoruces) != null;
                }
            }
            catch (ServiceException e) {
                isOk = false;
            }
        }
        return isOk;
    }

    @Override
    public Consumer removeConsumer(Consumer consumer, boolean isRemoveResourceIfUnused) throws ServiceException {
        Consumer removedConsumer = super.removeConsumer(consumer, isRemoveResourceIfUnused);
        if (isRemoveResourceIfUnused) {
            ConsumerUsage consumerUsage = this.getConsumerUsage();
            if (consumerUsage.getConsumersForResource("AuthDomain", true).size() == 0) {
                this.setDomain(null);
            }
            if (consumerUsage.getConsumersForResource("LDAPBaseCredential", true).size() == 0) {
                this.setCredentialBase(null);
            }
            if (consumerUsage.getConsumersForResource("LDAPBaseGroup", true).size() == 0) {
                this.setGroupBase(null);
            }
            if (consumerUsage.getConsumersForResource("LDAPBasePerson", true).size() == 0) {
                this.setPersonBase(null);
            }
        }
        return removedConsumer;
    }

    @Override
    public ConsumedResourceInterface removeResource(String resourceID, Set<ConsumedResourceInterface> removedConsumedResources) throws ServiceException {
        ConsumedResourceInterface consumedResource;
        ConsumerUsage consumerUsage = this.getConsumerUsage();
        if (resourceID != null && (consumedResource = consumerUsage.getResourceUsingUID(resourceID)) != null) {
            switch (consumedResource.getResourceTypeCode()) {
                case 4: {
                    this.removeProfileForID(resourceID, removedConsumedResources);
                    break;
                }
                case 5: {
                    this.removeUserForID(resourceID, removedConsumedResources);
                    break;
                }
            }
        }
        return super.removeResource(resourceID, removedConsumedResources);
    }

    @Override
    public String getConfirmDeleteUnusedResourcesMsg() {
        return RB.getStringResource("UserServiceInitObject.confirmRemovalUnusedResources.txt");
    }

    @Override
    public String getConfirmDeleteUnusedResourceMsg(ConsumedResourceInterface consumedResource) {
        String msg = null;
        int code = consumedResource.getResourceTypeCode();
        switch (code) {
            case 3: {
                msg = RB.getStringResource("SessionServiceInitObject.confirmRemovalUnusedTimeout.txt");
                break;
            }
            case 0: {
                msg = RB.getStringResource("SessionServiceInitObject.confirmRemovalUnusedContext.txt");
                break;
            }
            case 1: {
                msg = RB.getStringResource("SessionServiceInitObject.confirmRemovalUnusedContext.txt");
                break;
            }
            case 2: {
                msg = RB.getStringResource("SessionServiceInitObject.confirmRemovalUnusedContext.txt");
                break;
            }
            default: {
                msg = super.getConfirmDeleteUnusedResourceMsg(consumedResource);
            }
        }
        return msg;
    }

    private ProfileDomain removeProfileForID(String resourceID, Set<ConsumedResourceInterface> removedConsumedResources) {
        ProfileDomain removedObject = null;
        if (resourceID != null) {
            ProfileDomain nextProfileDomain = null;
            Iterator<ProfileDomain> iter = this._profileDefs.values().iterator();
            while (iter.hasNext()) {
                nextProfileDomain = iter.next();
                if (!resourceID.equals(nextProfileDomain.getResourceID())) continue;
                removedObject = nextProfileDomain;
                iter.remove();
                removedConsumedResources.add(nextProfileDomain);
                break;
            }
        }
        return removedObject;
    }

    private SimpleUserIdentity removeUserForID(String resourceID, Set<ConsumedResourceInterface> removedConsumedResources) {
        SimpleUserIdentity removedObject = null;
        if (resourceID != null) {
            SimpleUserIdentity nextUser = null;
            Iterator<SimpleUserIdentity> iter = this._users.iterator();
            while (iter.hasNext()) {
                nextUser = iter.next();
                if (!resourceID.equals(nextUser.getResourceID())) continue;
                removedObject = nextUser;
                iter.remove();
                removedConsumedResources.add(nextUser);
                break;
            }
        }
        return removedObject;
    }

    public List<SimpleUserIdentity> getUserList() {
        if (this._users == null) {
            this._users = new ArrayList<SimpleUserIdentity>(8);
        }
        return this._users;
    }

    public Map<String, ProfileDomain> getProfiles() {
        if (this._profileDefs == null) {
            this._profileDefs = new HashMap<String, ProfileDomain>(12);
        }
        return this._profileDefs;
    }

    public void setPersonBase(String base) {
        String value;
        String type = "LDAPBasePerson";
        ConsumedResourceAdapter cra = this.getConsumedResourceAdapter("LDAPBasePerson");
        String string = value = base == null ? "" : base;
        if (cra == null) {
            cra = new ConsumedResourceAdapter("LDAPBasePerson", value, "LDAPBasePerson", 2, RB.getStringResource("ConsumedResourceAdapter.ldapBasePerson.type.txt"), true);
            this.addResourceAdapter(cra);
        } else {
            cra.setResourceValue(value);
        }
        this._personBase = value;
    }

    public String getPersonBase() {
        ConsumedResourceAdapter cra = this.getConsumedResourceAdapter("LDAPBasePerson");
        String value = cra == null ? "" : cra.getResourceValue();
        return value == null ? "" : value;
    }

    public void setGroupBase(String base) {
        String value;
        String type = "LDAPBaseGroup";
        ConsumedResourceAdapter cra = this.getConsumedResourceAdapter("LDAPBaseGroup");
        String string = value = base == null ? "" : base;
        if (cra == null) {
            cra = new ConsumedResourceAdapter("LDAPBaseGroup", value, "LDAPBaseGroup", 1, RB.getStringResource("ConsumedResourceAdapter.ldapBaseGroup.type.txt"), true);
            this.addResourceAdapter(cra);
        } else {
            cra.setResourceValue(value);
        }
        this._groupBase = value;
    }

    public String getGroupBase() {
        ConsumedResourceAdapter cra = this.getConsumedResourceAdapter("LDAPBaseGroup");
        String value = cra == null ? "" : cra.getResourceValue();
        return value == null ? "" : value;
    }

    public void setCredentialBase(String base) {
        String value;
        String type = "LDAPBaseCredential";
        ConsumedResourceAdapter cra = this.getConsumedResourceAdapter("LDAPBaseCredential");
        String string = value = base == null ? "" : base;
        if (cra == null) {
            cra = new ConsumedResourceAdapter("LDAPBaseCredential", value, "LDAPBaseCredential", 0, RB.getStringResource("ConsumedResourceAdapter.ldapBaseCredential.type.txt"), true);
            this.addResourceAdapter(cra);
        } else {
            cra.setResourceValue(value);
        }
        this._credBase = value;
    }

    public String getCredentialBase() {
        ConsumedResourceAdapter cra = this.getConsumedResourceAdapter("LDAPBaseCredential");
        String value = cra == null ? "" : cra.getResourceValue();
        return value == null ? "" : value;
    }

    public void setDomain(String domain) {
        String value;
        String type = "AuthDomain";
        ConsumedResourceAdapter cra = this.getConsumedResourceAdapter("AuthDomain");
        String string = value = domain == null ? "" : domain;
        if (cra == null) {
            cra = new ConsumedResourceAdapter("AuthDomain", value, "AuthDomain", 3, RB.getStringResource("ConsumedResourceAdapter.authDomain.type.txt"), true);
            this.addResourceAdapter(cra);
        } else {
            cra.setResourceValue(value);
        }
        this._domain = value;
    }

    public String getDomain() {
        ConsumedResourceAdapter cra = this.getConsumedResourceAdapter("AuthDomain");
        String value = cra == null ? "" : cra.getResourceValue();
        return value == null ? "" : value;
    }

    public Set<SimpleUserIdentity> getUsers(String id) {
        HashSet<SimpleUserIdentity> users = new HashSet<SimpleUserIdentity>(1);
        if (id != null && this._users != null) {
            Object o = null;
            for (SimpleUserIdentity user : this._users) {
                o = user.getPrincipal();
                if (!(o instanceof String) || !Strings.equal((String)id, (String)((String)o), (boolean)false, (boolean)false)) continue;
                users.add(user);
                break;
            }
        }
        return users;
    }

    public Set<ProfileDomain> getProfiles(String application) {
        ProfileDomain o;
        HashSet<ProfileDomain> profiles = new HashSet<ProfileDomain>(1);
        if (application != null && this._profileDefs != null && (o = this._profileDefs.get(application)) != null) {
            profiles.add(o);
        }
        return profiles;
    }

    public ProfileDomain getProfileForApplication(String application) {
        return this._profileDefs.get(application);
    }

    public ProfileDomain getProfileUsingID(String uid) {
        ProfileDomain profileDomain = null;
        if (uid != null) {
            for (ProfileDomain aProfileDomain : this._profileDefs.values()) {
                if (!uid.equals(aProfileDomain.getResourceID())) continue;
                profileDomain = aProfileDomain;
                break;
            }
        }
        return profileDomain;
    }

    public Set<String> getApplicationsForProfile(String profileDomainID) {
        HashSet<String> applicationNames = new HashSet<String>(5);
        if (profileDomainID != null) {
            ProfileDomain aProfileDomain = null;
            for (Map.Entry<String, ProfileDomain> mapEntry : this._profileDefs.entrySet()) {
                aProfileDomain = mapEntry.getValue();
                if (!profileDomainID.equals(aProfileDomain.getResourceID())) continue;
                applicationNames.add(mapEntry.getKey());
            }
        }
        return applicationNames;
    }

    public String getApplicationForProfile(String profileDomainID) {
        String applicationName = null;
        if (profileDomainID != null) {
            ProfileDomain aProfileDomain = null;
            for (Map.Entry<String, ProfileDomain> mapEntry : this._profileDefs.entrySet()) {
                aProfileDomain = mapEntry.getValue();
                if (!profileDomainID.equals(aProfileDomain.getResourceID())) continue;
                applicationName = mapEntry.getKey();
                break;
            }
        }
        return applicationName;
    }

    @Override
    public DocumentFragment appendDOM(Document document) {
        return UserServiceInitObject.appendDOM(document, this);
    }

    @Override
    protected DocumentFragment appendDOM(Document document, AbstractServiceComponentConfig serviceConfig) throws ServiceConfigurationException, IllegalArgumentException {
        DocumentFragment documentFragment = null;
        try {
            documentFragment = UserServiceInitObject.appendDOM(document, (UserServiceInitObject)serviceConfig);
        }
        catch (ClassCastException e) {
            throw new ServiceConfigurationException(e, e.getLocalizedMessage());
        }
        return documentFragment;
    }

    private static DocumentFragment appendDOM(Document document, UserServiceInitObject userServiceInitObject) {
        Element element;
        DocumentFragment documentFragment = null;
        if (document != null && (element = document.getDocumentElement()) != null && Strings.equal((String)element.getNodeName(), (String)"UserService", (boolean)false, (boolean)false)) {
            String value = userServiceInitObject.getDomain();
            value = value != null ? value.trim() : "";
            element.setAttribute("domain", value);
            value = userServiceInitObject.getCredentialBase();
            value = value != null ? value.trim() : "";
            element.setAttribute("credentialbase", value);
            value = userServiceInitObject.getGroupBase();
            value = value != null ? value.trim() : "";
            element.setAttribute("groupbase", value);
            value = userServiceInitObject.getPersonBase();
            value = value != null ? value.trim() : "";
            element.setAttribute("personbase", value);
            UserServiceInitObject.appendUsersToDOM(document, userServiceInitObject);
            UserServiceInitObject.appendProfilesToDOM(document, userServiceInitObject);
        }
        return documentFragment;
    }

    private static void appendProfilesToDOM(Document document, UserServiceInitObject userServiceInitObject) {
        Element elementUserService;
        Element element = elementUserService = document != null ? document.getDocumentElement() : null;
        if (elementUserService != null) {
            Map<String, ProfileDomain> profiles = userServiceInitObject.getProfiles();
            Set<String> applications = profiles.keySet();
            Collections.sort(new ArrayList<String>(applications));
            for (String applicationName : applications) {
                ProfileDomain profileDomain = profiles.get(applicationName);
                if (null == profileDomain) continue;
                Element elementProfile = document.createElement("Profile");
                elementProfile.setAttribute("Application", applicationName);
                elementProfile.setAttribute("uid", profileDomain.getResourceID());
                elementProfile.setAttribute("url", profileDomain.getUrl());
                elementProfile.setAttribute("class", profileDomain.getClassName());
                elementProfile.setAttribute("type", profileDomain.getType());
                elementProfile.setAttribute("filter", profileDomain.getFilter());
                elementUserService.appendChild(elementProfile);
            }
        }
    }

    private static void appendUsersToDOM(Document document, UserServiceInitObject userServiceInitObject) {
        Element elementUserService;
        Element element = elementUserService = document != null ? document.getDocumentElement() : null;
        if (elementUserService != null) {
            Iterator<SimpleUserIdentity> iter = userServiceInitObject.getUsers();
            SimpleUserIdentity userIdentity = null;
            Element elementUserContext = null;
            String resourceID = null;
            Object value = null;
            while (iter.hasNext()) {
                userIdentity = iter.next();
                elementUserContext = document.createElement("UserContext");
                resourceID = userIdentity.getResourceID();
                if (null != resourceID) {
                    elementUserContext.setAttribute("uid", resourceID);
                }
                if ((value = userIdentity.getPrincipal()) instanceof String) {
                    elementUserContext.setAttribute("userid", (String)value);
                }
                if ((value = userIdentity.getCredential()) instanceof String) {
                    String inValue;
                    String outValue = inValue = (String)value;
                    if (inValue != null && !SasPasswordString.isEncoded((String)inValue)) {
                        try {
                            outValue = SasPasswordString.encode((String)inValue);
                        }
                        catch (SasPasswordEncodingException spee) {
                            outValue = inValue;
                        }
                    }
                    elementUserContext.setAttribute("password", outValue);
                }
                elementUserContext.setAttribute("domain", userIdentity.getDomain());
                elementUserService.appendChild(elementUserContext);
            }
        }
    }

    @Override
    protected AbstractServiceComponentConfig getConfig(Document serviceConfigDocument) throws ServiceConfigurationException, IllegalArgumentException {
        return serviceConfigDocument != null ? UserServiceInitializer.parse(serviceConfigDocument) : new UserServiceInitObject();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        UserServiceInitObject config = (UserServiceInitObject)super.clone();
        List<SimpleUserIdentity> usersList = this.getUserList();
        config._users = new ArrayList<SimpleUserIdentity>(usersList.size());
        for (SimpleUserIdentity user : usersList) {
            config._users.add((SimpleUserIdentity)user.clone());
        }
        Map<String, ProfileDomain> profileMap = this.getProfiles();
        config._profileDefs = new HashMap<String, ProfileDomain>(profileMap.size());
        for (Map.Entry<String, ProfileDomain> mapEntry : profileMap.entrySet()) {
            config._profileDefs.put(mapEntry.getKey(), (ProfileDomain)mapEntry.getValue().clone());
        }
        return config;
    }

    public UserServiceInitObject cloneConfig() {
        UserServiceInitObject clone = null;
        try {
            clone = (UserServiceInitObject)this.clone();
        }
        catch (CloneNotSupportedException e) {
            clone = null;
        }
        return clone;
    }

    public boolean equals(Object o) {
        boolean isEqual = false;
        if (this == o) {
            isEqual = true;
        } else if (o != null && o.getClass() == this.getClass()) {
            UserServiceInitObject usio = (UserServiceInitObject)o;
            boolean bl = isEqual = Strings.equal((String)this.getCredentialBase(), (String)usio.getCredentialBase(), (boolean)false, (boolean)false) && Strings.equal((String)this.getDomain(), (String)usio.getDomain(), (boolean)false, (boolean)false) && Strings.equal((String)this.getGroupBase(), (String)usio.getGroupBase(), (boolean)false, (boolean)false) && Strings.equal((String)this.getPersonBase(), (String)usio.getPersonBase(), (boolean)false, (boolean)false);
            if (isEqual) {
                if (this._users != null) {
                    isEqual = this._users.equals(usio._users);
                } else if (usio._users != null) {
                    isEqual = false;
                }
            }
            if (isEqual) {
                if (this._profileDefs != null) {
                    isEqual = this._profileDefs.equals(usio._profileDefs);
                } else if (usio._profileDefs != null) {
                    isEqual = false;
                }
            }
        }
        return isEqual;
    }

    public int hashCode() {
        int hashCode = 5;
        String domain = this.getDomain();
        String personBase = this.getPersonBase();
        String groupBase = this.getGroupBase();
        String credBase = this.getCredentialBase();
        int primeNumber = this.getPrimeNumber();
        hashCode = primeNumber * hashCode + (credBase == null ? 0 : credBase.hashCode());
        hashCode = primeNumber * hashCode + (domain == null ? 0 : domain.hashCode());
        hashCode = primeNumber * hashCode + (groupBase == null ? 0 : groupBase.hashCode());
        hashCode = primeNumber * hashCode + (personBase == null ? 0 : personBase.hashCode());
        hashCode = primeNumber * hashCode + (this._profileDefs == null ? 0 : this._profileDefs.hashCode());
        hashCode = primeNumber * hashCode + (this._users == null ? 0 : this._users.hashCode());
        return hashCode;
    }
}

