/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.user;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.user.CredentialPermission;
import com.sas.services.user.RB;
import com.sas.text.Message;
import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.ResourceBundle;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public final class CredentialPermissionCollection
extends PermissionCollection
implements Serializable {
    private static final long serialVersionUID = -4023755556366636806L;
    private boolean all_allowed = false;

    @Override
    public void add(Permission permission) {
        if (!(permission instanceof CredentialPermission)) {
            throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"CredentialPermission.badpermission.ex.fmt.txt", (Object)permission));
        }
        if (this.isReadOnly()) {
            throw new SecurityException(RB.getStringResource("CredentialPermission.readonly.ex.txt"));
        }
        this.all_allowed = true;
    }

    @Override
    public boolean implies(Permission permission) {
        return this.all_allowed;
    }

    public Enumeration elements() {
        return new Enumeration(){
            private boolean hasMore;
            {
                this.hasMore = CredentialPermissionCollection.this.all_allowed;
            }

            @Override
            public boolean hasMoreElements() {
                return this.hasMore;
            }

            public Object nextElement() {
                this.hasMore = false;
                return new CredentialPermission();
            }
        };
    }
}

