/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.session;

import com.sas.codepolicy.SASScope;
import com.sas.services.ServiceException;
import com.sas.services.session.RB;
import com.sas.services.session.SessionService;
import com.sas.services.session.SessionServiceFactory;
import com.sas.services.session.SummaryDataInterface;
import com.sas.services.util.AbstractMBean;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.TimeZone;
import javax.management.MBeanParameterInfo;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope
public class SessionServiceMBean
extends AbstractMBean {
    public static final String[] SUMMARY_DATA_NAMES = new String[]{"User name", "Session Context Identifier", "Email", "Login Time", "User Context Identifier"};
    public static final String[] SUMMARY_DATA_DESCRIPTIONS = new String[]{RB.getStringResource("SessionServiceMBean.userDescription.txt"), RB.getStringResource("SessionServiceMBean.sessionIdDescription.txt"), RB.getStringResource("SessionServiceMBean.emailDescription.txt"), RB.getStringResource("SessionServiceMBean.loginTimeDescription.txt"), RB.getStringResource("SessionServiceMBean.userIdDescription.txt")};
    public static final OpenType[] SUMMARY_DATA_TYPES = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING};
    public static final String[] SUMMARY_DATA_INDEX_NAMES = new String[]{"Session Context Identifier"};
    public static final String SUMMARY_COMPOSITETYPE_NAME = "com.sas.services.session.SummaryDataCt";
    public static final String SUMMARY_COMPOSITETYPE_DESCRIPTION = RB.getStringResource("SessionServiceMBean.summaryCompositeDescription.txt");
    public static final String SUMMARY_TABULARTYPE_NAME = "com.sas.services.session.SummaryDataTt";
    public static final String SUMMARY_TABULARTYPE_DESCRIPTION = RB.getStringResource("SessionServiceMBean.summaryTabularDescription.txt");
    private static final String QUIESCE_METHOD_NAME = "quiesce";
    private static final String IS_QUIESCED_METHOD_NAME = "isQuiesced";
    private static final String DESTROY_SESSIONS_METHOD_NAME = "destroySessions";
    private static final String RESUME_METHOD_NAME = "resume";
    private static final String SESSION_SUMMARYDATA_ATTRIBUTE_NAME = "SessionSummaryData";
    private static final String DESTROY_SESSION_METHOD_NAME = "destroySession";
    private final String STRING_CLASS_NAME = String.class.getName();
    private final String BOOLEAN_CLASS_NAME = Boolean.class.getName();
    static final String MBEAN_DESCRIPTION = RB.getStringResource("SessionServiceMBean.mBeanDescription.txt");
    private final String QUIESCE_DESCRIPTION = RB.getStringResource("SessionServiceMBean.quiesceDescription.txt");
    private final String IS_QUIESCED_DESCRIPTION = RB.getStringResource("SessionServiceMBean.isQuiescedDescription.txt");
    private final String DESTROY_SESSIONS_DESCRIPTION = RB.getStringResource("SessionServiceMBean.destroySessionsDescription.txt");
    private final String RESUME_DESCRIPTION = RB.getStringResource("SessionServiceMBean.resumeDescription.txt");
    private final String SESSION_SUMMARYDATA_DESCRIPTION = RB.getStringResource("SessionServiceMBean.sessionSummaryDescription.txt");
    private final String DESTROY_SESSION_DESCRIPTION = RB.getStringResource("SessionServiceMBean.destroySessionDescription.txt");
    private final String SESSIONCONTEXT_ID_PARM_NAME = RB.getStringResource("SessionServiceMBean.contextIdParmName.txt");
    final String SESSIONCONTEXT_ID_PARM_DESCRIPTION = RB.getStringResource("SessionServiceMBean.contextIdParmDescription.txt");
    public static final String RB_KEY = "SessionServiceMBean.";
    private static final int INIT_BUFSIZE = 100;
    private Logger _logger = LogManager.getLogger(SessionServiceMBean.class);
    private SessionService _sessionService;

    @Override
    protected Object getTargetObject() {
        this.initTargetObject();
        return this;
    }

    private void initTargetObject() {
        if (this._sessionService == null) {
            try {
                this._sessionService = (SessionService)new SessionServiceFactory().getService(null);
            }
            catch (Exception e) {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"SessionServiceMBean.exceptionGetService.fmt.txt", (Object)e.toString());
                throw (IllegalArgumentException)new IllegalArgumentException(msg).initCause(e);
            }
            catch (Error e) {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"SessionServiceMBean.errorGetService.fmt.txt", (Object)e.toString());
                throw (IllegalArgumentException)new IllegalArgumentException(msg).initCause(e);
            }
        }
    }

    SessionServiceMBean() {
        super(MBEAN_DESCRIPTION);
        this.addMBeanOperation(IS_QUIESCED_METHOD_NAME, this.IS_QUIESCED_DESCRIPTION, null, this.BOOLEAN_CLASS_NAME, 0);
        this.addMBeanOperation(QUIESCE_METHOD_NAME, this.QUIESCE_DESCRIPTION, null, "void", 1);
        this.addMBeanOperation(RESUME_METHOD_NAME, this.RESUME_DESCRIPTION, null, "void", 1);
        this.addMBeanOperation(DESTROY_SESSIONS_METHOD_NAME, this.DESTROY_SESSIONS_DESCRIPTION, null, "void", 1);
        this.addMBeanAttribute(SESSION_SUMMARYDATA_ATTRIBUTE_NAME, "javax.management.openmbean.TabularData", true, false, false, this.SESSION_SUMMARYDATA_DESCRIPTION);
        this.addMBeanOperation(DESTROY_SESSION_METHOD_NAME, this.DESTROY_SESSION_DESCRIPTION, new MBeanParameterInfo[]{new MBeanParameterInfo(this.SESSIONCONTEXT_ID_PARM_NAME, this.STRING_CLASS_NAME, this.SESSIONCONTEXT_ID_PARM_DESCRIPTION)}, "void", 1);
    }

    public boolean isQuiesced() throws RemoteException {
        return this._sessionService.isQuiesced();
    }

    public TabularData getSessionSummaryData() throws Exception {
        TabularDataSupport td = null;
        try {
            List list = this._sessionService.invokeGetSummaryData(null, false);
            TabularType dataTypes = null;
            CompositeType dataType = null;
            dataType = new CompositeType(SUMMARY_COMPOSITETYPE_NAME, SUMMARY_COMPOSITETYPE_DESCRIPTION, SUMMARY_DATA_NAMES, SUMMARY_DATA_DESCRIPTIONS, SUMMARY_DATA_TYPES);
            dataTypes = new TabularType(SUMMARY_TABULARTYPE_NAME, SUMMARY_TABULARTYPE_DESCRIPTION, dataType, SUMMARY_DATA_INDEX_NAMES);
            td = new TabularDataSupport(dataTypes);
            for (SummaryDataInterface sd : list) {
                Iterator eitor = sd.getEmailAddresses().iterator();
                StringBuffer buf = new StringBuffer(100);
                while (eitor.hasNext()) {
                    buf.append(eitor.next());
                    buf.append("  ");
                }
                Date d = new Date();
                d.setTime(sd.getLoginTime());
                SimpleDateFormat s = new SimpleDateFormat("ddMMMyyyy:HH:mm:ss z");
                s.setTimeZone(TimeZone.getTimeZone("GMT"));
                String timeAsStr = s.format(d);
                Object[] itemValues = new Object[]{sd.getUsername(), sd.getSessionContextUniqueId(), buf.toString(), timeAsStr, sd.getUniqueId()};
                CompositeDataSupport result = new CompositeDataSupport(dataType, SUMMARY_DATA_NAMES, itemValues);
                td.put(result);
            }
        }
        catch (Exception e) {
            if (this._logger != null) {
                this._logger.warn(RB.getStringResource(RB_KEY, "jmxSummaryDataError.txt"), (Throwable)e);
            }
            throw e;
        }
        return td;
    }

    public void destroySession(String sessionContextId) throws Exception {
        try {
            boolean b = this._sessionService.invokeDestroySession(null, sessionContextId, false);
            if (!b) {
                throw new Exception(RB.getStringResource(RB_KEY, "invalidId.txt"));
            }
        }
        catch (Exception e) {
            if (this._logger != null) {
                this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"SessionServiceMBean.jmxDestroySessionError.fmt.txt", (Object)sessionContextId));
            }
            throw e;
        }
    }

    public void destroySessions() throws Exception {
        try {
            this._sessionService.invokeDestroySessions(null, false);
        }
        catch (Exception e) {
            if (this._logger != null) {
                this._logger.warn(RB.getStringResource(RB_KEY, "jmxDestroySessionsError.txt"), (Throwable)e);
            }
            throw e;
        }
    }

    public void quiesce() throws Exception {
        try {
            this._sessionService.invokeQuiesce(null, false);
        }
        catch (ServiceException e) {
            if (this._logger != null) {
                this._logger.warn(RB.getStringResource(RB_KEY, "jmxQuiesceError.txt"), (Throwable)((Object)e));
            }
            throw new Exception(e.getLocalizedMessage());
        }
    }

    public void resume() throws Exception {
        try {
            this._sessionService.invokeResume(null, false);
        }
        catch (ServiceException e) {
            if (this._logger != null) {
                this._logger.warn(RB.getStringResource(RB_KEY, "jmxResumeError.txt"), (Throwable)((Object)e));
            }
            throw new Exception(e.getLocalizedMessage());
        }
    }
}

