/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.session;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.AbstractServiceComponentConfig;
import com.sas.services.MergePolicy;
import com.sas.services.ServiceConfigurationException;
import com.sas.services.ServiceException;
import com.sas.services.deployment.ConsumedResourceAdapter;
import com.sas.services.deployment.ConsumedResourceInterface;
import com.sas.services.deployment.Consumer;
import com.sas.services.deployment.ConsumerResourceAssoc;
import com.sas.services.deployment.ConsumerUsage;
import com.sas.services.session.RB;
import com.sas.services.session.SessionServiceFactory;
import com.sas.services.session.SessionServiceInitializer;
import com.sas.text.Message;
import com.sas.util.Strings;
import com.sas.util.UsageVersion;
import java.io.InputStream;
import java.util.HashMap;
import java.util.ResourceBundle;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public final class SessionServiceInitObject
extends AbstractServiceComponentConfig {
    private static final boolean IS_CONFIGURATION_UPDATEABLE = true;
    private static final UsageVersion USAGEVERSION_OLDEST = new UsageVersion(0, 0);
    private static final UsageVersion USAGEVERSION_CURRENT = new UsageVersion(0, 0);
    private static final long MSEC_PER_MINUTE = 60000L;
    private String _defaultUserContextName;
    private Long _sessionContextTimeoutMsec;

    public SessionServiceInitObject() {
        super(SessionServiceInitializer.getXMLDocument(), true);
        this.setUsageVersionCompatibility(USAGEVERSION_OLDEST, USAGEVERSION_CURRENT);
        this.setSessionContextTimeout(null);
        this.setUserContextName(null);
    }

    public SessionServiceInitObject(InputStream configInputStream) throws IllegalArgumentException {
        super(configInputStream, true);
        this.setUsageVersionCompatibility(USAGEVERSION_OLDEST, USAGEVERSION_CURRENT);
        this.setSessionContextTimeout(null);
        this.setUserContextName(null);
    }

    public SessionServiceInitObject(String defaultUser) {
        this();
        this.setUserContextName(defaultUser);
    }

    @Override
    protected AbstractServiceComponentConfig createConfiguration(Document document) throws ServiceException {
        return SessionServiceInitializer.parse(document);
    }

    @Override
    public String getConfirmDeleteUnusedResourcesMsg() {
        return RB.getStringResource("SessionServiceInitObject.confirmRemovalUnusedResources.txt");
    }

    @Override
    public String getConfirmDeleteUnusedResourceMsg(ConsumedResourceInterface consumedResource) {
        String msg = null;
        int code = consumedResource.getResourceTypeCode();
        switch (code) {
            case 1: {
                msg = RB.getStringResource("SessionServiceInitObject.confirmRemovalUnusedTimeout.txt");
                break;
            }
            case 0: {
                msg = RB.getStringResource("SessionServiceInitObject.confirmRemovalUnusedContext.txt");
                break;
            }
            default: {
                msg = super.getConfirmDeleteUnusedResourceMsg(consumedResource);
            }
        }
        return msg;
    }

    public void setUserContextName(String defaultUserContextName) {
        String userContextName = defaultUserContextName == null ? "" : defaultUserContextName.trim();
        String resourceID = "userContextName";
        ConsumedResourceAdapter cra = this.getConsumedResourceAdapter("userContextName");
        if (cra == null) {
            cra = new ConsumedResourceAdapter("userContextName", userContextName, "userContextName", 0, RB.getStringResource("SessionServiceInitObject.typeUserContext.txt"), true);
            this.addResourceAdapter(cra);
        } else {
            cra.setResourceValue(userContextName);
        }
        this._defaultUserContextName = userContextName;
    }

    public String getUserContextName() {
        ConsumedResourceAdapter cra = this.getConsumedResourceAdapter("userContextName");
        return cra == null ? null : cra.getResourceValue();
    }

    public void setSessionContextTimeout(Long sessionContextTimeoutMsec) {
        String timeoutMinutes;
        String resourceID = "sessionContextTimeout";
        ConsumedResourceAdapter cra = this.getConsumedResourceAdapter("sessionContextTimeout");
        String string = timeoutMinutes = sessionContextTimeoutMsec == null ? "" : Long.valueOf(sessionContextTimeoutMsec / 60000L).toString();
        if (cra == null) {
            cra = new ConsumedResourceAdapter("sessionContextTimeout", timeoutMinutes, "sessionContextTimeout", 1, RB.getStringResource("SessionServiceInitObject.typeSessionContextTimeout.txt"), true);
            this.addResourceAdapter(cra);
        } else {
            cra.setResourceValue(timeoutMinutes);
        }
        this._sessionContextTimeoutMsec = sessionContextTimeoutMsec;
    }

    public void setSessionContextTimeoutMinutes(Long sessionContextTimeoutMinutes) {
        this.setSessionContextTimeout(sessionContextTimeoutMinutes == null ? null : SessionServiceInitObject.convertMinutesToMsec(sessionContextTimeoutMinutes));
    }

    public static Long convertMinutesToMsec(Long minutes) {
        return minutes == null || minutes < 1L ? Long.valueOf(-1L) : Long.valueOf(minutes * 60000L);
    }

    public Long getSessionContextTimeout() {
        return this._sessionContextTimeoutMsec;
    }

    public Long getSessionContextTimeoutMinutes() {
        Long sessionContextTimeoutMinutes = null;
        Long sessionContextTimeoutMsec = this.getSessionContextTimeout();
        if (sessionContextTimeoutMsec != null) {
            sessionContextTimeoutMinutes = this._sessionContextTimeoutMsec / 60000L;
        }
        return sessionContextTimeoutMinutes;
    }

    @Override
    protected void validateServiceConfigurationCustom(Document document) throws ServiceConfigurationException {
        SessionServiceInitializer.parse(document);
    }

    static void validate(Document document) throws ServiceConfigurationException {
        if (document == null) {
            throw new ServiceConfigurationException(RB.getStringResource("SessionServiceInitializer.invalidObject.ex.txt"));
        }
        Element docElement = document.getDocumentElement();
        String docElementName = docElement.getNodeName();
        if (!"SessionService".equals(docElementName)) {
            throw new ServiceConfigurationException(Message.format((ResourceBundle)RB.getResources(), (String)"SessionServiceInitObject.invalidConfigDocElement.ex.fmt.txt", (Object)"SessionService", (Object)docElementName));
        }
    }

    @Override
    public DocumentFragment appendDOM(Document document) {
        return SessionServiceInitObject.appendDOM(document, this);
    }

    public static DocumentFragment appendDOM(Document document, SessionServiceInitObject serviceConfig) {
        Element element;
        if (document != null && (element = document.getDocumentElement()) != null && Strings.equal((String)element.getNodeName(), (String)"SessionService", (boolean)false, (boolean)false)) {
            if (!serviceConfig.isUserContextNameUndefined()) {
                element.setAttribute("userContextName", serviceConfig.getUserContextName().trim());
            }
            if (!serviceConfig.isSessionContextTimeoutUndefined()) {
                element.setAttribute("sessionContextTimeout", serviceConfig.getSessionContextTimeout().toString());
            }
        }
        return null;
    }

    @Override
    protected String getServiceFactoryClassName() {
        return SessionServiceFactory.class.getName();
    }

    private static boolean hasTimeout(Long timeoutInMsec) {
        return timeoutInMsec != null && timeoutInMsec.compareTo(0L) > 0;
    }

    @Override
    public Consumer removeConsumer(Consumer consumer, boolean isRemoveResourceIfUnused) throws ServiceException {
        Consumer removedConsumer = super.removeConsumer(consumer, isRemoveResourceIfUnused);
        if (isRemoveResourceIfUnused) {
            ConsumerUsage consumerUsage = this.getConsumerUsage();
            if (consumerUsage.getConsumersForResource("sessionContextTimeout", true).size() == 0) {
                this.setSessionContextTimeout(null);
            }
            if (consumerUsage.getConsumersForResource("userContextName", true).size() == 0) {
                this.setUserContextName(null);
            }
        }
        return removedConsumer;
    }

    @Override
    protected void mergeConfiguration(AbstractServiceComponentConfig currentConfig, AbstractServiceComponentConfig newConfig) throws ServiceConfigurationException, IllegalArgumentException {
        this.mergeConfiguration(currentConfig, newConfig, this.getDefaultMergePolicy());
    }

    @Override
    protected void mergeConfiguration(AbstractServiceComponentConfig currentConfig, AbstractServiceComponentConfig newConfig, MergePolicy mergePolicy) throws ServiceConfigurationException, IllegalArgumentException {
        SessionServiceInitObject serviceConfig1 = null;
        SessionServiceInitObject serviceConfig2 = null;
        try {
            serviceConfig1 = (SessionServiceInitObject)currentConfig;
            serviceConfig2 = (SessionServiceInitObject)newConfig;
        }
        catch (ClassCastException e) {
            throw new ServiceConfigurationException(e, Message.format((ResourceBundle)RB.getResources(), (String)"SessionServiceInitObject.invalidConfig.ex.fmt.txt", (Object)SessionServiceInitObject.class.getName()));
        }
        SessionServiceInitObject.mergeConfiguration(serviceConfig1, serviceConfig2, mergePolicy == null ? this.getDefaultMergePolicy() : mergePolicy);
    }

    private static void mergeConfiguration(SessionServiceInitObject thisConfig, SessionServiceInitObject newConfig, MergePolicy mergePolicy) throws ServiceConfigurationException, IllegalArgumentException {
        if (mergePolicy == null) {
            throw new IllegalArgumentException();
        }
        if (thisConfig == null) {
            throw new IllegalArgumentException();
        }
        if (newConfig == null) {
            throw new IllegalArgumentException();
        }
        boolean isUpdateName = false;
        boolean isUpdateTimeout = false;
        String configCurrentName = thisConfig.getUserContextName();
        String configNewName = newConfig.getUserContextName();
        if (configNewName != null && configNewName.length() > 0 && !Strings.equal((String)configCurrentName, (String)configNewName, (boolean)false, (boolean)false)) {
            boolean isOKToChangeName;
            boolean bl = isOKToChangeName = mergePolicy.isOKToReplace() || configCurrentName == null || configCurrentName.length() == 0;
            if (!isOKToChangeName) {
                throw new ServiceConfigurationException(Message.format((ResourceBundle)RB.getResources(), (String)"SessionServiceInitObject.conflictUserContextName.ex.fmt.txt", (Object)configCurrentName, (Object)thisConfig.getConfigName(), (Object)configNewName, (Object)newConfig.getConfigName()));
            }
            isUpdateName = true;
        }
        Long configCurrentTimeout = thisConfig.getSessionContextTimeout();
        Long configNewTimeout = newConfig.getSessionContextTimeout();
        if (configNewTimeout != null && !configNewTimeout.equals(configCurrentTimeout)) {
            boolean isOKToChangeTimeout;
            boolean isCurrentTimeoutUndefined = !SessionServiceInitObject.hasTimeout(configCurrentTimeout);
            boolean bl = isOKToChangeTimeout = mergePolicy.isOKToReplace() || isCurrentTimeoutUndefined;
            if (!isOKToChangeTimeout) {
                throw new ServiceConfigurationException(Message.format((ResourceBundle)RB.getResources(), (String)"SessionServiceInitObject.conflictTimeout.ex.fmt.txt", (Object)configCurrentTimeout, (Object)thisConfig.getConfigName(), (Object)configNewTimeout, (Object)newConfig.getConfigName()));
            }
            isUpdateTimeout = true;
        }
        if (isUpdateName) {
            thisConfig.setUserContextName(configNewName);
        }
        if (isUpdateTimeout) {
            thisConfig.setSessionContextTimeout(configNewTimeout);
        }
        HashMap<String, String> resourceIdMap = new HashMap<String, String>(2);
        String resourceKey = "userContextName";
        resourceIdMap.put(newConfig.getConsumedResourceAdapter(resourceKey).getResourceID(), thisConfig.getConsumedResourceAdapter(resourceKey).getResourceID());
        resourceKey = "sessionContextTimeout";
        resourceIdMap.put(newConfig.getConsumedResourceAdapter(resourceKey).getResourceID(), thisConfig.getConsumedResourceAdapter(resourceKey).getResourceID());
        thisConfig.getConsumerUsage().merge(newConfig.getConsumerUsage(), resourceIdMap);
    }

    @Override
    public Consumer addConsumer(Consumer consumer, boolean isConsumer) {
        Consumer addedConsumer = super.addConsumer(consumer, isConsumer);
        if (isConsumer) {
            this.clearUndefinedResources(consumer);
        }
        return addedConsumer;
    }

    @Override
    public void setIsConsumer(Consumer consumer, boolean isConsumer) {
        super.setIsConsumer(consumer, isConsumer);
        if (isConsumer) {
            this.clearUndefinedResources(consumer);
        }
    }

    private void clearUndefinedResources(Consumer consumer) {
        if (consumer != null) {
            String consumerID = consumer.getID();
            ConsumerUsage consumerUsage = this.getConsumerUsage();
            ConsumerResourceAssoc consumerResourceAssoc = null;
            if (this.isSessionContextTimeoutUndefined()) {
                consumerResourceAssoc = consumerUsage.getConsumerResourceAssocsForConsumerAndResource(consumerID, "sessionContextTimeout");
                consumerResourceAssoc.setIsConsumer(false);
            }
            if (this.isUserContextNameUndefined()) {
                consumerResourceAssoc = consumerUsage.getConsumerResourceAssocsForConsumerAndResource(consumerID, "userContextName");
                consumerResourceAssoc.setIsConsumer(false);
            }
        }
    }

    private boolean isSessionContextTimeoutUndefined() {
        return this.getSessionContextTimeout() == null;
    }

    private boolean isUserContextNameUndefined() {
        String value = this.getUserContextName();
        return value == null || value.trim().length() == 0;
    }

    @Override
    protected AbstractServiceComponentConfig getConfig(Document serviceConfigDocument) throws ServiceConfigurationException, IllegalArgumentException {
        return serviceConfigDocument == null ? new SessionServiceInitObject() : SessionServiceInitializer.parse(serviceConfigDocument);
    }

    @Override
    protected DocumentFragment appendDOM(Document document, AbstractServiceComponentConfig serviceConfig) throws ServiceConfigurationException, IllegalArgumentException {
        DocumentFragment documentFragment = null;
        try {
            documentFragment = SessionServiceInitObject.appendDOM(document, (SessionServiceInitObject)serviceConfig);
        }
        catch (ClassCastException e) {
            throw new ServiceConfigurationException(e, RB.getStringResource("SessionServiceInitObject.appendDOM.ex.txt"));
        }
        return documentFragment;
    }

    public boolean equals(Object o) {
        boolean isEqual = false;
        if (this == o) {
            isEqual = true;
        } else if (o != null && o.getClass() == this.getClass()) {
            SessionServiceInitObject ssio = (SessionServiceInitObject)o;
            isEqual = Strings.equal((String)this._defaultUserContextName, (String)ssio._defaultUserContextName, (boolean)false, (boolean)false);
            if (isEqual) {
                Long timeoutMsecThis = this.getSessionContextTimeout();
                Long timeoutMsecOther = ssio.getSessionContextTimeout();
                long timeoutThis = timeoutMsecThis == null ? -1L : timeoutMsecThis;
                long timeoutOther = timeoutMsecOther == null ? -1L : timeoutMsecOther;
                isEqual = timeoutThis == timeoutOther;
            }
        }
        return isEqual;
    }

    public int hashCode() {
        int hashCode = 5;
        int primeNumber = this.getPrimeNumber();
        hashCode = primeNumber * hashCode + (this._defaultUserContextName == null ? 0 : this._defaultUserContextName.hashCode());
        hashCode = primeNumber * hashCode + (this._sessionContextTimeoutMsec == null ? 0 : this._sessionContextTimeoutMsec.hashCode());
        return hashCode;
    }
}

