/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.session;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.entities.EntityKeyInterface;
import com.sas.net.ssl.SSLRMISocketFactories;
import com.sas.services.DefaultEntityKeyImpl;
import com.sas.services.ServiceException;
import com.sas.services.cache.Cache;
import com.sas.services.cache.CacheException;
import com.sas.services.cache.impl.BaseCacheFactory;
import com.sas.services.logging.util.LoggerMonitor2;
import com.sas.services.security.SecurityUtil;
import com.sas.services.session.LockingException;
import com.sas.services.session.RB;
import com.sas.services.session.RemoteSessionContextStateChangedListener;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.session.SessionContextPermission;
import com.sas.services.session.SessionContextStateChangedEvent;
import com.sas.services.session.SessionService;
import com.sas.services.user.UserContextInterface;
import com.sas.text.Message;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.dgc.VMID;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
class SessionContext
extends UnicastRemoteObject
implements SessionContextInterface {
    private static final String CACHE_NODE_PATH = "/Session/";
    private static final String SESSION_DESTROY_CONTEXT = "com.sas.services.session.SessionContext.destroy";
    private Cache _cache;
    private boolean _destroyed;
    private boolean _destroyPending;
    private Map _lockObjectMap;
    private RemoteSessionContextStateChangedListener _sessionServiceListener;
    private ArrayList _loggerStateChangedEvents = new ArrayList(0);
    private SessionContextInterface _rootSessionContext;
    private UserContextInterface _userContext;
    private Logger _logger = LogManager.getLogger(SessionContext.class);
    private EntityKeyInterface _entityKeyIf = null;
    private int _nameCounter;
    private boolean _forceDestroy = false;
    private long _lastTouched;
    private boolean _timeoutDisabled = false;
    public static final String RB_KEY = "SessionContext.";
    private static final boolean IS_FORCED_UNEXPORT = true;

    private SessionContext() throws RemoteException {
        super(SSLRMISocketFactories.getInstance().getPortForClass(0, SessionContext.class), SSLRMISocketFactories.getInstance().getRMIClientSocketFactoryForClass(SessionContext.class), SSLRMISocketFactories.getInstance().getRMIServerSocketFactoryForClass(SessionContext.class));
        this.setLastAccessTime();
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Creating SessionContext: " + this.hashCode());
        }
    }

    SessionContext(RemoteSessionContextStateChangedListener serviceListener, SessionContextInterface rootSessionContext, UserContextInterface userContext) throws RemoteException {
        this();
        this._entityKeyIf = new DefaultEntityKeyImpl();
        String cacheNode = CACHE_NODE_PATH + this._entityKeyIf.getEntityKey();
        try {
            this._cache = BaseCacheFactory.getCache((String)"com.sas.services.session.SessionContext", (String)cacheNode, (ClassLoader)this.getClass().getClassLoader());
        }
        catch (CacheException cex) {
            throw new RuntimeException(cex);
        }
        this._destroyed = false;
        this._destroyPending = false;
        this._lockObjectMap = new HashMap(1);
        this._sessionServiceListener = serviceListener;
        this._userContext = userContext;
        this._nameCounter = 1;
        this._rootSessionContext = rootSessionContext == null ? this : rootSessionContext;
    }

    public SessionContext(RemoteSessionContextStateChangedListener serviceListener, SessionContextInterface rootSessionContext, UserContextInterface userContext, LoggerMonitor2 monitorLogger, int monitorId, EntityKeyInterface id, Map cacheMap, Boolean destroyPending, Map lockMap) throws RemoteException {
        this(serviceListener, rootSessionContext, userContext, id, cacheMap, destroyPending, lockMap);
    }

    public SessionContext(RemoteSessionContextStateChangedListener serviceListener, SessionContextInterface rootSessionContext, UserContextInterface userContext, EntityKeyInterface id, Map cacheMap, Boolean destroyPending, Map lockMap) throws RemoteException {
        this(serviceListener, rootSessionContext, userContext);
        for (Map.Entry entry : cacheMap.entrySet()) {
            this._cache.put(entry.getKey(), entry.getValue());
        }
        this._destroyPending = destroyPending;
        this._lockObjectMap.putAll(lockMap);
        this._entityKeyIf = id;
    }

    public String getEntityKey() throws IllegalStateException, RemoteException {
        this.setLastAccessTime();
        return this._entityKeyIf.getEntityKey();
    }

    public boolean sameEntity(EntityKeyInterface entity) throws IllegalStateException, RemoteException {
        if (this._destroyed) {
            throw new IllegalStateException(RB.getStringResource(RB_KEY, "illegalStateException.ex.txt"));
        }
        this.setLastAccessTime();
        return this._entityKeyIf.sameEntity(entity);
    }

    public void setEntityKey(String entityKey) throws RemoteException, IllegalStateException {
        if (this._destroyed || this._destroyPending) {
            throw new IllegalStateException(RB.getStringResource(RB_KEY, "illegalStateException.ex.txt"));
        }
        this.setLastAccessTime();
        this._entityKeyIf.setEntityKey(entityKey);
    }

    @Override
    public SessionContextInterface getRootSessionContext() throws IllegalStateException, RemoteException {
        return this.getRootSessionContext(null);
    }

    @Override
    public SessionContextInterface getRootSessionContext(UserContextInterface userContext) throws IllegalStateException, RemoteException {
        SessionContextPermission scp = new SessionContextPermission("read");
        SecurityUtil.checkPermission(userContext, scp);
        if (this._destroyed) {
            throw new IllegalStateException(RB.getStringResource(RB_KEY, "illegalStateException.ex.txt"));
        }
        this.setLastAccessTime();
        return this._rootSessionContext;
    }

    @Override
    public UserContextInterface getUserContext() throws IllegalStateException, RemoteException {
        if (this._destroyed) {
            throw new IllegalStateException(RB.getStringResource(RB_KEY, "illegalStateException.ex.txt"));
        }
        this.setLastAccessTime();
        return this._userContext;
    }

    @Override
    public void setUserContext(UserContextInterface userContext) throws IllegalStateException, RemoteException {
        if (this._destroyed || this._destroyPending) {
            if (this._logger != null) {
                this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"SessionContext.setUserContextFailed.fmt.txt", (Object)this._entityKeyIf.getEntityKey()));
            }
            throw new IllegalStateException(RB.getStringResource(RB_KEY, "illegalStateException.ex.txt"));
        }
        if (this._userContext != null) {
            if (this._logger != null) {
                this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"SessionContext.userContextAlreadySet.fmt.txt", (Object)this._entityKeyIf.getEntityKey()));
            }
            throw new IllegalStateException(RB.getStringResource(RB_KEY, "userAlreadySet.illegalStateException.ex.txt"));
        }
        this.setLastAccessTime();
        this._userContext = userContext;
        if (userContext != null) {
            this._userContext.setSessionContext(this);
        }
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"SessionContext.setUserContextSuccessful.fmt.txt", (Object)this._entityKeyIf.getEntityKey()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object setAttribute(String name, Object value) throws IllegalStateException, RemoteException {
        Object storedResource = null;
        SessionContext sessionContext = this;
        synchronized (sessionContext) {
            if (this._logger != null && this._logger.isDebugEnabled()) {
                this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"SessionContext.setAttribute.fmt.txt", (Object)name, (Object)this._entityKeyIf.getEntityKey()));
            }
            if (this._destroyed || this._destroyPending) {
                if (this._logger != null) {
                    this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"SessionContext.setAttributeFailed.fmt.txt", (Object)name, (Object)this._entityKeyIf.getEntityKey()));
                }
                throw new IllegalStateException(RB.getStringResource(RB_KEY, "illegalStateException.ex.txt"));
            }
            if (name == null) {
                if (this._logger != null) {
                    this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"SessionContext.setAttributeNullName.fmt.txt", (Object)this._entityKeyIf.getEntityKey()));
                }
                throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "nullNameIllegalArgument.ex.txt"));
            }
            this.setLastAccessTime();
            storedResource = this._cache.get((Object)name);
            this._cache.put((Object)name, value);
        }
        if (storedResource != null && storedResource instanceof RemoteSessionContextStateChangedListener) {
            SessionContextStateChangedEvent event = new SessionContextStateChangedEvent(this, name, storedResource, 1);
            ((RemoteSessionContextStateChangedListener)storedResource).contextStateChanged(event);
        }
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"SessionContext.setAttributeSuccessful.fmt.txt", (Object)name, (Object)this._entityKeyIf.getEntityKey()));
        }
        return storedResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String setAttribute(Object value) throws RemoteException, IllegalStateException {
        String name = null;
        SessionContext sessionContext = this;
        synchronized (sessionContext) {
            if (this._logger != null && this._logger.isDebugEnabled()) {
                this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"SessionContext.setAtt.fmt.txt", (Object)this._entityKeyIf.getEntityKey()));
            }
            if (this._destroyed || this._destroyPending) {
                if (this._logger != null) {
                    this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"SessionContext.setAttFailed.fmt.txt", (Object)this._entityKeyIf.getEntityKey()));
                }
                throw new IllegalStateException(RB.getStringResource(RB_KEY, "illegalStateException.ex.txt"));
            }
            this.setLastAccessTime();
            boolean done = false;
            int nameCounter = this._nameCounter;
            while (!done) {
                StringBuffer buf = new StringBuffer();
                buf.append("session");
                buf.append(nameCounter++);
                name = buf.toString();
                if (this._cache.containsKey((Object)name)) continue;
                done = true;
                if (this._logger == null || !this._logger.isDebugEnabled()) continue;
                this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"SessionContext.createdName.fmt.txt", (Object)name, (Object)this._entityKeyIf.getEntityKey()));
            }
            this._nameCounter = nameCounter;
            this._cache.put(name, value);
        }
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"SessionContext.setAttributeSuccessful.fmt.txt", (Object)name, (Object)this._entityKeyIf.getEntityKey()));
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getAttribute(String name) throws IllegalStateException, RemoteException {
        Object obj = null;
        SessionContext sessionContext = this;
        synchronized (sessionContext) {
            if (this._logger != null && this._logger.isDebugEnabled()) {
                this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"SessionContext.getAttribute.fmt.txt", (Object)name, (Object)this._entityKeyIf.getEntityKey()));
            }
            if (this._destroyed) {
                if (this._logger != null) {
                    this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"SessionContext.getAttributeFailed.fmt.txt", (Object)name, (Object)this._entityKeyIf.getEntityKey()));
                }
                throw new IllegalStateException(RB.getStringResource(RB_KEY, "illegalStateException.ex.txt"));
            }
            if (name == null) {
                if (this._logger != null) {
                    this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"SessionContext.getAttributeNullName.fmt.txt", (Object)this._entityKeyIf.getEntityKey()));
                }
                throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "nullNameIllegalArgument.ex.txt"));
            }
            this.setLastAccessTime();
            obj = this._cache.get((Object)name);
        }
        return obj;
    }

    @Override
    public void touch() {
        this.setLastAccessTime();
    }

    public long getLastAccessTime() {
        return this._lastTouched;
    }

    private void setLastAccessTime() {
        this._lastTouched = System.currentTimeMillis();
    }

    @Override
    public void setTimeoutDisabled(boolean timeoutDisabled) {
        this._timeoutDisabled = timeoutDisabled;
    }

    public boolean isTimeoutDisabled() {
        return this._timeoutDisabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAttribute(String name) throws IllegalStateException, RemoteException {
        boolean returnValue = false;
        Object obj = null;
        SessionContext sessionContext = this;
        synchronized (sessionContext) {
            if (this._logger != null && this._logger.isDebugEnabled()) {
                this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"SessionContext.removeAttribute.fmt.txt", (Object)name, (Object)this._entityKeyIf.getEntityKey()));
            }
            if (this._destroyed || this._destroyPending) {
                if (this._logger != null && this._logger.isDebugEnabled()) {
                    this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"SessionContext.removeAttributeFailed.fmt.txt", (Object)name, (Object)this._entityKeyIf.getEntityKey()));
                }
                throw new IllegalStateException(RB.getStringResource(RB_KEY, "illegalStateException.ex.txt"));
            }
            if (name == null) {
                if (this._logger != null) {
                    this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"SessionContext.removeAttributeNullName.fmt.txt", (Object)this._entityKeyIf.getEntityKey()));
                }
                throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "nullNameIllegalArgument.ex.txt"));
            }
            this.setLastAccessTime();
            obj = this._cache.get((Object)name);
            if (obj != null) {
                this._cache.remove((Object)name);
                returnValue = true;
            }
        }
        if (obj != null && obj instanceof RemoteSessionContextStateChangedListener) {
            SessionContextStateChangedEvent event = new SessionContextStateChangedEvent(this, name, obj, 1);
            ((RemoteSessionContextStateChangedListener)obj).contextStateChanged(event);
        }
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"SessionContext.removeAttributeSuccessful.fmt.txt", (Object)name, (Object)this._entityKeyIf.getEntityKey()));
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object lock(String applicationName) throws IllegalStateException, RemoteException {
        String lockObject = null;
        SessionContext sessionContext = this;
        synchronized (sessionContext) {
            if (this._logger != null && this._logger.isDebugEnabled()) {
                this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"SessionContext.lock.fmt.txt", (Object)applicationName, (Object)this._entityKeyIf.getEntityKey()));
            }
            if (this._destroyed || this._destroyPending || this._forceDestroy) {
                if (this._logger != null) {
                    this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"SessionContext.lockFailed.fmt.txt", (Object)applicationName, (Object)this._entityKeyIf.getEntityKey()));
                }
                throw new IllegalStateException(RB.getStringResource(RB_KEY, "illegalStateException.ex.txt"));
            }
            this.setLastAccessTime();
            VMID vmid = new VMID();
            lockObject = vmid.toString();
            this._lockObjectMap.put(lockObject, applicationName);
            if (this._logger != null && this._logger.isInfoEnabled()) {
                this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"SessionContext.lockSuccessful.fmt.txt", (Object)applicationName, (Object)this._entityKeyIf.getEntityKey()));
            }
        }
        return lockObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock(Object lockObject) throws IllegalArgumentException, IllegalStateException, RemoteException {
        String applicationName = null;
        SessionContext sessionContext = this;
        synchronized (sessionContext) {
            if (this._logger != null && this._logger.isDebugEnabled()) {
                this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"SessionContext.unlock.fmt.txt", (Object)this._entityKeyIf.getEntityKey()));
            }
            if (this._destroyed || this._destroyPending || this._forceDestroy) {
                if (this._logger != null) {
                    this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"SessionContext.unlockFailed.fmt.txt", (Object)this._entityKeyIf.getEntityKey()));
                }
                throw new IllegalStateException(RB.getStringResource(RB_KEY, "illegalStateException.ex.txt"));
            }
            this.setLastAccessTime();
            if (this._lockObjectMap.isEmpty()) {
                if (this._logger != null && this._logger.isDebugEnabled()) {
                    this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"SessionContext.alreadyUnlocked.fmt.txt", (Object)this._entityKeyIf.getEntityKey()));
                }
                return;
            }
            if (lockObject == null) {
                if (this._logger != null) {
                    this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"SessionContext.unlockInvalidLockObject.fmt.txt", (Object)this._entityKeyIf.getEntityKey()));
                }
                throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "illegalArgumentException.ex.txt"));
            }
            if (lockObject instanceof String && this._lockObjectMap.containsKey(lockObject)) {
                applicationName = (String)this._lockObjectMap.get(lockObject);
                this._lockObjectMap.remove(lockObject);
                if (this._logger != null && this._logger.isInfoEnabled()) {
                    this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"SessionContext.unlockSuccessful.fmt.txt", (Object)applicationName, (Object)this._entityKeyIf.getEntityKey()));
                }
            } else {
                if (this._logger != null) {
                    this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"SessionContext.unlockInvalidLockObject.fmt.txt", (Object)this._entityKeyIf.getEntityKey()));
                }
                throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "illegalArgumentException.ex.txt"));
            }
        }
    }

    @Override
    public String getRootSessionContextEntityKey() throws RemoteException {
        if (this._destroyed) {
            throw new IllegalStateException(RB.getStringResource(RB_KEY, "illegalStateException.ex.txt"));
        }
        this.setLastAccessTime();
        return this._rootSessionContext.getEntityKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() throws LockingException, IllegalStateException, RemoteException {
        block35: {
            SessionContext obj;
            HashMap tmpMap = null;
            String key = null;
            SessionContext sessionContext = this;
            synchronized (sessionContext) {
                Logger destroylogger = LogManager.getLogger((String)SESSION_DESTROY_CONTEXT);
                if (destroylogger != null && destroylogger.isDebugEnabled()) {
                    destroylogger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"SessionContext.destroy.fmt.txt", (Object)this._entityKeyIf.getEntityKey()));
                }
                if (this._destroyed || this._destroyPending) {
                    if (this._logger != null && this._logger.isDebugEnabled()) {
                        this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"SessionContext.alreadyDestroyed.fmt.txt", (Object)this._entityKeyIf.getEntityKey()));
                    }
                    throw new IllegalStateException(RB.getStringResource(RB_KEY, "illegalStateException.ex.txt"));
                }
                this.setLastAccessTime();
                if (this._forceDestroy) {
                    this._lockObjectMap.clear();
                }
                if (!this._lockObjectMap.isEmpty()) {
                    if (this._logger != null && this._logger.isDebugEnabled()) {
                        this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"SessionContext.sessionLocked.fmt.txt", (Object)this._entityKeyIf.getEntityKey()));
                    }
                    StringBuffer buf = new StringBuffer();
                    Iterator itor = this._lockObjectMap.entrySet().iterator();
                    boolean first = true;
                    while (itor.hasNext()) {
                        Map.Entry entry = itor.next();
                        String appName = (String)entry.getValue();
                        if (appName == null || appName.equals("")) continue;
                        if (!first) {
                            buf.append(", ");
                        } else {
                            first = false;
                        }
                        buf.append(appName);
                    }
                    String appNames = buf.toString();
                    if (appNames == null || appNames.equals("")) {
                        throw new LockingException(RB.getStringResource(RB_KEY, "lockingException.ex.txt"));
                    }
                    throw new LockingException(Message.format((ResourceBundle)RB.getResources(), (String)"SessionContext.lockingException.ex.fmt.txt", (Object)appNames));
                }
                this._destroyPending = true;
                tmpMap = new HashMap(this._cache);
            }
            Iterator itor = tmpMap.entrySet().iterator();
            Map.Entry mapEntry = null;
            while (itor.hasNext()) {
                mapEntry = itor.next();
                key = (String)mapEntry.getKey();
                obj = mapEntry.getValue();
                if (obj instanceof RemoteSessionContextStateChangedListener) {
                    if (this._logger != null && this._logger.isDebugEnabled()) {
                        this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"SessionContext.objectImplsListener.fmt.txt", (Object)key, (Object)this._entityKeyIf.getEntityKey()));
                    }
                    try {
                        if (this._logger != null && this._logger.isDebugEnabled()) {
                            this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"SessionContext.sendEvent.fmt.txt", (Object)key, (Object)this._entityKeyIf.getEntityKey()));
                        }
                        SessionContextStateChangedEvent event = new SessionContextStateChangedEvent(this, key, obj, 2);
                        ((RemoteSessionContextStateChangedListener)((Object)obj)).contextStateChanged(event);
                    }
                    catch (Throwable t) {
                        if (this._logger == null) continue;
                        if (this._logger.isDebugEnabled()) {
                            this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"SessionContext.sendEventException.fmt.txt", (Object)key, (Object)this._entityKeyIf.getEntityKey()), t);
                            continue;
                        }
                        this._logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"SessionContext.sendEventException.fmt.txt", (Object)key, (Object)this._entityKeyIf.getEntityKey()));
                    }
                    continue;
                }
                if (this._logger == null || !this._logger.isDebugEnabled()) continue;
                this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"SessionContext.objectNotListener.fmt.txt", (Object)key, (Object)this._entityKeyIf.getEntityKey()));
            }
            obj = this;
            synchronized (obj) {
                this._destroyed = true;
            }
            try {
                if (this._userContext != null) {
                    this._userContext.destroy();
                }
            }
            catch (Throwable t) {
                this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"SessionContext.destroy.usrctxterr.fmt.txt", (Object)this._entityKeyIf.getEntityKey()));
            }
            this._userContext = null;
            this._cache.clear();
            this._cache = null;
            if (this._sessionServiceListener != null) {
                try {
                    SessionContextStateChangedEvent event = new SessionContextStateChangedEvent(this, null, null, 2);
                    this._sessionServiceListener.contextStateChanged(event);
                }
                catch (Exception e) {
                    if (this._logger == null) break block35;
                    this._logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"SessionContext.sessionTermError.fmt.txt", (Object)this._entityKeyIf.getEntityKey()), (Throwable)e);
                }
            }
        }
        this._sessionServiceListener = null;
        this._rootSessionContext = null;
        try {
            UnicastRemoteObject.unexportObject(this, true);
        }
        catch (NoSuchObjectException e) {
            // empty catch block
        }
        if (this._logger != null && this._logger.isDebugEnabled()) {
            this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"SessionContext.destroySuccessful.fmt.txt", (Object)this._entityKeyIf.getEntityKey()));
        }
        if (this._loggerStateChangedEvents.size() > 0) {
            for (SessionContextStateChangedEvent event : this._loggerStateChangedEvents) {
                ((RemoteSessionContextStateChangedListener)event.getObject()).contextStateChanged(event);
            }
        }
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Destroying SessionContext: " + this.hashCode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy(long delay) throws ServiceException, IllegalStateException, RemoteException {
        SessionContext sessionContext = this;
        synchronized (sessionContext) {
            if (this._logger != null && this._logger.isDebugEnabled()) {
                this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"SessionContext.destroyDelay.fmt.txt", (Object)Long.toString(delay), (Object)this._entityKeyIf.getEntityKey()));
            }
            if (this._destroyed || this._destroyPending) {
                if (this._logger != null && this._logger.isDebugEnabled()) {
                    this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"SessionContext.alreadyDestroyed.fmt.txt", (Object)this._entityKeyIf.getEntityKey()));
                }
                throw new IllegalStateException(RB.getStringResource(RB_KEY, "illegalStateException.ex.txt"));
            }
        }
        this.setLastAccessTime();
        if (this._sessionServiceListener != null) {
            ((SessionService)this._sessionServiceListener).addDeferredSessionContext(this, delay);
        }
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Destroying SessionContext: " + this.hashCode());
        }
    }

    void setLogger(Logger logger) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forceDestroy() throws IllegalStateException, RemoteException {
        this.setLastAccessTime();
        SessionContext sessionContext = this;
        synchronized (sessionContext) {
            this._forceDestroy = true;
        }
        if (this._logger != null) {
            this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"SessionContext.forceDestroy.fmt.txt", (Object)this._entityKeyIf.getEntityKey()));
        }
        try {
            this.destroy();
        }
        catch (LockingException lockingException) {
            // empty catch block
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (!this._destroyed) {
                if (this._logger != null && this._logger.isDebugEnabled()) {
                    this._logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"SessionContext.garbageCollection.fmt.txt", (Object)this._entityKeyIf.getEntityKey()));
                }
                this._lockObjectMap.clear();
                this.destroy();
            }
        }
        catch (Exception e) {
            if (this._logger != null) {
                this._logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"SessionContext.destroyError.fmt.txt", (Object)this._entityKeyIf.getEntityKey()), (Throwable)e);
            }
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public byte[] toByteArray() throws RemoteException, ServiceException {
        this.setLastAccessTime();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this._entityKeyIf);
            ByteArrayOutputStream testOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream tester = new ObjectOutputStream(testOutputStream);
            HashMap streamMap = new HashMap();
            for (Map.Entry nextEntry : this._cache.entrySet()) {
                try {
                    tester.writeObject(nextEntry.getKey());
                    tester.writeObject(nextEntry.getValue());
                    streamMap.put(nextEntry.getKey(), nextEntry.getValue());
                }
                catch (Exception ex) {
                    String msg = Message.format((ResourceBundle)RB.getResources(), (String)"SessionContext.serializeErr.fmt.txt", nextEntry.getKey(), nextEntry.getValue());
                    System.out.println(msg);
                }
            }
            oos.writeObject(streamMap);
            oos.writeObject(this._destroyPending);
            oos.writeObject(this._lockObjectMap);
            oos.writeObject(this._userContext.toByteArray());
            oos.flush();
            byte[] blobArray = baos.toByteArray();
            return blobArray;
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public boolean isDestroyPending() throws RemoteException {
        this.setLastAccessTime();
        return this._destroyPending;
    }
}

