/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.mgmt;

import com.sas.services.ServiceException;
import com.sas.services.mgmt.ServiceEvent;
import com.sas.services.mgmt.ServiceNotificationBroadcasterInterface;
import com.sas.services.mgmt.ServiceRemoteObserverInterface;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ServiceNotificationBroadcaster
implements ServiceNotificationBroadcasterInterface,
Serializable {
    private static final long serialVersionUID = 4813220089500798364L;
    private static final int TYPICAL_NUM_OBSERVERS = 5;
    private List<ServiceRemoteObserverInterface> _observers = Collections.synchronizedList(new ArrayList(5));

    @Override
    public final void addServiceObserver(ServiceRemoteObserverInterface serviceObserver) {
        if (serviceObserver != null && this._observers != null) {
            this._observers.add(serviceObserver);
        }
    }

    @Override
    public final void removeServiceObserver(ServiceRemoteObserverInterface serviceObserver) {
        if (serviceObserver != null && this._observers != null) {
            this._observers.remove(serviceObserver);
        }
    }

    @Override
    public final void removeAllServiceObservers() {
        if (this._observers != null) {
            this._observers.removeAll(this._observers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void notifyServiceObservers(ServiceEvent serviceEvent) {
        if (serviceEvent != null && this._observers != null) {
            List<ServiceRemoteObserverInterface> list = this._observers;
            synchronized (list) {
                Iterator<ServiceRemoteObserverInterface> iter = this._observers.iterator();
                while (iter.hasNext()) {
                    try {
                        iter.next().handleServiceEvent(serviceEvent);
                    }
                    catch (ServiceException e) {
                        iter.remove();
                    }
                    catch (RemoteException e) {
                        iter.remove();
                    }
                    catch (ClassCastException e) {
                        iter.remove();
                    }
                }
            }
        }
    }
}

