/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.logging;

import com.sas.codepolicy.SASScope;
import com.sas.services.logging.RB;
import com.sas.services.util.GetPropertyAction;
import java.security.AccessController;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Deprecated
@SASScope
public class LoggingLog {
    private static boolean debugEnabled = false;
    private static String errorPrefix = null;
    private static String debugPrefix = null;
    public static String SYSTEM_VARIABLE_LOG_DEBUG = "com.sas.services.logging.debug";

    public static void setDebug(boolean enabled) {
        debugEnabled = enabled;
    }

    public static boolean isDebug() {
        return debugEnabled;
    }

    public static boolean isDebugContext(String context) {
        return debugEnabled && context != null && !context.equals("") && AccessController.doPrivileged(new GetPropertyAction(context)) != null;
    }

    public static void error(String msg) {
        System.err.println(errorPrefix + msg);
    }

    public static void error(String msg, Throwable t) {
        System.err.println(errorPrefix + msg);
        if (t != null) {
            t.printStackTrace(System.err);
        }
    }

    public static void debug(String msg) {
        if (debugEnabled) {
            System.out.println(debugPrefix + msg);
        }
    }

    public static void debug(String msg, Throwable t) {
        if (debugEnabled) {
            System.out.println(debugPrefix + msg);
            if (t != null) {
                t.printStackTrace(System.out);
            }
        }
    }

    public static void debug(String msg, String context) {
        if (debugEnabled && context != null && !context.equals("") && AccessController.doPrivileged(new GetPropertyAction(context)) != null) {
            System.out.println(debugPrefix + msg);
        }
    }

    public static void debug(String msg, String context, Throwable t) {
        if (debugEnabled && context != null && !context.equals("") && AccessController.doPrivileged(new GetPropertyAction(context)) != null) {
            System.out.println(debugPrefix + msg);
            if (t != null) {
                t.printStackTrace(System.out);
            }
        }
    }

    public static void printNode(String prefix, Node node) {
        NodeList childList = node.getChildNodes();
        if (node instanceof Element) {
            NamedNodeMap attrMap = node.getAttributes();
            String ending = attrMap.getLength() == 0 ? (childList.getLength() == 0 ? "/>" : ">") : "";
            LoggingLog.debug(prefix + "<" + node.getNodeName() + ending);
            for (int j = 0; j < attrMap.getLength(); ++j) {
                ending = j == attrMap.getLength() - 1 ? (childList.getLength() == 0 ? "/>" : ">") : "";
                Node attrNode = attrMap.item(j);
                LoggingLog.debug(prefix + "        " + attrNode.getNodeName() + "=\"" + attrNode.getNodeValue() + "\"" + ending);
            }
        }
        for (int i = 0; i < childList.getLength(); ++i) {
            Node childNode = childList.item(i);
            LoggingLog.printNode("    " + prefix, childNode);
        }
        if (node instanceof Element && childList.getLength() > 0) {
            LoggingLog.debug(prefix + "</" + node.getNodeName() + ">");
        }
    }

    static {
        String logDebug = AccessController.doPrivileged(new GetPropertyAction(SYSTEM_VARIABLE_LOG_DEBUG));
        if (logDebug != null && logDebug.equalsIgnoreCase("true")) {
            debugEnabled = true;
        }
        errorPrefix = RB.getStringResource("LoggingLog.errorPrefix.txt") + " ";
        debugPrefix = RB.getStringResource("LoggingLog.debugPrefix.txt") + " ";
    }
}

