/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.util;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.ServiceException;
import com.sas.services.information.Factory;
import java.io.Serializable;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class JdbcRepositoryKey
implements Serializable {
    private static final long serialVersionUID = -7459652880337964519L;
    private Class objectClass;
    private Serializable keyValue;

    public JdbcRepositoryKey() {
    }

    public JdbcRepositoryKey(String keyString) throws ServiceException, ClassNotFoundException {
        int index = keyString.indexOf(47);
        if (index < 0) {
            throw new ServiceException("Bad key format.");
        }
        String oClassString = keyString.substring(0, index);
        this.objectClass = Factory.getInstance().loadClass(oClassString);
        int index2 = keyString.indexOf(43, index + 1);
        if (index2 < 0) {
            throw new ServiceException("Bad key format.");
        }
        String kClassString = keyString.substring(index + 1, index2);
        String kValueString = keyString.substring(index2 + 1);
        if ("java.lang.String".equals(kClassString)) {
            this.keyValue = kValueString;
            return;
        }
        Class[] ctorArgs = new Class[]{String.class};
        Object[] ctorParms = new Object[]{kValueString};
        this.keyValue = (Serializable)Factory.getInstance().newInstance(kClassString, ctorArgs, ctorParms);
    }

    public Class getObjectClass() {
        return this.objectClass;
    }

    public Serializable getvalue() {
        return this.keyValue;
    }
}

