/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.search.impl;

import com.sas.codepolicy.SASScope;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterComponent;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.FolderUtil;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.RootFolderInterface;
import com.sas.services.information.publicobject.PublicObjectFactory;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.services.information.search.DisplayNameFilter;
import com.sas.services.information.search.ObjectNameFilter;
import com.sas.services.information.search.PublicTypeFilter;
import com.sas.services.information.search.ResultDetails;
import com.sas.services.information.search.Search;
import com.sas.services.information.search.SearchCriteriaException;
import com.sas.services.information.search.SearchFilter;
import com.sas.services.information.search.SearchFolder;
import com.sas.services.information.search.SearchUtility;
import com.sas.services.information.search.SortOrder;
import com.sas.services.information.search.impl.RB;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope
public class SearchImpl
extends UnicastRemoteObject
implements Search,
Cloneable {
    private static final long serialVersionUID = -1806431397739734532L;
    protected static final int FLAGS = -2080374380;
    protected ServerInterface _server;
    protected PathUrl _folderPathUrl = null;
    protected OMIRepositoryInterface _repos;
    private boolean _includeUnknownPublicTypes = false;
    protected boolean _supportedServerVersion = true;
    private boolean _includeNonSearchablePublicTypes = false;
    protected ResultDetails _resultDetails = null;
    protected List<SearchFilter> _searchFilters = null;
    protected List<PublicObjectInterface> _searchResults = new ArrayList<PublicObjectInterface>();
    private SearchFolder _searchFolder = null;
    private boolean _recursiveFolderSearching = true;
    private boolean _includeMatchingFolders = false;
    private boolean _isAssociated = false;
    private boolean _validateCriteria = true;
    private Logger log = LogManager.getLogger(SearchImpl.class);

    public SearchImpl(ServerInterface server) throws ServiceException, RemoteException {
        this._server = server;
        this.initialize();
    }

    @Override
    public ServerInterface getServer() throws RemoteException {
        return this._server;
    }

    private void initialize() throws ServiceException, RemoteException {
        if (this._server.getServerVersion() < 9300) {
            this._supportedServerVersion = false;
        }
    }

    @Override
    public List<PublicObjectInterface> search() throws ServiceException, RemoteException {
        ResultDetails.ResultLimit limit;
        SearchUtility.ValidCriteriaResults results;
        if (this._resultDetails == null) {
            this.getResultDetails();
        }
        this._searchResults.clear();
        if (this._validateCriteria && (results = SearchUtility.validateSearchCriteria(this, this._server)) != null && !results.isValidCriteria()) {
            int errCount = 0;
            List<String> errorMsgs = results.getCriteriaErrorMsgs();
            for (String msg : errorMsgs) {
                this.log.error(msg);
                ++errCount;
            }
            throw new SearchCriteriaException(errorMsgs);
        }
        if (this._folderPathUrl != null) {
            FolderInterface folder = (FolderInterface)this._server.getObjectByPath(this._folderPathUrl);
            if (folder == null) {
                throw new SearchCriteriaException(RB.getStringResource("SearchImpl.BadFolderPath.Error.txt"));
            }
            this._searchResults = this.folderSearch(folder);
        } else {
            FilterInterface filter = this.createSearchFilter(this._searchFilters);
            HashSet<String> objectIDCache = null;
            boolean isAdditionalSearchingNeeded = this.isDisplayNameSearchNeeded(this._searchFilters);
            List objects = this._server.browseSearch(filter);
            if (objects != null && objects.size() > 0) {
                objectIDCache = new HashSet<String>(objects.size());
                for (BrowseMetadataInterface browse : objects) {
                    PublicObjectInterface po = this.convertToPublicObject(browse);
                    if (po == null) continue;
                    this._searchResults.add(po);
                    if (!isAdditionalSearchingNeeded) continue;
                    objectIDCache.add(po.getIdentifier());
                }
            }
            if (isAdditionalSearchingNeeded) {
                this.runDisplayNameSearch(this._searchResults, this._searchFilters, objectIDCache);
            }
        }
        if (SortOrder.isSortingEnabled() && this._searchResults != null && this._searchResults.size() > 0) {
            Collections.sort(this._searchResults, SortOrder.getComparator(this.getResultDetails().getSortOrder()));
        }
        if ((limit = this.getResultDetails().getResultLimit()) != ResultDetails.ResultLimit.UNLIMITED) {
            int intLimit = limit.getLimit();
            if (this._searchResults.size() > intLimit) {
                ArrayList<PublicObjectInterface> subResults = new ArrayList<PublicObjectInterface>();
                for (PublicObjectInterface sobj : this._searchResults) {
                    subResults.add(sobj);
                    if (subResults.size() < intLimit) continue;
                    break;
                }
                return Collections.unmodifiableList(subResults);
            }
        }
        return Collections.unmodifiableList(this._searchResults);
    }

    private PublicObjectInterface convertToPublicObject(BrowseMetadataInterface browse) throws ServiceException, RemoteException {
        TypeDescriptorInterface type;
        String publicType;
        if (browse != null && (publicType = (String)browse.getRawData().get("PublicType")) != null && (type = this._server.getTypeDescriptor(publicType)) != null) {
            return PublicObjectFactory.createPublicObject(this._server, browse);
        }
        return null;
    }

    private void runDisplayNameSearch(List<PublicObjectInterface> searchResults, List<SearchFilter> searchFilters, Set<String> objectIDCache) throws ServiceException, RemoteException {
        boolean typeFilterExists = false;
        ArrayList<SearchFilter> newFilters = new ArrayList<SearchFilter>();
        for (SearchFilter filter : searchFilters) {
            Serializable originalFilter;
            if (filter instanceof ObjectNameFilter) {
                originalFilter = (ObjectNameFilter)filter;
                DisplayNameFilter newNameFilter = new DisplayNameFilter(((ObjectNameFilter)originalFilter).getName(), ((ObjectNameFilter)originalFilter).isIncludingDescription(), ((ObjectNameFilter)originalFilter).getSearchOperator());
                newFilters.add(newNameFilter);
                continue;
            }
            if (filter instanceof PublicTypeFilter) {
                typeFilterExists = true;
                originalFilter = (PublicTypeFilter)filter;
                List<String> originalTypes = ((PublicTypeFilter)originalFilter).getTypes();
                ArrayList<String> newTypes = new ArrayList<String>(3);
                if (originalTypes == null || originalTypes.isEmpty()) {
                    newTypes.add("User");
                    newTypes.add("UserGroup");
                    newTypes.add("Role");
                } else {
                    if (originalTypes.contains("User")) {
                        newTypes.add("User");
                    }
                    if (originalTypes.contains("UserGroup")) {
                        newTypes.add("UserGroup");
                    }
                    if (originalTypes.contains("Role")) {
                        newTypes.add("Role");
                    }
                }
                if (newTypes.isEmpty()) continue;
                newFilters.add(new PublicTypeFilter(newTypes));
                continue;
            }
            newFilters.add(filter);
        }
        if (!typeFilterExists) {
            ArrayList<String> newTypes = new ArrayList<String>(3);
            newTypes.add("User");
            newTypes.add("UserGroup");
            newTypes.add("Role");
            newFilters.add(new PublicTypeFilter(newTypes));
        }
        FilterInterface filter = this.createSearchFilter(newFilters);
        filter.setType("Identity");
        List objects = this._server.browseSearch(filter);
        if (objects != null && !objects.isEmpty()) {
            for (BrowseMetadataInterface browse : objects) {
                PublicObjectInterface po;
                if (objectIDCache != null && objectIDCache.contains(browse.getReposId()) || (po = this.convertToPublicObject(browse)) == null) continue;
                this._searchResults.add(po);
            }
        }
    }

    private boolean isDisplayNameSearchNeeded(List<SearchFilter> searchFilters) {
        boolean nameSearch = false;
        boolean typeSearch = false;
        boolean typeFilterFound = false;
        if (searchFilters != null) {
            for (SearchFilter filter : searchFilters) {
                if (filter instanceof ObjectNameFilter) {
                    nameSearch = true;
                    continue;
                }
                if (!(filter instanceof PublicTypeFilter)) continue;
                typeFilterFound = true;
                List<String> types = ((PublicTypeFilter)filter).getTypes();
                if (types != null && !types.isEmpty() && !types.contains("User") && !types.contains("UserGroup") && !types.contains("Role")) continue;
                typeSearch = true;
            }
        }
        if (!typeFilterFound) {
            typeSearch = true;
        }
        return typeSearch && nameSearch;
    }

    private List<PublicObjectInterface> folderSearch(FolderInterface folder) throws ServiceException, RemoteException {
        ArrayList<PublicObjectInterface> results = new ArrayList<PublicObjectInterface>();
        this.lookforFolderTypeinSearchFilters(this._searchFilters);
        if (this._includeMatchingFolders) {
            FilterInterface filter = this.createSubFoldersSearchFilter(folder.getIdentifier(), this._searchFilters, this._recursiveFolderSearching);
            this.searchForMatchingSubFolders(folder, filter, results);
            this._includeMatchingFolders = false;
            FilterInterface filter2 = this.createFolderSearchFilter(folder.getIdentifier(), this._searchFilters, this._recursiveFolderSearching);
            this.searchForMatchingMembers(folder, filter2, results);
            this._includeMatchingFolders = true;
        } else {
            FilterInterface filter = this.createFolderSearchFilter(folder.getIdentifier(), this._searchFilters, this._recursiveFolderSearching);
            this.searchForMatchingMembers(folder, filter, results);
        }
        return results;
    }

    private void lookforFolderTypeinSearchFilters(List<SearchFilter> filtersList) {
        boolean typeFilterExists = false;
        if (filtersList != null && filtersList.size() > 0) {
            block0: for (SearchFilter sc : filtersList) {
                if (!(sc instanceof PublicTypeFilter)) continue;
                this._includeMatchingFolders = false;
                typeFilterExists = true;
                List<String> selectedTypes = ((PublicTypeFilter)sc).getTypes();
                int length = selectedTypes.size();
                for (int i = 0; i < length; ++i) {
                    String type = selectedTypes.get(i);
                    if (!FolderUtil.isFolder(type)) continue;
                    this._includeMatchingFolders = true;
                    continue block0;
                }
            }
        }
        if (!typeFilterExists) {
            this._includeMatchingFolders = true;
        }
    }

    private void searchForMatchingMembers(FolderInterface folder, FilterInterface filter, List<PublicObjectInterface> results) throws ServiceException, RemoteException {
        String key = folder.getIdentifier() + "/" + folder.getTypeDescriptor().getMetadataType();
        if (folder instanceof RootFolderInterface) {
            if (this._recursiveFolderSearching) {
                BrowseMetadataInterface browseRoot = this._server.browseFolder(key, this.getRootFolderFilter());
                List topLevelFolders = (List)browseRoot.get("SoftwareTrees");
                for (BrowseMetadataInterface topLevelFolder : topLevelFolders) {
                    key = topLevelFolder.getReposId() + "/" + topLevelFolder.getNativeType();
                    BrowseMetadataInterface browseFolder = this._server.browseFolder(key, filter);
                    this.parseFolderContents(browseFolder, folder, results);
                }
            }
        } else {
            BrowseMetadataInterface browseFolder = this._server.browseFolder(key, filter);
            this.parseFolderContents(browseFolder, folder, results);
        }
    }

    private void parseFolderContents(BrowseMetadataInterface browseFolder, FolderInterface folder, List<PublicObjectInterface> results) throws ServiceException, RemoteException {
        List members;
        BrowseMetadataInterface subFolder;
        int i;
        int subFolderSize;
        List subFolders;
        if (this._includeMatchingFolders && !browseFolder.getReposId().equalsIgnoreCase(folder.getIdentifier())) {
            this.processResult(browseFolder, results);
        }
        if (this._recursiveFolderSearching) {
            subFolders = browseFolder.getSubfolders();
            if (subFolders != null) {
                subFolderSize = subFolders.size();
                for (i = 0; i < subFolderSize; ++i) {
                    subFolder = (BrowseMetadataInterface)subFolders.get(i);
                    if (!subFolder.isAFolder()) continue;
                    this.parseFolderContents(subFolder, folder, results);
                }
            }
        } else if (this._includeMatchingFolders && (subFolders = browseFolder.getSubfolders()) != null) {
            subFolderSize = subFolders.size();
            for (i = 0; i < subFolderSize; ++i) {
                subFolder = (BrowseMetadataInterface)subFolders.get(i);
                if (!subFolder.isAFolder()) continue;
                this.processResult(subFolder, results);
            }
        }
        if ((members = browseFolder.getMembers()) != null && members.size() > 0) {
            int memberSize = members.size();
            for (i = 0; i < memberSize; ++i) {
                BrowseMetadataInterface member = (BrowseMetadataInterface)members.get(i);
                this.processResult(member, results);
            }
        }
    }

    private void searchForMatchingSubFolders(FolderInterface folder, FilterInterface filter, List<PublicObjectInterface> results) throws ServiceException, RemoteException {
        String key = folder.getIdentifier() + "/" + folder.getTypeDescriptor().getMetadataType();
        if (this._recursiveFolderSearching) {
            List matchingFoldersList = this._server.browseSearch(filter);
            this.processMatchingSubFolders(matchingFoldersList, folder, results);
        } else if (folder instanceof RootFolderInterface) {
            BrowseMetadataInterface softwareComp = this._server.browseFetch(key, filter);
            List matchingTrees = (List)softwareComp.get("SoftwareTrees");
            if (matchingTrees != null) {
                Iterator iter = matchingTrees.iterator();
                BrowseMetadataInterface bmi = null;
                while (iter.hasNext()) {
                    bmi = (BrowseMetadataInterface)iter.next();
                    this.processResult(bmi, results);
                }
            }
        } else {
            BrowseMetadataInterface browseFolder = this._server.browseFolder(key, filter);
            this.parseFolderContents(browseFolder, folder, results);
        }
    }

    private void processMatchingSubFolders(List<BrowseMetadataInterface> matchingFoldersList, FolderInterface folder, List<PublicObjectInterface> results) throws ServiceException, RemoteException {
        for (BrowseMetadataInterface bmi : matchingFoldersList) {
            boolean addToResults = this.isFolderUnderParentSearchFolder(bmi, folder);
            if (!addToResults) continue;
            this.processResult(bmi, results);
        }
    }

    private boolean isFolderUnderParentSearchFolder(BrowseMetadataInterface browseObj, FolderInterface folder) throws ServiceException, RemoteException {
        boolean inParentTree = false;
        String parentID = folder.getIdentifier();
        List parents = browseObj.getParents();
        if (parents != null && !parents.isEmpty()) {
            BrowseMetadataInterface parentBrowse = (BrowseMetadataInterface)parents.get(0);
            if (parentID.equals(parentBrowse.getReposId())) {
                return true;
            }
            inParentTree = this.isFolderUnderParentSearchFolder(parentBrowse, folder);
        } else {
            List scParents = (List)browseObj.get("SoftwareComponents");
            if (scParents != null && !scParents.isEmpty()) {
                for (BrowseMetadataInterface scParent : scParents) {
                    if (!parentID.equals(scParent.getReposId())) continue;
                    return true;
                }
            }
            inParentTree = false;
        }
        return inParentTree;
    }

    private void processResult(BrowseMetadataInterface browseObject, List<PublicObjectInterface> results) throws ServiceException, RemoteException {
        PublicObjectInterface po = PublicObjectFactory.createPublicObject(this._server, browseObject);
        if (po != null && po.getTypeDescriptor() != null) {
            results.add(po);
        }
    }

    private FilterInterface getRootFolderFilter() {
        Filter filter = new Filter();
        filter.setOMRTemplate("<Templates><SoftwareComponent Name=\"\" PublicType=\"\" UsageVersion=\"\"><SoftwareTrees/></SoftwareComponent><Tree Name=\"\" PublicType=\"\" UsageVersion=\"\"/></Templates>");
        filter.setOMRFlags(-2147483644);
        return filter;
    }

    protected FilterInterface createSearchFilter(List<SearchFilter> filtersList) throws ServiceException, RemoteException {
        Filter filter = new Filter();
        filter.setType("PrimaryType");
        StringBuilder template = new StringBuilder();
        template.append("<Templates>");
        template.append(this._resultDetails.getTemplate());
        template.append("</Templates>");
        filter.setOMRTemplate(template.toString());
        if (this._repos != null) {
            filter.setOMRRepository(this._repos.getDefaultRepositoryId());
            filter.setOMRFlags(-2080374380);
        } else {
            OMIRepositoryInterface ri = (OMIRepositoryInterface)this._server.getFoundationRepository();
            filter.setOMRRepository(ri.getDefaultRepositoryId());
            filter.setOMRFlags(-2080366188);
        }
        FilterComponent comp = new FilterComponent();
        filter.setFilterComponent(comp);
        comp.setAggregation(0);
        boolean typeFilterExists = false;
        if (filtersList != null && filtersList.size() > 0) {
            for (SearchFilter sc : filtersList) {
                comp.addComponent(sc.getFilterComponent());
                if (!(sc instanceof PublicTypeFilter)) continue;
                typeFilterExists = true;
            }
        }
        if (!typeFilterExists) {
            comp.addComponent(new DefaultPublicTypeFilter().getFilterComponent());
        }
        return filter;
    }

    protected FilterInterface createFolderSearchFilter(String folderID, List<SearchFilter> filtersList, boolean recursiveSearch) throws ServiceException, RemoteException {
        boolean searchFromRoot;
        if (!this._supportedServerVersion) {
            recursiveSearch = true;
        }
        Filter filter = new Filter();
        String rootFolderID = this._server.getRootFolder().getIdentifier();
        boolean bl = searchFromRoot = rootFolderID.equals(folderID);
        if (searchFromRoot || !rootFolderID.substring(0, 8).equals(folderID.substring(0, 8))) {
            filter.setOMRFlags(-2080366188);
        } else {
            filter.setOMRFlags(-2080374380);
        }
        filter.setOMRFlags(-2080374380);
        if (this._repos != null) {
            filter.setOMRRepository(this._repos.getDefaultRepositoryId());
        } else {
            OMIRepositoryInterface ri = (OMIRepositoryInterface)this._server.getFoundationRepository();
            filter.setOMRRepository(ri.getDefaultRepositoryId());
        }
        ResultDetails details = this.getResultDetails();
        String memberTemplate = details.getTemplate();
        String folderAttributes = details.getFolderAttributesForTemplate();
        FilterInterface subFoldersFilter = this.getSubFoldersFilter(filtersList, folderID);
        FilterInterface membersFilter = this.getMembersFilter(filtersList, folderID);
        StringBuilder sb = new StringBuilder(250);
        sb.append("<Templates>");
        if (recursiveSearch) {
            sb.append("<Tree ").append(folderAttributes).append(">");
            if (subFoldersFilter != null) {
                sb.append("<SubTrees ");
                sb.append(subFoldersFilter.getOMRSearchString());
                sb.append("/>");
            }
            if (membersFilter != null) {
                sb.append("<Members ");
                sb.append(membersFilter.getOMRSearchString());
                sb.append("/>");
            }
            this.appendFolderTemplateAssociations(sb, details);
            sb.append("</Tree>");
            sb.append(memberTemplate);
        } else {
            sb.append("<Template TemplateName=\"Tree\">");
            sb.append("<Tree ").append(folderAttributes).append(">");
            if (subFoldersFilter != null) {
                sb.append("<SubTrees ");
                sb.append(subFoldersFilter.getOMRSearchString());
                sb.append(">");
                sb.append("<Tree TemplateName=\"SubTree\"/>");
                sb.append("</SubTrees>");
            }
            if (membersFilter != null) {
                sb.append("<Members ");
                sb.append(membersFilter.getOMRSearchString());
                sb.append("/>");
            }
            this.appendFolderTemplateAssociations(sb, details);
            sb.append("</Tree>");
            sb.append(memberTemplate);
            sb.append("</Template>");
            sb.append("<Template TemplateName=\"SubTree\">");
            sb.append("<Tree ").append(folderAttributes).append(" >");
            this.appendFolderTemplateAssociations(sb, details);
            sb.append("</Tree>");
            this.appendTemplateAssociations(sb, details);
            sb.append("</Template>");
        }
        sb.append("</Templates>");
        filter.setOMRTemplate(sb.toString());
        return filter;
    }

    private void appendFolderTemplateAssociations(StringBuilder sb, ResultDetails details) {
        if (details.isKeywordsIncluded()) {
            sb.append("<Keywords/>");
        }
        if (details.isResponsiblePartiesIncluded()) {
            sb.append("<ResponsibleParties/>");
        }
    }

    private void appendTemplateAssociations(StringBuilder sb, ResultDetails details) {
        if (details.isKeywordsIncluded()) {
            sb.append("<Keyword Name=\"\"/>");
        }
        if (details.isResponsiblePartiesIncluded()) {
            sb.append("<ResponsibleParty Name=\"\" Role=\"\">");
            sb.append("  <Persons/>");
            sb.append("</ResponsibleParty>");
            sb.append("<Person Name=\"\" DisplayName=\"\" />");
        }
    }

    protected FilterInterface createRootFolderSearchFilter(List<SearchFilter> filtersList) throws ServiceException, RemoteException {
        Filter filter = new Filter();
        filter.setOMRFlags(-2080366188);
        ResultDetails details = this.getResultDetails();
        String folderAttributes = details.getFolderAttributesForTemplate();
        FilterInterface subFoldersFilter = this.getSubFoldersFilter(filtersList, null);
        StringBuilder sb = new StringBuilder(250);
        sb.append("<Templates>");
        sb.append("<SoftwareComponent Name=\"\" PublicType=\"\" UsageVersion=\"\">");
        if (subFoldersFilter != null) {
            sb.append("<SoftwareTrees ");
            sb.append(subFoldersFilter.getOMRSearchString());
            sb.append("/>");
        }
        sb.append("</SoftwareComponent>");
        sb.append("<Tree ").append(folderAttributes).append(">");
        this.appendFolderTemplateAssociations(sb, details);
        sb.append("</Tree>");
        this.appendTemplateAssociations(sb, details);
        sb.append("</Templates>");
        filter.setOMRTemplate(sb.toString());
        return filter;
    }

    protected FilterInterface createSubFoldersSearchFilter(String folderID, List<SearchFilter> filtersList, boolean recursiveSearch) throws ServiceException, RemoteException {
        boolean searchFromRoot;
        int folderFlags = -2080374396;
        String rootFolderID = this._server.getRootFolder().getIdentifier();
        boolean bl = searchFromRoot = rootFolderID.equals(folderID);
        if (searchFromRoot || !rootFolderID.substring(0, 8).equals(folderID.substring(0, 8))) {
            folderFlags |= 0x2000;
        }
        Filter filter = new Filter();
        filter.setOMRFlags(folderFlags);
        filter.setType("Tree");
        if (this._repos != null) {
            filter.setOMRRepository(this._repos.getDefaultRepositoryId());
        } else {
            OMIRepositoryInterface ri = (OMIRepositoryInterface)this._server.getFoundationRepository();
            filter.setOMRRepository(ri.getDefaultRepositoryId());
        }
        FilterInterface subFoldersFilter = this.getSubFoldersFilter(filtersList, folderID);
        StringBuilder sb = new StringBuilder(250);
        sb.append("<Templates>");
        if (recursiveSearch) {
            filter.setExplicitSearchString("omi", subFoldersFilter.getXMLSelectString());
            sb.append("<Template TemplateName=\"Tree\">");
            sb.append("<Tree ");
            sb.append(this._resultDetails.getFolderAttributesForTemplate());
            sb.append(">");
            sb.append("<ParentTree/>");
            sb.append("<SoftwareComponents/>");
            sb.append("</Tree>");
            sb.append("<SoftwareComponent Name=\"\" PublicType=\"\" />");
            sb.append("</Template>");
        } else if (searchFromRoot) {
            sb.append("<SoftwareComponent Name=\"\" PublicType=\"\" >");
            sb.append("<SoftwareTrees ");
            sb.append(subFoldersFilter.getOMRSearchString());
            sb.append("/>");
            sb.append("</SoftwareComponent>");
            sb.append("<Tree ");
            sb.append(this._resultDetails.getFolderAttributesForTemplate());
            sb.append("/>");
        } else {
            sb.append("<Template TemplateName=\"Tree\">");
            sb.append("<Tree ");
            sb.append(this._resultDetails.getFolderAttributesForTemplate());
            sb.append(">");
            if (subFoldersFilter != null) {
                sb.append("<SubTrees ");
                sb.append(subFoldersFilter.getOMRSearchString());
                sb.append(">");
                sb.append("<Tree TemplateName=\"SubTree\"/>");
                sb.append("</SubTrees>");
            }
            sb.append("</Tree>");
            sb.append("</Template>");
            sb.append("<Template TemplateName=\"SubTree\">");
            sb.append("<Tree Name=\"\" PublicType=\"\" TreeType=\"\"/>");
            sb.append("</Template>");
        }
        sb.append("</Templates>");
        filter.setOMRTemplate(sb.toString());
        return filter;
    }

    protected FilterInterface getSubFoldersFilter(List<SearchFilter> filtersList, String folderID) {
        Filter subFoldersFilter = new Filter();
        if (this._includeMatchingFolders) {
            List<String> types;
            FilterComponent comp = new FilterComponent();
            comp.setAggregation(0);
            subFoldersFilter.setFilterComponent(comp);
            PublicTypeFilter typeFilter = null;
            if (filtersList != null && filtersList.size() > 0) {
                for (SearchFilter sc : filtersList) {
                    if (sc instanceof PublicTypeFilter) {
                        typeFilter = (PublicTypeFilter)sc;
                        continue;
                    }
                    comp.addComponent(sc.getFilterComponent());
                }
            }
            ArrayList<String> folderTypes = new ArrayList<String>(2);
            PublicTypeFilter folderTypeFilter = null;
            if (typeFilter != null && (types = typeFilter.getTypes()) != null && !types.isEmpty()) {
                for (String type : types) {
                    if (!FolderUtil.isFolder(type)) continue;
                    folderTypes.add(type);
                }
            }
            folderTypeFilter = !folderTypes.isEmpty() ? new PublicTypeFilter(folderTypes, false) : new PublicTypeFilter(Arrays.asList("Folder"), true);
            comp.addComponent(folderTypeFilter.getFilterComponent());
        } else {
            PublicTypeFilter folderSearchFilter = new PublicTypeFilter(Arrays.asList("Folder"), true);
            subFoldersFilter.setFilterComponent(folderSearchFilter.getFilterComponent());
        }
        return subFoldersFilter;
    }

    protected FilterInterface getMembersFilter(List<SearchFilter> filtersList, String folderID) {
        boolean typeFilterExists = false;
        Filter membersFilter = new Filter();
        FilterComponent comp = new FilterComponent();
        comp.setAggregation(0);
        membersFilter.setFilterComponent(comp);
        if (filtersList != null && filtersList.size() > 0) {
            for (SearchFilter sc : filtersList) {
                comp.addComponent(sc.getFilterComponent());
                if (!(sc instanceof PublicTypeFilter)) continue;
                typeFilterExists = true;
            }
        }
        if (!this.isIncludingUnknownPublicTypes() && !typeFilterExists) {
            comp.addComponent(new DefaultPublicTypeFilter().getFilterComponent());
        }
        return membersFilter;
    }

    protected void setIncludeUnknownPublicTypes(boolean include) {
        this._includeUnknownPublicTypes = include;
    }

    protected boolean isIncludingUnknownPublicTypes() {
        return this._includeUnknownPublicTypes;
    }

    protected void setIncludeNonSearchablePublicTypes(boolean include) {
        this._includeNonSearchablePublicTypes = include;
    }

    protected boolean isIncludingNonSearchablePublicTypes() {
        return this._includeNonSearchablePublicTypes;
    }

    @Override
    public ResultDetails getResultDetails() throws RemoteException {
        if (this._resultDetails == null) {
            this._resultDetails = ResultDetails.getInstance();
            this._resultDetails.setDescriptionIncluded(true);
            this._resultDetails.setDatesIncluded(true);
        }
        return this._resultDetails;
    }

    @Override
    public PathUrl getFolderScope() throws RemoteException {
        return this._folderPathUrl;
    }

    @Override
    public void setFolderScope(PathUrl pathUrl, boolean recurse) throws RemoteException {
        if (pathUrl != null) {
            if (pathUrl.getType() == null) {
                pathUrl.setType("Folder");
                this._folderPathUrl = pathUrl;
            } else if (pathUrl.getType().equalsIgnoreCase("Folder")) {
                this._folderPathUrl = pathUrl;
            }
        } else {
            this._folderPathUrl = null;
        }
        this._recursiveFolderSearching = recurse;
    }

    @Override
    public List<SearchFilter> getFilters() throws RemoteException {
        return this._searchFilters;
    }

    @Override
    public void addFilter(SearchFilter filter) throws RemoteException {
        if (this._searchFilters == null) {
            this._searchFilters = new ArrayList<SearchFilter>();
        }
        for (SearchFilter searchFilter : this._searchFilters) {
            if (!searchFilter.getClass().equals(filter.getClass())) continue;
            this._searchFilters.remove(searchFilter);
            break;
        }
        this._searchFilters.add(filter);
    }

    @Override
    public void removeFilter(SearchFilter filter) throws RemoteException {
        if (this._searchFilters != null && this._searchFilters.contains(filter)) {
            this._searchFilters.remove(filter);
        }
    }

    @Override
    public void setRepository(OMIRepositoryInterface repos) throws RemoteException {
        this._repos = repos;
    }

    @Override
    public OMIRepositoryInterface getRepository() throws RemoteException {
        return this._repos;
    }

    @Override
    public List<PublicObjectInterface> getSearchResults() throws RemoteException {
        return this._searchResults;
    }

    @Override
    public boolean isFolderSearchRecursive() throws RemoteException {
        return this._recursiveFolderSearching;
    }

    public boolean isAssociatedToSearchFolder() {
        return this._isAssociated;
    }

    protected void setSearchFolder(SearchFolder searchFolder) {
        this._searchFolder = searchFolder;
        this._isAssociated = searchFolder != null;
    }

    protected SearchFolder getSearchFolder() {
        return this._searchFolder;
    }

    @Override
    public void setValidateCriteria(boolean validate) throws RemoteException {
        this._validateCriteria = validate;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    @SASScope
    class DefaultPublicTypeFilter
    extends PublicTypeFilter {
        private static final long serialVersionUID = -3526788075347401909L;

        public DefaultPublicTypeFilter() {
            super(null);
        }

        @Override
        public FilterComponent getFilterComponent() {
            FilterComponent comp = new FilterComponent();
            comp.setAggregation(0);
            comp.addComponent(new FilterComponent("PublicType", 11, ""));
            if (!SearchImpl.this.isIncludingNonSearchablePublicTypes()) {
                this.setPublicTypeFilterExclusions(comp);
            }
            return comp;
        }

        private void setPublicTypeFilterExclusions(FilterComponent comp) {
            try {
                MetadataServerInterface msi = (MetadataServerInterface)SearchImpl.this.getServer();
                Map typeMap = msi.getTypeDictionaryMap();
                for (String nextKey : typeMap.keySet()) {
                    TypeDescriptorInterface tdi = (TypeDescriptorInterface)typeMap.get(nextKey);
                    String isSearchAllowed = tdi.getPropertyValue("IsSearchAllowed");
                    if (isSearchAllowed == null || !isSearchAllowed.equalsIgnoreCase("false")) continue;
                    String publicType = tdi.getTypeName();
                    comp.addComponent(new FilterComponent("PublicType", 11, publicType));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

