/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.search.impl;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.impl.SearchImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.services.information.search.ResultDetails;
import com.sas.services.information.search.Search;
import com.sas.services.information.search.SearchCriteriaModel;
import com.sas.services.information.search.SearchFactory;
import com.sas.services.information.search.SearchFilter;
import com.sas.services.information.search.SearchFolder;
import com.sas.services.information.search.SearchUtility;
import com.sas.services.information.search.SortOrder;
import com.sas.services.information.search.impl.RB;
import com.sas.services.information.search.impl.SearchImpl;
import com.sas.storage.editableproperties.LocalizableProperties;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.editableproperties.UnexpectedLocalizationException;
import com.sas.text.Message;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.logging.log4j.Level;

@SASScope
public class SearchFolderImpl
extends Metadata
implements SearchFolder,
LocalizableProperties {
    private static final long serialVersionUID = 7176132004714989173L;
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(2, 0);
    public static final UsageVersion NINETHREE_VERSION = new UsageVersion(1, 0);
    private SearchCriteriaModel _scm = null;
    boolean folderHasBeenChecked = false;
    private List<PublicObjectInterface> _searchResults = new ArrayList<PublicObjectInterface>();
    private Search _search = null;

    public SearchFolderImpl() throws RemoteException {
        super(SearchFolderImpl.class);
    }

    public SearchFolderImpl(Object o) throws RemoteException {
        super(o);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public SearchFolderImpl(com.sas.metadata.remote.Search o) throws RemoteException {
        super(o);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public SearchFolderImpl(com.sas.metadata.remote.impl.SearchImpl o) throws RemoteException {
        super(o);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public SearchFolderImpl(SearchImpl_Stub o) throws RemoteException {
        super(o);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public SearchFolderImpl(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        super(SearchFolderImpl.class);
        if (repos == null || name == null) {
            throw new IllegalArgumentException();
        }
        OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
        try {
            com.sas.metadata.remote.Search searchObj = (com.sas.metadata.remote.Search)omirepository.createMetadata(name, "Search");
            searchObj.setPublicType("SearchFolder");
            searchObj.setUsageVersion(CURRENT_VERSION.encode());
            this._isCompatible = true;
            this._isReadCompatible = true;
            this._repositoryObject = searchObj;
            this._repositoryFlag = 2;
            this.setRepository(repos);
            if (parent != null) {
                try {
                    parent.addItem(this);
                }
                catch (ServiceException serviceException) {}
            }
        }
        catch (ServiceException ex) {
            this.logThrowable(Level.WARN, ex.getMessage(), "com.sas.services.information.search.impl.SearchFolderImpl", (Throwable)((Object)ex));
        }
    }

    public void setSearch(Search search) throws ServiceException, RemoteException {
        this._search = search;
        if (search instanceof SearchImpl) {
            ((SearchImpl)this._search).setSearchFolder(this);
        }
    }

    @Override
    public void update() throws ServiceException, RemoteException {
        if (this._search == null) {
            this._search = this.getSearch();
        }
        com.sas.metadata.remote.Search searchObj = (com.sas.metadata.remote.Search)this._repositoryObject;
        this._scm = SearchUtility.createSearchCriteriaModel(this._search);
        String searchDetailsString = SearchUtility.getModelXML(this._scm);
        searchObj.setDetails(searchDetailsString);
        this._searchResults = this._search.getSearchResults();
        if (this._scm.getModelVersion() == 1) {
            searchObj.setUsageVersion(NINETHREE_VERSION.encode());
        }
        super.update();
    }

    @Override
    public List<PublicObjectInterface> getSearchResults() throws ServiceException, RemoteException {
        if (!this._isCompatible) {
            if (this._isReadCompatible) {
                this.logMessage(Level.WARN, Message.format((ResourceBundle)RB.getResources(), (String)"SearchFolderImpl.IsCompatible.warning.txt", (Object)this.getUsageVersion(), (Object)CURRENT_VERSION));
            } else {
                throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
            }
        }
        if (this._searchResults == null || this._searchResults.size() == 0) {
            this._searchResults = this.search();
        }
        return this._searchResults;
    }

    private ResultDetails.ResultLimit getResultLimit() throws ServiceException, RemoteException {
        if (this._scm != null) {
            return this._scm.getResultLimit();
        }
        this.retrieveSearchDetails();
        return this._scm.getResultLimit();
    }

    private List<SearchFilter> getSearchFilters() throws ServiceException, RemoteException {
        if (this._scm != null) {
            return this._scm.getSearchFilters();
        }
        this.retrieveSearchDetails();
        return this._scm.getSearchFilters();
    }

    private SortOrder[] getSortOrder() throws ServiceException, RemoteException {
        if (this._scm != null) {
            return this._scm.getSortOrder();
        }
        this.retrieveSearchDetails();
        return this._scm.getSortOrder();
    }

    private PathUrl getFolderPathURL() throws ServiceException, RemoteException {
        if (this.folderHasBeenChecked) {
            return this._scm.getFolderScope();
        }
        this.retrieveSearchDetails();
        return this._scm.getFolderScope();
    }

    private boolean isFolderSearchingRecursive() throws ServiceException, RemoteException {
        if (this.folderHasBeenChecked) {
            return this._scm.getRecursiveSearchFlag();
        }
        this.retrieveSearchDetails();
        return this._scm.getRecursiveSearchFlag();
    }

    private void retrieveSearchDetails() throws ServiceException, RemoteException {
        com.sas.metadata.remote.Search searchObj = (com.sas.metadata.remote.Search)this._repositoryObject;
        String searchDetailsString = null;
        try {
            searchDetailsString = searchObj.getDetails();
            if (searchDetailsString == null || searchDetailsString.length() == 0) {
                return;
            }
        }
        catch (Exception e) {
            throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"SearchFolderImpl.populatecriteria.error.fmt.txt", (Object)e.getMessage()));
        }
        ServerInterface si = this._repository.getServer();
        this._scm = SearchUtility.createSearchCriteriaModel(si, searchDetailsString);
        this.folderHasBeenChecked = true;
    }

    @Override
    public List<PublicObjectInterface> search() throws ServiceException, RemoteException {
        ArrayList<PublicObjectInterface> searchResults = new ArrayList<PublicObjectInterface>();
        this._search = this.getSearch();
        if (this._search == null) {
            return searchResults;
        }
        this._searchResults = this._search.search();
        return this._searchResults;
    }

    @Override
    public Search getSearch() throws ServiceException, RemoteException {
        if (this.getState() == 1) {
            this._search = SearchFactory.createSearch(this._repository.getServer());
        } else {
            if (this._search != null) {
                return this._search;
            }
            this._search = SearchFactory.createSearch(this._repository.getServer());
            this._search.setFolderScope(this.getFolderPathURL(), this.isFolderSearchingRecursive());
            this._search.getResultDetails().setResultLimit(this.getResultLimit());
            this._search.getResultDetails().setSortOrder(this.getSortOrder());
            List<SearchFilter> filterList = this.getSearchFilters();
            if (filterList != null) {
                for (SearchFilter sf : filterList) {
                    this._search.addFilter(sf);
                }
            }
            this.setSearch(this._search);
        }
        return this._search;
    }

    @Override
    public String getType() throws RemoteException {
        return "SearchFolder";
    }

    @Override
    public SearchFolder copyTo(FolderInterface folder, String name) throws ServiceException, RemoteException {
        SearchFolderImpl newSF = (SearchFolderImpl)super.copyTo(folder, name);
        this._search = this.getSearch();
        SearchImpl newSearch = null;
        if (this._search instanceof SearchImpl) {
            newSearch = (SearchImpl)((SearchImpl)this._search).clone();
            newSearch.setSearchFolder(newSF);
        }
        newSF.setSearch(newSearch);
        return newSF;
    }

    @Override
    public List getChildren() throws ServiceException, RemoteException {
        return this.getSearchResults();
    }

    @Override
    public PublicObjectInterface getChildAt(int index) throws ServiceException, RemoteException {
        List<PublicObjectInterface> resultList = this.getSearchResults();
        if (index < 0 || index > resultList.size()) {
            return null;
        }
        return resultList.get(index);
    }

    @Override
    public int getChildCount() throws ServiceException, RemoteException {
        List<PublicObjectInterface> resultList = this.getSearchResults();
        return resultList.size();
    }

    @Override
    public List getChildren(String type) throws ServiceException, RemoteException {
        throw new UnsupportedOperationException(RB.getStringResource("SearchFolderImpl.UnsupportedOperation.exception.txt"));
    }

    @Override
    public PublicObjectInterface newChild(String type, String name) throws ServiceException, RemoteException {
        throw new UnsupportedOperationException(RB.getStringResource("SearchFolderImpl.UnsupportedOperation.exception.txt"));
    }

    public PropertyList getLocalizableProperties() throws UnexpectedLocalizationException {
        return this.getDefaultLocalizableProperties();
    }

    public void setLocalizableProperties(PropertyMap map) throws UnexpectedLocalizationException {
        this.setDefaultLocalizableProperties(map);
    }
}

