/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.search;

import com.sas.services.information.search.RB;
import com.sas.services.information.search.SortOrder;

public class ResultDetails {
    private boolean _includeDescription = false;
    private boolean _includeDates = false;
    private boolean _includeKeywords = false;
    private boolean _includeResponsibleParties = false;
    private boolean _modified = false;
    private String _template = null;
    private ResultLimit _resultLimit = ResultLimit.UNLIMITED;
    protected SortOrder[] _sortOrder = SortOrder.getDefaultOrder();

    public static ResultDetails getInstance() {
        return new ResultDetails();
    }

    public void setDescriptionIncluded(boolean include) {
        this.setContentsModified(true);
        this._includeDescription = include;
    }

    public void setDatesIncluded(boolean include) {
        this.setContentsModified(true);
        this._includeDates = include;
    }

    public void setKeywordsIncluded(boolean include) {
        this.setContentsModified(true);
        this._includeKeywords = include;
    }

    public void setResponsiblePartiesIncluded(boolean include) {
        this.setContentsModified(true);
        this._includeResponsibleParties = include;
    }

    public boolean isDescriptionIncluded() {
        return this._includeDescription;
    }

    public boolean isDatesIncluded() {
        return this._includeDates;
    }

    public boolean isKeywordsIncluded() {
        return this._includeKeywords;
    }

    public boolean isResponsiblePartiesIncluded() {
        return this._includeResponsibleParties;
    }

    public String getTemplate() {
        if (this._template == null || this._modified) {
            this._template = this.generateTemplate();
        }
        return this._template;
    }

    protected void setContentsModified(boolean modified) {
        this._modified = modified;
    }

    private String generateTemplate() {
        StringBuilder sb = new StringBuilder(100);
        sb.append("<Root Name=\"\" DisplayName=\"\" PublicType=\"\" UsageVersion=\"\" ");
        if (this.isDescriptionIncluded()) {
            sb.append("Desc=\"\" ");
        }
        if (this.isDatesIncluded()) {
            sb.append("MetadataCreated=\"\" MetadataUpdated=\"\" ");
        }
        sb.append(">");
        StringBuilder sbAssocs = null;
        if (this.isKeywordsIncluded()) {
            sb.append("<Keywords/>");
            if (sbAssocs == null) {
                sbAssocs = new StringBuilder();
            }
            sbAssocs.append("<Keyword Name=\"\"/>");
        }
        if (this.isResponsiblePartiesIncluded()) {
            sb.append("<ResponsibleParties/>");
            if (sbAssocs == null) {
                sbAssocs = new StringBuilder();
            }
            sbAssocs.append("<ResponsibleParty Name=\"\" Role=\"\">");
            sbAssocs.append("  <Persons/>");
            sbAssocs.append("</ResponsibleParty>");
            sbAssocs.append("<Person Name=\"\" DisplayName=\"\" />");
        }
        sb.append("</Root>");
        if (sbAssocs != null && sbAssocs.length() > 0) {
            sb.insert(0, sbAssocs);
        }
        return sb.toString();
    }

    public String getFolderAttributesForTemplate() {
        StringBuilder sb = new StringBuilder(100);
        sb.append("Name=\"\" PublicType=\"\" UsageVersion=\"\" TreeType=\"\" ");
        if (this.isDescriptionIncluded()) {
            sb.append("Desc=\"\" ");
        }
        if (this.isDatesIncluded()) {
            sb.append("MetadataCreated=\"\" MetadataUpdated=\"\" ");
        }
        return sb.toString();
    }

    public void setResultLimit(ResultLimit limit) {
        if (limit == null) {
            return;
        }
        this._resultLimit = limit;
    }

    public ResultLimit getResultLimit() {
        return this._resultLimit;
    }

    public void setSortOrder(SortOrder[] order) {
        if (order == null) {
            return;
        }
        this._sortOrder = order;
    }

    public SortOrder[] getSortOrder() {
        return this._sortOrder;
    }

    public static enum ResultLimit {
        UNLIMITED(RB.getStringResource("ResultLimit.NoLimit.txt"), -1),
        TEN(RB.getStringResource("ResultLimit.TenLimit.txt"), 10),
        TWENTYFIVE(RB.getStringResource("ResultLimit.TwentyFiveLimit.txt"), 25),
        FIFTY(RB.getStringResource("ResultLimit.FiftyLimit.txt"), 50),
        ONEHUNDRED(RB.getStringResource("ResultLimit.OneHundredLimit.txt"), 100);

        private String _displayname;
        private int _limit;

        private ResultLimit(String displayname, int lvalue) {
            this._displayname = displayname;
            this._limit = lvalue;
        }

        public int getLimit() {
            return this._limit;
        }

        public String toString() {
            return this._displayname;
        }

        public static ResultLimit getResultLimitforValue(int lvalue) {
            if (lvalue == UNLIMITED.getLimit()) {
                return UNLIMITED;
            }
            if (lvalue == TEN.getLimit()) {
                return TEN;
            }
            if (lvalue == TWENTYFIVE.getLimit()) {
                return TWENTYFIVE;
            }
            if (lvalue == FIFTY.getLimit()) {
                return FIFTY;
            }
            if (lvalue == ONEHUNDRED.getLimit()) {
                return ONEHUNDRED;
            }
            return UNLIMITED;
        }
    }
}

