/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.sasfolders;

import com.sas.services.ServiceException;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.services.information.sasfolders.ContainerNode;
import com.sas.services.information.sasfolders.FolderNodeInterface;
import java.rmi.RemoteException;

public class FolderNode
extends ContainerNode
implements FolderNodeInterface {
    private static final String TREE_TYPE = "TreeType";
    protected long _refreshTime = 0L;

    public FolderNode(BrowseMetadataInterface browseObject) {
        super(browseObject);
    }

    public FolderNode(String id, String name, TypeDescriptorInterface type) {
        super(id, name, type);
    }

    @Override
    protected void populateChildren() throws ServiceException, RemoteException {
        if (this._model != null && (!this.isPopulated() || this.isRefreshNeeded())) {
            if (this._children != null) {
                this._children.clear();
            }
            this._model.populateFolder(this);
        }
    }

    @Override
    public void setPopulated(boolean populated) {
        super.setPopulated(populated);
        this._refreshTime = System.currentTimeMillis();
    }

    private boolean isRefreshNeeded() {
        long refreshInterval = this._model.getConfiguration().getFolderRefreshValue();
        if (refreshInterval == -1L) {
            return false;
        }
        if (refreshInterval == 0L) {
            return true;
        }
        if (System.currentTimeMillis() - this._refreshTime > refreshInterval) {
            this._refreshTime = System.currentTimeMillis();
            return true;
        }
        return false;
    }

    @Override
    public String getFolderType() throws ServiceException, RemoteException {
        BrowseMetadataInterface browse = this.getBrowseObject();
        if (browse == null) {
            this.refresh();
        }
        String type = null;
        if (browse != null) {
            type = (String)this._browseObject.getRawData().get(TREE_TYPE);
        }
        return type == null ? "" : type;
    }
}

