/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.sasfolders;

import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.services.information.metadata.RootFolderInterface;
import com.sas.services.information.publicobject.PublicObjectContainerInterface;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.services.information.sasfolders.FolderModelInterface;
import com.sas.services.information.sasfolders.FolderModelListener;
import com.sas.services.information.sasfolders.FolderNodeInterface;
import com.sas.services.information.sasfolders.ModelConfiguration;
import com.sas.services.information.sasfolders.NodeFilterInterface;
import com.sas.services.information.sasfolders.RootFolderNode;
import com.sas.services.information.search.SortOrder;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractFolderModel2
implements FolderModelInterface {
    protected static final FilterInterface ROOT_FOLDER_FILTER = new Filter();
    protected static final FilterInterface FETCH_OBJECT_FILTER;
    protected Logger _logger = null;
    protected ServerInterface _server = null;
    protected FolderNodeInterface _rootFolder = null;
    protected NodeFilterInterface[] _nodeFilters = null;
    protected Comparator<PublicObjectInterface> _sortingComparator = SortOrder.getComparator(SortOrder.getDefaultOrder());
    protected SortOrder[] _sortOrder = null;
    protected ModelConfiguration _config = null;
    protected List<FolderModelListener> _modelListenerList = null;

    public AbstractFolderModel2(ServerInterface server) throws ServiceException, RemoteException {
        this._server = server;
        this._logger = LogManager.getLogger((String)"com.sas.services.information.sasfolders.AbstractFolderModel2");
        this._config = this.createModelConfiguration();
    }

    @Override
    public final void addFolderModelListener(FolderModelListener listener) {
        if (this._modelListenerList == null) {
            this._modelListenerList = new ArrayList<FolderModelListener>(5);
        }
        this._modelListenerList.add(listener);
    }

    @Override
    public final void removeFolderModelListener(FolderModelListener listener) {
        if (this._modelListenerList != null) {
            this._modelListenerList.remove(listener);
        }
    }

    @Override
    public ServerInterface getServer() {
        return this._server;
    }

    public SortOrder[] getSortOrder() throws ServiceException, RemoteException {
        return this._sortOrder;
    }

    public void setSortOrder(SortOrder[] order) throws ServiceException, RemoteException {
        this._sortingComparator = SortOrder.getComparator(order);
        this._sortOrder = order;
    }

    @Override
    public ModelConfiguration getConfiguration() {
        return this._config;
    }

    @Override
    public void setConfiguration(ModelConfiguration config) {
        this._config = config;
    }

    @Override
    public void setNodeFilters(NodeFilterInterface[] filters) {
        this._nodeFilters = filters;
    }

    @Override
    public NodeFilterInterface[] getNodeFilters() {
        return this._nodeFilters;
    }

    @Override
    public FolderNodeInterface getRootFolder() throws ServiceException, RemoteException {
        if (this._rootFolder == null) {
            RootFolderInterface rootFolder = this._server.getRootFolder();
            BrowseMetadataInterface browseRootFolder = this._server.browseFolder(rootFolder.getEntityKey(), ROOT_FOLDER_FILTER);
            this._rootFolder = new RootFolderNode(browseRootFolder);
            this._rootFolder.setFolderModel(this);
            ((RootFolderNode)this._rootFolder).setRootFolderPath(rootFolder.getPathUrl());
        }
        return this._rootFolder;
    }

    @Override
    public int getChildCount(PublicObjectContainerInterface parent) throws ServiceException, RemoteException {
        return parent.getChildCount();
    }

    protected ModelConfiguration createModelConfiguration() {
        return ModelConfiguration.getDefault();
    }

    protected void logMessage(Level level, String message, String loggingContext) {
        Logger logger = LogManager.getLogger((String)loggingContext);
        if (logger.isEnabled(level)) {
            logger.log(level, message);
        }
    }

    protected void logThrowable(Level level, String message, Throwable t, String loggingContext) {
        Logger logger = LogManager.getLogger((String)loggingContext);
        if (logger.isEnabled(level)) {
            logger.log(level, message, t);
        }
    }

    protected boolean isLoggingEnabled(Level level, String loggingContext) {
        Logger logger = LogManager.getLogger((String)loggingContext);
        return logger.isEnabled(level);
    }

    static {
        ROOT_FOLDER_FILTER.setOMRTemplate("<Templates><SoftwareComponent Name=\"\" PublicType=\"\" UsageVersion=\"\"><SoftwareTrees search=\"@PublicType='Folder'\"/></SoftwareComponent><Tree Name=\"\" PublicType=\"\" TreeType=\"\" UsageVersion=\"\"/></Templates>");
        ROOT_FOLDER_FILTER.setOMRFlags(-2147483644);
        FETCH_OBJECT_FILTER = new Filter();
        FETCH_OBJECT_FILTER.setOMRTemplate("<Templates><Tree Name=\"\" TreeType=\"\" PublicType=\"\"><ParentTree/><SoftwareComponents/></Tree><Root Name=\"\" PublicType=\"\" DisplayName=\"\"><Trees/></Root></Templates>");
        FETCH_OBJECT_FILTER.setOMRFlags(-2147483628);
    }
}

