/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.publicobject;

import com.sas.codepolicy.SASScope;
import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.publicobject.BasePublicObject;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.services.information.publicobject.RB;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import java.rmi.RemoteException;

@SASScope
public class PublicObjectFactory {
    public static final String PUBLIC_TYPE = "PublicType";

    public static PublicObjectInterface createPublicObject(ServerInterface server, String id, String name, String type) throws ServiceException, RemoteException {
        return PublicObjectFactory.createPublicObject(server, id, name, server.getTypeDescriptor(type));
    }

    public static PublicObjectInterface createPublicObject(ServerInterface server, String id, String name, TypeDescriptorInterface type) throws ServiceException, RemoteException {
        if (type == null) {
            throw new ServiceException(RB.getStringResource("PublicObjectFactory.MissingPublicType.txt"));
        }
        BasePublicObject po = new BasePublicObject(id, name, type);
        po.setServer(server);
        return po;
    }

    public static PublicObjectInterface createPublicObject(ServerInterface server, BrowseMetadataInterface browseObject) throws ServiceException, RemoteException {
        String publicType = (String)browseObject.getRawData().get(PUBLIC_TYPE);
        if (publicType == null || publicType.length() == 0) {
            return null;
        }
        TypeDescriptorInterface tdi = server.getTypeDescriptor(publicType);
        if (tdi == null) {
            throw new ServiceException(RB.getStringResource("PublicObjectFactory.MissingPublicType.txt"));
        }
        BasePublicObject po = new BasePublicObject(browseObject);
        po.setServer(server);
        return po;
    }

    public static void setPublicObjectPath(PublicObjectInterface publicObject, String absolutePath) throws ServiceException, RemoteException {
        if (publicObject instanceof BasePublicObject) {
            ServerInterface server = ((BasePublicObject)publicObject).getServer();
            if (server == null) {
                return;
            }
            PathUrl path = PathUrl.newPathUrlFromAbsolutePath(server, absolutePath);
            ((BasePublicObject)publicObject).setPathUrl(path);
        }
    }

    public static void setPublicObjectPath(PublicObjectInterface publicObject, PathUrl path) throws ServiceException, RemoteException {
        if (publicObject instanceof BasePublicObject) {
            ((BasePublicObject)publicObject).setPathUrl(path);
        }
    }
}

