/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata.servers;

import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.metadata.ServerInterface;
import com.sas.services.user.UserContextInterface;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.text.StringEscapeUtils;

public class ServersUtil {
    public static ServerInterface getServer(UserContextInterface userContext, String name) throws ServiceException {
        try {
            Filter filter = new Filter();
            filter.setType("ServerComponent");
            filter.setOMRFlags(8342);
            filter.setExplicitSearchString("omi", "<XMLSelect search=\"*[@Name = '" + StringEscapeUtils.escapeXml11((String)name) + "' and (@PublicType =: 'Server.' or @PublicType =: 'LogicalServer.' or @PublicType =: 'ApplicationServer')]\"/>");
            List objects = userContext.getAuthServer().search(filter);
            if (objects.isEmpty()) {
                return null;
            }
            return (ServerInterface)objects.get(0);
        }
        catch (RemoteException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Collection<ServerInterface> getAllServers(UserContextInterface userContext) throws ServiceException {
        try {
            Filter filter = new Filter();
            filter.setType("ServerComponent");
            filter.setOMRFlags(8342);
            filter.setExplicitSearchString("omi", "<XMLSelect search=\"*[@PublicType =: 'Server.' or @PublicType =: 'LogicalServer.' or @PublicType =: 'ApplicationServer']\"/>");
            List objects = userContext.getAuthServer().search(filter);
            return objects;
        }
        catch (RemoteException e) {
            throw new IllegalStateException(e);
        }
    }

    public static <T extends ServerInterface> T getServer(UserContextInterface userContext, String name, String publicType) throws ServiceException {
        try {
            Filter filter = new Filter();
            filter.setType("ServerComponent");
            filter.setOMRFlags(8342);
            filter.setExplicitSearchString("omi", "<XMLSelect search=\"*[@Name = '" + StringEscapeUtils.escapeXml11((String)name) + "' and @PublicType = '" + StringEscapeUtils.escapeXml11((String)publicType) + "']\"/>");
            List objects = userContext.getAuthServer().search(filter);
            if (objects.isEmpty()) {
                return null;
            }
            return (T)((ServerInterface)objects.get(0));
        }
        catch (RemoteException e) {
            throw new IllegalStateException(e);
        }
    }

    public static <T extends ServerInterface> Collection<T> getAllServers(UserContextInterface userContext, String publicType) throws ServiceException {
        try {
            Filter filter = new Filter();
            filter.setType("ServerComponent");
            filter.setOMRFlags(8342);
            filter.setExplicitSearchString("omi", "<XMLSelect search=\"*[@PublicType = '" + StringEscapeUtils.escapeXml11((String)publicType) + "']\"/>");
            List objects = userContext.getAuthServer().search(filter);
            return objects;
        }
        catch (RemoteException e) {
            throw new IllegalStateException(e);
        }
    }

    public static boolean serverExists(UserContextInterface userContext, String name) throws ServiceException {
        try {
            Filter filter = new Filter();
            filter.setType("ServerComponent");
            filter.setOMRFlags(8342);
            filter.setExplicitSearchString("omi", "<XMLSelect search=\"*[@Name = '" + StringEscapeUtils.escapeXml11((String)name) + "' and (@PublicType =: 'Server.' or @PublicType =: 'LogicalServer.' or @PublicType =: 'ApplicationServer')]\"/>");
            MetadataServerInterface metadataServer = (MetadataServerInterface)userContext.getAuthServer();
            return metadataServer.getCountNoSecurity(filter, null) > 0;
        }
        catch (RemoteException e) {
            throw new IllegalStateException(e);
        }
    }

    public static boolean serverExists(UserContextInterface userContext, String name, String publicType) throws ServiceException {
        try {
            Filter filter = new Filter();
            filter.setType("ServerComponent");
            filter.setOMRFlags(8342);
            filter.setExplicitSearchString("omi", "<XMLSelect search=\"*[@Name = '" + StringEscapeUtils.escapeXml11((String)name) + "' and @PublicType = '" + StringEscapeUtils.escapeXml11((String)publicType) + "']\"/>");
            MetadataServerInterface metadataServer = (MetadataServerInterface)userContext.getAuthServer();
            return metadataServer.getCountNoSecurity(filter, null) > 0;
        }
        catch (RemoteException e) {
            throw new IllegalStateException(e);
        }
    }
}

