/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata.servers;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CustomAssociation;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.Identity;
import com.sas.metadata.remote.Login;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.SASClientConnection;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.ServerComponent;
import com.sas.services.ServiceException;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.OMIServer;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.metadata.OMRProperty;
import com.sas.services.information.metadata.PhysicalTableInterface;
import com.sas.services.information.metadata.SASLibraryInterface;
import com.sas.services.information.metadata.servers.LASRMultipleServersException;
import com.sas.services.information.metadata.servers.LASRServerAlreadyExistsException;
import com.sas.services.information.metadata.servers.LASRServerImpl;
import com.sas.services.information.metadata.servers.LASRServerInterface;
import com.sas.services.util.Names;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class LASRUtilities {
    private MetadataServerInterface metadataServer;
    private static Logger _logger = LogManager.getLogger(LASRUtilities.class);
    private static final String LIBRARY_TAG_OMR_PROPERTY = "TAG";

    public LASRUtilities(MetadataServerInterface metadataServer) {
        this.metadataServer = metadataServer;
    }

    public LASRServerInterface getServerByName(String name) throws ServiceException {
        return LASRUtilities.getServerByName(this.metadataServer, name);
    }

    public static LASRServerInterface getServerByName(MetadataServerInterface metadataServer, String name) throws ServiceException {
        MdObjectStore store = ((OMIServer)metadataServer).getObjectStore();
        try {
            MdOMIUtil omiUtil = store.getFactory().getOMIUtil();
            List objects = omiUtil.getMetadataObjectsSubset((MdStore)store, omiUtil.getFoundationReposID(), "ServerComponent", 8584, "<XMLSelect search=\"ServerComponent[@Name='" + StringEscapeUtils.escapeXml11((String)name) + "' and @PublicType='Server.LASR']\"/>");
            if (objects.size() == 0) {
                return null;
            }
            String repositoryKey = LASRUtilities.getRepositoryKey((DeployedComponent)objects.get(0));
            return (LASRServerInterface)metadataServer.fetch(repositoryKey, true);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        catch (MdException e) {
            throw new ServiceException(e);
        }
    }

    public LASRServerInterface getServerByAddress(String hostname, int port) throws ServiceException {
        List<LASRServerInterface> servers = this.getAllServers();
        LASRServerInterface serverFinal = null;
        int count = 0;
        for (LASRServerInterface server : servers) {
            try {
                if (!server.getHost().equalsIgnoreCase(hostname) && !server.getShortHost().equalsIgnoreCase(hostname) || server.getPort() != port) continue;
                serverFinal = server;
                ++count;
            }
            catch (RemoteException e) {
                _logger.error("Bad metadata on LASR Analytics Server", (Throwable)e);
            }
        }
        if (count > 1) {
            throw new LASRMultipleServersException(hostname, port);
        }
        return serverFinal;
    }

    public static String getTableNameAndTag(PhysicalTableInterface table) throws ServiceException, RemoteException {
        return LASRUtilities.getTableNameAndTag(table.getLibrary(), table);
    }

    public static String getLibraryTag(SASLibraryInterface library) throws ServiceException, RemoteException {
        String tag = null;
        if (library == null) {
            throw new RemoteException("Library Expected.");
        }
        if (library.getRepositoryEntity() instanceof SASLibrary) {
            List libraryProperties = library.getObjectProperties();
            int sizeList = libraryProperties.size();
            for (int t = 0; t < sizeList; ++t) {
                OMRProperty omrProperty = (OMRProperty)libraryProperties.get(t);
                Property whatIsIt = (Property)omrProperty.getRepositoryEntity();
                String propertyName = whatIsIt.getPropertyName();
                if (propertyName == null || !propertyName.equals(LIBRARY_TAG_OMR_PROPERTY)) continue;
                tag = whatIsIt.getDefaultValue();
                break;
            }
            if (tag == null) {
                tag = "WORK";
            }
        } else {
            throw new RemoteException("Expected Library to be of type SASLibrary - it was [" + library.getRepositoryEntity().getClass().getName() + "] instead");
        }
        return tag;
    }

    public static String getTableNameAndTag(SASLibraryInterface library, PhysicalTableInterface table) throws ServiceException, RemoteException {
        String name = table.getTableName();
        String tag = null;
        if (library == null) {
            throw new RemoteException("Library not found on table: " + table.getName());
        }
        if (library.getRepositoryEntity() instanceof SASLibrary) {
            List libraryProperties = library.getObjectProperties();
            int sizeList = libraryProperties.size();
            for (int t = 0; t < sizeList; ++t) {
                OMRProperty omrProperty = (OMRProperty)libraryProperties.get(t);
                Property whatIsIt = (Property)omrProperty.getRepositoryEntity();
                String propertyName = whatIsIt.getPropertyName();
                if (propertyName == null || !propertyName.equals(LIBRARY_TAG_OMR_PROPERTY)) continue;
                tag = whatIsIt.getDefaultValue();
                break;
            }
            if (tag == null) {
                tag = "WORK";
            }
        } else {
            throw new RemoteException("Expected Library to be of type SASLibrary - it was [" + library.getRepositoryEntity().getClass().getName() + "] instead");
        }
        return tag + "." + name;
    }

    public List<LASRServerInterface> getAllServers() throws ServiceException {
        return LASRUtilities.getAllServers(this.metadataServer);
    }

    public static List<LASRServerInterface> getAllServers(MetadataServerInterface metadataServer) throws ServiceException {
        MdObjectStore store = ((OMIServer)metadataServer).getObjectStore();
        try {
            MdOMIUtil omiUtil = store.getFactory().getOMIUtil();
            List objects = omiUtil.getMetadataObjectsSubset((MdStore)store, omiUtil.getFoundationReposID(), "ServerComponent", 8584, "<XMLSelect search=\"ServerComponent[@PublicType='Server.LASR']\"/>");
            ArrayList<LASRServerInterface> servers = new ArrayList<LASRServerInterface>(objects.size());
            for (ServerComponent object : objects) {
                String repositoryKey = LASRUtilities.getRepositoryKey((DeployedComponent)object);
                LASRServerInterface server = (LASRServerInterface)metadataServer.fetch(repositoryKey, true);
                servers.add(server);
            }
            return servers;
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        catch (MdException e) {
            throw new ServiceException(e);
        }
    }

    public LASRServerInterface createServer(String name) throws IllegalArgumentException, ServiceException {
        return this.createServer(null, name);
    }

    public LASRServerInterface createServer(RepositoryInterface repository, String name) throws IllegalArgumentException, ServiceException {
        Names.validateOMRObjectName(name, true);
        if (this.getServerByName(name) != null) {
            throw new LASRServerAlreadyExistsException(name);
        }
        try {
            if (repository == null) {
                repository = this.metadataServer.getFoundationRepository();
            }
            return new LASRServerImpl(repository, name);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    public void removeUnusedSecurityKeys() throws ServiceException {
        try {
            Identity identity = (Identity)this.metadataServer.getIdentity().getRepositoryEntity();
            AssociationList logins = identity.getLogins();
            ArrayList<Login> deleteCandidates = new ArrayList<Login>(logins.size());
            for (Login login : logins) {
                CustomAssociation association;
                AssociationList objects;
                AssociationList associations;
                if (!"LASR Server Security Key".equals(login.getName()) || (associations = login.getCustomAssociations()).size() > 0 && (objects = (association = (CustomAssociation)associations.get(0)).getReferencedObjects()).size() > 0) continue;
                deleteCandidates.add(login);
            }
            for (Login login : deleteCandidates) {
                login.delete();
            }
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        catch (MdException e) {
            throw new ServiceException(e);
        }
    }

    public LASRServerInterface getLibraryServer(SASLibraryInterface library) throws ServiceException {
        return LASRUtilities.getLibraryServer(this.metadataServer, library);
    }

    public static LASRServerInterface getLibraryServer(MetadataServerInterface metadataServer, SASLibraryInterface library) throws ServiceException {
        try {
            SASLibrary libraryObject = (SASLibrary)library.getRepositoryEntity();
            SASClientConnection connectionObject = libraryObject.getLibraryConnection();
            if (connectionObject == null) {
                throw new ServiceException("SASLibrary object is not associated with a server.  Ensure that the library metadata is correct.");
            }
            String repositoryKey = LASRUtilities.getRepositoryKey(connectionObject.getSource());
            return (LASRServerInterface)metadataServer.fetch(repositoryKey, true);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        catch (MdException e) {
            throw new ServiceException(e);
        }
    }

    private static String getRepositoryKey(DeployedComponent component) throws RemoteException {
        String key = component.getFQID() + "/" + component.getCMetadataType();
        return key;
    }
}

