/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata.servers;

import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.SASClientConnection;
import com.sas.metadata.remote.ServerComponent;
import com.sas.services.ServiceException;
import com.sas.services.information.ItemAlreadyExistsException;
import com.sas.services.information.metadata.SASClientConnectionInterface;
import com.sas.services.information.metadata.servers.AbstractConnectionBuilder;
import com.sas.services.information.metadata.servers.LASRServerInterface;
import com.sas.services.information.metadata.servers.LASRServerUtil;
import com.sas.services.information.metadata.servers.ServerBuilder;
import com.sas.services.user.UserContextInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public final class LASRServerBuilder
extends ServerBuilder<LASRServerInterface, ServerComponent, LASRServerBuilder> {
    private static final double USAGE_VERSION = 1000000.0;
    private List<Connection> connections = new ArrayList<Connection>();
    public static final String SMPMODE = "SMPMODE";
    public static final String FORCE = "FORCE";
    public static final String PATH = "PATH";
    public static final String LIFETIME = "LIFETIME";
    public static final String LOGGING = "LOGGING";
    public static final String VERBOSE = "VERBOSE";
    public static final String LOGPATH = "LOGPATH";
    public static final String KEEPLOG = "KEEPLOG";
    public static final String MAXFILESIZE = "MAXFILESIZE";
    public static final String MAXROLLNUM = "MAXROLLNUM";
    public static final String ADDTIONALLOGOPTIONS = "ADDTIONALLOGOPTIONS";
    public static final String INSTALL = "INSTALL";
    public static final String NODES = "NODES";
    public static final String TABLEMEM = "TABLEMEM";
    public static final String EXTERNALMEM = "EXTERNALMEM";

    public static LASRServerBuilder builder() {
        return new LASRServerBuilder();
    }

    private LASRServerBuilder() {
        super(ServerComponent.class, "Server.LASR", 1000000.0, "SASIOLA", "SASIOLA");
        this.serviceType = "DBMS Server";
        this.vendor = "SAS";
        this.prototypeName = "Server.LASR.Prototype.Name.xmlKey.txt";
    }

    public Connection connection() {
        Connection connection = (Connection)new Connection().buildName(this.name, this.connections.size() + 1);
        this.connections.add(connection);
        return connection;
    }

    @Override
    public void validate(UserContextInterface user) throws IllegalArgumentException, IllegalStateException, ItemAlreadyExistsException, ServiceException {
        super.validate(user);
        if (this.connections.isEmpty()) {
            throw new IllegalStateException("No connection is defined.");
        }
        for (Connection builder : this.connections) {
            builder.validate(user);
        }
        Connection.checkForDuplicateNames(this.connections);
    }

    @Override
    protected void createObject() throws RemoteException, MdException, ServiceException {
        super.createObject();
        for (Connection connection : this.connections) {
            connection.buildAndConnect(this.user, (DeployedComponent)this.built);
        }
    }

    public final class Connection
    extends AbstractConnectionBuilder<SASClientConnectionInterface, SASClientConnection, Connection> {
        private int port;

        private Connection() {
            super(SASClientConnection.class, null, 0.0, "LASRProtocol", "TCP");
            this.port = 0;
            this.prototypeName = "Connection.LASR.Name.xmlKey.txt";
        }

        public Connection host(String host) {
            this.option("HOST", host);
            return this;
        }

        public Connection port(int port) {
            this.port = port;
            return this;
        }

        public LASRServerBuilder end() {
            return LASRServerBuilder.this;
        }

        @Override
        public void validate(UserContextInterface user) throws IllegalArgumentException, IllegalStateException, ItemAlreadyExistsException, ServiceException {
            super.validate(user);
            if (!this.options.containsKey("HOST")) {
                throw new IllegalStateException("HOST must be specified");
            }
        }

        @Override
        protected void createObject() throws RemoteException, MdException, ServiceException {
            String signerUrl;
            if (!this.options.containsKey("SIGNER") && (signerUrl = LASRServerUtil.getAuthorizationServiceUrl(this.user)) != null) {
                this.options.put("SIGNER", signerUrl);
            }
            super.createObject();
            if (this.port != 0) {
                ((SASClientConnection)this.built).setPort(this.port);
            }
            if (this.options.containsKey("HOST")) {
                ((SASClientConnection)this.built).setRemoteAddress((String)this.options.get("HOST"));
            }
        }
    }
}

