/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata.servers;

import com.sas.metadata.remote.AuthenticationDomain;
import com.sas.metadata.remote.Connection;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.services.information.ItemAlreadyExistsException;
import com.sas.services.information.metadata.ConnectionInterface;
import com.sas.services.information.metadata.MetadataBuilder;
import com.sas.services.user.UserContextInterface;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.HashSet;

public abstract class AbstractConnectionBuilder<T extends ConnectionInterface, J extends Connection, B extends AbstractConnectionBuilder<T, J, B>>
extends MetadataBuilder<T, J, B> {
    public static final String NO_CREDENTIALS_DOMAIN = "NoCredentials";
    public static final String PROMPTED_CREDENTIALS_DOMAIN = "PromptedCredentials";
    protected String authenticationDomain = "NoCredentials";
    protected String applicationProtocol = null;
    protected String communicationProtocol = null;

    protected AbstractConnectionBuilder(Class<J> metadataType, String publicType, double usageVersion, String applicationProtocol, String communicationProtocol) {
        super(metadataType, publicType, usageVersion);
        this.applicationProtocol = applicationProtocol;
        this.communicationProtocol = communicationProtocol;
    }

    public B authenticationDomain(String authenticationDomain) {
        this.authenticationDomain = authenticationDomain;
        return (B)this;
    }

    public B authenticationNone() {
        this.authenticationDomain = NO_CREDENTIALS_DOMAIN;
        return (B)this;
    }

    public B authenticationPrompted() {
        this.authenticationDomain = PROMPTED_CREDENTIALS_DOMAIN;
        return (B)this;
    }

    public B buildName(String serverName, int count) {
        if (serverName != null) {
            String prefix = ": ";
            if (count > 1) {
                prefix = " " + Integer.toString(count) + ": ";
            }
            if (serverName.length() + prefix.length() <= 50) {
                this.name("Connection" + prefix + serverName);
            } else if (serverName.length() + prefix.length() <= 56) {
                this.name("Conn" + prefix + serverName);
            } else {
                this.name(serverName);
            }
        }
        return (B)this;
    }

    @Override
    protected void createObject() throws RemoteException, MdException, ServiceException {
        super.createObject();
        if (this.applicationProtocol != null) {
            ((Connection)this.built).setApplicationProtocol(this.applicationProtocol);
        }
        if (this.communicationProtocol != null) {
            ((Connection)this.built).setCommunicationProtocol(this.communicationProtocol);
        }
        if (this.authenticationDomain == null || NO_CREDENTIALS_DOMAIN.equalsIgnoreCase(this.authenticationDomain)) {
            ((Connection)this.built).setAuthenticationType("none");
        } else if (PROMPTED_CREDENTIALS_DOMAIN.equalsIgnoreCase(this.authenticationDomain)) {
            ((Connection)this.built).setAuthenticationType("prompt");
        } else {
            ((Connection)this.built).setAuthenticationType("user/password");
            AuthenticationDomain domain = this.findMetadataByName(this.authenticationDomain, AuthenticationDomain.class);
            if (domain == null) {
                domain = this.createMetadata(this.authenticationDomain, AuthenticationDomain.class);
                domain.setPublicType("AuthenticationDomain");
                domain.setUsageVersion(1000000.0);
            }
            ((Connection)this.built).setDomain(domain);
        }
    }

    protected void buildAndConnect(UserContextInterface user, DeployedComponent server) throws ItemAlreadyExistsException, IllegalArgumentException, IllegalStateException, ServiceException, RemoteException {
        this.buildInternal(user);
        ((Connection)this.built).setSource(server);
    }

    static void checkForDuplicateNames(Collection<? extends AbstractConnectionBuilder> builders) {
        if (builders.size() <= 1) {
            return;
        }
        HashSet<String> names = new HashSet<String>(builders.size());
        for (AbstractConnectionBuilder abstractConnectionBuilder : builders) {
            if (names.contains(abstractConnectionBuilder.name)) {
                throw new IllegalStateException("Cannot define two connections with same name: " + abstractConnectionBuilder.name);
            }
            names.add(abstractConnectionBuilder.name);
        }
    }
}

