/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata.secureddata.impl;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.DeployedDataPackage;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.impl.SecuredLibraryImpl_Stub;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.VersionIncompatibleException;
import com.sas.services.information.metadata.EmbeddedObjectInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.Metadata;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.secureddata.SecuredLibrary;
import com.sas.services.information.metadata.secureddata.SecuredTable;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.editableproperties.SubstitutionProperties;
import com.sas.storage.editableproperties.UnexpectedSubstitutionException;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.Level;

public class SecuredLibraryImpl
extends Metadata
implements SecuredLibrary,
EmbeddedObjectInterface,
SubstitutionProperties {
    public static final UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    public static final UsageVersion CURRENT_VERSION = new UsageVersion(1, 0);

    public SecuredLibraryImpl() throws RemoteException {
        super(SecuredLibraryImpl.class);
    }

    public SecuredLibraryImpl(Object o, Class theClass) throws RemoteException {
        super(o, theClass);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public SecuredLibraryImpl(Object o) throws RemoteException {
        super(o);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public SecuredLibraryImpl(com.sas.metadata.remote.SecuredLibrary o) throws RemoteException {
        super(o, SecuredLibraryImpl.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public SecuredLibraryImpl(SecuredLibraryImpl_Stub o) throws RemoteException {
        super(o, SecuredLibraryImpl.class);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public SecuredLibraryImpl(RepositoryInterface repos, String name, FolderInterface parent) throws RemoteException {
        block5: {
            super(SecuredLibraryImpl.class);
            if (repos == null || name == null) {
                throw new IllegalArgumentException();
            }
            OMIRepositoryInterface omirepository = (OMIRepositoryInterface)repos;
            try {
                com.sas.metadata.remote.SecuredLibrary library = (com.sas.metadata.remote.SecuredLibrary)omirepository.createMetadata(name, "SecuredLibrary");
                library.setPublicType("SecuredLibrary");
                library.setUsageVersion(CURRENT_VERSION.encode());
                this._isCompatible = true;
                this._isReadCompatible = true;
                this._repositoryObject = library;
                this._repositoryFlag = 2;
                this.setRepository(repos);
                if (parent == null) break block5;
                try {
                    parent.addItem(this);
                }
                catch (ServiceException ex) {
                    library.delete();
                    throw new RuntimeException(ex.getLocalizedMessage(), (Throwable)((Object)ex));
                }
            }
            catch (ServiceException ex) {
                this.logThrowable(Level.WARN, ex.getMessage(), "com.sas.services.information.metadata.secureddata.impl.SecuredLibraryImpl", (Throwable)((Object)ex));
            }
        }
    }

    @Override
    public String getType() throws RemoteException {
        return "SecuredLibrary";
    }

    @Override
    public List<SecuredTable> getTables() throws ServiceException, RemoteException {
        this.checkReadAllowed();
        if (this._repositoryObject != null) {
            ArrayList<SecuredTable> tables = new ArrayList<SecuredTable>();
            com.sas.metadata.remote.SecuredLibrary library = (com.sas.metadata.remote.SecuredLibrary)this._repositoryObject;
            try {
                AssociationList members = library.getTables();
                if (!members.isEmpty()) {
                    for (Root member : members) {
                        SecuredTable table;
                        if (!(member instanceof com.sas.metadata.remote.SecuredTable) || (table = (SecuredTable)this._repository.factoryProcess(member)) == null) continue;
                        tables.add(table);
                    }
                }
                return tables;
            }
            catch (MdException e) {
                throw new ServiceException(e, e.getMessage());
            }
        }
        return Collections.emptyList();
    }

    @Override
    public PublicObjectInterface getChildAt(int index) throws ServiceException, RemoteException {
        List tables = this.getChildren();
        if (tables == null || tables.size() == 0) {
            throw new ArrayIndexOutOfBoundsException("The secured library does not contain any tables.");
        }
        return (PublicObjectInterface)tables.get(index);
    }

    @Override
    public int getChildCount() throws ServiceException, RemoteException {
        List tables = this.getChildren();
        return tables.size();
    }

    @Override
    public List getChildren() throws ServiceException, RemoteException {
        return this.getTables();
    }

    @Override
    public List getChildren(String type) throws ServiceException, RemoteException {
        throw new UnsupportedOperationException();
    }

    @Override
    public PublicObjectInterface newChild(String type, String name) throws ServiceException, RemoteException {
        throw new UnsupportedOperationException();
    }

    protected void checkReadAllowed() throws VersionIncompatibleException, RemoteException {
        if (!this.isReadCompatible()) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
    }

    protected void checkWriteAllowed() throws VersionIncompatibleException, RemoteException {
        if (!this.isCompatible()) {
            throw new VersionIncompatibleException(this.getClass().getName(), CURRENT_VERSION, this.getUsageVersion());
        }
        this.checkPulse(true);
    }

    public PropertyList getSubstitutionProperties() throws UnexpectedSubstitutionException {
        PropertyList list = new PropertyList();
        try {
            int pathCount = 0;
            AssociationList packages = ((com.sas.metadata.remote.SecuredLibrary)this._repositoryObject).getUsingPackages(true);
            if (packages != null && packages.size() > 0) {
                for (int i = 0; i < packages.size(); ++i) {
                    DeployedDataPackage iDDP = (DeployedDataPackage)packages.get(i);
                    if (!(iDDP instanceof Directory)) continue;
                    ++pathCount;
                    if (i == 0 && packages.size() == 1) {
                        list.addProperty("DirPath", ((Directory)iDDP).getDirectoryName());
                        continue;
                    }
                    list.addProperty("DirPath", i + 1, ((Directory)iDDP).getDirectoryName());
                }
            }
        }
        catch (MdException e) {
            throw new UnexpectedSubstitutionException((Throwable)e);
        }
        catch (RemoteException e) {
            throw new UnexpectedSubstitutionException((Throwable)e);
        }
        return list;
    }

    public void setSubstitutionProperties(PropertyMap map) throws UnexpectedSubstitutionException {
        try {
            AssociationList packages = ((com.sas.metadata.remote.SecuredLibrary)this._repositoryObject).getUsingPackages(true);
            for (int i = 0; i < packages.size(); ++i) {
                String path;
                DeployedDataPackage iDDP = (DeployedDataPackage)packages.get(i);
                if (!(iDDP instanceof Directory)) continue;
                if (i == 0 && packages.size() == 1 && map.containsProperty("DirPath")) {
                    path = map.getProperty("DirPath");
                    if (path == ((Directory)iDDP).getDirectoryName()) continue;
                    ((Directory)iDDP).setDirectoryName(path);
                    continue;
                }
                if (!map.containsIndexedProperty("DirPath", i + 1) || (path = map.getProperty("DirPath", i + 1)) == ((Directory)iDDP).getDirectoryName()) continue;
                ((Directory)iDDP).setDirectoryName(path);
            }
        }
        catch (MdException e) {
            throw new UnexpectedSubstitutionException((Throwable)e);
        }
        catch (RemoteException e) {
            throw new UnexpectedSubstitutionException((Throwable)e);
        }
    }

    @Override
    public MetadataInterface getEmbeddedObject(String subpath) throws ServiceException, RemoteException {
        String name = null;
        String type = null;
        int index = subpath.lastIndexOf(40);
        if (!subpath.endsWith(")")) {
            index = -1;
        }
        if (index > 0) {
            name = PathUrl.decodeString(subpath.substring(0, index));
            type = subpath.substring(index + 1, subpath.length() - 1);
            if (!"SecuredTable".equals(type)) {
                throw new ServiceException("Only a type of Secured table can be embedded within a Secured library.");
            }
        }
        List<SecuredTable> tables = this.getTables();
        for (SecuredTable table : tables) {
            if (!table.getName().equals(name)) continue;
            return table;
        }
        return null;
    }
}

