/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata.prompt;

import com.sas.codepolicy.SASScope;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.prompt.PromptsPersistUtil;
import com.sas.services.information.metadata.prompt.RB;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.util.ValidateArg;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.log.log4j.Log4JFactory2;
import com.sas.util.xmlpersist.IntegratedReadingContext;
import com.sas.util.xmlpersist.PersistenceInterface;
import com.sas.util.xmlpersist.PromptsReadingContext;
import com.sas.util.xmlpersist.impl.PersistHelper;
import com.sas.util.xmlpersist.impl.PersistenceFactory;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.prefs.BackingStoreException;
import org.xml.sax.SAXException;

@SASScope
final class ServicesEnabledReadingContext
implements PromptsReadingContext {
    private PromptsReadingContext internalContext = null;
    private static final String RB_KEY = "ServicesEnabledReadingContext.";
    private UserContextInterface userContext = null;
    private Log4JFactory2 factory = new Log4JFactory2();
    private CommonLoggerInterface logger = null;
    private ServerInterface server = null;

    ServicesEnabledReadingContext(UserContextInterface userContext) {
        this.setUserContext(userContext);
        this.logger = LoggerRepository2.getLogger((String)this.getClass().getName(), null);
        this.internalContext = PersistenceFactory.newReadingContext((LoggerFactoryInterface)this.factory);
        WeakHashMap<String, UserContextInterface> optionsMap = new WeakHashMap<String, UserContextInterface>();
        optionsMap.put("USER_CONTEXT", userContext);
        optionsMap.put("com.sas.util.log.LoggerFactoryInterface", (UserContextInterface)this.factory);
        this.internalContext.setOptionsMap(optionsMap);
    }

    public PersistenceInterface getObjectFromMetadata(String type, String sbipUrl) throws BackingStoreException {
        ValidateArg.notNull((Object)type, (String)"type");
        ValidateArg.notNull((Object)sbipUrl, (String)"sbipUrl");
        if (this.getOptionsMap() != null && this.getOptionsMap().containsKey("USER_CONTEXT")) {
            UserContextInterface userContext = (UserContextInterface)this.getOptionsMap().get("USER_CONTEXT");
            try {
                SessionContextInterface session = userContext.getSessionContext();
                List attrValue = (List)session.getAttribute("_SAS_METADATA_BEING_LOADED");
                if (attrValue != null) {
                    if (attrValue.contains(sbipUrl.intern())) {
                        String msg = new MessageFormat(RB.getStringResource("ServicesEnabledReadingContext.recursiveResourceFound.fmt.txt")).format(new Object[]{sbipUrl});
                        throw new BackingStoreException(msg);
                    }
                    attrValue.add(sbipUrl.intern());
                } else {
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(sbipUrl.intern());
                    session.setAttribute("_SAS_METADATA_BEING_LOADED", list);
                }
            }
            catch (RemoteException re) {
                throw new BackingStoreException(re);
            }
        }
        PromptDefinitionInterface retVal = null;
        PathUrl pathUrl = null;
        this.logger.debug("getObjectFromMetadata() for", sbipUrl);
        try {
            String temp = sbipUrl.toUpperCase();
            pathUrl = temp.startsWith("SBIP://") ? new PathUrl(sbipUrl) : PathUrl.newPathUrlFromAbsolutePath(this.server, PersistHelper.parseSBIPUrl((String)sbipUrl));
            if (null != pathUrl) {
                this.logger.debug("Searching with this URL:", pathUrl.toString());
                if ("Prompt".equals(type)) {
                    retVal = PromptsPersistUtil.getDefinitionFromFolder(pathUrl, this.userContext);
                } else if ("PromptGroup".equals(type)) {
                    retVal = PromptsPersistUtil.getGroupFromFolder(pathUrl, this.userContext);
                }
            }
        }
        catch (ServiceException e) {
            throw new BackingStoreException((Throwable)((Object)e));
        }
        catch (RemoteException e) {
            throw new BackingStoreException(e);
        }
        finally {
            if (this.getOptionsMap() != null && this.getOptionsMap().containsKey("USER_CONTEXT")) {
                UserContextInterface userContext = (UserContextInterface)this.getOptionsMap().get("USER_CONTEXT");
                try {
                    SessionContextInterface session = userContext.getSessionContext();
                    List attrValue = (List)session.getAttribute("_SAS_METADATA_BEING_LOADED");
                    if (attrValue != null) {
                        if (attrValue.contains(sbipUrl.intern())) {
                            attrValue.remove(sbipUrl.intern());
                        }
                        if (attrValue.isEmpty()) {
                            session.removeAttribute("_SAS_METADATA_BEING_LOADED");
                        }
                    }
                }
                catch (RemoteException re) {
                    throw new BackingStoreException(re);
                }
                catch (IllegalStateException ise) {
                    throw new BackingStoreException(ise);
                }
            }
        }
        if (null == retVal || null == pathUrl) {
            String msg = new MessageFormat(RB.getStringResource("ServicesEnabledReadingContext.notFound.fmt.log")).format(new Object[]{sbipUrl});
            throw new BackingStoreException(msg);
        }
        this.logger.debug("Returning a persistence object for:", pathUrl.toString());
        return retVal;
    }

    public void setUserContext(UserContextInterface userContext) {
        ValidateArg.notNull((Object)userContext, (String)"userContext");
        this.userContext = userContext;
        if (null == this.server) {
            try {
                this.server = userContext.getAuthServer();
            }
            catch (ServiceException e) {
                this.logger.error(e.getMessage(), (Throwable)((Object)e));
            }
            catch (RemoteException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public PersistenceInterface getObjectForUsedObjectElement(String useOfType, String persistenceID) throws SAXException {
        return this.internalContext.getObjectForUsedObjectElement(useOfType, persistenceID);
    }

    public PersistenceInterface getObjectForNewObjectElement(String persistenceID, String elementName) throws SAXException {
        return this.internalContext.getObjectForNewObjectElement(persistenceID, elementName);
    }

    public Object getObject(String reference, Class type) {
        return this.internalContext.getObject(reference, type);
    }

    public void setOptionsMap(Map arg0) {
        ValidateArg.notNull((Object)arg0, (String)"arg0");
        if (!arg0.containsKey("USER_CONTEXT")) {
            arg0.put("USER_CONTEXT", this.userContext);
        }
        this.internalContext.setOptionsMap(arg0);
    }

    public Map getOptionsMap() {
        return this.internalContext.getOptionsMap();
    }

    public void notePersistenceIDOfModelBeingRead(PersistenceInterface model, String persistenceID) {
        this.internalContext.notePersistenceIDOfModelBeingRead(model, persistenceID);
    }

    public Object getObject(String reference) {
        return this.internalContext.getObject(reference);
    }

    public void setReadingContext(IntegratedReadingContext foreignContext) {
        this.internalContext.setReadingContext(foreignContext);
    }

    public IntegratedReadingContext getReadingContext() {
        return this.internalContext.getReadingContext();
    }

    public PersistenceInterface getModel() {
        return this.internalContext.getModel();
    }

    public String modifySbipURL(String input) {
        return this.internalContext.modifySbipURL(input);
    }

    public void addMissingResource(Object key, Object value) {
        this.internalContext.addMissingResource(key, value);
    }

    public Map getMissingResources() {
        return this.internalContext.getMissingResources();
    }

    public void addUnknownAttribute(Object key, Object value) {
        this.internalContext.addUnknownAttribute(key, value);
    }

    public Map getUnknownAttributes() {
        return this.internalContext.getUnknownAttributes();
    }

    public void addUnknownElement(Object elementName) {
        this.internalContext.addUnknownElement(elementName);
    }

    public List getUnknownElements() {
        return this.internalContext.getUnknownElements();
    }

    public Object getServer() {
        return this.server;
    }

    public void setServer(Object server) {
        if (!(server instanceof ServerInterface)) {
            throw new IllegalArgumentException("Parameter must be instance of com.sas.services.information.ServerInterface");
        }
        this.server = (ServerInterface)server;
    }

    public void destroy() {
        Map map = this.getOptionsMap();
        if (null != map && map.containsKey("USER_CONTEXT")) {
            map.remove("USER_CONTEXT");
        }
        this.userContext = null;
        this.internalContext.destroy();
    }
}

