/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata.libraries;

import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.SASLibrary;
import com.sas.services.ServiceException;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.OMIServer;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.SASLibraryInterface;
import com.sas.services.user.UserContextInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class SASLibraryUtil {
    private SASLibraryUtil() {
    }

    public static SASLibraryInterface getLibrary(UserContextInterface userContext, String path) throws ServiceException {
        try {
            MetadataServerInterface metadataServer = (MetadataServerInterface)userContext.getAuthServer();
            PathUrl pathUrl = PathUrl.newPathUrlFromAbsolutePath(metadataServer, path);
            if (pathUrl.getType() == null) {
                pathUrl.setType("Library");
            } else if (!pathUrl.getType().equals("Library")) {
                throw new IllegalArgumentException("Path must specify a library");
            }
            return (SASLibraryInterface)metadataServer.getObjectByPath(pathUrl);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    public static Collection<SASLibraryInterface> getAllLibraries(UserContextInterface userContext, String engine) throws ServiceException {
        try {
            MetadataServerInterface metadataServer = (MetadataServerInterface)userContext.getAuthServer();
            String repositoryId = ((OMIRepositoryInterface)metadataServer.getFoundationRepository()).getDefaultRepositoryId();
            List objects = ((OMIServer)metadataServer).getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)((OMIServer)metadataServer).getObjectStore(), repositoryId, "SASLibrary", 8584, "<XMLSelect search=\"*[@PublicType='Library' and @Engine='" + engine + "']\"/>");
            ArrayList<SASLibraryInterface> libraries = new ArrayList<SASLibraryInterface>();
            for (SASLibrary object : objects) {
                SASLibraryInterface library = (SASLibraryInterface)metadataServer.factoryProcess(object);
                if (library == null) continue;
                libraries.add(library);
            }
            return libraries;
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        catch (MdException e) {
            throw new ServiceException(e);
        }
    }

    public static Collection<SASLibraryInterface> getAllLibraries(UserContextInterface userContext) throws ServiceException {
        try {
            MetadataServerInterface metadataServer = (MetadataServerInterface)userContext.getAuthServer();
            String repositoryId = ((OMIRepositoryInterface)metadataServer.getFoundationRepository()).getDefaultRepositoryId();
            List objects = ((OMIServer)metadataServer).getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)((OMIServer)metadataServer).getObjectStore(), repositoryId, "SASLibrary", 8584, "<XMLSelect search=\"*[@PublicType='Library']\"/>");
            ArrayList<SASLibraryInterface> libraries = new ArrayList<SASLibraryInterface>();
            for (SASLibrary object : objects) {
                SASLibraryInterface library = (SASLibraryInterface)metadataServer.factoryProcess(object);
                if (library == null) continue;
                libraries.add(library);
            }
            return libraries;
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        catch (MdException e) {
            throw new ServiceException(e);
        }
    }
}

