/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.information.metadata.libraries;

import com.sas.services.ServiceException;
import com.sas.services.information.ItemAlreadyExistsException;
import com.sas.services.information.metadata.LoginInterface;
import com.sas.services.information.metadata.SASClientConnectionInterface;
import com.sas.services.information.metadata.SASLibraryInterface;
import com.sas.services.information.metadata.ServerComponentInterface;
import com.sas.services.information.metadata.libraries.LibraryBuilder;
import com.sas.services.user.UserContextInterface;
import java.rmi.RemoteException;

public final class SASHDATLibraryBuilder
extends LibraryBuilder<SASHDATLibraryBuilder> {
    static final String ENGINE = "SASHDAT";
    private String path = null;

    public static SASHDATLibraryBuilder builder() {
        return new SASHDATLibraryBuilder();
    }

    private SASHDATLibraryBuilder() {
        this.engine = ENGINE;
        this.isDBMSLibrary = true;
        this.dataServerPublicType = "Server.Hadoop";
        this.prototypeName = "Library.SASHadoop.Prototype.Name.xmlKey.txt";
    }

    public SASHDATLibraryBuilder dataServer(String serverName) {
        this.dataServerName = serverName;
        return this;
    }

    public SASHDATLibraryBuilder dataServer(ServerComponentInterface server) {
        this.dataServer = server;
        return this;
    }

    public SASHDATLibraryBuilder schema(String schema) {
        this.schema = schema;
        return this;
    }

    public SASHDATLibraryBuilder connection(String connectionName) {
        this.connectionName = connectionName;
        return this;
    }

    public SASHDATLibraryBuilder connection(SASClientConnectionInterface connection) {
        this.connection = connection;
        return this;
    }

    public SASHDATLibraryBuilder defaultLogin(String defaultLoginUserId) {
        this.defaultLoginUserId = defaultLoginUserId;
        return this;
    }

    public SASHDATLibraryBuilder defaultLogin(LoginInterface defaultLogin) {
        this.defaultLogin = defaultLogin;
        return this;
    }

    public SASHDATLibraryBuilder path(String path) {
        this.path = path;
        return this;
    }

    @Override
    public SASLibraryInterface build(UserContextInterface user) throws ItemAlreadyExistsException, IllegalArgumentException, IllegalStateException, ServiceException {
        SASLibraryInterface library = super.build(user);
        try {
            if (this.path != null) {
                this.createProperty("Library.SASHadoop.Path.Name.xmlKey.txt", "PATH", "=", this.path);
            }
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        return library;
    }
}

